/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.HttpsConnection;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import com.android.internal.net.DomainNameValidator;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.harmony.security.provider.cert.X509CertImpl;
import org.apache.harmony.xnet.provider.jsse.SSLParametersImpl;

class CertificateChainValidator {
    private static final CertificateChainValidator sInstance = new CertificateChainValidator();

    public static CertificateChainValidator getInstance() {
        return sInstance;
    }

    private CertificateChainValidator() {
    }

    public SslError doHandshakeAndValidateServerCertificates(HttpsConnection connection, SSLSocket sslSocket, String domain) throws IOException {
        Certificate[] peerCertificates;
        SSLSession sslSession = sslSocket.getSession();
        if (!sslSession.isValid()) {
            this.closeSocketThrowException(sslSocket, "failed to perform SSL handshake");
        }
        if ((peerCertificates = sslSocket.getSession().getPeerCertificates()) == null || peerCertificates.length == 0) {
            this.closeSocketThrowException(sslSocket, "failed to retrieve peer certificates");
        } else if (connection != null && peerCertificates[0] != null) {
            connection.setCertificate(new SslCertificate((X509Certificate)peerCertificates[0]));
        }
        return CertificateChainValidator.verifyServerDomainAndCertificates((X509Certificate[])peerCertificates, domain, "RSA");
    }

    public static SslError verifyServerCertificates(byte[][] certChain, String domain, String authType) throws IOException {
        if (certChain == null || certChain.length == 0) {
            throw new IllegalArgumentException("bad certificate chain");
        }
        X509Certificate[] serverCertificates = new X509Certificate[certChain.length];
        for (int i = 0; i < certChain.length; ++i) {
            serverCertificates[i] = new X509CertImpl(certChain[i]);
        }
        return CertificateChainValidator.verifyServerDomainAndCertificates(serverCertificates, domain, authType);
    }

    private static SslError verifyServerDomainAndCertificates(X509Certificate[] chain, String domain, String authType) throws IOException {
        X509Certificate currCertificate = chain[0];
        if (currCertificate == null) {
            throw new IllegalArgumentException("certificate for this site is null");
        }
        if (!DomainNameValidator.match(currCertificate, domain)) {
            return new SslError(2, currCertificate);
        }
        try {
            SSLParametersImpl.getDefaultTrustManager().checkServerTrusted(chain, authType);
            return null;
        }
        catch (CertificateException e) {
            return new SslError(3, currCertificate);
        }
    }

    private void closeSocketThrowException(SSLSocket socket, String errorMessage, String defaultErrorMessage) throws IOException {
        this.closeSocketThrowException(socket, errorMessage != null ? errorMessage : defaultErrorMessage);
    }

    private void closeSocketThrowException(SSLSocket socket, String errorMessage) throws IOException {
        if (socket != null) {
            SSLSession session = socket.getSession();
            if (session != null) {
                session.invalidate();
            }
            socket.close();
        }
        throw new SSLHandshakeException(errorMessage);
    }
}

