/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import libcore.io.DiskLruCache;
import libcore.io.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpResponseCache
extends ResponseCache
implements Closeable {
    private final libcore.net.http.HttpResponseCache delegate;

    private HttpResponseCache(File directory, long maxSize) throws IOException {
        this.delegate = new libcore.net.http.HttpResponseCache(directory, maxSize);
    }

    public static HttpResponseCache getInstalled() {
        ResponseCache installed = ResponseCache.getDefault();
        return installed instanceof HttpResponseCache ? (HttpResponseCache)installed : null;
    }

    public static HttpResponseCache install(File directory, long maxSize) throws IOException {
        HttpResponseCache installed = HttpResponseCache.getInstalled();
        if (installed != null) {
            DiskLruCache installedCache = installed.delegate.getCache();
            if (installedCache.getDirectory().equals(directory) && installedCache.maxSize() == maxSize && !installedCache.isClosed()) {
                return installed;
            }
            IoUtils.closeQuietly((AutoCloseable)installed);
        }
        HttpResponseCache result = new HttpResponseCache(directory, maxSize);
        ResponseCache.setDefault(result);
        return result;
    }

    @Override
    public CacheResponse get(URI uri, String requestMethod, Map<String, List<String>> requestHeaders) throws IOException {
        return this.delegate.get(uri, requestMethod, requestHeaders);
    }

    @Override
    public CacheRequest put(URI uri, URLConnection urlConnection) throws IOException {
        return this.delegate.put(uri, urlConnection);
    }

    public long size() {
        return this.delegate.getCache().size();
    }

    public long maxSize() {
        return this.delegate.getCache().maxSize();
    }

    public void flush() {
        try {
            this.delegate.getCache().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getNetworkCount() {
        return this.delegate.getNetworkCount();
    }

    public int getHitCount() {
        return this.delegate.getHitCount();
    }

    public int getRequestCount() {
        return this.delegate.getRequestCount();
    }

    @Override
    public void close() throws IOException {
        if (ResponseCache.getDefault() == this) {
            ResponseCache.setDefault(null);
        }
        this.delegate.getCache().close();
    }

    public void delete() throws IOException {
        if (ResponseCache.getDefault() == this) {
            ResponseCache.setDefault(null);
        }
        this.delegate.getCache().delete();
    }
}

