/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import android.net.rtp.AudioCodec;
import android.net.rtp.AudioStream;
import java.util.HashMap;
import java.util.Map;

public class AudioGroup {
    public static final int MODE_ON_HOLD = 0;
    public static final int MODE_MUTED = 1;
    public static final int MODE_NORMAL = 2;
    public static final int MODE_ECHO_SUPPRESSION = 3;
    private static final int MODE_LAST = 3;
    private final Map<AudioStream, Integer> mStreams = new HashMap<AudioStream, Integer>();
    private int mMode = 0;
    private int mNative;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioStream[] getStreams() {
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            return this.mStreams.keySet().toArray(new AudioStream[this.mStreams.size()]);
        }
    }

    public int getMode() {
        return this.mMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) {
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException("Invalid mode");
        }
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            this.nativeSetMode(mode);
            this.mMode = mode;
        }
    }

    private native void nativeSetMode(int var1);

    synchronized void add(AudioStream stream, AudioCodec codec, int dtmfType) {
        if (!this.mStreams.containsKey(stream)) {
            try {
                int socket = stream.dup();
                String codecSpec = String.format("%d %s %s", codec.type, codec.rtpmap, codec.fmtp);
                this.nativeAdd(stream.getMode(), socket, stream.getRemoteAddress().getHostAddress(), stream.getRemotePort(), codecSpec, dtmfType);
                this.mStreams.put(stream, socket);
            }
            catch (NullPointerException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private native void nativeAdd(int var1, int var2, String var3, int var4, String var5, int var6);

    synchronized void remove(AudioStream stream) {
        Integer socket = this.mStreams.remove(stream);
        if (socket != null) {
            this.nativeRemove(socket);
        }
    }

    private native void nativeRemove(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDtmf(int event) {
        if (event < 0 || event > 15) {
            throw new IllegalArgumentException("Invalid event");
        }
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            this.nativeSendDtmf(event);
        }
    }

    private native void nativeSendDtmf(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        AudioGroup audioGroup = this;
        synchronized (audioGroup) {
            this.mStreams.clear();
            this.nativeRemove(-1);
        }
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    static {
        System.loadLibrary("rtp_jni");
    }
}

