/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.wifi.WifiConfiguration;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.UUID;

class WifiApConfigStore
extends StateMachine {
    private Context mContext;
    private static final String TAG = "WifiApConfigStore";
    private static final String AP_CONFIG_FILE = Environment.getDataDirectory() + "/misc/wifi/softap.conf";
    private static final int AP_CONFIG_FILE_VERSION = 1;
    private State mDefaultState = new DefaultState();
    private State mInactiveState = new InactiveState();
    private State mActiveState = new ActiveState();
    private WifiConfiguration mWifiApConfig = null;
    private AsyncChannel mReplyChannel = new AsyncChannel();

    WifiApConfigStore(Context context, Handler target) {
        super(TAG, target.getLooper());
        this.mContext = context;
        this.addState(this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mActiveState, this.mDefaultState);
        this.setInitialState(this.mInactiveState);
    }

    public static WifiApConfigStore makeWifiApConfigStore(Context context, Handler target) {
        WifiApConfigStore s = new WifiApConfigStore(context, target);
        s.start();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadApConfiguration() {
        block13: {
            block12: {
                in = null;
                try {
                    try {
                        config = new WifiConfiguration();
                        in = new DataInputStream(new BufferedInputStream(new FileInputStream(WifiApConfigStore.AP_CONFIG_FILE)));
                        version = in.readInt();
                        if (version != 1) {
                            Log.e("WifiApConfigStore", "Bad version on hotspot configuration file, set defaults");
                            this.setDefaultApConfiguration();
                            var6_5 = null;
                            if (in == null) return;
                            break block12;
                        }
                        config.SSID = in.readUTF();
                        authType = in.readInt();
                        config.allowedKeyManagement.set(authType);
                        if (authType != 0) {
                            config.preSharedKey = in.readUTF();
                        }
                        this.mWifiApConfig = config;
                        break block13;
                    }
                    catch (IOException ignore) {
                        this.setDefaultApConfiguration();
                        var6_7 = null;
                        if (in == null) return;
                        try {
                            in.close();
                            return;
                        }
                        catch (IOException e) {
                            return;
                        }
                    }
                }
                catch (Throwable var5_14) {
                    var6_8 = null;
                    if (in == null) throw var5_14;
                    ** try [egrp 2[TRYBLOCK] [6 : 133->140)] { 
lbl37:
                    // 1 sources

                    in.close();
                    throw var5_14;
lbl39:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var5_14;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 133->140)] { 
lbl44:
            // 1 sources

            in.close();
            return;
lbl46:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        var6_6 = null;
        if (in == null) return;
        try {}
        catch (IOException e) {}
        in.close();
        return;
    }

    Messenger getMessenger() {
        return new Messenger(this.getHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeApConfiguration(WifiConfiguration config) {
        FilterOutputStream out;
        block8: {
            out = null;
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(AP_CONFIG_FILE)));
            ((DataOutputStream)out).writeInt(1);
            ((DataOutputStream)out).writeUTF(config.SSID);
            int authType = config.getAuthType();
            ((DataOutputStream)out).writeInt(authType);
            if (authType == 0) break block8;
            ((DataOutputStream)out).writeUTF(config.preSharedKey);
        }
        Object var5_5 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                Log.e(TAG, "Error writing hotspot configuration" + e);
                Object var5_6 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void setDefaultApConfiguration() {
        WifiConfiguration config = new WifiConfiguration();
        config.SSID = this.mContext.getString(17040348);
        config.allowedKeyManagement.set(4);
        String randomUUID = UUID.randomUUID().toString();
        config.preSharedKey = randomUUID.substring(0, 8) + randomUUID.substring(9, 13);
        this.sendMessage(131097, config);
    }

    class ActiveState
    extends State {
        ActiveState() {
        }

        public void enter() {
            new Thread(new Runnable(){

                public void run() {
                    WifiApConfigStore.this.writeApConfiguration(WifiApConfigStore.this.mWifiApConfig);
                    WifiApConfigStore.this.sendMessage(131098);
                }
            }).start();
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131097: {
                    WifiApConfigStore.this.deferMessage(message);
                    break;
                }
                case 131098: {
                    WifiApConfigStore.this.transitionTo(WifiApConfigStore.this.mInactiveState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class InactiveState
    extends State {
        InactiveState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131097: {
                    WifiApConfigStore.this.mWifiApConfig = (WifiConfiguration)message.obj;
                    WifiApConfigStore.this.transitionTo(WifiApConfigStore.this.mActiveState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131097: 
                case 131098: {
                    Log.e(WifiApConfigStore.TAG, "Unexpected message: " + message);
                    break;
                }
                case 131099: {
                    WifiApConfigStore.this.mReplyChannel.replyToMessage(message, 131100, WifiApConfigStore.this.mWifiApConfig);
                    break;
                }
                default: {
                    Log.e(WifiApConfigStore.TAG, "Failed to handle " + message);
                }
            }
            return true;
        }
    }
}

