/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.content.Intent;
import android.net.DhcpInfoInternal;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.net.ProxyProperties;
import android.net.RouteInfo;
import android.net.wifi.NetworkUpdateResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiNative;
import android.net.wifi.WpsInfo;
import android.net.wifi.WpsResult;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WifiConfigStore {
    private static Context sContext;
    private static final String TAG = "WifiConfigStore";
    private static final boolean DBG = false;
    private static HashMap<Integer, WifiConfiguration> sConfiguredNetworks;
    private static HashMap<Integer, Integer> sNetworkIds;
    private static int sLastPriority;
    private static final String ipConfigFile;
    private static final int IPCONFIG_FILE_VERSION = 2;
    private static final String ID_KEY = "id";
    private static final String IP_ASSIGNMENT_KEY = "ipAssignment";
    private static final String LINK_ADDRESS_KEY = "linkAddress";
    private static final String GATEWAY_KEY = "gateway";
    private static final String DNS_KEY = "dns";
    private static final String PROXY_SETTINGS_KEY = "proxySettings";
    private static final String PROXY_HOST_KEY = "proxyHost";
    private static final String PROXY_PORT_KEY = "proxyPort";
    private static final String EXCLUSION_LIST_KEY = "exclusionList";
    private static final String EOS = "eos";

    WifiConfigStore() {
    }

    static void initialize(Context context) {
        sContext = context;
        WifiConfigStore.loadConfiguredNetworks();
        WifiConfigStore.enableAllNetworks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<WifiConfiguration> getConfiguredNetworks() {
        ArrayList<WifiConfiguration> networks = new ArrayList<WifiConfiguration>();
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            for (WifiConfiguration config : sConfiguredNetworks.values()) {
                networks.add(new WifiConfiguration(config));
            }
        }
        return networks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void enableAllNetworks() {
        boolean networkEnabledStateChanged = false;
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            for (WifiConfiguration config : sConfiguredNetworks.values()) {
                if (config == null || config.status != 1) continue;
                if (WifiNative.enableNetworkCommand(config.networkId, false)) {
                    networkEnabledStateChanged = true;
                    config.status = 2;
                    continue;
                }
                WifiConfigStore.loge("Enable network failed on " + config.networkId);
            }
        }
        if (networkEnabledStateChanged) {
            WifiNative.saveConfigCommand();
            WifiConfigStore.sendConfiguredNetworksChangedBroadcast();
        }
    }

    static int selectNetwork(WifiConfiguration config) {
        if (config != null) {
            NetworkUpdateResult result = WifiConfigStore.addOrUpdateNetworkNative(config);
            int netId = result.getNetworkId();
            if (netId != -1) {
                WifiConfigStore.selectNetwork(netId);
            } else {
                WifiConfigStore.loge("Failed to update network " + config);
            }
            return netId;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void selectNetwork(int netId) {
        if (sLastPriority == -1 || sLastPriority > 1000000) {
            HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
            synchronized (hashMap) {
                for (WifiConfiguration config : sConfiguredNetworks.values()) {
                    if (config.networkId == -1) continue;
                    config.priority = 0;
                    WifiConfigStore.addOrUpdateNetworkNative(config);
                }
            }
            sLastPriority = 0;
        }
        WifiConfiguration config = new WifiConfiguration();
        config.networkId = netId;
        config.priority = ++sLastPriority;
        WifiConfigStore.addOrUpdateNetworkNative(config);
        WifiNative.saveConfigCommand();
        WifiConfigStore.enableNetworkWithoutBroadcast(netId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NetworkUpdateResult saveNetwork(WifiConfiguration config) {
        boolean newNetwork = config.networkId == -1;
        NetworkUpdateResult result = WifiConfigStore.addOrUpdateNetworkNative(config);
        int netId = result.getNetworkId();
        if (newNetwork && netId != -1) {
            WifiNative.enableNetworkCommand(netId, false);
            HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
            synchronized (hashMap) {
                WifiConfigStore.sConfiguredNetworks.get((Object)Integer.valueOf((int)netId)).status = 2;
            }
        }
        WifiNative.saveConfigCommand();
        WifiConfigStore.sendConfiguredNetworksChangedBroadcast();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void forgetNetwork(int netId) {
        if (WifiNative.removeNetworkCommand(netId)) {
            WifiNative.saveConfigCommand();
            HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
            synchronized (hashMap) {
                WifiConfiguration config = sConfiguredNetworks.get(netId);
                if (config != null) {
                    sConfiguredNetworks.remove(netId);
                    sNetworkIds.remove(WifiConfigStore.configKey(config));
                }
            }
            WifiConfigStore.writeIpAndProxyConfigurations();
            WifiConfigStore.sendConfiguredNetworksChangedBroadcast();
        } else {
            WifiConfigStore.loge("Failed to remove network " + netId);
        }
    }

    static int addOrUpdateNetwork(WifiConfiguration config) {
        NetworkUpdateResult result = WifiConfigStore.addOrUpdateNetworkNative(config);
        WifiConfigStore.sendConfiguredNetworksChangedBroadcast();
        return result.getNetworkId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeNetwork(int netId) {
        boolean ret = WifiNative.removeNetworkCommand(netId);
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            WifiConfiguration config;
            if (ret && (config = sConfiguredNetworks.get(netId)) != null) {
                sConfiguredNetworks.remove(netId);
                sNetworkIds.remove(WifiConfigStore.configKey(config));
            }
        }
        WifiConfigStore.sendConfiguredNetworksChangedBroadcast();
        return ret;
    }

    static boolean enableNetwork(int netId, boolean disableOthers) {
        boolean ret = WifiConfigStore.enableNetworkWithoutBroadcast(netId, disableOthers);
        WifiConfigStore.sendConfiguredNetworksChangedBroadcast();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean enableNetworkWithoutBroadcast(int netId, boolean disableOthers) {
        boolean ret = WifiNative.enableNetworkCommand(netId, disableOthers);
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            WifiConfiguration config = sConfiguredNetworks.get(netId);
            if (config != null) {
                config.status = 2;
            }
        }
        if (disableOthers) {
            WifiConfigStore.markAllNetworksDisabledExcept(netId);
        }
        return ret;
    }

    static boolean disableNetwork(int netId) {
        return WifiConfigStore.disableNetwork(netId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean disableNetwork(int netId, int reason) {
        boolean ret = WifiNative.disableNetworkCommand(netId);
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            WifiConfiguration config = sConfiguredNetworks.get(netId);
            if (config != null && config.status != 1) {
                config.status = 1;
                config.disableReason = reason;
            }
        }
        WifiConfigStore.sendConfiguredNetworksChangedBroadcast();
        return ret;
    }

    static boolean saveConfig() {
        return WifiNative.saveConfigCommand();
    }

    static WpsResult startWpsWithPinFromAccessPoint(WpsInfo config) {
        WpsResult result = new WpsResult();
        if (WifiNative.startWpsWithPinFromAccessPointCommand(config.BSSID, config.pin)) {
            WifiConfigStore.markAllNetworksDisabled();
            result.status = WpsResult.Status.SUCCESS;
        } else {
            WifiConfigStore.loge("Failed to start WPS pin method configuration");
            result.status = WpsResult.Status.FAILURE;
        }
        return result;
    }

    static WpsResult startWpsWithPinFromDevice(WpsInfo config) {
        WpsResult result = new WpsResult();
        result.pin = WifiNative.startWpsWithPinFromDeviceCommand(config.BSSID);
        if (!TextUtils.isEmpty(result.pin)) {
            WifiConfigStore.markAllNetworksDisabled();
            result.status = WpsResult.Status.SUCCESS;
        } else {
            WifiConfigStore.loge("Failed to start WPS pin method configuration");
            result.status = WpsResult.Status.FAILURE;
        }
        return result;
    }

    static WpsResult startWpsPbc(WpsInfo config) {
        WpsResult result = new WpsResult();
        if (WifiNative.startWpsPbcCommand(config.BSSID)) {
            WifiConfigStore.markAllNetworksDisabled();
            result.status = WpsResult.Status.SUCCESS;
        } else {
            WifiConfigStore.loge("Failed to start WPS push button configuration");
            result.status = WpsResult.Status.FAILURE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LinkProperties getLinkProperties(int netId) {
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            WifiConfiguration config = sConfiguredNetworks.get(netId);
            if (config != null) {
                return new LinkProperties(config.linkProperties);
            }
        }
        return null;
    }

    static DhcpInfoInternal getIpConfiguration(int netId) {
        Iterator<LinkAddress> iter;
        DhcpInfoInternal dhcpInfoInternal = new DhcpInfoInternal();
        LinkProperties linkProperties = WifiConfigStore.getLinkProperties(netId);
        if (linkProperties != null && (iter = linkProperties.getLinkAddresses().iterator()).hasNext()) {
            LinkAddress linkAddress = iter.next();
            dhcpInfoInternal.ipAddress = linkAddress.getAddress().getHostAddress();
            for (RouteInfo route : linkProperties.getRoutes()) {
                dhcpInfoInternal.addRoute(route);
            }
            dhcpInfoInternal.prefixLength = linkAddress.getNetworkPrefixLength();
            Iterator<InetAddress> dnsIterator = linkProperties.getDnses().iterator();
            dhcpInfoInternal.dns1 = dnsIterator.next().getHostAddress();
            if (dnsIterator.hasNext()) {
                dhcpInfoInternal.dns2 = dnsIterator.next().getHostAddress();
            }
        }
        return dhcpInfoInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setIpConfiguration(int netId, DhcpInfoInternal dhcpInfo) {
        LinkProperties linkProperties = dhcpInfo.makeLinkProperties();
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            WifiConfiguration config = sConfiguredNetworks.get(netId);
            if (config != null) {
                if (config.linkProperties != null) {
                    linkProperties.setHttpProxy(config.linkProperties.getHttpProxy());
                }
                config.linkProperties = linkProperties;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearIpConfiguration(int netId) {
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            WifiConfiguration config = sConfiguredNetworks.get(netId);
            if (config != null && config.linkProperties != null) {
                ProxyProperties proxy = config.linkProperties.getHttpProxy();
                config.linkProperties.clear();
                config.linkProperties.setHttpProxy(proxy);
            }
        }
    }

    static ProxyProperties getProxyProperties(int netId) {
        LinkProperties linkProperties = WifiConfigStore.getLinkProperties(netId);
        if (linkProperties != null) {
            return new ProxyProperties(linkProperties.getHttpProxy());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isUsingStaticIp(int netId) {
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            WifiConfiguration config = sConfiguredNetworks.get(netId);
            if (config != null && config.ipAssignment == WifiConfiguration.IpAssignment.STATIC) {
                return true;
            }
        }
        return false;
    }

    private static void sendConfiguredNetworksChangedBroadcast() {
        Intent intent = new Intent("android.net.wifi.CONFIGURED_NETWORKS_CHANGE");
        intent.addFlags(0x10000000);
        sContext.sendBroadcast(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadConfiguredNetworks() {
        String listStr = WifiNative.listNetworksCommand();
        sLastPriority = 0;
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            sConfiguredNetworks.clear();
            sNetworkIds.clear();
            if (listStr == null) {
                return;
            }
            String[] lines = listStr.split("\n");
            for (int i = 1; i < lines.length; ++i) {
                String[] result = lines[i].split("\t");
                WifiConfiguration config = new WifiConfiguration();
                try {
                    config.networkId = Integer.parseInt(result[0]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                config.status = result.length > 3 ? (result[3].indexOf("[CURRENT]") != -1 ? 0 : (result[3].indexOf("[DISABLED]") != -1 ? 1 : 2)) : 2;
                WifiConfigStore.readNetworkVariables(config);
                if (config.priority > sLastPriority) {
                    sLastPriority = config.priority;
                }
                sConfiguredNetworks.put(config.networkId, config);
                sNetworkIds.put(WifiConfigStore.configKey(config), config.networkId);
            }
        }
        WifiConfigStore.readIpAndProxyConfigurations();
        WifiConfigStore.sendConfiguredNetworksChangedBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateIpAndProxyFromWpsConfig(int netId, WpsInfo wpsConfig) {
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            WifiConfiguration config = sConfiguredNetworks.get(netId);
            if (config != null) {
                config.ipAssignment = wpsConfig.ipAssignment;
                config.proxySettings = wpsConfig.proxySettings;
                config.linkProperties = wpsConfig.linkProperties;
                WifiConfigStore.writeIpAndProxyConfigurations();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void markAllNetworksDisabledExcept(int netId) {
        HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
        synchronized (hashMap) {
            for (WifiConfiguration config : sConfiguredNetworks.values()) {
                if (config == null || config.networkId == netId || config.status == 1) continue;
                config.status = 1;
                config.disableReason = 0;
            }
        }
    }

    private static void markAllNetworksDisabled() {
        WifiConfigStore.markAllNetworksDisabledExcept(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIpAndProxyConfigurations() {
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(ipConfigFile)));
            ((DataOutputStream)out).writeInt(2);
            HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
            synchronized (hashMap) {
                for (WifiConfiguration config : sConfiguredNetworks.values()) {
                    boolean writeToFile = false;
                    try {
                        LinkProperties linkProperties = config.linkProperties;
                        switch (config.ipAssignment) {
                            case STATIC: {
                                ((DataOutputStream)out).writeUTF(IP_ASSIGNMENT_KEY);
                                ((DataOutputStream)out).writeUTF(config.ipAssignment.toString());
                                for (LinkAddress linkAddr : linkProperties.getLinkAddresses()) {
                                    ((DataOutputStream)out).writeUTF(LINK_ADDRESS_KEY);
                                    ((DataOutputStream)out).writeUTF(linkAddr.getAddress().getHostAddress());
                                    ((DataOutputStream)out).writeInt(linkAddr.getNetworkPrefixLength());
                                }
                                for (RouteInfo route : linkProperties.getRoutes()) {
                                    ((DataOutputStream)out).writeUTF(GATEWAY_KEY);
                                    LinkAddress dest = route.getDestination();
                                    if (dest != null) {
                                        ((DataOutputStream)out).writeInt(1);
                                        ((DataOutputStream)out).writeUTF(dest.getAddress().getHostAddress());
                                        ((DataOutputStream)out).writeInt(dest.getNetworkPrefixLength());
                                    } else {
                                        ((DataOutputStream)out).writeInt(0);
                                    }
                                    if (route.getGateway() != null) {
                                        ((DataOutputStream)out).writeInt(1);
                                        ((DataOutputStream)out).writeUTF(route.getGateway().getHostAddress());
                                        continue;
                                    }
                                    ((DataOutputStream)out).writeInt(0);
                                }
                                for (InetAddress inetAddr : linkProperties.getDnses()) {
                                    ((DataOutputStream)out).writeUTF(DNS_KEY);
                                    ((DataOutputStream)out).writeUTF(inetAddr.getHostAddress());
                                }
                                writeToFile = true;
                                break;
                            }
                            case DHCP: {
                                ((DataOutputStream)out).writeUTF(IP_ASSIGNMENT_KEY);
                                ((DataOutputStream)out).writeUTF(config.ipAssignment.toString());
                                writeToFile = true;
                                break;
                            }
                            case UNASSIGNED: {
                                break;
                            }
                            default: {
                                WifiConfigStore.loge("Ignore invalid ip assignment while writing");
                            }
                        }
                        switch (config.proxySettings) {
                            case STATIC: {
                                ProxyProperties proxyProperties = linkProperties.getHttpProxy();
                                String exclusionList = proxyProperties.getExclusionList();
                                ((DataOutputStream)out).writeUTF(PROXY_SETTINGS_KEY);
                                ((DataOutputStream)out).writeUTF(config.proxySettings.toString());
                                ((DataOutputStream)out).writeUTF(PROXY_HOST_KEY);
                                ((DataOutputStream)out).writeUTF(proxyProperties.getHost());
                                ((DataOutputStream)out).writeUTF(PROXY_PORT_KEY);
                                ((DataOutputStream)out).writeInt(proxyProperties.getPort());
                                ((DataOutputStream)out).writeUTF(EXCLUSION_LIST_KEY);
                                ((DataOutputStream)out).writeUTF(exclusionList);
                                writeToFile = true;
                                break;
                            }
                            case NONE: {
                                ((DataOutputStream)out).writeUTF(PROXY_SETTINGS_KEY);
                                ((DataOutputStream)out).writeUTF(config.proxySettings.toString());
                                writeToFile = true;
                                break;
                            }
                            case UNASSIGNED: {
                                break;
                            }
                            default: {
                                WifiConfigStore.loge("Ignore invalid proxy settings while writing");
                            }
                        }
                        if (writeToFile) {
                            ((DataOutputStream)out).writeUTF(ID_KEY);
                            ((DataOutputStream)out).writeInt(WifiConfigStore.configKey(config));
                        }
                    }
                    catch (NullPointerException e) {
                        WifiConfigStore.loge("Failure in writing " + config.linkProperties + e);
                    }
                    ((DataOutputStream)out).writeUTF(EOS);
                }
            }
        }
        catch (IOException e) {
            WifiConfigStore.loge("Error writing data file");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readIpAndProxyConfigurations() {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(ipConfigFile)));
            int version = ((DataInputStream)in).readInt();
            if (version != 2 && version != 1) {
                WifiConfigStore.loge("Bad version on IP configuration file, ignore read");
                return;
            }
            while (true) {
                int id2 = -1;
                WifiConfiguration.IpAssignment ipAssignment = WifiConfiguration.IpAssignment.UNASSIGNED;
                WifiConfiguration.ProxySettings proxySettings = WifiConfiguration.ProxySettings.UNASSIGNED;
                LinkProperties linkProperties = new LinkProperties();
                String proxyHost = null;
                int proxyPort = -1;
                String exclusionList = null;
                while (true) {
                    String key = ((DataInputStream)in).readUTF();
                    try {
                        if (key.equals(ID_KEY)) {
                            id2 = ((DataInputStream)in).readInt();
                            continue;
                        }
                        if (key.equals(IP_ASSIGNMENT_KEY)) {
                            ipAssignment = WifiConfiguration.IpAssignment.valueOf(((DataInputStream)in).readUTF());
                            continue;
                        }
                        if (key.equals(LINK_ADDRESS_KEY)) {
                            LinkAddress linkAddr = new LinkAddress(NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF()), ((DataInputStream)in).readInt());
                            linkProperties.addLinkAddress(linkAddr);
                            continue;
                        }
                        if (key.equals(GATEWAY_KEY)) {
                            LinkAddress dest = null;
                            InetAddress gateway = null;
                            if (version == 1) {
                                gateway = NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF());
                            } else {
                                if (((DataInputStream)in).readInt() == 1) {
                                    dest = new LinkAddress(NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF()), ((DataInputStream)in).readInt());
                                }
                                if (((DataInputStream)in).readInt() == 1) {
                                    gateway = NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF());
                                }
                            }
                            linkProperties.addRoute(new RouteInfo(dest, gateway));
                            continue;
                        }
                        if (key.equals(DNS_KEY)) {
                            linkProperties.addDns(NetworkUtils.numericToInetAddress(((DataInputStream)in).readUTF()));
                            continue;
                        }
                        if (key.equals(PROXY_SETTINGS_KEY)) {
                            proxySettings = WifiConfiguration.ProxySettings.valueOf(((DataInputStream)in).readUTF());
                            continue;
                        }
                        if (key.equals(PROXY_HOST_KEY)) {
                            proxyHost = ((DataInputStream)in).readUTF();
                            continue;
                        }
                        if (key.equals(PROXY_PORT_KEY)) {
                            proxyPort = ((DataInputStream)in).readInt();
                            continue;
                        }
                        if (key.equals(EXCLUSION_LIST_KEY)) {
                            exclusionList = ((DataInputStream)in).readUTF();
                            continue;
                        }
                        if (key.equals(EOS)) break;
                        WifiConfigStore.loge("Ignore unknown key " + key + "while reading");
                    }
                    catch (IllegalArgumentException e) {
                        WifiConfigStore.loge("Ignore invalid address while reading" + e);
                    }
                }
                if (id2 != -1) {
                    HashMap<Integer, WifiConfiguration> hashMap = sConfiguredNetworks;
                    synchronized (hashMap) {
                        WifiConfiguration config = sConfiguredNetworks.get(sNetworkIds.get(id2));
                        if (config == null) {
                            WifiConfigStore.loge("configuration found for missing network, ignored");
                        } else {
                            config.linkProperties = linkProperties;
                            switch (ipAssignment) {
                                case STATIC: 
                                case DHCP: {
                                    config.ipAssignment = ipAssignment;
                                    break;
                                }
                                case UNASSIGNED: {
                                    break;
                                }
                                default: {
                                    WifiConfigStore.loge("Ignore invalid ip assignment while reading");
                                }
                            }
                            switch (proxySettings) {
                                case STATIC: {
                                    config.proxySettings = proxySettings;
                                    ProxyProperties proxyProperties = new ProxyProperties(proxyHost, proxyPort, exclusionList);
                                    linkProperties.setHttpProxy(proxyProperties);
                                    break;
                                }
                                case NONE: {
                                    config.proxySettings = proxySettings;
                                    break;
                                }
                                case UNASSIGNED: {
                                    break;
                                }
                                default: {
                                    WifiConfigStore.loge("Ignore invalid proxy settings while reading");
                                }
                            }
                        }
                        continue;
                    }
                }
                WifiConfigStore.loge("Missing id while parsing configuration");
            }
        }
        catch (EOFException ignore) {
            return;
        }
        catch (IOException e) {
            WifiConfigStore.loge("Error parsing configuration" + e);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NetworkUpdateResult addOrUpdateNetworkNative(WifiConfiguration config) {
        WifiConfiguration sConfig;
        HashMap<Integer, WifiConfiguration> allowedProtocolsString;
        boolean updateFailed;
        boolean newNetwork;
        int netId;
        block40: {
            netId = config.networkId;
            newNetwork = false;
            if (netId == -1) {
                Integer savedNetId = sNetworkIds.get(WifiConfigStore.configKey(config));
                if (savedNetId != null) {
                    netId = savedNetId;
                } else {
                    newNetwork = true;
                    netId = WifiNative.addNetworkCommand();
                    if (netId < 0) {
                        WifiConfigStore.loge("Failed to add a network!");
                        return new NetworkUpdateResult(-1);
                    }
                }
            }
            updateFailed = true;
            if (config.SSID != null && !WifiNative.setNetworkVariableCommand(netId, "ssid", config.SSID)) {
                WifiConfigStore.loge("failed to set SSID: " + config.SSID);
            } else if (config.BSSID != null && !WifiNative.setNetworkVariableCommand(netId, "bssid", config.BSSID)) {
                WifiConfigStore.loge("failed to set BSSID: " + config.BSSID);
            } else {
                String allowedKeyManagementString = WifiConfigStore.makeString(config.allowedKeyManagement, WifiConfiguration.KeyMgmt.strings);
                if (config.allowedKeyManagement.cardinality() != 0 && !WifiNative.setNetworkVariableCommand(netId, "key_mgmt", allowedKeyManagementString)) {
                    WifiConfigStore.loge("failed to set key_mgmt: " + allowedKeyManagementString);
                } else {
                    allowedProtocolsString = WifiConfigStore.makeString(config.allowedProtocols, WifiConfiguration.Protocol.strings);
                    if (config.allowedProtocols.cardinality() != 0 && !WifiNative.setNetworkVariableCommand(netId, "proto", (String)((Object)allowedProtocolsString))) {
                        WifiConfigStore.loge("failed to set proto: " + (String)((Object)allowedProtocolsString));
                    } else {
                        String allowedAuthAlgorithmsString = WifiConfigStore.makeString(config.allowedAuthAlgorithms, WifiConfiguration.AuthAlgorithm.strings);
                        if (config.allowedAuthAlgorithms.cardinality() != 0 && !WifiNative.setNetworkVariableCommand(netId, "auth_alg", allowedAuthAlgorithmsString)) {
                            WifiConfigStore.loge("failed to set auth_alg: " + allowedAuthAlgorithmsString);
                        } else {
                            String allowedPairwiseCiphersString = WifiConfigStore.makeString(config.allowedPairwiseCiphers, WifiConfiguration.PairwiseCipher.strings);
                            if (config.allowedPairwiseCiphers.cardinality() != 0 && !WifiNative.setNetworkVariableCommand(netId, "pairwise", allowedPairwiseCiphersString)) {
                                WifiConfigStore.loge("failed to set pairwise: " + allowedPairwiseCiphersString);
                            } else {
                                String allowedGroupCiphersString = WifiConfigStore.makeString(config.allowedGroupCiphers, WifiConfiguration.GroupCipher.strings);
                                if (config.allowedGroupCiphers.cardinality() != 0 && !WifiNative.setNetworkVariableCommand(netId, "group", allowedGroupCiphersString)) {
                                    WifiConfigStore.loge("failed to set group: " + allowedGroupCiphersString);
                                } else if (config.preSharedKey != null && !config.preSharedKey.equals("*") && !WifiNative.setNetworkVariableCommand(netId, "psk", config.preSharedKey)) {
                                    WifiConfigStore.loge("failed to set psk");
                                } else {
                                    boolean hasSetKey = false;
                                    if (config.wepKeys != null) {
                                        for (int i = 0; i < config.wepKeys.length; ++i) {
                                            if (config.wepKeys[i] == null || config.wepKeys[i].equals("*")) continue;
                                            if (!WifiNative.setNetworkVariableCommand(netId, WifiConfiguration.wepKeyVarNames[i], config.wepKeys[i])) {
                                                WifiConfigStore.loge("failed to set wep_key" + i + ": " + config.wepKeys[i]);
                                                break block40;
                                            }
                                            hasSetKey = true;
                                        }
                                    }
                                    if (hasSetKey && !WifiNative.setNetworkVariableCommand(netId, "wep_tx_keyidx", Integer.toString(config.wepTxKeyIndex))) {
                                        WifiConfigStore.loge("failed to set wep_tx_keyidx: " + config.wepTxKeyIndex);
                                    } else if (!WifiNative.setNetworkVariableCommand(netId, "priority", Integer.toString(config.priority))) {
                                        WifiConfigStore.loge(config.SSID + ": failed to set priority: " + config.priority);
                                    } else if (config.hiddenSSID && !WifiNative.setNetworkVariableCommand(netId, "scan_ssid", Integer.toString(config.hiddenSSID ? 1 : 0))) {
                                        WifiConfigStore.loge(config.SSID + ": failed to set hiddenSSID: " + config.hiddenSSID);
                                    } else {
                                        for (WifiConfiguration.EnterpriseField field : config.enterpriseFields) {
                                            String varName = field.varName();
                                            String value = field.value();
                                            if (value == null) continue;
                                            if (field != config.eap) {
                                                String string2 = value = value.length() == 0 ? "NULL" : WifiConfigStore.convertToQuotedString(value);
                                            }
                                            if (WifiNative.setNetworkVariableCommand(netId, varName, value)) continue;
                                            WifiConfigStore.loge(config.SSID + ": failed to set " + varName + ": " + value);
                                            break block40;
                                        }
                                        updateFailed = false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (updateFailed) {
            if (newNetwork) {
                WifiNative.removeNetworkCommand(netId);
                WifiConfigStore.loge("Failed to set a network variable, removed network: " + netId);
            }
            return new NetworkUpdateResult(-1);
        }
        allowedProtocolsString = sConfiguredNetworks;
        synchronized (allowedProtocolsString) {
            sConfig = sConfiguredNetworks.get(netId);
        }
        if (sConfig == null) {
            sConfig = new WifiConfiguration();
            sConfig.networkId = netId;
        }
        WifiConfigStore.readNetworkVariables(sConfig);
        allowedProtocolsString = sConfiguredNetworks;
        synchronized (allowedProtocolsString) {
            sConfiguredNetworks.put(netId, sConfig);
            sNetworkIds.put(WifiConfigStore.configKey(sConfig), netId);
        }
        NetworkUpdateResult result = WifiConfigStore.writeIpAndProxyConfigurationsOnChange(sConfig, config);
        result.setNetworkId(netId);
        return result;
    }

    private static NetworkUpdateResult writeIpAndProxyConfigurationsOnChange(WifiConfiguration currentConfig, WifiConfiguration newConfig) {
        boolean ipChanged = false;
        boolean proxyChanged = false;
        LinkProperties linkProperties = new LinkProperties();
        switch (newConfig.ipAssignment) {
            case STATIC: {
                boolean routesDiffer;
                Collection<LinkAddress> currentLinkAddresses = currentConfig.linkProperties.getLinkAddresses();
                Collection<LinkAddress> newLinkAddresses = newConfig.linkProperties.getLinkAddresses();
                Collection<InetAddress> currentDnses = currentConfig.linkProperties.getDnses();
                Collection<InetAddress> newDnses = newConfig.linkProperties.getDnses();
                Collection<RouteInfo> currentRoutes = currentConfig.linkProperties.getRoutes();
                Collection<RouteInfo> newRoutes = newConfig.linkProperties.getRoutes();
                boolean linkAddressesDiffer = currentLinkAddresses.size() != newLinkAddresses.size() || !currentLinkAddresses.containsAll(newLinkAddresses);
                boolean dnsesDiffer = currentDnses.size() != newDnses.size() || !currentDnses.containsAll(newDnses);
                boolean bl = routesDiffer = currentRoutes.size() != newRoutes.size() || !currentRoutes.containsAll(newRoutes);
                if (currentConfig.ipAssignment == newConfig.ipAssignment && !linkAddressesDiffer && !dnsesDiffer && !routesDiffer) break;
                ipChanged = true;
                break;
            }
            case DHCP: {
                if (currentConfig.ipAssignment == newConfig.ipAssignment) break;
                ipChanged = true;
                break;
            }
            case UNASSIGNED: {
                break;
            }
            default: {
                WifiConfigStore.loge("Ignore invalid ip assignment during write");
            }
        }
        switch (newConfig.proxySettings) {
            case STATIC: {
                ProxyProperties newHttpProxy = newConfig.linkProperties.getHttpProxy();
                ProxyProperties currentHttpProxy = currentConfig.linkProperties.getHttpProxy();
                if (newHttpProxy != null) {
                    proxyChanged = !newHttpProxy.equals(currentHttpProxy);
                    break;
                }
                proxyChanged = currentHttpProxy != null;
                break;
            }
            case NONE: {
                if (currentConfig.proxySettings == newConfig.proxySettings) break;
                proxyChanged = true;
                break;
            }
            case UNASSIGNED: {
                break;
            }
            default: {
                WifiConfigStore.loge("Ignore invalid proxy configuration during write");
            }
        }
        if (!ipChanged) {
            WifiConfigStore.addIpSettingsFromConfig(linkProperties, currentConfig);
        } else {
            currentConfig.ipAssignment = newConfig.ipAssignment;
            WifiConfigStore.addIpSettingsFromConfig(linkProperties, newConfig);
            WifiConfigStore.log("IP config changed SSID = " + currentConfig.SSID + " linkProperties: " + linkProperties.toString());
        }
        if (!proxyChanged) {
            linkProperties.setHttpProxy(currentConfig.linkProperties.getHttpProxy());
        } else {
            currentConfig.proxySettings = newConfig.proxySettings;
            linkProperties.setHttpProxy(newConfig.linkProperties.getHttpProxy());
            WifiConfigStore.log("proxy changed SSID = " + currentConfig.SSID);
            if (linkProperties.getHttpProxy() != null) {
                WifiConfigStore.log(" proxyProperties: " + linkProperties.getHttpProxy().toString());
            }
        }
        if (ipChanged || proxyChanged) {
            currentConfig.linkProperties = linkProperties;
            WifiConfigStore.writeIpAndProxyConfigurations();
            WifiConfigStore.sendConfiguredNetworksChangedBroadcast();
        }
        return new NetworkUpdateResult(ipChanged, proxyChanged);
    }

    private static void addIpSettingsFromConfig(LinkProperties linkProperties, WifiConfiguration config) {
        for (LinkAddress linkAddr : config.linkProperties.getLinkAddresses()) {
            linkProperties.addLinkAddress(linkAddr);
        }
        for (RouteInfo route : config.linkProperties.getRoutes()) {
            linkProperties.addRoute(route);
        }
        for (InetAddress dns : config.linkProperties.getDnses()) {
            linkProperties.addDns(dns);
        }
    }

    private static void readNetworkVariables(WifiConfiguration config) {
        int index;
        int netId = config.networkId;
        if (netId < 0) {
            return;
        }
        String value = WifiNative.getNetworkVariableCommand(netId, "ssid");
        config.SSID = !TextUtils.isEmpty(value) ? value : null;
        value = WifiNative.getNetworkVariableCommand(netId, "bssid");
        config.BSSID = !TextUtils.isEmpty(value) ? value : null;
        value = WifiNative.getNetworkVariableCommand(netId, "priority");
        config.priority = -1;
        if (!TextUtils.isEmpty(value)) {
            try {
                config.priority = Integer.parseInt(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        value = WifiNative.getNetworkVariableCommand(netId, "scan_ssid");
        config.hiddenSSID = false;
        if (!TextUtils.isEmpty(value)) {
            try {
                config.hiddenSSID = Integer.parseInt(value) != 0;
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        value = WifiNative.getNetworkVariableCommand(netId, "wep_tx_keyidx");
        config.wepTxKeyIndex = -1;
        if (!TextUtils.isEmpty(value)) {
            try {
                config.wepTxKeyIndex = Integer.parseInt(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        for (int i = 0; i < 4; ++i) {
            value = WifiNative.getNetworkVariableCommand(netId, WifiConfiguration.wepKeyVarNames[i]);
            config.wepKeys[i] = !TextUtils.isEmpty(value) ? value : null;
        }
        value = WifiNative.getNetworkVariableCommand(netId, "psk");
        config.preSharedKey = !TextUtils.isEmpty(value) ? value : null;
        value = WifiNative.getNetworkVariableCommand(config.networkId, "proto");
        if (!TextUtils.isEmpty(value)) {
            String[] vals;
            for (String val : vals = value.split(" ")) {
                index = WifiConfigStore.lookupString(val, WifiConfiguration.Protocol.strings);
                if (0 > index) continue;
                config.allowedProtocols.set(index);
            }
        }
        if (!TextUtils.isEmpty(value = WifiNative.getNetworkVariableCommand(config.networkId, "key_mgmt"))) {
            String[] vals;
            for (String val : vals = value.split(" ")) {
                index = WifiConfigStore.lookupString(val, WifiConfiguration.KeyMgmt.strings);
                if (0 > index) continue;
                config.allowedKeyManagement.set(index);
            }
        }
        if (!TextUtils.isEmpty(value = WifiNative.getNetworkVariableCommand(config.networkId, "auth_alg"))) {
            String[] vals;
            for (String val : vals = value.split(" ")) {
                index = WifiConfigStore.lookupString(val, WifiConfiguration.AuthAlgorithm.strings);
                if (0 > index) continue;
                config.allowedAuthAlgorithms.set(index);
            }
        }
        if (!TextUtils.isEmpty(value = WifiNative.getNetworkVariableCommand(config.networkId, "pairwise"))) {
            String[] vals;
            for (String val : vals = value.split(" ")) {
                index = WifiConfigStore.lookupString(val, WifiConfiguration.PairwiseCipher.strings);
                if (0 > index) continue;
                config.allowedPairwiseCiphers.set(index);
            }
        }
        if (!TextUtils.isEmpty(value = WifiNative.getNetworkVariableCommand(config.networkId, "group"))) {
            String[] vals;
            for (String val : vals = value.split(" ")) {
                index = WifiConfigStore.lookupString(val, WifiConfiguration.GroupCipher.strings);
                if (0 > index) continue;
                config.allowedGroupCiphers.set(index);
            }
        }
        for (WifiConfiguration.EnterpriseField field : config.enterpriseFields) {
            value = WifiNative.getNetworkVariableCommand(netId, field.varName());
            if (TextUtils.isEmpty(value)) continue;
            if (field != config.eap) {
                value = WifiConfigStore.removeDoubleQuotes(value);
            }
            field.setValue(value);
        }
    }

    private static String removeDoubleQuotes(String string2) {
        if (string2.length() <= 2) {
            return "";
        }
        return string2.substring(1, string2.length() - 1);
    }

    private static String convertToQuotedString(String string2) {
        return "\"" + string2 + "\"";
    }

    private static String makeString(BitSet set, String[] strings) {
        StringBuffer buf = new StringBuffer();
        int nextSetBit = -1;
        set = set.get(0, strings.length);
        while ((nextSetBit = set.nextSetBit(nextSetBit + 1)) != -1) {
            buf.append(strings[nextSetBit].replace('_', '-')).append(' ');
        }
        if (set.cardinality() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private static int lookupString(String string2, String[] strings) {
        int size = strings.length;
        string2 = string2.replace('-', '_');
        for (int i = 0; i < size; ++i) {
            if (!string2.equals(strings[i])) continue;
            return i;
        }
        WifiConfigStore.loge("Failed to look-up a string: " + string2);
        return -1;
    }

    private static int configKey(WifiConfiguration config) {
        String key = config.allowedKeyManagement.get(1) ? config.SSID + WifiConfiguration.KeyMgmt.strings[1] : (config.allowedKeyManagement.get(2) || config.allowedKeyManagement.get(3) ? config.SSID + WifiConfiguration.KeyMgmt.strings[2] : (config.wepKeys[0] != null ? config.SSID + "WEP" : config.SSID + WifiConfiguration.KeyMgmt.strings[0]));
        return key.hashCode();
    }

    static String dump() {
        StringBuffer sb = new StringBuffer();
        String LS = System.getProperty("line.separator");
        sb.append("sLastPriority ").append(sLastPriority).append(LS);
        sb.append("Configured networks ").append(LS);
        for (WifiConfiguration conf : WifiConfigStore.getConfiguredNetworks()) {
            sb.append(conf).append(LS);
        }
        return sb.toString();
    }

    public static String getConfigFile() {
        return ipConfigFile;
    }

    private static void loge(String s) {
        Log.e(TAG, s);
    }

    private static void log(String s) {
        Log.d(TAG, s);
    }

    static {
        sConfiguredNetworks = new HashMap();
        sNetworkIds = new HashMap();
        sLastPriority = -1;
        ipConfigFile = Environment.getDataDirectory() + "/misc/wifi/ipconfig.txt";
    }
}

