/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.NetworkInfo;
import android.net.wifi.StateChangeResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiNative;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pGroup;
import android.os.Message;
import android.util.Log;
import com.android.internal.util.StateMachine;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WifiMonitor {
    private static final String TAG = "WifiMonitor";
    private static final int CONNECTED = 1;
    private static final int DISCONNECTED = 2;
    private static final int STATE_CHANGE = 3;
    private static final int SCAN_RESULTS = 4;
    private static final int LINK_SPEED = 5;
    private static final int TERMINATING = 6;
    private static final int DRIVER_STATE = 7;
    private static final int EAP_FAILURE = 8;
    private static final int UNKNOWN = 9;
    private static final String EVENT_PREFIX_STR = "CTRL-EVENT-";
    private static final int EVENT_PREFIX_LEN_STR = "CTRL-EVENT-".length();
    private static final String WPA_EVENT_PREFIX_STR = "WPA:";
    private static final String PASSWORD_MAY_BE_INCORRECT_STR = "pre-shared key may be incorrect";
    private static final String WPS_OVERLAP_STR = "WPS-OVERLAP-DETECTED";
    private static final String CONNECTED_STR = "CONNECTED";
    private static final String DISCONNECTED_STR = "DISCONNECTED";
    private static final String STATE_CHANGE_STR = "STATE-CHANGE";
    private static final String SCAN_RESULTS_STR = "SCAN-RESULTS";
    private static final String LINK_SPEED_STR = "LINK-SPEED";
    private static final String TERMINATING_STR = "TERMINATING";
    private static final String DRIVER_STATE_STR = "DRIVER-STATE";
    private static final String EAP_FAILURE_STR = "EAP-FAILURE";
    private static final String EAP_AUTH_FAILURE_STR = "EAP authentication failed";
    private static Pattern mConnectedEventPattern = Pattern.compile("((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) .* \\[id=([0-9]+) ");
    private static final String P2P_EVENT_PREFIX_STR = "P2P";
    private static final String P2P_DEVICE_FOUND_STR = "P2P-DEVICE-FOUND";
    private static final String P2P_DEVICE_LOST_STR = "P2P-DEVICE-LOST";
    private static final String P2P_GO_NEG_REQUEST_STR = "P2P-GO-NEG-REQUEST";
    private static final String P2P_GO_NEG_SUCCESS_STR = "P2P-GO-NEG-SUCCESS";
    private static final String P2P_GO_NEG_FAILURE_STR = "P2P-GO-NEG-FAILURE";
    private static final String P2P_GROUP_FORMATION_SUCCESS_STR = "P2P-GROUP-FORMATION-SUCCESS";
    private static final String P2P_GROUP_FORMATION_FAILURE_STR = "P2P-GROUP-FORMATION-FAILURE";
    private static final String P2P_GROUP_STARTED_STR = "P2P-GROUP-STARTED";
    private static final String P2P_GROUP_REMOVED_STR = "P2P-GROUP-REMOVED";
    private static final String P2P_INVITATION_RECEIVED_STR = "P2P-INVITATION-RECEIVED";
    private static final String P2P_INVITATION_RESULT_STR = "P2P-INVITATION-RESULT";
    private static final String P2P_PROV_DISC_PBC_REQ_STR = "P2P-PROV-DISC-PBC-REQ";
    private static final String P2P_PROV_DISC_ENTER_PIN_STR = "P2P-PROV-DISC-ENTER-PIN";
    private static final String P2P_PROV_DISC_SHOW_PIN_STR = "P2P-PROV-DISC-SHOW-PIN";
    private static final String HOST_AP_EVENT_PREFIX_STR = "AP";
    private static final String AP_STA_CONNECTED_STR = "AP-STA-CONNECTED";
    private static final String AP_STA_DISCONNECTED_STR = "AP-STA-DISCONNECTED";
    private final StateMachine mStateMachine;
    private static final int BASE = 147456;
    public static final int SUP_CONNECTION_EVENT = 147457;
    public static final int SUP_DISCONNECTION_EVENT = 147458;
    public static final int NETWORK_CONNECTION_EVENT = 147459;
    public static final int NETWORK_DISCONNECTION_EVENT = 147460;
    public static final int SCAN_RESULTS_EVENT = 147461;
    public static final int SUPPLICANT_STATE_CHANGE_EVENT = 147462;
    public static final int AUTHENTICATION_FAILURE_EVENT = 147463;
    public static final int WPS_OVERLAP_EVENT = 147464;
    public static final int DRIVER_HUNG_EVENT = 147465;
    public static final int P2P_DEVICE_FOUND_EVENT = 147477;
    public static final int P2P_DEVICE_LOST_EVENT = 147478;
    public static final int P2P_GO_NEGOTIATION_REQUEST_EVENT = 147479;
    public static final int P2P_GO_NEGOTIATION_SUCCESS_EVENT = 147481;
    public static final int P2P_GO_NEGOTIATION_FAILURE_EVENT = 147482;
    public static final int P2P_GROUP_FORMATION_SUCCESS_EVENT = 147483;
    public static final int P2P_GROUP_FORMATION_FAILURE_EVENT = 147484;
    public static final int P2P_GROUP_STARTED_EVENT = 147485;
    public static final int P2P_GROUP_REMOVED_EVENT = 147486;
    public static final int P2P_INVITATION_RECEIVED_EVENT = 147487;
    public static final int P2P_INVITATION_RESULT_EVENT = 147488;
    public static final int P2P_PROV_DISC_PBC_REQ_EVENT = 147489;
    public static final int P2P_PROV_DISC_ENTER_PIN_EVENT = 147490;
    public static final int P2P_PROV_DISC_SHOW_PIN_EVENT = 147491;
    public static final int AP_STA_DISCONNECTED_EVENT = 147497;
    public static final int AP_STA_CONNECTED_EVENT = 147498;
    private static final String MONITOR_SOCKET_CLOSED_STR = "connection closed";
    private static final String WPA_RECV_ERROR_STR = "recv error";
    private int mRecvErrors = 0;
    private static final int MAX_RECV_ERRORS = 10;

    public WifiMonitor(StateMachine wifiStateMachine) {
        this.mStateMachine = wifiStateMachine;
    }

    public void startMonitoring() {
        new MonitorThread().start();
    }

    private void handleNetworkStateChange(NetworkInfo.DetailedState newState, String data) {
        Matcher match;
        String BSSID = null;
        int networkId = -1;
        if (newState == NetworkInfo.DetailedState.CONNECTED && (match = mConnectedEventPattern.matcher(data)).find()) {
            BSSID = match.group(1);
            try {
                networkId = Integer.parseInt(match.group(2));
            }
            catch (NumberFormatException e) {
                networkId = -1;
            }
        }
        this.notifyNetworkStateChange(newState, BSSID, networkId);
    }

    void notifyNetworkStateChange(NetworkInfo.DetailedState newState, String BSSID, int netId) {
        if (newState == NetworkInfo.DetailedState.CONNECTED) {
            Message m = this.mStateMachine.obtainMessage(147459, netId, 0, BSSID);
            this.mStateMachine.sendMessage(m);
        } else {
            Message m = this.mStateMachine.obtainMessage(147460, netId, 0, BSSID);
            this.mStateMachine.sendMessage(m);
        }
    }

    void notifySupplicantStateChange(int networkId, String BSSID, SupplicantState newState) {
        this.mStateMachine.sendMessage(this.mStateMachine.obtainMessage(147462, new StateChangeResult(networkId, BSSID, newState)));
    }

    private static void nap(int secs) {
        try {
            Thread.sleep(secs * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class MonitorThread
    extends Thread {
        public MonitorThread() {
            super(WifiMonitor.TAG);
        }

        public void run() {
            if (!this.connectToSupplicant()) {
                WifiMonitor.this.mStateMachine.sendMessage(147458);
                return;
            }
            WifiMonitor.this.mStateMachine.sendMessage(147457);
            while (true) {
                int ind;
                String eventStr;
                if (!(eventStr = WifiNative.waitForEvent()).startsWith(WifiMonitor.EVENT_PREFIX_STR)) {
                    if (eventStr.startsWith(WifiMonitor.WPA_EVENT_PREFIX_STR) && 0 < eventStr.indexOf(WifiMonitor.PASSWORD_MAY_BE_INCORRECT_STR)) {
                        WifiMonitor.this.mStateMachine.sendMessage(147463);
                        continue;
                    }
                    if (eventStr.startsWith(WifiMonitor.WPS_OVERLAP_STR)) {
                        WifiMonitor.this.mStateMachine.sendMessage(147464);
                        continue;
                    }
                    if (eventStr.startsWith(WifiMonitor.P2P_EVENT_PREFIX_STR)) {
                        this.handleP2pEvents(eventStr);
                        continue;
                    }
                    if (!eventStr.startsWith(WifiMonitor.HOST_AP_EVENT_PREFIX_STR)) continue;
                    this.handleHostApEvents(eventStr);
                    continue;
                }
                String eventName = eventStr.substring(EVENT_PREFIX_LEN_STR);
                int nameEnd = eventName.indexOf(32);
                if (nameEnd != -1) {
                    eventName = eventName.substring(0, nameEnd);
                }
                if (eventName.length() == 0) continue;
                int event = eventName.equals(WifiMonitor.CONNECTED_STR) ? 1 : (eventName.equals(WifiMonitor.DISCONNECTED_STR) ? 2 : (eventName.equals(WifiMonitor.STATE_CHANGE_STR) ? 3 : (eventName.equals(WifiMonitor.SCAN_RESULTS_STR) ? 4 : (eventName.equals(WifiMonitor.LINK_SPEED_STR) ? 5 : (eventName.equals(WifiMonitor.TERMINATING_STR) ? 6 : (eventName.equals(WifiMonitor.DRIVER_STATE_STR) ? 7 : (eventName.equals(WifiMonitor.EAP_FAILURE_STR) ? 8 : 9)))))));
                String eventData = eventStr;
                if (event == 7 || event == 5) {
                    eventData = eventData.split(" ")[1];
                } else if (event == 3 || event == 8) {
                    ind = eventStr.indexOf(" ");
                    if (ind != -1) {
                        eventData = eventStr.substring(ind + 1);
                    }
                } else {
                    ind = eventStr.indexOf(" - ");
                    if (ind != -1) {
                        eventData = eventStr.substring(ind + 3);
                    }
                }
                if (event == 3) {
                    this.handleSupplicantStateChange(eventData);
                } else if (event == 7) {
                    this.handleDriverEvent(eventData);
                } else {
                    if (event == 6) {
                        if (eventData.startsWith(WifiMonitor.MONITOR_SOCKET_CLOSED_STR)) break;
                        if (eventData.startsWith(WifiMonitor.WPA_RECV_ERROR_STR) && ++WifiMonitor.this.mRecvErrors <= 10) continue;
                        WifiMonitor.this.mStateMachine.sendMessage(147458);
                        break;
                    }
                    if (event == 8) {
                        if (eventData.startsWith(WifiMonitor.EAP_AUTH_FAILURE_STR)) {
                            WifiMonitor.this.mStateMachine.sendMessage(147463);
                        }
                    } else {
                        this.handleEvent(event, eventData);
                    }
                }
                WifiMonitor.this.mRecvErrors = 0;
            }
        }

        private boolean connectToSupplicant() {
            int connectTries = 0;
            while (true) {
                if (WifiNative.connectToSupplicant()) {
                    return true;
                }
                if (connectTries++ >= 5) break;
                WifiMonitor.nap(1);
            }
            return false;
        }

        private void handleDriverEvent(String state) {
            if (state == null) {
                return;
            }
            if (state.equals("HANGED")) {
                WifiMonitor.this.mStateMachine.sendMessage(147465);
            }
        }

        void handleEvent(int event, String remainder) {
            switch (event) {
                case 2: {
                    WifiMonitor.this.handleNetworkStateChange(NetworkInfo.DetailedState.DISCONNECTED, remainder);
                    break;
                }
                case 1: {
                    WifiMonitor.this.handleNetworkStateChange(NetworkInfo.DetailedState.CONNECTED, remainder);
                    break;
                }
                case 4: {
                    WifiMonitor.this.mStateMachine.sendMessage(147461);
                    break;
                }
            }
        }

        private void handleP2pEvents(String dataString) {
            if (dataString.startsWith(WifiMonitor.P2P_DEVICE_FOUND_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147477, new WifiP2pDevice(dataString));
            } else if (dataString.startsWith(WifiMonitor.P2P_DEVICE_LOST_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147478, new WifiP2pDevice(dataString));
            } else if (dataString.startsWith(WifiMonitor.P2P_GO_NEG_REQUEST_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147479, new WifiP2pConfig(dataString));
            } else if (dataString.startsWith(WifiMonitor.P2P_GO_NEG_SUCCESS_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147481);
            } else if (dataString.startsWith(WifiMonitor.P2P_GO_NEG_FAILURE_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147482);
            } else if (dataString.startsWith(WifiMonitor.P2P_GROUP_FORMATION_SUCCESS_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147483);
            } else if (dataString.startsWith(WifiMonitor.P2P_GROUP_FORMATION_FAILURE_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147484);
            } else if (dataString.startsWith(WifiMonitor.P2P_GROUP_STARTED_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147485, new WifiP2pGroup(dataString));
            } else if (dataString.startsWith(WifiMonitor.P2P_GROUP_REMOVED_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147486, new WifiP2pGroup(dataString));
            } else if (dataString.startsWith(WifiMonitor.P2P_INVITATION_RECEIVED_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147487, new WifiP2pGroup(dataString));
            } else if (dataString.startsWith(WifiMonitor.P2P_INVITATION_RESULT_STR)) {
                String[] tokens = dataString.split(" ");
                if (tokens.length != 2) {
                    return;
                }
                String[] nameValue = tokens[1].split("=");
                if (nameValue.length != 2) {
                    return;
                }
                WifiMonitor.this.mStateMachine.sendMessage(147488, nameValue[1]);
            } else if (dataString.startsWith(WifiMonitor.P2P_PROV_DISC_PBC_REQ_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147489, new WifiP2pDevice(dataString));
            } else if (dataString.startsWith(WifiMonitor.P2P_PROV_DISC_ENTER_PIN_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147490, new WifiP2pDevice(dataString));
            }
        }

        private void handleHostApEvents(String dataString) {
            String[] tokens = dataString.split(" ");
            if (tokens[0].equals(WifiMonitor.AP_STA_CONNECTED_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147498, tokens[1]);
            } else if (tokens[0].equals(WifiMonitor.AP_STA_DISCONNECTED_STR)) {
                WifiMonitor.this.mStateMachine.sendMessage(147497, tokens[1]);
            }
        }

        private void handleSupplicantStateChange(String dataString) {
            String[] dataTokens = dataString.split(" ");
            String BSSID = null;
            int networkId = -1;
            int newState = -1;
            for (String token : dataTokens) {
                int value;
                String[] nameValue = token.split("=");
                if (nameValue.length != 2) continue;
                if (nameValue[0].equals("BSSID")) {
                    BSSID = nameValue[1];
                    continue;
                }
                try {
                    value = Integer.parseInt(nameValue[1]);
                }
                catch (NumberFormatException e) {
                    Log.w(WifiMonitor.TAG, "STATE-CHANGE non-integer parameter: " + token);
                    continue;
                }
                if (nameValue[0].equals("id")) {
                    networkId = value;
                    continue;
                }
                if (!nameValue[0].equals("state")) continue;
                newState = value;
            }
            if (newState == -1) {
                return;
            }
            SupplicantState newSupplicantState = SupplicantState.INVALID;
            for (SupplicantState state : SupplicantState.values()) {
                if (state.ordinal() != newState) continue;
                newSupplicantState = state;
                break;
            }
            if (newSupplicantState == SupplicantState.INVALID) {
                Log.w(WifiMonitor.TAG, "Invalid supplicant state: " + newState);
            }
            WifiMonitor.this.notifySupplicantStateChange(networkId, BSSID, newSupplicantState);
        }
    }
}

