/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WpsInfo;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pGroup;
import java.util.ArrayList;

public class WifiNative {
    static final int BLUETOOTH_COEXISTENCE_MODE_ENABLED = 0;
    static final int BLUETOOTH_COEXISTENCE_MODE_DISABLED = 1;
    static final int BLUETOOTH_COEXISTENCE_MODE_SENSE = 2;

    public static native String getErrorString(int var0);

    public static native boolean loadDriver();

    public static native boolean isDriverLoaded();

    public static native boolean unloadDriver();

    public static native boolean startSupplicant();

    public static native boolean startP2pSupplicant();

    public static native boolean stopSupplicant();

    public static native boolean killSupplicant();

    public static native boolean connectToSupplicant();

    public static native void closeSupplicantConnection();

    public static native boolean pingCommand();

    public static native boolean scanCommand(boolean var0);

    public static native boolean setScanModeCommand(boolean var0);

    public static native String listNetworksCommand();

    public static native int addNetworkCommand();

    public static native boolean setNetworkVariableCommand(int var0, String var1, String var2);

    public static native String getNetworkVariableCommand(int var0, String var1);

    public static native boolean removeNetworkCommand(int var0);

    public static native boolean enableNetworkCommand(int var0, boolean var1);

    public static native boolean disableNetworkCommand(int var0);

    public static native boolean reconnectCommand();

    public static native boolean reassociateCommand();

    public static native boolean disconnectCommand();

    public static native String statusCommand();

    public static native String getMacAddressCommand();

    public static native String scanResultsCommand();

    public static native boolean startDriverCommand();

    public static native boolean stopDriverCommand();

    public static native boolean startFilteringMulticastV4Packets();

    public static native boolean stopFilteringMulticastV4Packets();

    public static native boolean startFilteringMulticastV6Packets();

    public static native boolean stopFilteringMulticastV6Packets();

    public static native boolean setPowerModeCommand(int var0);

    public static native int getBandCommand();

    public static native boolean setBandCommand(int var0);

    public static native int getPowerModeCommand();

    public static native boolean setBluetoothCoexistenceModeCommand(int var0);

    public static native boolean setBluetoothCoexistenceScanModeCommand(boolean var0);

    public static native boolean saveConfigCommand();

    public static native boolean reloadConfigCommand();

    public static native boolean setScanResultHandlingCommand(int var0);

    public static native boolean addToBlacklistCommand(String var0);

    public static native boolean clearBlacklistCommand();

    public static native boolean startWpsPbcCommand(String var0);

    public static native boolean startWpsWithPinFromAccessPointCommand(String var0, String var1);

    public static native String startWpsWithPinFromDeviceCommand(String var0);

    public static native boolean setSuspendOptimizationsCommand(boolean var0);

    public static native boolean setCountryCodeCommand(String var0);

    public static native String waitForEvent();

    public static native void enableBackgroundScanCommand(boolean var0);

    public static native void setScanIntervalCommand(int var0);

    private static native boolean doBooleanCommand(String var0);

    private static native int doIntCommand(String var0);

    private static native String doStringCommand(String var0);

    public static String signalPoll() {
        return WifiNative.doStringCommand("SIGNAL_POLL");
    }

    public static boolean wpsPbc() {
        return WifiNative.doBooleanCommand("WPS_PBC");
    }

    public static boolean wpsPin(String pin) {
        return WifiNative.doBooleanCommand("WPS_PIN any " + pin);
    }

    public static boolean setPersistentReconnect(boolean enabled) {
        int value = enabled ? 1 : 0;
        return WifiNative.doBooleanCommand("SET persistent_reconnect " + value);
    }

    public static boolean setDeviceName(String name) {
        return WifiNative.doBooleanCommand("SET device_name " + name);
    }

    public static boolean setDeviceType(String type) {
        return WifiNative.doBooleanCommand("SET device_type " + type);
    }

    public static boolean p2pFind() {
        return WifiNative.doBooleanCommand("P2P_FIND");
    }

    public static boolean p2pFind(int timeout) {
        if (timeout <= 0) {
            return WifiNative.p2pFind();
        }
        return WifiNative.doBooleanCommand("P2P_FIND " + timeout);
    }

    public static boolean p2pListen() {
        return WifiNative.doBooleanCommand("P2P_LISTEN");
    }

    public static boolean p2pListen(int timeout) {
        if (timeout <= 0) {
            return WifiNative.p2pListen();
        }
        return WifiNative.doBooleanCommand("P2P_LISTEN " + timeout);
    }

    public static boolean p2pFlush() {
        return WifiNative.doBooleanCommand("P2P_FLUSH");
    }

    public static String p2pConnect(WifiP2pConfig config, boolean joinExistingGroup) {
        int groupOwnerIntent;
        if (config == null) {
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        WpsInfo wps = config.wps;
        args.add(config.deviceAddress);
        switch (wps.setup) {
            case 0: {
                args.add("pbc");
                break;
            }
            case 1: {
                args.add("pin");
                args.add("display");
                break;
            }
            case 2: {
                args.add(wps.pin);
                args.add("keypad");
                break;
            }
            case 3: {
                args.add(wps.pin);
                args.add("label");
            }
        }
        if (joinExistingGroup) {
            args.add("join");
        }
        if ((groupOwnerIntent = config.groupOwnerIntent) < 0 || groupOwnerIntent > 15) {
            groupOwnerIntent = 3;
        }
        args.add("go_intent=" + groupOwnerIntent);
        String command = "P2P_CONNECT ";
        for (String s : args) {
            command = command + s + " ";
        }
        return WifiNative.doStringCommand(command);
    }

    public static boolean p2pCancelConnect() {
        return WifiNative.doBooleanCommand("P2P_CANCEL");
    }

    public static boolean p2pGroupAdd() {
        return WifiNative.doBooleanCommand("P2P_GROUP_ADD");
    }

    public static boolean p2pGroupRemove(String iface) {
        if (iface == null) {
            return false;
        }
        return WifiNative.doBooleanCommand("P2P_GROUP_REMOVE " + iface);
    }

    public static boolean p2pReject(String deviceAddress) {
        return WifiNative.doBooleanCommand("P2P_REJECT " + deviceAddress);
    }

    public static boolean p2pInvite(WifiP2pGroup group, String deviceAddress) {
        if (deviceAddress == null) {
            return false;
        }
        if (group == null) {
            return WifiNative.doBooleanCommand("P2P_INVITE peer=" + deviceAddress);
        }
        return WifiNative.doBooleanCommand("P2P_INVITE group=" + group.getInterface() + " peer=" + deviceAddress + " go_dev_addr=" + group.getOwner().deviceAddress);
    }

    public static boolean p2pReinvoke(int netId, String deviceAddress) {
        if (deviceAddress == null || netId < 0) {
            return false;
        }
        return WifiNative.doBooleanCommand("P2P_INVITE persistent=" + netId + " peer=" + deviceAddress);
    }

    public static String p2pGetInterfaceAddress(String deviceAddress) {
        String[] tokens;
        if (deviceAddress == null) {
            return null;
        }
        String peerInfo = WifiNative.p2pPeer(deviceAddress);
        if (peerInfo == null) {
            return null;
        }
        for (String token : tokens = peerInfo.split("\n")) {
            if (!token.startsWith("intended_addr=")) continue;
            String[] nameValue = token.split("=");
            if (nameValue.length != 2) break;
            return nameValue[1];
        }
        return null;
    }

    public static String p2pGetDeviceAddress() {
        String[] tokens;
        String status = WifiNative.statusCommand();
        if (status == null) {
            return "";
        }
        for (String token : tokens = status.split("\n")) {
            if (!token.startsWith("p2p_device_address=")) continue;
            String[] nameValue = token.split("=");
            if (nameValue.length != 2) break;
            return nameValue[1];
        }
        return "";
    }

    public static String p2pPeer(String deviceAddress) {
        return WifiNative.doStringCommand("P2P_PEER " + deviceAddress);
    }
}

