/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.backup.IBackupManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.DhcpInfoInternal;
import android.net.DhcpStateMachine;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.net.wifi.NetworkUpdateResult;
import android.net.wifi.ScanResult;
import android.net.wifi.StateChangeResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.SupplicantStateTracker;
import android.net.wifi.WifiApConfigStore;
import android.net.wifi.WifiConfigStore;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiMonitor;
import android.net.wifi.WifiNative;
import android.net.wifi.WpsInfo;
import android.net.wifi.WpsResult;
import android.net.wifi.WpsStateMachine;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.Messenger;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.EventLog;
import android.util.Log;
import android.util.LruCache;
import com.android.internal.app.IBatteryStats;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WifiStateMachine
extends StateMachine {
    private static final String TAG = "WifiStateMachine";
    private static final String NETWORKTYPE = "WIFI";
    private static final boolean DBG = false;
    private static final String SOFTAP_IFACE = "wl0.1";
    private WifiMonitor mWifiMonitor;
    private INetworkManagementService mNwService;
    private ConnectivityManager mCm;
    private List<ScanResult> mScanResults;
    private static final Pattern scanResultPattern = Pattern.compile("\t+");
    private static final int SCAN_RESULT_CACHE_SIZE = 80;
    private final LruCache<String, ScanResult> mScanResultCache;
    private String mInterfaceName;
    private String mTetherInterfaceName;
    private int mLastSignalLevel = -1;
    private String mLastBssid;
    private int mLastNetworkId;
    private boolean mEnableRssiPolling = false;
    private boolean mEnableBackgroundScan = false;
    private int mRssiPollToken = 0;
    private int mReconnectCount = 0;
    private boolean mIsScanMode = false;
    private boolean mScanResultIsPending = false;
    private boolean mBluetoothConnectionActive = false;
    private static final int POLL_RSSI_INTERVAL_MSECS = 3000;
    private static final int SUPPLICANT_RESTART_INTERVAL_MSECS = 5000;
    private static final int SUPPLICANT_RESTART_TRIES = 5;
    private int mSupplicantRestartCount = 0;
    private int mSupplicantStopFailureToken = 0;
    private static final int TETHER_NOTIFICATION_TIME_OUT_MSECS = 5000;
    private int mTetherToken = 0;
    private LinkProperties mLinkProperties;
    private PowerManager.WakeLock mWakeLock;
    private Context mContext;
    private DhcpInfoInternal mDhcpInfoInternal;
    private WifiInfo mWifiInfo;
    private NetworkInfo mNetworkInfo;
    private SupplicantStateTracker mSupplicantStateTracker;
    private WpsStateMachine mWpsStateMachine;
    private DhcpStateMachine mDhcpStateMachine;
    private AlarmManager mAlarmManager;
    private PendingIntent mScanIntent;
    private AtomicInteger mFrequencyBand = new AtomicInteger(0);
    private AtomicBoolean mFilteringMulticastV4Packets = new AtomicBoolean(true);
    private AsyncChannel mReplyChannel = new AsyncChannel();
    private WifiP2pManager mWifiP2pManager;
    private AsyncChannel mWifiP2pChannel = new AsyncChannel();
    private AsyncChannel mWifiApConfigChannel = new AsyncChannel();
    private static final int EVENTLOG_WIFI_STATE_CHANGED = 50021;
    private static final int EVENTLOG_WIFI_EVENT_HANDLED = 50022;
    private static final int EVENTLOG_SUPPLICANT_STATE_CHANGED = 50023;
    static final int BASE = 131072;
    static final int CMD_LOAD_DRIVER = 131073;
    static final int CMD_UNLOAD_DRIVER = 131074;
    static final int CMD_LOAD_DRIVER_SUCCESS = 131075;
    static final int CMD_LOAD_DRIVER_FAILURE = 131076;
    static final int CMD_UNLOAD_DRIVER_SUCCESS = 131077;
    static final int CMD_UNLOAD_DRIVER_FAILURE = 131078;
    static final int CMD_START_SUPPLICANT = 131083;
    static final int CMD_STOP_SUPPLICANT = 131084;
    static final int CMD_START_DRIVER = 131085;
    static final int CMD_STOP_DRIVER = 131086;
    static final int CMD_STATIC_IP_SUCCESS = 131087;
    static final int CMD_STATIC_IP_FAILURE = 131088;
    static final int CMD_STOP_SUPPLICANT_FAILED = 131089;
    static final int CMD_DELAYED_STOP_DRIVER = 131090;
    static final int CMD_START_AP = 131093;
    static final int CMD_START_AP_SUCCESS = 131094;
    static final int CMD_START_AP_FAILURE = 131095;
    static final int CMD_STOP_AP = 131096;
    static final int CMD_SET_AP_CONFIG = 131097;
    static final int CMD_SET_AP_CONFIG_COMPLETED = 131098;
    static final int CMD_REQUEST_AP_CONFIG = 131099;
    static final int CMD_RESPONSE_AP_CONFIG = 131100;
    static final int CMD_TETHER_STATE_CHANGE = 131101;
    static final int CMD_TETHER_NOTIFICATION_TIMED_OUT = 131102;
    static final int CMD_BLUETOOTH_ADAPTER_STATE_CHANGE = 131103;
    static final int CMD_PING_SUPPLICANT = 131123;
    static final int CMD_ADD_OR_UPDATE_NETWORK = 131124;
    static final int CMD_REMOVE_NETWORK = 131125;
    static final int CMD_ENABLE_NETWORK = 131126;
    static final int CMD_ENABLE_ALL_NETWORKS = 131127;
    static final int CMD_DISABLE_NETWORK = 131128;
    static final int CMD_BLACKLIST_NETWORK = 131129;
    static final int CMD_CLEAR_BLACKLIST = 131130;
    static final int CMD_SAVE_CONFIG = 131131;
    static final int CMD_START_SCAN = 131143;
    static final int CMD_SET_SCAN_MODE = 131144;
    static final int CMD_SET_SCAN_TYPE = 131145;
    static final int CMD_DISCONNECT = 131146;
    static final int CMD_RECONNECT = 131147;
    static final int CMD_REASSOCIATE = 131148;
    static final int CMD_SET_HIGH_PERF_MODE = 131149;
    static final int CMD_SET_COUNTRY_CODE = 131152;
    static final int CMD_ENABLE_RSSI_POLL = 131154;
    static final int CMD_RSSI_POLL = 131155;
    static final int CMD_START_PACKET_FILTERING = 131156;
    static final int CMD_STOP_PACKET_FILTERING = 131157;
    static final int MULTICAST_V6 = 1;
    static final int MULTICAST_V4 = 0;
    static final int CMD_CONNECT_NETWORK = 131158;
    static final int CMD_SAVE_NETWORK = 131159;
    static final int CMD_FORGET_NETWORK = 131160;
    static final int CMD_START_WPS = 131161;
    static final int CMD_SET_FREQUENCY_BAND = 131162;
    static final int CMD_ENABLE_BACKGROUND_SCAN = 131163;
    static final int CMD_RESET_SUPPLICANT_STATE = 131183;
    static final int WPS_COMPLETED_EVENT = 131193;
    static final int CMD_RESET_WPS_STATE = 131194;
    public static final int WIFI_ENABLE_PENDING = 131203;
    public static final int P2P_ENABLE_PROCEED = 131204;
    private static final int CONNECT_MODE = 1;
    private static final int SCAN_ONLY_MODE = 2;
    private static final int SCAN_ACTIVE = 1;
    private static final int SCAN_PASSIVE = 2;
    private static final int SUCCESS = 1;
    private static final int FAILURE = -1;
    private static final int IN_ECM_STATE = 1;
    private static final int NOT_IN_ECM_STATE = 0;
    private static final int DEFAULT_MAX_DHCP_RETRIES = 9;
    static final int POWER_MODE_ACTIVE = 1;
    static final int POWER_MODE_AUTO = 0;
    private int mPowerMode = 0;
    private final int mDefaultFrameworkScanIntervalMs;
    private final int mDefaultSupplicantScanIntervalMs;
    private static final int MIN_INTERVAL_ENABLE_ALL_NETWORKS_MS = 600000;
    private long mLastEnableAllNetworksTime;
    private static final int DELAYED_DRIVER_STOP_MS = 120000;
    private int mDelayedStopCounter;
    private boolean mInDelayedStop = false;
    private static final int MIN_RSSI = -200;
    private static final int MAX_RSSI = 256;
    private State mDefaultState = new DefaultState();
    private State mInitialState = new InitialState();
    private State mDriverUnloadingState = new DriverUnloadingState();
    private State mDriverUnloadedState = new DriverUnloadedState();
    private State mDriverFailedState = new DriverFailedState();
    private State mDriverLoadingState = new DriverLoadingState();
    private State mDriverLoadedState = new DriverLoadedState();
    private State mSupplicantStartingState = new SupplicantStartingState();
    private State mSupplicantStartedState = new SupplicantStartedState();
    private State mSupplicantStoppingState = new SupplicantStoppingState();
    private State mDriverStartingState = new DriverStartingState();
    private State mDriverStartedState = new DriverStartedState();
    private State mDriverStoppingState = new DriverStoppingState();
    private State mDriverStoppedState = new DriverStoppedState();
    private State mScanModeState = new ScanModeState();
    private State mConnectModeState = new ConnectModeState();
    private State mConnectingState = new ConnectingState();
    private State mConnectedState = new ConnectedState();
    private State mDisconnectingState = new DisconnectingState();
    private State mDisconnectedState = new DisconnectedState();
    private State mWaitForWpsCompletionState = new WaitForWpsCompletionState();
    private State mSoftApStartingState = new SoftApStartingState();
    private State mSoftApStartedState = new SoftApStartedState();
    private State mTetheringState = new TetheringState();
    private State mTetheredState = new TetheredState();
    private State mSoftApStoppingState = new SoftApStoppingState();
    private State mWaitForP2pDisableState = new WaitForP2pDisableState();
    private final AtomicInteger mWifiState = new AtomicInteger(1);
    private final AtomicInteger mWifiApState = new AtomicInteger(11);
    private final AtomicInteger mLastEnableUid = new AtomicInteger(Process.myUid());
    private final AtomicInteger mLastApEnableUid = new AtomicInteger(Process.myUid());
    private static final int SCAN_REQUEST = 0;
    private static final String ACTION_START_SCAN = "com.android.server.WifiManager.action.START_SCAN";
    private boolean mIsRunning = false;
    private boolean mReportedRunning = false;
    private final WorkSource mRunningWifiUids = new WorkSource();
    private final WorkSource mLastRunningWifiUids = new WorkSource();
    private final IBatteryStats mBatteryStats;
    private boolean mNextWifiActionExplicit = false;
    private int mLastExplicitNetworkId;
    private long mLastNetworkChoiceTime;
    private static final long EXPLICIT_CONNECT_ALLOWED_DELAY_MS = 120000L;

    public WifiStateMachine(Context context, String wlanInterface) {
        super(TAG);
        this.mContext = context;
        this.mInterfaceName = wlanInterface;
        this.mNetworkInfo = new NetworkInfo(1, 0, NETWORKTYPE, "");
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batteryinfo"));
        IBinder b = ServiceManager.getService("network_management");
        this.mNwService = INetworkManagementService.Stub.asInterface(b);
        this.mWifiMonitor = new WifiMonitor(this);
        this.mDhcpInfoInternal = new DhcpInfoInternal();
        this.mWifiInfo = new WifiInfo();
        this.mSupplicantStateTracker = new SupplicantStateTracker(context, this, this.getHandler());
        this.mWpsStateMachine = new WpsStateMachine(context, this, this.getHandler());
        this.mLinkProperties = new LinkProperties();
        WifiApConfigStore wifiApConfigStore = WifiApConfigStore.makeWifiApConfigStore(context, this.getHandler());
        wifiApConfigStore.loadApConfiguration();
        this.mWifiApConfigChannel.connectSync(this.mContext, this.getHandler(), wifiApConfigStore.getMessenger());
        this.mNetworkInfo.setIsAvailable(false);
        this.mLinkProperties.clear();
        this.mLastBssid = null;
        this.mLastNetworkId = -1;
        this.mLastSignalLevel = -1;
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent scanIntent = new Intent(ACTION_START_SCAN, null);
        this.mScanIntent = PendingIntent.getBroadcast(this.mContext, 0, scanIntent, 0);
        this.mDefaultFrameworkScanIntervalMs = this.mContext.getResources().getInteger(17694730);
        this.mDefaultSupplicantScanIntervalMs = this.mContext.getResources().getInteger(17694729);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ArrayList<String> available = intent.getStringArrayListExtra("availableArray");
                ArrayList<String> active = intent.getStringArrayListExtra("activeArray");
                WifiStateMachine.this.sendMessage(131101, new TetherStateChange(available, active));
            }
        }, new IntentFilter("android.net.conn.TETHER_STATE_CHANGED"));
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                WifiStateMachine.this.startScan(false);
            }
        }, new IntentFilter(ACTION_START_SCAN));
        this.mScanResultCache = new LruCache(80);
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, TAG);
        this.addState(this.mDefaultState);
        this.addState(this.mInitialState, this.mDefaultState);
        this.addState(this.mDriverUnloadingState, this.mDefaultState);
        this.addState(this.mDriverUnloadedState, this.mDefaultState);
        this.addState(this.mDriverFailedState, this.mDriverUnloadedState);
        this.addState(this.mDriverLoadingState, this.mDefaultState);
        this.addState(this.mDriverLoadedState, this.mDefaultState);
        this.addState(this.mSupplicantStartingState, this.mDefaultState);
        this.addState(this.mSupplicantStartedState, this.mDefaultState);
        this.addState(this.mDriverStartingState, this.mSupplicantStartedState);
        this.addState(this.mDriverStartedState, this.mSupplicantStartedState);
        this.addState(this.mScanModeState, this.mDriverStartedState);
        this.addState(this.mConnectModeState, this.mDriverStartedState);
        this.addState(this.mConnectingState, this.mConnectModeState);
        this.addState(this.mConnectedState, this.mConnectModeState);
        this.addState(this.mDisconnectingState, this.mConnectModeState);
        this.addState(this.mDisconnectedState, this.mConnectModeState);
        this.addState(this.mWaitForWpsCompletionState, this.mConnectModeState);
        this.addState(this.mDriverStoppingState, this.mSupplicantStartedState);
        this.addState(this.mDriverStoppedState, this.mSupplicantStartedState);
        this.addState(this.mSupplicantStoppingState, this.mDefaultState);
        this.addState(this.mSoftApStartingState, this.mDefaultState);
        this.addState(this.mSoftApStartedState, this.mDefaultState);
        this.addState(this.mTetheringState, this.mSoftApStartedState);
        this.addState(this.mTetheredState, this.mSoftApStartedState);
        this.addState(this.mSoftApStoppingState, this.mDefaultState);
        this.addState(this.mWaitForP2pDisableState, this.mDefaultState);
        this.setInitialState(this.mInitialState);
        this.start();
    }

    public boolean syncPingSupplicant(AsyncChannel channel) {
        Message resultMsg = channel.sendMessageSynchronously(131123);
        boolean result = resultMsg.arg1 != -1;
        resultMsg.recycle();
        return result;
    }

    public void startScan(boolean forceActive) {
        this.sendMessage(this.obtainMessage(131143, forceActive ? 1 : 2, 0));
    }

    public void setWifiEnabled(boolean enable) {
        this.mLastEnableUid.set(Binder.getCallingUid());
        if (enable) {
            this.sendMessage(this.obtainMessage(131073, 2, 0));
            this.sendMessage(131083);
        } else {
            this.sendMessage(131084);
            this.sendMessage(this.obtainMessage(131074, 1, 0));
        }
    }

    public void setWifiApEnabled(WifiConfiguration wifiConfig, boolean enable) {
        this.mLastApEnableUid.set(Binder.getCallingUid());
        if (enable) {
            this.sendMessage(this.obtainMessage(131073, 12, 0));
            this.sendMessage(this.obtainMessage(131093, wifiConfig));
        } else {
            this.sendMessage(131096);
            this.sendMessage(this.obtainMessage(131074, 11, 0));
        }
    }

    public void setWifiApConfiguration(WifiConfiguration config) {
        this.mWifiApConfigChannel.sendMessage(131097, config);
    }

    public WifiConfiguration syncGetWifiApConfiguration() {
        Message resultMsg = this.mWifiApConfigChannel.sendMessageSynchronously(131099);
        WifiConfiguration ret = (WifiConfiguration)resultMsg.obj;
        resultMsg.recycle();
        return ret;
    }

    public int syncGetWifiState() {
        return this.mWifiState.get();
    }

    public String syncGetWifiStateByName() {
        switch (this.mWifiState.get()) {
            case 0: {
                return "disabling";
            }
            case 1: {
                return "disabled";
            }
            case 2: {
                return "enabling";
            }
            case 3: {
                return "enabled";
            }
            case 4: {
                return "unknown state";
            }
        }
        return "[invalid state]";
    }

    public int syncGetWifiApState() {
        return this.mWifiApState.get();
    }

    public String syncGetWifiApStateByName() {
        switch (this.mWifiApState.get()) {
            case 10: {
                return "disabling";
            }
            case 11: {
                return "disabled";
            }
            case 12: {
                return "enabling";
            }
            case 13: {
                return "enabled";
            }
            case 14: {
                return "failed";
            }
        }
        return "[invalid state]";
    }

    public WifiInfo syncRequestConnectionInfo() {
        return this.mWifiInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DhcpInfo syncGetDhcpInfo() {
        DhcpInfoInternal dhcpInfoInternal = this.mDhcpInfoInternal;
        synchronized (dhcpInfoInternal) {
            return this.mDhcpInfoInternal.makeDhcpInfo();
        }
    }

    public void setDriverStart(boolean enable, boolean ecm) {
        if (enable) {
            this.sendMessage(131085);
        } else {
            this.sendMessage(this.obtainMessage(131086, ecm ? 1 : 0, 0));
        }
    }

    public void setScanOnlyMode(boolean enable) {
        if (enable) {
            this.sendMessage(this.obtainMessage(131144, 2, 0));
        } else {
            this.sendMessage(this.obtainMessage(131144, 1, 0));
        }
    }

    public void setScanType(boolean active) {
        if (active) {
            this.sendMessage(this.obtainMessage(131145, 1, 0));
        } else {
            this.sendMessage(this.obtainMessage(131145, 2, 0));
        }
    }

    public List<ScanResult> syncGetScanResultsList() {
        return this.mScanResults;
    }

    public void disconnectCommand() {
        this.sendMessage(131146);
    }

    public void reconnectCommand() {
        this.sendMessage(131147);
    }

    public void reassociateCommand() {
        this.sendMessage(131148);
    }

    public int syncAddOrUpdateNetwork(AsyncChannel channel, WifiConfiguration config) {
        Message resultMsg = channel.sendMessageSynchronously(131124, config);
        int result = resultMsg.arg1;
        resultMsg.recycle();
        return result;
    }

    public List<WifiConfiguration> syncGetConfiguredNetworks() {
        return WifiConfigStore.getConfiguredNetworks();
    }

    public boolean syncRemoveNetwork(AsyncChannel channel, int networkId) {
        Message resultMsg = channel.sendMessageSynchronously(131125, networkId);
        boolean result = resultMsg.arg1 != -1;
        resultMsg.recycle();
        return result;
    }

    public boolean syncEnableNetwork(AsyncChannel channel, int netId, boolean disableOthers) {
        Message resultMsg = channel.sendMessageSynchronously(131126, netId, disableOthers ? 1 : 0);
        boolean result = resultMsg.arg1 != -1;
        resultMsg.recycle();
        return result;
    }

    public boolean syncDisableNetwork(AsyncChannel channel, int netId) {
        Message resultMsg = channel.sendMessageSynchronously(131128, netId, 0);
        boolean result = resultMsg.arg1 != -1;
        resultMsg.recycle();
        return result;
    }

    public void addToBlacklist(String bssid) {
        this.sendMessage(this.obtainMessage(131129, bssid));
    }

    public void clearBlacklist() {
        this.sendMessage(this.obtainMessage(131130));
    }

    public void connectNetwork(int netId) {
        this.sendMessage(this.obtainMessage(131158, netId, 0));
    }

    public void connectNetwork(WifiConfiguration wifiConfig) {
        this.sendMessage(this.obtainMessage(131158, -1, 0, wifiConfig));
    }

    public void saveNetwork(WifiConfiguration wifiConfig) {
        this.sendMessage(this.obtainMessage(131159, wifiConfig));
    }

    public void forgetNetwork(int netId) {
        this.sendMessage(this.obtainMessage(131160, netId, 0));
    }

    public void disableNetwork(Messenger replyTo, int netId, int reason) {
        Message message = this.obtainMessage(131128, netId, reason);
        message.replyTo = replyTo;
        this.sendMessage(message);
    }

    public void startWps(Messenger replyTo, WpsInfo config) {
        Message msg = this.obtainMessage(131161, config);
        msg.replyTo = replyTo;
        this.sendMessage(msg);
    }

    public void enableRssiPolling(boolean enabled) {
        this.sendMessage(this.obtainMessage(131154, enabled ? 1 : 0, 0));
    }

    public void enableBackgroundScanCommand(boolean enabled) {
        this.sendMessage(this.obtainMessage(131163, enabled ? 1 : 0, 0));
    }

    public void enableAllNetworks() {
        this.sendMessage(131127);
    }

    public void startFilteringMulticastV4Packets() {
        this.mFilteringMulticastV4Packets.set(true);
        this.sendMessage(this.obtainMessage(131156, 0, 0));
    }

    public void stopFilteringMulticastV4Packets() {
        this.mFilteringMulticastV4Packets.set(false);
        this.sendMessage(this.obtainMessage(131157, 0, 0));
    }

    public void startFilteringMulticastV6Packets() {
        this.sendMessage(this.obtainMessage(131156, 1, 0));
    }

    public void stopFilteringMulticastV6Packets() {
        this.sendMessage(this.obtainMessage(131157, 1, 0));
    }

    public void setHighPerfModeEnabled(boolean enable) {
        this.sendMessage(this.obtainMessage(131149, enable ? 1 : 0, 0));
    }

    public void setCountryCode(String countryCode, boolean persist) {
        if (persist) {
            Settings.Secure.putString(this.mContext.getContentResolver(), "wifi_country_code", countryCode);
        }
        this.sendMessage(this.obtainMessage(131152, countryCode));
    }

    public void setFrequencyBand(int band, boolean persist) {
        if (persist) {
            Settings.Secure.putInt(this.mContext.getContentResolver(), "wifi_frequency_band", band);
        }
        this.sendMessage(this.obtainMessage(131162, band, 0));
    }

    public int getFrequencyBand() {
        return this.mFrequencyBand.get();
    }

    public String getConfigFile() {
        return WifiConfigStore.getConfigFile();
    }

    public void sendBluetoothAdapterStateChange(int state) {
        this.sendMessage(this.obtainMessage(131103, state, 0));
    }

    public boolean syncSaveConfig(AsyncChannel channel) {
        Message resultMsg = channel.sendMessageSynchronously(131131);
        boolean result = resultMsg.arg1 != -1;
        resultMsg.recycle();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBatteryWorkSource(WorkSource newSource) {
        WorkSource workSource = this.mRunningWifiUids;
        synchronized (workSource) {
            try {
                if (newSource != null) {
                    this.mRunningWifiUids.set(newSource);
                }
                if (this.mIsRunning) {
                    if (this.mReportedRunning) {
                        if (this.mLastRunningWifiUids.diff(this.mRunningWifiUids)) {
                            this.mBatteryStats.noteWifiRunningChanged(this.mLastRunningWifiUids, this.mRunningWifiUids);
                            this.mLastRunningWifiUids.set(this.mRunningWifiUids);
                        }
                    } else {
                        this.mBatteryStats.noteWifiRunning(this.mRunningWifiUids);
                        this.mLastRunningWifiUids.set(this.mRunningWifiUids);
                        this.mReportedRunning = true;
                    }
                } else if (this.mReportedRunning) {
                    this.mBatteryStats.noteWifiStopped(this.mLastRunningWifiUids);
                    this.mLastRunningWifiUids.clear();
                    this.mReportedRunning = false;
                }
                this.mWakeLock.setWorkSource(newSource);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String LS = System.getProperty("line.separator");
        sb.append("current HSM state: ").append(this.getCurrentState().getName()).append(LS);
        sb.append("mLinkProperties ").append(this.mLinkProperties).append(LS);
        sb.append("mWifiInfo ").append(this.mWifiInfo).append(LS);
        sb.append("mDhcpInfoInternal ").append(this.mDhcpInfoInternal).append(LS);
        sb.append("mNetworkInfo ").append(this.mNetworkInfo).append(LS);
        sb.append("mLastSignalLevel ").append(this.mLastSignalLevel).append(LS);
        sb.append("mLastBssid ").append(this.mLastBssid).append(LS);
        sb.append("mLastNetworkId ").append(this.mLastNetworkId).append(LS);
        sb.append("mReconnectCount ").append(this.mReconnectCount).append(LS);
        sb.append("mIsScanMode ").append(this.mIsScanMode).append(LS);
        sb.append("Supplicant status").append(LS).append(WifiNative.statusCommand()).append(LS).append(LS);
        sb.append(WifiConfigStore.dump());
        return sb.toString();
    }

    private void checkAndSetConnectivityInstance() {
        if (this.mCm == null) {
            this.mCm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        }
    }

    private boolean startTethering(ArrayList<String> available) {
        boolean wifiAvailable = false;
        this.checkAndSetConnectivityInstance();
        String[] wifiRegexs = this.mCm.getTetherableWifiRegexs();
        for (String intf : available) {
            for (String regex : wifiRegexs) {
                if (!intf.matches(regex)) continue;
                InterfaceConfiguration ifcg = null;
                try {
                    ifcg = this.mNwService.getInterfaceConfig(intf);
                    if (ifcg != null) {
                        ifcg.addr = new LinkAddress(NetworkUtils.numericToInetAddress("192.168.43.1"), 24);
                        ifcg.interfaceFlags = "[up]";
                        this.mNwService.setInterfaceConfig(intf, ifcg);
                    }
                }
                catch (Exception e) {
                    this.loge("Error configuring interface " + intf + ", :" + e);
                    return false;
                }
                if (this.mCm.tether(intf) != 0) {
                    this.loge("Error tethering on " + intf);
                    return false;
                }
                this.mTetherInterfaceName = intf;
                return true;
            }
        }
        return false;
    }

    private void stopTethering() {
        this.checkAndSetConnectivityInstance();
        InterfaceConfiguration ifcg = null;
        try {
            ifcg = this.mNwService.getInterfaceConfig(this.mInterfaceName);
            if (ifcg != null) {
                ifcg.addr = new LinkAddress(NetworkUtils.numericToInetAddress("0.0.0.0"), 0);
                this.mNwService.setInterfaceConfig(this.mInterfaceName, ifcg);
            }
        }
        catch (Exception e) {
            this.loge("Error resetting interface " + this.mInterfaceName + ", :" + e);
        }
        if (this.mCm.untether(this.mTetherInterfaceName) != 0) {
            this.loge("Untether initiate failed!");
        }
    }

    private boolean isWifiTethered(ArrayList<String> active) {
        this.checkAndSetConnectivityInstance();
        String[] wifiRegexs = this.mCm.getTetherableWifiRegexs();
        for (String intf : active) {
            for (String regex : wifiRegexs) {
                if (!intf.matches(regex)) continue;
                return true;
            }
        }
        return false;
    }

    private void setCountryCode() {
        String countryCode = Settings.Secure.getString(this.mContext.getContentResolver(), "wifi_country_code");
        if (countryCode != null && !countryCode.isEmpty()) {
            this.setCountryCode(countryCode, false);
        }
    }

    private void setFrequencyBand() {
        int band = Settings.Secure.getInt(this.mContext.getContentResolver(), "wifi_frequency_band", 0);
        this.setFrequencyBand(band, false);
    }

    private void setWifiState(int wifiState) {
        int previousWifiState = this.mWifiState.get();
        try {
            if (wifiState == 3) {
                this.mBatteryStats.noteWifiOn();
            } else if (wifiState == 1) {
                this.mBatteryStats.noteWifiOff();
            }
        }
        catch (RemoteException e) {
            this.loge("Failed to note battery stats in wifi");
        }
        this.mWifiState.set(wifiState);
        Intent intent = new Intent("android.net.wifi.WIFI_STATE_CHANGED");
        intent.addFlags(0x10000000);
        intent.putExtra("wifi_state", wifiState);
        intent.putExtra("previous_wifi_state", previousWifiState);
        this.mContext.sendStickyBroadcast(intent);
    }

    private void setWifiApState(int wifiApState) {
        int previousWifiApState = this.mWifiApState.get();
        try {
            if (wifiApState == 13) {
                this.mBatteryStats.noteWifiOn();
            } else if (wifiApState == 11) {
                this.mBatteryStats.noteWifiOff();
            }
        }
        catch (RemoteException e) {
            this.loge("Failed to note battery stats in wifi");
        }
        this.mWifiApState.set(wifiApState);
        Intent intent = new Intent("android.net.wifi.WIFI_AP_STATE_CHANGED");
        intent.addFlags(0x10000000);
        intent.putExtra("wifi_state", wifiApState);
        intent.putExtra("previous_wifi_state", previousWifiApState);
        this.mContext.sendStickyBroadcast(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScanResult parseScanResult(String line) {
        ScanResult scanResult = null;
        if (line != null) {
            LruCache<String, ScanResult> lruCache = this.mScanResultCache;
            synchronized (lruCache) {
                String[] result = scanResultPattern.split(line);
                if (3 <= result.length && result.length <= 5) {
                    String ssid;
                    String flags;
                    int level;
                    int frequency;
                    String bssid = result[0];
                    try {
                        frequency = Integer.parseInt(result[1]);
                        level = Integer.parseInt(result[2]);
                        if (level > 0) {
                            level -= 256;
                        }
                    }
                    catch (NumberFormatException e) {
                        frequency = 0;
                        level = 0;
                    }
                    if (result.length == 4) {
                        if (result[3].charAt(0) == '[') {
                            flags = result[3];
                            ssid = "";
                        } else {
                            flags = "";
                            ssid = result[3];
                        }
                    } else if (result.length == 5) {
                        flags = result[3];
                        ssid = result[4];
                    } else {
                        flags = "";
                        ssid = "";
                    }
                    String key = bssid + ssid;
                    scanResult = this.mScanResultCache.get(key);
                    if (scanResult != null) {
                        scanResult.level = level;
                        scanResult.SSID = ssid;
                        scanResult.capabilities = flags;
                        scanResult.frequency = frequency;
                    } else if (0 < ssid.trim().length()) {
                        scanResult = new ScanResult(ssid, bssid, flags, level, frequency);
                        this.mScanResultCache.put(key, scanResult);
                    }
                } else {
                    this.loge("Misformatted scan result text with " + result.length + " fields: " + line);
                }
            }
        }
        return scanResult;
    }

    private void setScanResults(String scanResults) {
        if (scanResults == null) {
            return;
        }
        ArrayList<ScanResult> scanList = new ArrayList<ScanResult>();
        int lineCount = 0;
        int scanResultsLen = scanResults.length();
        int lineBeg = 0;
        for (int lineEnd = 0; lineEnd <= scanResultsLen; ++lineEnd) {
            String line;
            ScanResult scanResult;
            if (lineEnd != scanResultsLen && scanResults.charAt(lineEnd) != '\n') continue;
            if (++lineCount == 1) {
                lineBeg = lineEnd + 1;
                continue;
            }
            if (lineEnd > lineBeg && (scanResult = this.parseScanResult(line = scanResults.substring(lineBeg, lineEnd))) != null) {
                scanList.add(scanResult);
            }
            lineBeg = lineEnd + 1;
        }
        this.mScanResults = scanList;
    }

    private String fetchSSID() {
        String[] lines;
        String status = WifiNative.statusCommand();
        if (status == null) {
            return null;
        }
        for (String line : lines = status.split("\n")) {
            String[] prop = line.split(" *= *");
            if (prop.length < 2) continue;
            String name = prop[0];
            String value = prop[1];
            if (!name.equalsIgnoreCase("ssid")) continue;
            return value;
        }
        return null;
    }

    private void fetchRssiAndLinkSpeedNative() {
        int newRssi = -1;
        int newLinkSpeed = -1;
        String signalPoll = WifiNative.signalPoll();
        if (signalPoll != null) {
            String[] lines;
            for (String line : lines = signalPoll.split("\n")) {
                String[] prop = line.split("=");
                if (prop.length < 2) continue;
                try {
                    if (prop[0].equals("RSSI")) {
                        newRssi = Integer.parseInt(prop[1]);
                        continue;
                    }
                    if (!prop[0].equals("LINKSPEED")) continue;
                    newLinkSpeed = Integer.parseInt(prop[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (newRssi != -1 && -200 < newRssi && newRssi < 256) {
            if (newRssi > 0) {
                newRssi -= 256;
            }
            this.mWifiInfo.setRssi(newRssi);
            int newSignalLevel = WifiManager.calculateSignalLevel(newRssi, 4);
            if (newSignalLevel != this.mLastSignalLevel) {
                this.sendRssiChangeBroadcast(newRssi);
            }
            this.mLastSignalLevel = newSignalLevel;
        } else {
            this.mWifiInfo.setRssi(-200);
        }
        if (newLinkSpeed != -1) {
            this.mWifiInfo.setLinkSpeed(newLinkSpeed);
        }
    }

    private void setHighPerfModeEnabledNative(boolean enable) {
        if (!WifiNative.setSuspendOptimizationsCommand(!enable)) {
            this.loge("set suspend optimizations failed!");
        }
        if (enable) {
            if (!WifiNative.setPowerModeCommand(1)) {
                this.loge("set power mode active failed!");
            }
        } else if (!WifiNative.setPowerModeCommand(0)) {
            this.loge("set power mode auto failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLinkProperties() {
        if (WifiConfigStore.isUsingStaticIp(this.mLastNetworkId)) {
            this.mLinkProperties = WifiConfigStore.getLinkProperties(this.mLastNetworkId);
        } else {
            DhcpInfoInternal dhcpInfoInternal = this.mDhcpInfoInternal;
            synchronized (dhcpInfoInternal) {
                this.mLinkProperties = this.mDhcpInfoInternal.makeLinkProperties();
            }
            this.mLinkProperties.setHttpProxy(WifiConfigStore.getProxyProperties(this.mLastNetworkId));
        }
        this.mLinkProperties.setInterfaceName(this.mInterfaceName);
    }

    private int getMaxDhcpRetries() {
        return Settings.Secure.getInt(this.mContext.getContentResolver(), "wifi_max_dhcp_retry_count", 9);
    }

    private void sendScanResultsAvailableBroadcast() {
        Intent intent = new Intent("android.net.wifi.SCAN_RESULTS");
        intent.addFlags(0x10000000);
        this.mContext.sendBroadcast(intent);
    }

    private void sendRssiChangeBroadcast(int newRssi) {
        Intent intent = new Intent("android.net.wifi.RSSI_CHANGED");
        intent.addFlags(0x10000000);
        intent.putExtra("newRssi", newRssi);
        this.mContext.sendBroadcast(intent);
    }

    private void sendNetworkStateChangeBroadcast(String bssid) {
        Intent intent = new Intent("android.net.wifi.STATE_CHANGE");
        intent.addFlags(0x30000000);
        intent.putExtra("networkInfo", this.mNetworkInfo);
        intent.putExtra("linkProperties", new LinkProperties(this.mLinkProperties));
        if (bssid != null) {
            intent.putExtra("bssid", bssid);
        }
        if (this.mNetworkInfo.getState() == NetworkInfo.State.CONNECTED) {
            intent.putExtra("wifiInfo", new WifiInfo(this.mWifiInfo));
        }
        this.mContext.sendStickyBroadcast(intent);
    }

    private void sendErrorBroadcast(int errorCode) {
        Intent intent = new Intent("android.net.wifi.ERROR");
        intent.addFlags(0x10000000);
        intent.putExtra("errorCode", errorCode);
        this.mContext.sendBroadcast(intent);
    }

    private void sendLinkConfigurationChangedBroadcast() {
        Intent intent = new Intent("android.net.wifi.LINK_CONFIGURATION_CHANGED");
        intent.addFlags(0x10000000);
        intent.putExtra("linkProperties", new LinkProperties(this.mLinkProperties));
        this.mContext.sendBroadcast(intent);
    }

    private void sendSupplicantConnectionChangedBroadcast(boolean connected) {
        Intent intent = new Intent("android.net.wifi.supplicant.CONNECTION_CHANGE");
        intent.addFlags(0x10000000);
        intent.putExtra("connected", connected);
        this.mContext.sendBroadcast(intent);
    }

    private void setNetworkDetailedState(NetworkInfo.DetailedState state) {
        if (state != this.mNetworkInfo.getDetailedState()) {
            this.mNetworkInfo.setDetailedState(state, null, null);
        }
    }

    private NetworkInfo.DetailedState getNetworkDetailedState() {
        return this.mNetworkInfo.getDetailedState();
    }

    private SupplicantState handleSupplicantStateChange(Message message) {
        StateChangeResult stateChangeResult = (StateChangeResult)message.obj;
        SupplicantState state = stateChangeResult.state;
        EventLog.writeEvent(50023, state.ordinal());
        this.mWifiInfo.setSupplicantState(state);
        if (SupplicantState.isConnecting(state)) {
            this.mWifiInfo.setNetworkId(stateChangeResult.networkId);
        } else {
            this.mWifiInfo.setNetworkId(-1);
        }
        if (state == SupplicantState.ASSOCIATING) {
            this.mWifiInfo.setBSSID(stateChangeResult.BSSID);
        }
        this.mSupplicantStateTracker.sendMessage(Message.obtain(message));
        this.mWpsStateMachine.sendMessage(Message.obtain(message));
        return state;
    }

    private void handleNetworkDisconnect() {
        this.handlePostDhcpSetup();
        if (this.mDhcpStateMachine != null) {
            this.mDhcpStateMachine.sendMessage(196610);
            this.mDhcpStateMachine.quit();
            this.mDhcpStateMachine = null;
        }
        try {
            this.mNwService.clearInterfaceAddresses(this.mInterfaceName);
            this.mNwService.disableIpv6(this.mInterfaceName);
        }
        catch (Exception e) {
            this.loge("Failed to clear addresses or disable ipv6" + e);
        }
        this.mWifiInfo.setInetAddress(null);
        this.mWifiInfo.setBSSID(null);
        this.mWifiInfo.setSSID(null);
        this.mWifiInfo.setNetworkId(-1);
        this.mWifiInfo.setRssi(-200);
        this.mWifiInfo.setLinkSpeed(-1);
        this.mWifiInfo.setExplicitConnect(false);
        this.setNetworkDetailedState(NetworkInfo.DetailedState.DISCONNECTED);
        this.sendNetworkStateChangeBroadcast(this.mLastBssid);
        this.mLinkProperties.clear();
        if (!WifiConfigStore.isUsingStaticIp(this.mLastNetworkId)) {
            WifiConfigStore.clearIpConfiguration(this.mLastNetworkId);
        }
        this.mLastBssid = null;
        this.mLastNetworkId = -1;
    }

    void handlePreDhcpSetup() {
        if (!this.mBluetoothConnectionActive) {
            WifiNative.setBluetoothCoexistenceModeCommand(1);
        }
        this.mPowerMode = WifiNative.getPowerModeCommand();
        if (this.mPowerMode < 0) {
            this.mPowerMode = 0;
        }
        if (this.mPowerMode != 1) {
            WifiNative.setPowerModeCommand(1);
        }
    }

    void handlePostDhcpSetup() {
        WifiNative.setPowerModeCommand(this.mPowerMode);
        WifiNative.setBluetoothCoexistenceModeCommand(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSuccessfulIpConfiguration(DhcpInfoInternal dhcpInfoInternal) {
        DhcpInfoInternal dhcpInfoInternal2 = this.mDhcpInfoInternal;
        synchronized (dhcpInfoInternal2) {
            this.mDhcpInfoInternal = dhcpInfoInternal;
        }
        this.mLastSignalLevel = -1;
        this.mReconnectCount = 0;
        WifiConfigStore.setIpConfiguration(this.mLastNetworkId, dhcpInfoInternal);
        InetAddress addr = NetworkUtils.numericToInetAddress(dhcpInfoInternal.ipAddress);
        this.mWifiInfo.setInetAddress(addr);
        if (this.getNetworkDetailedState() == NetworkInfo.DetailedState.CONNECTED) {
            LinkProperties linkProperties = dhcpInfoInternal.makeLinkProperties();
            linkProperties.setHttpProxy(WifiConfigStore.getProxyProperties(this.mLastNetworkId));
            linkProperties.setInterfaceName(this.mInterfaceName);
            if (!linkProperties.equals(this.mLinkProperties)) {
                this.mLinkProperties = linkProperties;
                this.sendLinkConfigurationChangedBroadcast();
            }
        } else {
            this.configureLinkProperties();
            this.setNetworkDetailedState(NetworkInfo.DetailedState.CONNECTED);
            this.sendNetworkStateChangeBroadcast(this.mLastBssid);
        }
    }

    private void handleFailedIpConfiguration() {
        this.loge("IP configuration failed");
        this.mWifiInfo.setInetAddress(null);
        if (++this.mReconnectCount > this.getMaxDhcpRetries()) {
            this.loge("Failed " + this.mReconnectCount + " times, Disabling " + this.mLastNetworkId);
            WifiConfigStore.disableNetwork(this.mLastNetworkId, 2);
            this.mReconnectCount = 0;
        }
        WifiNative.disconnectCommand();
        WifiNative.reconnectCommand();
    }

    private void startSoftApWithConfig(final WifiConfiguration config) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    WifiStateMachine.this.mNwService.startAccessPoint(config, WifiStateMachine.this.mInterfaceName, WifiStateMachine.SOFTAP_IFACE);
                }
                catch (Exception e) {
                    WifiStateMachine.this.loge("Exception in softap start " + e);
                    try {
                        WifiStateMachine.this.mNwService.stopAccessPoint(WifiStateMachine.this.mInterfaceName);
                        WifiStateMachine.this.mNwService.startAccessPoint(config, WifiStateMachine.this.mInterfaceName, WifiStateMachine.SOFTAP_IFACE);
                    }
                    catch (Exception e1) {
                        WifiStateMachine.this.loge("Exception in softap re-start " + e1);
                        WifiStateMachine.this.sendMessage(131095);
                        return;
                    }
                }
                WifiStateMachine.this.sendMessage(131094);
            }
        }).start();
    }

    private void log(String s) {
        Log.d(TAG, s);
    }

    private void loge(String s) {
        Log.e(TAG, s);
    }

    class SoftApStoppingState
    extends State {
        SoftApStoppingState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131102, ++WifiStateMachine.this.mTetherToken, 0), 5000L);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131101: {
                    TetherStateChange stateChange = (TetherStateChange)message.obj;
                    if (WifiStateMachine.this.isWifiTethered(stateChange.active)) break;
                    try {
                        WifiStateMachine.this.mNwService.stopAccessPoint(WifiStateMachine.this.mInterfaceName);
                    }
                    catch (Exception e) {
                        WifiStateMachine.this.loge("Exception in stopAccessPoint()");
                    }
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverLoadedState);
                    break;
                }
                case 131102: {
                    if (message.arg1 != WifiStateMachine.this.mTetherToken) break;
                    WifiStateMachine.this.loge("Failed to get tether update, force stop access point");
                    try {
                        WifiStateMachine.this.mNwService.stopAccessPoint(WifiStateMachine.this.mInterfaceName);
                    }
                    catch (Exception e) {
                        WifiStateMachine.this.loge("Exception in stopAccessPoint()");
                    }
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverLoadedState);
                    break;
                }
                case 131073: 
                case 131074: 
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131144: 
                case 131145: 
                case 131149: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: 
                case 143361: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class TetheredState
    extends State {
        TetheredState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131101: {
                    TetherStateChange stateChange = (TetherStateChange)message.obj;
                    if (!WifiStateMachine.this.isWifiTethered(stateChange.active)) {
                        WifiStateMachine.this.loge("Tethering reports wifi as untethered!, shut down soft Ap");
                        WifiStateMachine.this.setWifiApEnabled(null, false);
                    }
                    return true;
                }
                case 131096: {
                    WifiStateMachine.this.setWifiApState(10);
                    WifiStateMachine.this.stopTethering();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSoftApStoppingState);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class TetheringState
    extends State {
        TetheringState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131102, ++WifiStateMachine.this.mTetherToken, 0), 5000L);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131101: {
                    TetherStateChange stateChange = (TetherStateChange)message.obj;
                    if (WifiStateMachine.this.isWifiTethered(stateChange.active)) {
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mTetheredState);
                    }
                    return true;
                }
                case 131102: {
                    if (message.arg1 != WifiStateMachine.this.mTetherToken) break;
                    WifiStateMachine.this.loge("Failed to get tether update, shutdown soft access point");
                    WifiStateMachine.this.setWifiApEnabled(null, false);
                    break;
                }
                case 131073: 
                case 131074: 
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131144: 
                case 131145: 
                case 131149: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: 
                case 143361: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class WaitForP2pDisableState
    extends State {
        private int mSavedArg;

        WaitForP2pDisableState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            this.mSavedArg = ((WifiStateMachine)WifiStateMachine.this).getCurrentMessage().arg1;
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 143362: {
                    message.arg1 = this.mSavedArg;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverLoadingState);
                    break;
                }
                case 131073: 
                case 131074: 
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131144: 
                case 131145: 
                case 131149: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class SoftApStartedState
    extends State {
        SoftApStartedState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131096: {
                    WifiStateMachine.this.setWifiApState(10);
                    try {
                        WifiStateMachine.this.mNwService.stopAccessPoint(WifiStateMachine.this.mInterfaceName);
                    }
                    catch (Exception e) {
                        WifiStateMachine.this.loge("Exception in stopAccessPoint()");
                    }
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverLoadedState);
                    break;
                }
                case 131093: {
                    break;
                }
                case 131083: {
                    WifiStateMachine.this.loge("Cannot start supplicant with a running soft AP");
                    WifiStateMachine.this.setWifiState(4);
                    break;
                }
                case 131101: {
                    TetherStateChange stateChange = (TetherStateChange)message.obj;
                    if (!WifiStateMachine.this.startTethering(stateChange.available)) break;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mTetheringState);
                    break;
                }
                case 143361: {
                    WifiStateMachine.this.setWifiApEnabled(null, false);
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class SoftApStartingState
    extends State {
        SoftApStartingState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            Message message = WifiStateMachine.this.getCurrentMessage();
            if (message.what == 131093) {
                WifiConfiguration config = (WifiConfiguration)message.obj;
                if (config == null) {
                    WifiStateMachine.this.mWifiApConfigChannel.sendMessage(131099);
                } else {
                    WifiStateMachine.this.mWifiApConfigChannel.sendMessage(131097, config);
                    WifiStateMachine.this.startSoftApWithConfig(config);
                }
            } else {
                throw new RuntimeException("Illegal transition to SoftApStartingState: " + message);
            }
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131073: 
                case 131074: 
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131101: 
                case 131144: 
                case 131145: 
                case 131149: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: 
                case 143361: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 131100: {
                    WifiConfiguration config = (WifiConfiguration)message.obj;
                    if (config != null) {
                        WifiStateMachine.this.startSoftApWithConfig(config);
                        break;
                    }
                    WifiStateMachine.this.loge("Softap config is null!");
                    WifiStateMachine.this.sendMessage(131095);
                    break;
                }
                case 131094: {
                    WifiStateMachine.this.setWifiApState(13);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSoftApStartedState);
                    break;
                }
                case 131095: {
                    WifiStateMachine.this.sendMessage(WifiStateMachine.this.obtainMessage(131074, 14, 0));
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class WaitForWpsCompletionState
    extends State {
        WaitForWpsCompletionState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131086: 
                case 131126: 
                case 131144: 
                case 131147: 
                case 131148: 
                case 131158: 
                case 147459: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 147460: {
                    WifiStateMachine.this.handleNetworkDisconnect();
                    break;
                }
                case 131193: {
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class DisconnectedState
    extends State {
        private boolean mAlarmEnabled = false;
        private long mFrameworkScanIntervalMs;

        DisconnectedState() {
        }

        private void setScanAlarm(boolean enabled) {
            if (enabled == this.mAlarmEnabled) {
                return;
            }
            if (enabled) {
                if (this.mFrameworkScanIntervalMs > 0L) {
                    WifiStateMachine.this.mAlarmManager.setRepeating(0, System.currentTimeMillis() + this.mFrameworkScanIntervalMs, this.mFrameworkScanIntervalMs, WifiStateMachine.this.mScanIntent);
                    this.mAlarmEnabled = true;
                }
            } else {
                WifiStateMachine.this.mAlarmManager.cancel(WifiStateMachine.this.mScanIntent);
                this.mAlarmEnabled = false;
            }
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            this.mFrameworkScanIntervalMs = Settings.Secure.getLong(WifiStateMachine.this.mContext.getContentResolver(), "wifi_framework_scan_interval_ms", WifiStateMachine.this.mDefaultFrameworkScanIntervalMs);
            if (WifiStateMachine.this.mEnableBackgroundScan) {
                if (!WifiStateMachine.this.mScanResultIsPending) {
                    WifiNative.enableBackgroundScanCommand(true);
                }
            } else {
                this.setScanAlarm(true);
            }
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131144: {
                    if (message.arg1 != 2) break;
                    WifiNative.setScanResultHandlingCommand(message.arg1);
                    WifiNative.disconnectCommand();
                    WifiStateMachine.this.mIsScanMode = true;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mScanModeState);
                    break;
                }
                case 131163: {
                    WifiStateMachine.this.mEnableBackgroundScan = message.arg1 == 1;
                    if (WifiStateMachine.this.mEnableBackgroundScan) {
                        WifiNative.enableBackgroundScanCommand(true);
                        this.setScanAlarm(false);
                        break;
                    }
                    WifiNative.enableBackgroundScanCommand(false);
                    this.setScanAlarm(true);
                    break;
                }
                case 147460: {
                    break;
                }
                case 147462: {
                    StateChangeResult stateChangeResult = (StateChangeResult)message.obj;
                    WifiStateMachine.this.setNetworkDetailedState(WifiInfo.getDetailedStateOf(stateChangeResult.state));
                    return false;
                }
                case 131143: {
                    if (WifiStateMachine.this.mEnableBackgroundScan) {
                        WifiNative.enableBackgroundScanCommand(false);
                    }
                    return false;
                }
                case 147461: {
                    if (WifiStateMachine.this.mEnableBackgroundScan && WifiStateMachine.this.mScanResultIsPending) {
                        WifiNative.enableBackgroundScanCommand(true);
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }

        public void exit() {
            if (WifiStateMachine.this.mEnableBackgroundScan) {
                WifiNative.enableBackgroundScanCommand(false);
            }
            this.setScanAlarm(false);
        }
    }

    class DisconnectingState
    extends State {
        DisconnectingState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131144: {
                    if (message.arg1 != 2) break;
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 147462: {
                    WifiStateMachine.this.deferMessage(message);
                    WifiStateMachine.this.handleNetworkDisconnect();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class ConnectedState
    extends State {
        ConnectedState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            WifiStateMachine.this.mRssiPollToken++;
            if (WifiStateMachine.this.mEnableRssiPolling) {
                WifiStateMachine.this.sendMessage(WifiStateMachine.this.obtainMessage(131155, WifiStateMachine.this.mRssiPollToken, 0));
            }
        }

        public boolean processMessage(Message message) {
            boolean eventLoggingEnabled = true;
            switch (message.what) {
                case 196612: {
                    WifiStateMachine.this.handlePreDhcpSetup();
                    WifiStateMachine.this.mDhcpStateMachine.sendMessage(196614);
                    break;
                }
                case 196613: {
                    WifiStateMachine.this.handlePostDhcpSetup();
                    if (message.arg1 == 1) {
                        WifiStateMachine.this.handleSuccessfulIpConfiguration((DhcpInfoInternal)message.obj);
                        break;
                    }
                    if (message.arg1 != 2) break;
                    WifiStateMachine.this.handleFailedIpConfiguration();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectingState);
                    break;
                }
                case 131146: {
                    WifiNative.disconnectCommand();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectingState);
                    break;
                }
                case 131144: {
                    if (message.arg1 != 2) break;
                    WifiStateMachine.this.sendMessage(131146);
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 131143: {
                    eventLoggingEnabled = false;
                    WifiNative.setScanResultHandlingCommand(2);
                    return false;
                }
                case 131158: {
                    int netId = message.arg1;
                    if (WifiStateMachine.this.mWifiInfo.getNetworkId() == netId) break;
                    return false;
                }
                case 131159: {
                    WifiConfiguration config = (WifiConfiguration)message.obj;
                    NetworkUpdateResult result = WifiConfigStore.saveNetwork(config);
                    if (WifiStateMachine.this.mWifiInfo.getNetworkId() != result.getNetworkId()) break;
                    if (result.hasIpChanged()) {
                        WifiStateMachine.this.log("Reconfiguring IP on connection");
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mConnectingState);
                    }
                    if (!result.hasProxyChanged()) break;
                    WifiStateMachine.this.log("Reconfiguring proxy on connection");
                    WifiStateMachine.this.configureLinkProperties();
                    WifiStateMachine.this.sendLinkConfigurationChangedBroadcast();
                    break;
                }
                case 147459: {
                    break;
                }
                case 131155: {
                    eventLoggingEnabled = false;
                    if (message.arg1 != WifiStateMachine.this.mRssiPollToken) break;
                    WifiStateMachine.this.fetchRssiAndLinkSpeedNative();
                    WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131155, WifiStateMachine.this.mRssiPollToken, 0), 3000L);
                    break;
                }
                case 131154: {
                    WifiStateMachine.this.mEnableRssiPolling = message.arg1 == 1;
                    WifiStateMachine.this.mRssiPollToken++;
                    if (!WifiStateMachine.this.mEnableRssiPolling) break;
                    WifiStateMachine.this.fetchRssiAndLinkSpeedNative();
                    WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131155, WifiStateMachine.this.mRssiPollToken, 0), 3000L);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (eventLoggingEnabled) {
                EventLog.writeEvent(50022, message.what);
            }
            return true;
        }

        public void exit() {
            WifiStateMachine.this.checkAndSetConnectivityInstance();
            WifiStateMachine.this.mCm.requestNetworkTransitionWakelock(WifiStateMachine.TAG);
            if (WifiStateMachine.this.mScanResultIsPending) {
                WifiNative.setScanResultHandlingCommand(1);
            }
        }
    }

    class ConnectingState
    extends State {
        ConnectingState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            try {
                WifiStateMachine.this.mNwService.enableIpv6(WifiStateMachine.this.mInterfaceName);
            }
            catch (RemoteException re) {
                WifiStateMachine.this.loge("Failed to enable IPv6: " + re);
            }
            catch (IllegalStateException e) {
                WifiStateMachine.this.loge("Failed to enable IPv6: " + e);
            }
            if (!WifiConfigStore.isUsingStaticIp(WifiStateMachine.this.mLastNetworkId)) {
                WifiStateMachine.this.mDhcpStateMachine = DhcpStateMachine.makeDhcpStateMachine(WifiStateMachine.this.mContext, WifiStateMachine.this, WifiStateMachine.this.mInterfaceName);
                WifiStateMachine.this.mDhcpStateMachine.registerForPreDhcpNotification();
                WifiStateMachine.this.mDhcpStateMachine.sendMessage(196609);
            } else {
                DhcpInfoInternal dhcpInfoInternal = WifiConfigStore.getIpConfiguration(WifiStateMachine.this.mLastNetworkId);
                InterfaceConfiguration ifcg = new InterfaceConfiguration();
                ifcg.addr = dhcpInfoInternal.makeLinkAddress();
                ifcg.interfaceFlags = "[up]";
                try {
                    WifiStateMachine.this.mNwService.setInterfaceConfig(WifiStateMachine.this.mInterfaceName, ifcg);
                    WifiStateMachine.this.sendMessage(131087, dhcpInfoInternal);
                }
                catch (RemoteException re) {
                    WifiStateMachine.this.loge("Static IP configuration failed: " + re);
                    WifiStateMachine.this.sendMessage(131088);
                }
                catch (IllegalStateException e) {
                    WifiStateMachine.this.loge("Static IP configuration failed: " + e);
                    WifiStateMachine.this.sendMessage(131088);
                }
            }
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 196612: {
                    WifiStateMachine.this.handlePreDhcpSetup();
                    WifiStateMachine.this.mDhcpStateMachine.sendMessage(196614);
                    break;
                }
                case 196613: {
                    WifiStateMachine.this.handlePostDhcpSetup();
                    if (message.arg1 == 1) {
                        WifiStateMachine.this.handleSuccessfulIpConfiguration((DhcpInfoInternal)message.obj);
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mConnectedState);
                        break;
                    }
                    if (message.arg1 != 2) break;
                    WifiStateMachine.this.handleFailedIpConfiguration();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectingState);
                    break;
                }
                case 131087: {
                    WifiStateMachine.this.handleSuccessfulIpConfiguration((DhcpInfoInternal)message.obj);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mConnectedState);
                    break;
                }
                case 131088: {
                    WifiStateMachine.this.handleFailedIpConfiguration();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectingState);
                    break;
                }
                case 131146: {
                    WifiNative.disconnectCommand();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectingState);
                    break;
                }
                case 131158: {
                    int netId = message.arg1;
                    if (WifiStateMachine.this.mWifiInfo.getNetworkId() == netId) break;
                    return false;
                }
                case 131159: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 147459: {
                    break;
                }
                case 131144: {
                    if (message.arg1 != 2) break;
                    WifiStateMachine.this.sendMessage(131146);
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 131143: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                case 131149: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class ConnectModeState
    extends State {
        ConnectModeState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147463: {
                    WifiStateMachine.this.mSupplicantStateTracker.sendMessage(147463);
                    break;
                }
                case 147464: {
                    WifiStateMachine.this.sendErrorBroadcast(1);
                    break;
                }
                case 147462: {
                    SupplicantState state = WifiStateMachine.this.handleSupplicantStateChange(message);
                    if (!SupplicantState.isDriverActive(state)) {
                        if (WifiStateMachine.this.mNetworkInfo.getState() != NetworkInfo.State.DISCONNECTED) {
                            WifiStateMachine.this.handleNetworkDisconnect();
                        }
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStoppedState);
                        break;
                    }
                    if (state != SupplicantState.DISCONNECTED || WifiStateMachine.this.mNetworkInfo.getState() == NetworkInfo.State.DISCONNECTED) break;
                    WifiStateMachine.this.handleNetworkDisconnect();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                case 131146: {
                    WifiNative.disconnectCommand();
                    break;
                }
                case 131147: {
                    WifiNative.reconnectCommand();
                    break;
                }
                case 131148: {
                    WifiNative.reassociateCommand();
                    break;
                }
                case 131158: {
                    int netId = message.arg1;
                    WifiConfiguration config = (WifiConfiguration)message.obj;
                    if (config != null) {
                        netId = WifiConfigStore.selectNetwork(config);
                    } else {
                        WifiConfigStore.selectNetwork(netId);
                    }
                    WifiStateMachine.this.mSupplicantStateTracker.sendMessage(131158);
                    WifiNative.reconnectCommand();
                    WifiStateMachine.this.mLastExplicitNetworkId = netId;
                    WifiStateMachine.this.mLastNetworkChoiceTime = SystemClock.elapsedRealtime();
                    WifiStateMachine.this.mNextWifiActionExplicit = true;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectingState);
                    break;
                }
                case 131161: {
                    WifiStateMachine.this.mWpsStateMachine.sendMessage(Message.obtain(message));
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mWaitForWpsCompletionState);
                    break;
                }
                case 147461: {
                    WifiNative.setScanResultHandlingCommand(1);
                    return false;
                }
                case 147459: {
                    WifiStateMachine.this.mLastNetworkId = message.arg1;
                    WifiStateMachine.this.mLastBssid = (String)message.obj;
                    WifiStateMachine.this.mWifiInfo.setSSID(WifiStateMachine.this.fetchSSID());
                    WifiStateMachine.this.mWifiInfo.setBSSID(WifiStateMachine.this.mLastBssid);
                    WifiStateMachine.this.mWifiInfo.setNetworkId(WifiStateMachine.this.mLastNetworkId);
                    if (WifiStateMachine.this.mNextWifiActionExplicit && WifiStateMachine.this.mWifiInfo.getNetworkId() == WifiStateMachine.this.mLastExplicitNetworkId && SystemClock.elapsedRealtime() < WifiStateMachine.this.mLastNetworkChoiceTime + 120000L) {
                        WifiStateMachine.this.mWifiInfo.setExplicitConnect(true);
                    }
                    WifiStateMachine.this.mNextWifiActionExplicit = false;
                    WifiStateMachine.this.setNetworkDetailedState(NetworkInfo.DetailedState.OBTAINING_IPADDR);
                    WifiStateMachine.this.sendNetworkStateChangeBroadcast(WifiStateMachine.this.mLastBssid);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mConnectingState);
                    break;
                }
                case 147460: {
                    WifiStateMachine.this.handleNetworkDisconnect();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class ScanModeState
    extends State {
        ScanModeState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131144: {
                    if (message.arg1 == 2) {
                        return true;
                    }
                    WifiNative.setScanResultHandlingCommand(message.arg1);
                    WifiNative.reconnectCommand();
                    WifiStateMachine.this.mIsScanMode = false;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
                    break;
                }
                case 131146: 
                case 131147: 
                case 131148: 
                case 147459: 
                case 147460: 
                case 147462: {
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class DriverStoppedState
    extends State {
        DriverStoppedState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147462: {
                    StateChangeResult stateChangeResult = (StateChangeResult)message.obj;
                    SupplicantState state = stateChangeResult.state;
                    if (!SupplicantState.isDriverActive(state)) break;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStartedState);
                    break;
                }
                case 131085: {
                    WifiStateMachine.this.mWakeLock.acquire();
                    WifiNative.startDriverCommand();
                    WifiStateMachine.this.mWakeLock.release();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStartingState);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class DriverStoppingState
    extends State {
        DriverStoppingState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147462: {
                    SupplicantState state = WifiStateMachine.this.handleSupplicantStateChange(message);
                    if (state != SupplicantState.INTERFACE_DISABLED) break;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStoppedState);
                    break;
                }
                case 131085: 
                case 131086: 
                case 131143: 
                case 131145: 
                case 131146: 
                case 131147: 
                case 131148: 
                case 131149: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class DriverStartedState
    extends State {
        DriverStartedState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            WifiStateMachine.this.mIsRunning = true;
            WifiStateMachine.this.mInDelayedStop = false;
            WifiStateMachine.this.updateBatteryWorkSource(null);
            WifiNative.setBluetoothCoexistenceScanModeCommand(WifiStateMachine.this.mBluetoothConnectionActive);
            WifiStateMachine.this.setCountryCode();
            WifiStateMachine.this.setFrequencyBand();
            WifiStateMachine.this.setNetworkDetailedState(NetworkInfo.DetailedState.DISCONNECTED);
            WifiNative.stopFilteringMulticastV6Packets();
            if (WifiStateMachine.this.mFilteringMulticastV4Packets.get()) {
                WifiNative.startFilteringMulticastV4Packets();
            } else {
                WifiNative.stopFilteringMulticastV4Packets();
            }
            if (WifiStateMachine.this.mIsScanMode) {
                WifiNative.setScanResultHandlingCommand(2);
                WifiNative.disconnectCommand();
                WifiStateMachine.this.transitionTo(WifiStateMachine.this.mScanModeState);
            } else {
                WifiNative.setScanResultHandlingCommand(1);
                WifiNative.reconnectCommand();
                WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDisconnectedState);
            }
        }

        public boolean processMessage(Message message) {
            boolean eventLoggingEnabled = true;
            switch (message.what) {
                case 131145: {
                    if (message.arg1 == 1) {
                        WifiNative.setScanModeCommand(true);
                        break;
                    }
                    WifiNative.setScanModeCommand(false);
                    break;
                }
                case 131143: {
                    eventLoggingEnabled = false;
                    WifiNative.scanCommand(message.arg1 == 1);
                    WifiStateMachine.this.mScanResultIsPending = true;
                    break;
                }
                case 131149: {
                    WifiStateMachine.this.setHighPerfModeEnabledNative(message.arg1 == 1);
                    break;
                }
                case 131152: {
                    String country = (String)message.obj;
                    if (WifiNative.setCountryCodeCommand(country.toUpperCase())) break;
                    WifiStateMachine.this.loge("Failed to set country code " + country);
                    break;
                }
                case 131162: {
                    int band = message.arg1;
                    if (WifiNative.setBandCommand(band)) {
                        WifiStateMachine.this.mFrequencyBand.set(band);
                        WifiStateMachine.this.startScan(true);
                        break;
                    }
                    WifiStateMachine.this.loge("Failed to set frequency band " + band);
                    break;
                }
                case 131103: {
                    WifiStateMachine.this.mBluetoothConnectionActive = message.arg1 != 0;
                    WifiNative.setBluetoothCoexistenceScanModeCommand(WifiStateMachine.this.mBluetoothConnectionActive);
                    break;
                }
                case 131086: {
                    int mode = message.arg1;
                    if (WifiStateMachine.this.mInDelayedStop && mode != 1) break;
                    WifiStateMachine.this.mInDelayedStop = true;
                    WifiStateMachine.this.mDelayedStopCounter++;
                    if (mode == 1) {
                        WifiStateMachine.this.sendMessage(WifiStateMachine.this.obtainMessage(131090, WifiStateMachine.this.mDelayedStopCounter, 0));
                        break;
                    }
                    WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131090, WifiStateMachine.this.mDelayedStopCounter, 0), 120000L);
                    break;
                }
                case 131085: {
                    if (!WifiStateMachine.this.mInDelayedStop) break;
                    WifiStateMachine.this.mInDelayedStop = false;
                    WifiStateMachine.this.mDelayedStopCounter++;
                    break;
                }
                case 131090: {
                    if (message.arg1 != WifiStateMachine.this.mDelayedStopCounter) break;
                    if (WifiStateMachine.this.getCurrentState() != WifiStateMachine.this.mDisconnectedState) {
                        WifiNative.disconnectCommand();
                        WifiStateMachine.this.handleNetworkDisconnect();
                    }
                    WifiStateMachine.this.mWakeLock.acquire();
                    WifiNative.stopDriverCommand();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStoppingState);
                    WifiStateMachine.this.mWakeLock.release();
                    break;
                }
                case 131156: {
                    if (message.arg1 == 1) {
                        WifiNative.startFilteringMulticastV6Packets();
                        break;
                    }
                    if (message.arg1 == 0) {
                        WifiNative.startFilteringMulticastV4Packets();
                        break;
                    }
                    WifiStateMachine.this.loge("Illegal arugments to CMD_START_PACKET_FILTERING");
                    break;
                }
                case 131157: {
                    if (message.arg1 == 1) {
                        WifiNative.stopFilteringMulticastV6Packets();
                        break;
                    }
                    if (message.arg1 == 0) {
                        WifiNative.stopFilteringMulticastV4Packets();
                        break;
                    }
                    WifiStateMachine.this.loge("Illegal arugments to CMD_STOP_PACKET_FILTERING");
                    break;
                }
                default: {
                    return false;
                }
            }
            if (eventLoggingEnabled) {
                EventLog.writeEvent(50022, message.what);
            }
            return true;
        }

        public void exit() {
            WifiStateMachine.this.mIsRunning = false;
            WifiStateMachine.this.updateBatteryWorkSource(null);
            WifiStateMachine.this.mScanResults = null;
        }
    }

    class DriverStartingState
    extends State {
        DriverStartingState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147462: {
                    SupplicantState state = WifiStateMachine.this.handleSupplicantStateChange(message);
                    if (!SupplicantState.isDriverActive(state)) break;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStartedState);
                    break;
                }
                case 131085: 
                case 131086: 
                case 131143: 
                case 131145: 
                case 131146: 
                case 131147: 
                case 131148: 
                case 131149: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: 
                case 147459: 
                case 147460: 
                case 147463: 
                case 147464: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class SupplicantStoppingState
    extends State {
        SupplicantStoppingState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            if (!WifiNative.stopSupplicant()) {
                WifiStateMachine.this.loge("Failed to stop supplicant");
            }
            WifiStateMachine.this.sendMessageDelayed(WifiStateMachine.this.obtainMessage(131089, ++WifiStateMachine.this.mSupplicantStopFailureToken, 0), 5000L);
            WifiStateMachine.this.mNetworkInfo.setIsAvailable(false);
            WifiStateMachine.this.handleNetworkDisconnect();
            WifiStateMachine.this.setWifiState(0);
            WifiStateMachine.this.sendSupplicantConnectionChangedBroadcast(false);
            WifiStateMachine.this.mSupplicantStateTracker.sendMessage(131183);
            WifiStateMachine.this.mWpsStateMachine.sendMessage(131194);
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147457: {
                    WifiStateMachine.this.loge("Supplicant connection received while stopping");
                    break;
                }
                case 147458: {
                    WifiNative.killSupplicant();
                    WifiNative.closeSupplicantConnection();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverLoadedState);
                    break;
                }
                case 131089: {
                    if (message.arg1 != WifiStateMachine.this.mSupplicantStopFailureToken) break;
                    WifiStateMachine.this.loge("Timed out on a supplicant stop, kill and proceed");
                    WifiNative.killSupplicant();
                    WifiNative.closeSupplicantConnection();
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverLoadedState);
                    break;
                }
                case 131073: 
                case 131074: 
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131144: 
                case 131145: 
                case 131149: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class SupplicantStartedState
    extends State {
        SupplicantStartedState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            WifiStateMachine.this.mIsScanMode = false;
            WifiStateMachine.this.mNetworkInfo.setIsAvailable(true);
            long supplicantScanIntervalMs = Settings.Secure.getLong(WifiStateMachine.this.mContext.getContentResolver(), "wifi_supplicant_scan_interval_ms", WifiStateMachine.this.mDefaultSupplicantScanIntervalMs);
            WifiNative.setScanIntervalCommand((int)supplicantScanIntervalMs / 1000);
        }

        public boolean processMessage(Message message) {
            boolean eventLoggingEnabled = true;
            switch (message.what) {
                case 131084: {
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSupplicantStoppingState);
                    break;
                }
                case 147458: {
                    WifiStateMachine.this.loge("Connection lost, restart supplicant");
                    WifiNative.killSupplicant();
                    WifiNative.closeSupplicantConnection();
                    WifiStateMachine.this.mNetworkInfo.setIsAvailable(false);
                    WifiStateMachine.this.handleNetworkDisconnect();
                    WifiStateMachine.this.sendSupplicantConnectionChangedBroadcast(false);
                    WifiStateMachine.this.mSupplicantStateTracker.sendMessage(131183);
                    WifiStateMachine.this.mWpsStateMachine.sendMessage(131194);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverLoadedState);
                    WifiStateMachine.this.sendMessageDelayed(131083, 5000L);
                    break;
                }
                case 147461: {
                    eventLoggingEnabled = false;
                    WifiStateMachine.this.setScanResults(WifiNative.scanResultsCommand());
                    WifiStateMachine.this.sendScanResultsAvailableBroadcast();
                    WifiStateMachine.this.mScanResultIsPending = false;
                    break;
                }
                case 131123: {
                    boolean ok = WifiNative.pingCommand();
                    WifiStateMachine.this.mReplyChannel.replyToMessage(message, message.what, ok ? 1 : -1);
                    break;
                }
                case 131124: {
                    WifiConfiguration config = (WifiConfiguration)message.obj;
                    WifiStateMachine.this.mReplyChannel.replyToMessage(message, 131124, WifiConfigStore.addOrUpdateNetwork(config));
                    break;
                }
                case 131125: {
                    boolean ok = WifiConfigStore.removeNetwork(message.arg1);
                    WifiStateMachine.this.mReplyChannel.replyToMessage(message, message.what, ok ? 1 : -1);
                    break;
                }
                case 131126: {
                    boolean ok = WifiConfigStore.enableNetwork(message.arg1, message.arg2 == 1);
                    WifiStateMachine.this.mReplyChannel.replyToMessage(message, message.what, ok ? 1 : -1);
                    break;
                }
                case 131127: {
                    long time = SystemClock.elapsedRealtime();
                    if (time - WifiStateMachine.this.mLastEnableAllNetworksTime <= 600000L) break;
                    WifiConfigStore.enableAllNetworks();
                    WifiStateMachine.this.mLastEnableAllNetworksTime = time;
                    break;
                }
                case 131128: {
                    boolean ok = WifiConfigStore.disableNetwork(message.arg1, message.arg2);
                    WifiStateMachine.this.mReplyChannel.replyToMessage(message, message.what, ok ? 1 : -1);
                    break;
                }
                case 131129: {
                    WifiNative.addToBlacklistCommand((String)message.obj);
                    break;
                }
                case 131130: {
                    WifiNative.clearBlacklistCommand();
                    break;
                }
                case 131131: {
                    boolean ok = WifiConfigStore.saveConfig();
                    WifiStateMachine.this.mReplyChannel.replyToMessage(message, 131131, ok ? 1 : -1);
                    IBackupManager ibm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                    if (ibm == null) break;
                    try {
                        ibm.dataChanged("com.android.providers.settings");
                    }
                    catch (Exception e) {}
                    break;
                }
                case 131093: {
                    WifiStateMachine.this.loge("Failed to start soft AP with a running supplicant");
                    WifiStateMachine.this.setWifiApState(14);
                    break;
                }
                case 131144: {
                    WifiStateMachine.this.mIsScanMode = message.arg1 == 2;
                    break;
                }
                case 131159: {
                    WifiConfiguration config = (WifiConfiguration)message.obj;
                    WifiConfigStore.saveNetwork(config);
                    break;
                }
                case 131160: {
                    WifiConfigStore.forgetNetwork(message.arg1);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (eventLoggingEnabled) {
                EventLog.writeEvent(50022, message.what);
            }
            return true;
        }

        public void exit() {
            WifiStateMachine.this.mNetworkInfo.setIsAvailable(false);
        }
    }

    class SupplicantStartingState
    extends State {
        SupplicantStartingState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147457: {
                    WifiStateMachine.this.setWifiState(3);
                    WifiStateMachine.this.mSupplicantRestartCount = 0;
                    WifiStateMachine.this.mSupplicantStateTracker.sendMessage(131183);
                    WifiStateMachine.this.mWpsStateMachine.sendMessage(131194);
                    WifiStateMachine.this.mLastBssid = null;
                    WifiStateMachine.this.mLastNetworkId = -1;
                    WifiStateMachine.this.mLastSignalLevel = -1;
                    WifiStateMachine.this.mWifiInfo.setMacAddress(WifiNative.getMacAddressCommand());
                    WifiConfigStore.initialize(WifiStateMachine.this.mContext);
                    WifiStateMachine.this.sendSupplicantConnectionChangedBroadcast(true);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverStartedState);
                    break;
                }
                case 147458: {
                    if (++WifiStateMachine.this.mSupplicantRestartCount <= 5) {
                        WifiStateMachine.this.loge("Failed to setup control channel, restart supplicant");
                        WifiNative.killSupplicant();
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverLoadedState);
                        WifiStateMachine.this.sendMessageDelayed(131083, 5000L);
                        break;
                    }
                    WifiStateMachine.this.loge("Failed " + WifiStateMachine.this.mSupplicantRestartCount + " times to start supplicant, unload driver");
                    WifiStateMachine.this.mSupplicantRestartCount = 0;
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverLoadedState);
                    WifiStateMachine.this.sendMessage(WifiStateMachine.this.obtainMessage(131074, 4, 0));
                    break;
                }
                case 131073: 
                case 131074: 
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131144: 
                case 131145: 
                case 131149: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class DriverFailedState
    extends State {
        DriverFailedState() {
        }

        public void enter() {
            WifiStateMachine.this.loge(this.getName() + "\n");
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            return false;
        }
    }

    class DriverUnloadedState
    extends State {
        DriverUnloadedState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131073: {
                    WifiStateMachine.this.mWifiP2pChannel.sendMessage(131203);
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mWaitForP2pDisableState);
                    break;
                }
                case 143361: {
                    WifiStateMachine.this.mReplyChannel.replyToMessage(message, 131204);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class DriverUnloadingState
    extends State {
        DriverUnloadingState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            final Message message = new Message();
            message.copyFrom(WifiStateMachine.this.getCurrentMessage());
            new Thread(new Runnable(){

                public void run() {
                    WifiStateMachine.this.mWakeLock.acquire();
                    if (WifiNative.unloadDriver()) {
                        WifiStateMachine.this.sendMessage(131077);
                        switch (message.arg1) {
                            case 1: 
                            case 4: {
                                WifiStateMachine.this.setWifiState(message.arg1);
                                break;
                            }
                            case 11: 
                            case 14: {
                                WifiStateMachine.this.setWifiApState(message.arg1);
                            }
                        }
                    } else {
                        WifiStateMachine.this.loge("Failed to unload driver!");
                        WifiStateMachine.this.sendMessage(131078);
                        switch (message.arg1) {
                            case 1: 
                            case 4: {
                                WifiStateMachine.this.setWifiState(4);
                                break;
                            }
                            case 11: 
                            case 14: {
                                WifiStateMachine.this.setWifiApState(14);
                            }
                        }
                    }
                    WifiStateMachine.this.mWakeLock.release();
                }
            }).start();
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131077: {
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverUnloadedState);
                    break;
                }
                case 131078: {
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverFailedState);
                    break;
                }
                case 131073: 
                case 131074: 
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131144: 
                case 131145: 
                case 131149: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class DriverLoadedState
    extends State {
        DriverLoadedState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131074: {
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverUnloadingState);
                    break;
                }
                case 131083: {
                    try {
                        WifiStateMachine.this.mNwService.wifiFirmwareReload(WifiStateMachine.this.mInterfaceName, "STA");
                    }
                    catch (Exception e) {
                        WifiStateMachine.this.loge("Failed to reload STA firmware " + e);
                    }
                    try {
                        WifiStateMachine.this.mNwService.setInterfaceDown(WifiStateMachine.this.mInterfaceName);
                        WifiStateMachine.this.mNwService.setInterfaceIpv6PrivacyExtensions(WifiStateMachine.this.mInterfaceName, true);
                    }
                    catch (RemoteException re) {
                        WifiStateMachine.this.loge("Unable to change interface settings: " + re);
                    }
                    catch (IllegalStateException ie) {
                        WifiStateMachine.this.loge("Unable to change interface settings: " + ie);
                    }
                    if (WifiNative.startSupplicant()) {
                        WifiStateMachine.this.mWifiMonitor.startMonitoring();
                        WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSupplicantStartingState);
                        break;
                    }
                    WifiStateMachine.this.loge("Failed to start supplicant!");
                    WifiStateMachine.this.sendMessage(WifiStateMachine.this.obtainMessage(131074, 4, 0));
                    break;
                }
                case 131093: {
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mSoftApStartingState);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class DriverLoadingState
    extends State {
        DriverLoadingState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            final Message message = new Message();
            message.copyFrom(WifiStateMachine.this.getCurrentMessage());
            new Thread(new Runnable(){

                public void run() {
                    WifiStateMachine.this.mWakeLock.acquire();
                    switch (message.arg1) {
                        case 2: {
                            WifiStateMachine.this.setWifiState(2);
                            break;
                        }
                        case 12: {
                            WifiStateMachine.this.setWifiApState(12);
                        }
                    }
                    if (WifiNative.loadDriver()) {
                        WifiStateMachine.this.sendMessage(131075);
                    } else {
                        WifiStateMachine.this.loge("Failed to load driver!");
                        switch (message.arg1) {
                            case 2: {
                                WifiStateMachine.this.setWifiState(4);
                                break;
                            }
                            case 12: {
                                WifiStateMachine.this.setWifiApState(14);
                            }
                        }
                        WifiStateMachine.this.sendMessage(131076);
                    }
                    WifiStateMachine.this.mWakeLock.release();
                }
            }).start();
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131075: {
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverLoadedState);
                    break;
                }
                case 131076: {
                    WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverFailedState);
                    break;
                }
                case 131073: 
                case 131074: 
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131093: 
                case 131096: 
                case 131144: 
                case 131145: 
                case 131149: 
                case 131152: 
                case 131156: 
                case 131157: 
                case 131162: {
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            EventLog.writeEvent(50022, message.what);
            return true;
        }
    }

    class InitialState
    extends State {
        InitialState() {
        }

        public void enter() {
            EventLog.writeEvent(50021, this.getName());
            if (WifiNative.isDriverLoaded()) {
                WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverLoadedState);
            } else {
                WifiStateMachine.this.transitionTo(WifiStateMachine.this.mDriverUnloadedState);
            }
            WifiStateMachine.this.mWifiP2pManager = (WifiP2pManager)WifiStateMachine.this.mContext.getSystemService("wifip2p");
            WifiStateMachine.this.mWifiP2pChannel.connect(WifiStateMachine.this.mContext, WifiStateMachine.this.getHandler(), WifiStateMachine.this.mWifiP2pManager.getMessenger());
            try {
                WifiStateMachine.this.mNwService.disableIpv6(WifiStateMachine.this.mInterfaceName);
            }
            catch (RemoteException re) {
                WifiStateMachine.this.loge("Failed to disable IPv6: " + re);
            }
            catch (IllegalStateException e) {
                WifiStateMachine.this.loge("Failed to disable IPv6: " + e);
            }
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 69632: {
                    if (message.arg1 == 0) {
                        WifiStateMachine.this.mWifiP2pChannel.sendMessage(69633);
                        break;
                    }
                    WifiStateMachine.this.loge("WifiP2pService connection failure, error=" + message.arg1);
                    break;
                }
                case 69636: {
                    WifiStateMachine.this.loge("WifiP2pService channel lost, message.arg1 =" + message.arg1);
                    break;
                }
                case 131103: {
                    WifiStateMachine.this.mBluetoothConnectionActive = message.arg1 != 0;
                    break;
                }
                case 131123: 
                case 131124: 
                case 131125: 
                case 131126: 
                case 131128: 
                case 131131: {
                    WifiStateMachine.this.mReplyChannel.replyToMessage(message, message.what, -1);
                    break;
                }
                case 131154: {
                    WifiStateMachine.this.mEnableRssiPolling = message.arg1 == 1;
                    break;
                }
                case 131163: {
                    WifiStateMachine.this.mEnableBackgroundScan = message.arg1 == 1;
                    break;
                }
                case 131073: 
                case 131074: 
                case 131083: 
                case 131084: 
                case 131085: 
                case 131086: 
                case 131089: 
                case 131090: 
                case 131093: 
                case 131094: 
                case 131095: 
                case 131096: 
                case 131097: 
                case 131098: 
                case 131099: 
                case 131100: 
                case 131101: 
                case 131102: 
                case 131127: 
                case 131129: 
                case 131130: 
                case 131143: 
                case 131144: 
                case 131145: 
                case 131146: 
                case 131147: 
                case 131148: 
                case 131149: 
                case 131152: 
                case 131155: 
                case 131158: 
                case 131159: 
                case 131160: 
                case 131162: 
                case 147457: 
                case 147458: 
                case 147459: 
                case 147460: 
                case 147461: 
                case 147462: 
                case 147463: 
                case 147464: 
                case 196612: 
                case 196613: {
                    break;
                }
                case 147465: {
                    WifiStateMachine.this.setWifiEnabled(false);
                    WifiStateMachine.this.setWifiEnabled(true);
                    break;
                }
                case 131161: {
                    WifiStateMachine.this.mReplyChannel.replyToMessage(message, 11, new WpsResult(WpsResult.Status.FAILURE));
                    break;
                }
                case 143361: {
                    WifiStateMachine.this.setWifiEnabled(false);
                    WifiStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    WifiStateMachine.this.loge("Error! unhandled message" + message);
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TetherStateChange {
        ArrayList<String> available;
        ArrayList<String> active;

        TetherStateChange(ArrayList<String> av, ArrayList<String> ac) {
            this.available = av;
            this.active = ac;
        }
    }
}

