/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;
import android.util.Slog;
import java.util.concurrent.atomic.AtomicBoolean;

public class WifiStateTracker
implements NetworkStateTracker {
    private static final String NETWORKTYPE = "WIFI";
    private static final String TAG = "WifiStateTracker";
    private static final boolean LOGV = true;
    private AtomicBoolean mTeardownRequested = new AtomicBoolean(false);
    private AtomicBoolean mPrivateDnsRouteSet = new AtomicBoolean(false);
    private AtomicBoolean mDefaultRouteSet = new AtomicBoolean(false);
    private LinkProperties mLinkProperties;
    private LinkCapabilities mLinkCapabilities;
    private NetworkInfo mNetworkInfo;
    private NetworkInfo.State mLastState = NetworkInfo.State.UNKNOWN;
    private Handler mCsHandler;
    private Context mContext;
    private BroadcastReceiver mWifiStateReceiver;
    private WifiManager mWifiManager;

    public WifiStateTracker(int netType, String networkName) {
        this.mNetworkInfo = new NetworkInfo(netType, 0, networkName, "");
        this.mLinkProperties = new LinkProperties();
        this.mLinkCapabilities = new LinkCapabilities();
        this.mNetworkInfo.setIsAvailable(false);
        this.setTeardownRequested(false);
    }

    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested.set(isRequested);
    }

    public boolean isTeardownRequested() {
        return this.mTeardownRequested.get();
    }

    public void startMonitoring(Context context, Handler target) {
        this.mCsHandler = target;
        this.mContext = context;
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.LINK_CONFIGURATION_CHANGED");
        filter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
        this.mWifiStateReceiver = new WifiStateReceiver();
        this.mContext.registerReceiver(this.mWifiStateReceiver, filter);
    }

    public boolean teardown() {
        this.mTeardownRequested.set(true);
        this.mWifiManager.stopWifi();
        return true;
    }

    public boolean reconnect() {
        this.mTeardownRequested.set(false);
        this.mWifiManager.startWifi();
        return true;
    }

    public boolean setRadio(boolean turnOn) {
        this.mWifiManager.setWifiEnabled(turnOn);
        return true;
    }

    public boolean isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    public void setUserDataEnable(boolean enabled) {
        Slog.w(TAG, "ignoring setUserDataEnable(" + enabled + ")");
    }

    public void setPolicyDataEnable(boolean enabled) {
        Slog.w(TAG, "ignoring setPolicyDataEnable(" + enabled + ")");
    }

    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet.get();
    }

    public void privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet.set(enabled);
    }

    public NetworkInfo getNetworkInfo() {
        return new NetworkInfo(this.mNetworkInfo);
    }

    public LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public LinkCapabilities getLinkCapabilities() {
        return new LinkCapabilities(this.mLinkCapabilities);
    }

    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet.get();
    }

    public void defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet.set(enabled);
    }

    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wifi";
    }

    public void setDependencyMet(boolean met) {
    }

    private class WifiStateReceiver
    extends BroadcastReceiver {
        private WifiStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.net.wifi.p2p.CONNECTION_STATE_CHANGE")) {
                WifiStateTracker.this.mNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                WifiStateTracker.this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
                if (WifiStateTracker.this.mLinkProperties == null) {
                    WifiStateTracker.this.mLinkProperties = new LinkProperties();
                }
                WifiStateTracker.this.mLinkCapabilities = (LinkCapabilities)intent.getParcelableExtra("linkCapabilities");
                if (WifiStateTracker.this.mLinkCapabilities == null) {
                    WifiStateTracker.this.mLinkCapabilities = new LinkCapabilities();
                }
            } else if (intent.getAction().equals("android.net.wifi.STATE_CHANGE")) {
                WifiStateTracker.this.mNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                WifiStateTracker.this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
                if (WifiStateTracker.this.mLinkProperties == null) {
                    WifiStateTracker.this.mLinkProperties = new LinkProperties();
                }
                WifiStateTracker.this.mLinkCapabilities = (LinkCapabilities)intent.getParcelableExtra("linkCapabilities");
                if (WifiStateTracker.this.mLinkCapabilities == null) {
                    WifiStateTracker.this.mLinkCapabilities = new LinkCapabilities();
                }
                NetworkInfo.State state = WifiStateTracker.this.mNetworkInfo.getState();
                if (WifiStateTracker.this.mLastState == state) {
                    return;
                }
                WifiStateTracker.this.mLastState = state;
                Message msg = WifiStateTracker.this.mCsHandler.obtainMessage(1, new NetworkInfo(WifiStateTracker.this.mNetworkInfo));
                msg.sendToTarget();
            } else if (intent.getAction().equals("android.net.wifi.LINK_CONFIGURATION_CHANGED")) {
                WifiStateTracker.this.mLinkProperties = (LinkProperties)intent.getParcelableExtra("linkProperties");
                Message msg = WifiStateTracker.this.mCsHandler.obtainMessage(3, WifiStateTracker.this.mNetworkInfo);
                msg.sendToTarget();
            }
        }
    }
}

