/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.DnsPinger;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Message;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class WifiWatchdogStateMachine
extends StateMachine {
    private static final boolean DBG = false;
    private static final String TAG = "WifiWatchdogStateMachine";
    private static final String DISABLED_NETWORK_NOTIFICATION_ID = "WifiWatchdog.networkdisabled";
    private static final String WALLED_GARDEN_NOTIFICATION_ID = "WifiWatchdog.walledgarden";
    private static final int WIFI_SIGNAL_LEVELS = 4;
    private static final int LOW_SIGNAL_CUTOFF = 0;
    private static final long DEFAULT_DNS_CHECK_SHORT_INTERVAL_MS = 120000L;
    private static final long DEFAULT_DNS_CHECK_LONG_INTERVAL_MS = 3600000L;
    private static final long DEFAULT_WALLED_GARDEN_INTERVAL_MS = 1800000L;
    private static final int DEFAULT_MAX_SSID_BLACKLISTS = 7;
    private static final int DEFAULT_NUM_DNS_PINGS = 5;
    private static final int DEFAULT_MIN_DNS_RESPONSES = 1;
    private static final int DEFAULT_DNS_PING_TIMEOUT_MS = 2000;
    private static final long DEFAULT_BLACKLIST_FOLLOWUP_INTERVAL_MS = 15000L;
    private static final String DEFAULT_WALLED_GARDEN_URL = "http://clients3.google.com/generate_204";
    private static final int WALLED_GARDEN_SOCKET_TIMEOUT_MS = 10000;
    private static final int WALLED_GARDEN_START_DELAY_MS = 3000;
    private static final int DNS_INTRATEST_PING_INTERVAL_MS = 200;
    private static final int DNS_START_DELAY_MS = 1000;
    private static final int BASE = 135168;
    private static final int EVENT_WATCHDOG_TOGGLED = 135169;
    private static final int EVENT_NETWORK_STATE_CHANGE = 135170;
    private static final int EVENT_RSSI_CHANGE = 135171;
    private static final int EVENT_SCAN_RESULTS_AVAILABLE = 135172;
    private static final int EVENT_WIFI_RADIO_STATE_CHANGE = 135173;
    private static final int EVENT_WATCHDOG_SETTINGS_CHANGE = 135174;
    private static final int MESSAGE_HANDLE_WALLED_GARDEN = 135268;
    private static final int MESSAGE_HANDLE_BAD_AP = 135269;
    private static final int MESSAGE_SINGLE_DNS_CHECK = 135270;
    private static final int MESSAGE_NETWORK_FOLLOWUP = 135271;
    private static final int MESSAGE_DELAYED_WALLED_GARDEN_CHECK = 135272;
    private Context mContext;
    private ContentResolver mContentResolver;
    private WifiManager mWifiManager;
    private DnsPinger mDnsPinger;
    private IntentFilter mIntentFilter;
    private BroadcastReceiver mBroadcastReceiver;
    private DefaultState mDefaultState = new DefaultState();
    private WatchdogDisabledState mWatchdogDisabledState = new WatchdogDisabledState();
    private WatchdogEnabledState mWatchdogEnabledState = new WatchdogEnabledState();
    private NotConnectedState mNotConnectedState = new NotConnectedState();
    private ConnectedState mConnectedState = new ConnectedState();
    private DnsCheckingState mDnsCheckingState = new DnsCheckingState();
    private OnlineWatchState mOnlineWatchState = new OnlineWatchState();
    private OnlineState mOnlineState = new OnlineState();
    private DnsCheckFailureState mDnsCheckFailureState = new DnsCheckFailureState();
    private DelayWalledGardenState mDelayWalledGardenState = new DelayWalledGardenState();
    private WalledGardenState mWalledGardenState = new WalledGardenState();
    private BlacklistedApState mBlacklistedApState = new BlacklistedApState();
    private long mDnsCheckShortIntervalMs;
    private long mDnsCheckLongIntervalMs;
    private long mWalledGardenIntervalMs;
    private int mMaxSsidBlacklists;
    private int mNumDnsPings;
    private int mMinDnsResponses;
    private int mDnsPingTimeoutMs;
    private long mBlacklistFollowupIntervalMs;
    private boolean mPoorNetworkDetectionEnabled;
    private boolean mWalledGardenTestEnabled;
    private String mWalledGardenUrl;
    private boolean mShowDisabledNotification;
    private WifiInfo mConnectionInfo;
    private int mNetEventCounter = 0;
    private HashSet<String> mBssids = new HashSet();
    private int mNumCheckFailures = 0;
    private Long mLastWalledGardenCheckTime = null;
    public boolean mDisableAPNextFailure = false;
    private static boolean sWifiOnly = false;
    private boolean mDisabledNotificationShown;
    private boolean mWalledGardenNotificationShown;
    public boolean mHasConnectedWifiManager = false;

    private WifiWatchdogStateMachine(Context context) {
        super(TAG);
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mDnsPinger = new DnsPinger(this.mContext, "WifiWatchdogStateMachine.DnsPinger", this.getHandler().getLooper(), this.getHandler(), 1);
        this.setupNetworkReceiver();
        this.registerForSettingsChanges();
        this.registerForWatchdogToggle();
        this.addState(this.mDefaultState);
        this.addState(this.mWatchdogDisabledState, this.mDefaultState);
        this.addState(this.mWatchdogEnabledState, this.mDefaultState);
        this.addState(this.mNotConnectedState, this.mWatchdogEnabledState);
        this.addState(this.mConnectedState, this.mWatchdogEnabledState);
        this.addState(this.mDnsCheckingState, this.mConnectedState);
        this.addState(this.mDnsCheckFailureState, this.mConnectedState);
        this.addState(this.mDelayWalledGardenState, this.mConnectedState);
        this.addState(this.mWalledGardenState, this.mConnectedState);
        this.addState(this.mBlacklistedApState, this.mConnectedState);
        this.addState(this.mOnlineWatchState, this.mConnectedState);
        this.addState(this.mOnlineState, this.mConnectedState);
        this.setInitialState(this.mWatchdogDisabledState);
        this.updateSettings();
    }

    public static WifiWatchdogStateMachine makeWifiWatchdogStateMachine(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        boolean bl = sWifiOnly = !cm.isNetworkSupported(0);
        if (Settings.Secure.getString(contentResolver, "wifi_watchdog_on") == null && sWifiOnly) {
            WifiWatchdogStateMachine.putSettingsBoolean(contentResolver, "wifi_watchdog_on", false);
        }
        WifiWatchdogStateMachine wwsm = new WifiWatchdogStateMachine(context);
        wwsm.start();
        wwsm.sendMessage(135169);
        return wwsm;
    }

    private void setupNetworkReceiver() {
        this.mBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("android.net.wifi.STATE_CHANGE")) {
                    WifiWatchdogStateMachine.this.sendMessage(135170, intent);
                } else if (action.equals("android.net.wifi.RSSI_CHANGED")) {
                    WifiWatchdogStateMachine.this.obtainMessage(135171, WifiWatchdogStateMachine.this.mNetEventCounter, intent.getIntExtra("newRssi", -200)).sendToTarget();
                } else if (action.equals("android.net.wifi.SCAN_RESULTS")) {
                    WifiWatchdogStateMachine.this.sendMessage(135172);
                } else if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                    WifiWatchdogStateMachine.this.sendMessage(135173, intent.getIntExtra("wifi_state", 4));
                }
            }
        };
        this.mIntentFilter = new IntentFilter();
        this.mIntentFilter.addAction("android.net.wifi.STATE_CHANGE");
        this.mIntentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        this.mIntentFilter.addAction("android.net.wifi.RSSI_CHANGED");
        this.mIntentFilter.addAction("android.net.wifi.SCAN_RESULTS");
    }

    private void registerForWatchdogToggle() {
        ContentObserver contentObserver = new ContentObserver(this.getHandler()){

            public void onChange(boolean selfChange) {
                WifiWatchdogStateMachine.this.sendMessage(135169);
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_on"), false, contentObserver);
    }

    private void registerForSettingsChanges() {
        ContentObserver contentObserver = new ContentObserver(this.getHandler()){

            public void onChange(boolean selfChange) {
                WifiWatchdogStateMachine.this.sendMessage(135174);
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_dns_check_short_interval_ms"), false, contentObserver);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_dns_check_long_interval_ms"), false, contentObserver);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_walled_garden_interval_ms"), false, contentObserver);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_max_ssid_blacklists"), false, contentObserver);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_num_dns_pings"), false, contentObserver);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_min_dns_responses"), false, contentObserver);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_dns_ping_timeout_ms"), false, contentObserver);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_blacklist_followup_interval_ms"), false, contentObserver);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_walled_garden_test_enabled"), false, contentObserver);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_walled_garden_url"), false, contentObserver);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_watchdog_show_disabled_network_popup"), false, contentObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWalledGardenConnection() {
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(this.mWalledGardenUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setInstanceFollowRedirects(false);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setReadTimeout(10000);
            urlConnection.setUseCaches(false);
            urlConnection.getInputStream();
            boolean bl = urlConnection.getResponseCode() != 204;
            Object var5_6 = null;
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
            return bl;
        }
        catch (IOException e) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                return bl;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_8 = null;
                    if (urlConnection == null) break block6;
                    urlConnection.disconnect();
                }
                throw throwable;
            }
        }
    }

    private boolean rssiStrengthAboveCutoff(int rssi) {
        return WifiManager.calculateSignalLevel(rssi, 4) > 0;
    }

    public void dump(PrintWriter pw) {
        pw.print("WatchdogStatus: ");
        pw.print("State " + this.getCurrentState());
        pw.println(", network [" + this.mConnectionInfo + "]");
        pw.print("checkFailures   " + this.mNumCheckFailures);
        pw.println(", bssids: " + this.mBssids);
        pw.println("lastSingleCheck: " + this.mOnlineWatchState.lastCheckTime);
    }

    private boolean isWatchdogEnabled() {
        return WifiWatchdogStateMachine.getSettingsBoolean(this.mContentResolver, "wifi_watchdog_on", true);
    }

    private void updateSettings() {
        this.mDnsCheckShortIntervalMs = Settings.Secure.getLong(this.mContentResolver, "wifi_watchdog_dns_check_short_interval_ms", 120000L);
        this.mDnsCheckLongIntervalMs = Settings.Secure.getLong(this.mContentResolver, "wifi_watchdog_dns_check_long_interval_ms", 3600000L);
        this.mMaxSsidBlacklists = Settings.Secure.getInt(this.mContentResolver, "wifi_watchdog_max_ssid_blacklists", 7);
        this.mNumDnsPings = Settings.Secure.getInt(this.mContentResolver, "wifi_watchdog_num_dns_pings", 5);
        this.mMinDnsResponses = Settings.Secure.getInt(this.mContentResolver, "wifi_watchdog_min_dns_responses", 1);
        this.mDnsPingTimeoutMs = Settings.Secure.getInt(this.mContentResolver, "wifi_watchdog_dns_ping_timeout_ms", 2000);
        this.mBlacklistFollowupIntervalMs = Settings.Secure.getLong(this.mContentResolver, "wifi_watchdog_blacklist_followup_interval_ms", 15000L);
        this.mPoorNetworkDetectionEnabled = WifiWatchdogStateMachine.getSettingsBoolean(this.mContentResolver, "wifi_watchdog_poor_network_test_enabled", false);
        this.mWalledGardenTestEnabled = WifiWatchdogStateMachine.getSettingsBoolean(this.mContentResolver, "wifi_watchdog_walled_garden_test_enabled", true);
        this.mWalledGardenUrl = WifiWatchdogStateMachine.getSettingsStr(this.mContentResolver, "wifi_watchdog_walled_garden_url", DEFAULT_WALLED_GARDEN_URL);
        this.mWalledGardenIntervalMs = Settings.Secure.getLong(this.mContentResolver, "wifi_watchdog_walled_garden_interval_ms", 1800000L);
        this.mShowDisabledNotification = WifiWatchdogStateMachine.getSettingsBoolean(this.mContentResolver, "wifi_watchdog_show_disabled_network_popup", true);
    }

    private static long waitTime(long interval, Long lastTime) {
        if (lastTime == null) {
            return 0L;
        }
        long wait = interval + lastTime - SystemClock.elapsedRealtime();
        return wait > 0L ? wait : 0L;
    }

    private static String wifiInfoToStr(WifiInfo wifiInfo) {
        if (wifiInfo == null) {
            return "null";
        }
        return "(" + wifiInfo.getSSID() + ", " + wifiInfo.getBSSID() + ")";
    }

    private void updateBssids() {
        String curSsid = this.mConnectionInfo.getSSID();
        List<ScanResult> results = this.mWifiManager.getScanResults();
        int oldNumBssids = this.mBssids.size();
        if (results == null) {
            return;
        }
        for (ScanResult result : results) {
            if (result == null || result.SSID == null || !curSsid.equals(result.SSID)) continue;
            this.mBssids.add(result.BSSID);
        }
    }

    private void resetWatchdogState() {
        this.mConnectionInfo = null;
        this.mDisableAPNextFailure = false;
        this.mLastWalledGardenCheckTime = null;
        this.mNumCheckFailures = 0;
        this.mBssids.clear();
        this.setDisabledNetworkNotificationVisible(false);
        this.setWalledGardenNotificationVisible(false);
    }

    private void setWalledGardenNotificationVisible(boolean visible) {
        if (!visible && !this.mWalledGardenNotificationShown) {
            return;
        }
        Resources r = Resources.getSystem();
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (visible) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse(this.mWalledGardenUrl));
            intent.setFlags(0x10400000);
            String title = r.getString(17040344, 0);
            String details = r.getString(17040345, this.mConnectionInfo.getSSID());
            Notification notification = new Notification();
            notification.when = 0L;
            notification.icon = 17302772;
            notification.flags = 16;
            notification.contentIntent = PendingIntent.getActivity(this.mContext, 0, intent, 0);
            notification.tickerText = title;
            notification.setLatestEventInfo(this.mContext, title, details, notification.contentIntent);
            notificationManager.notify(WALLED_GARDEN_NOTIFICATION_ID, 1, notification);
        } else {
            notificationManager.cancel(WALLED_GARDEN_NOTIFICATION_ID, 1);
        }
        this.mWalledGardenNotificationShown = visible;
    }

    private void setDisabledNetworkNotificationVisible(boolean visible) {
        if (!visible && !this.mDisabledNotificationShown) {
            return;
        }
        Resources r = Resources.getSystem();
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (visible) {
            CharSequence title = r.getText(17040346);
            String msg = this.mConnectionInfo.getSSID() + r.getText(17040347);
            Notification wifiDisabledWarning = new Notification.Builder(this.mContext).setSmallIcon(17301642).setDefaults(-1).setTicker(title).setContentTitle(title).setContentText(msg).setContentIntent(PendingIntent.getActivity(this.mContext, 0, new Intent("android.net.wifi.PICK_WIFI_NETWORK").setFlags(0x10000000), 0)).setWhen(System.currentTimeMillis()).setAutoCancel(true).getNotification();
            notificationManager.notify(DISABLED_NETWORK_NOTIFICATION_ID, 1, wifiDisabledWarning);
        } else {
            notificationManager.cancel(DISABLED_NETWORK_NOTIFICATION_ID, 1);
        }
        this.mDisabledNotificationShown = visible;
    }

    private static String getSettingsStr(ContentResolver cr, String name, String def) {
        String v = Settings.Secure.getString(cr, name);
        return v != null ? v : def;
    }

    private static boolean getSettingsBoolean(ContentResolver cr, String name, boolean def) {
        return Settings.Secure.getInt(cr, name, def ? 1 : 0) == 1;
    }

    private static boolean putSettingsBoolean(ContentResolver cr, String name, boolean value) {
        return Settings.Secure.putInt(cr, name, value ? 1 : 0);
    }

    private void log(String s) {
        Log.d(TAG, s);
    }

    private void loge(String s) {
        Log.e(TAG, s);
    }

    class BlacklistedApState
    extends State {
        BlacklistedApState() {
        }

        public void enter() {
            WifiWatchdogStateMachine.this.mDisableAPNextFailure = true;
            WifiWatchdogStateMachine.this.sendMessageDelayed(WifiWatchdogStateMachine.this.obtainMessage(135271, WifiWatchdogStateMachine.this.mNetEventCounter, 0), WifiWatchdogStateMachine.this.mBlacklistFollowupIntervalMs);
        }

        public boolean processMessage(Message msg) {
            if (msg.what != 135271) {
                return false;
            }
            if (msg.arg1 != WifiWatchdogStateMachine.this.mNetEventCounter) {
                return true;
            }
            WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mDnsCheckingState);
            return true;
        }
    }

    class WalledGardenState
    extends State {
        WalledGardenState() {
        }

        public void enter() {
            WifiWatchdogStateMachine.this.obtainMessage(135268, WifiWatchdogStateMachine.this.mNetEventCounter, 0).sendToTarget();
        }

        public boolean processMessage(Message msg) {
            if (msg.what != 135268) {
                return false;
            }
            if (msg.arg1 != WifiWatchdogStateMachine.this.mNetEventCounter) {
                return true;
            }
            WifiWatchdogStateMachine.this.setWalledGardenNotificationVisible(true);
            if (WifiWatchdogStateMachine.this.mPoorNetworkDetectionEnabled) {
                WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineWatchState);
            } else {
                WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineState);
            }
            return true;
        }
    }

    class DnsCheckFailureState
    extends State {
        DnsCheckFailureState() {
        }

        public void enter() {
            WifiWatchdogStateMachine.this.mNumCheckFailures++;
            WifiWatchdogStateMachine.this.obtainMessage(135269, WifiWatchdogStateMachine.this.mNetEventCounter, 0).sendToTarget();
        }

        public boolean processMessage(Message msg) {
            if (msg.what != 135269) {
                return false;
            }
            if (msg.arg1 != WifiWatchdogStateMachine.this.mNetEventCounter) {
                return true;
            }
            if (WifiWatchdogStateMachine.this.mDisableAPNextFailure || WifiWatchdogStateMachine.this.mNumCheckFailures >= WifiWatchdogStateMachine.this.mBssids.size() || WifiWatchdogStateMachine.this.mNumCheckFailures >= WifiWatchdogStateMachine.this.mMaxSsidBlacklists) {
                if (sWifiOnly) {
                    WifiWatchdogStateMachine.this.log("Would disable bad network, but device has no mobile data!  Going idle...");
                    WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mNotConnectedState);
                    return true;
                }
                WifiWatchdogStateMachine.this.log("Disabling current SSID " + WifiWatchdogStateMachine.wifiInfoToStr(WifiWatchdogStateMachine.this.mConnectionInfo) + ".  " + "numCheckFailures " + WifiWatchdogStateMachine.this.mNumCheckFailures + ", numAPs " + WifiWatchdogStateMachine.this.mBssids.size());
                int networkId = WifiWatchdogStateMachine.this.mConnectionInfo.getNetworkId();
                if (!WifiWatchdogStateMachine.this.mHasConnectedWifiManager) {
                    WifiWatchdogStateMachine.this.mWifiManager.asyncConnect(WifiWatchdogStateMachine.this.mContext, WifiWatchdogStateMachine.this.getHandler());
                    WifiWatchdogStateMachine.this.mHasConnectedWifiManager = true;
                }
                WifiWatchdogStateMachine.this.mWifiManager.disableNetwork(networkId, 1);
                if (WifiWatchdogStateMachine.this.mShowDisabledNotification && WifiWatchdogStateMachine.this.mConnectionInfo.isExplicitConnect()) {
                    WifiWatchdogStateMachine.this.setDisabledNetworkNotificationVisible(true);
                }
                WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mNotConnectedState);
            } else {
                WifiWatchdogStateMachine.this.log("Blacklisting current BSSID.  " + WifiWatchdogStateMachine.wifiInfoToStr(WifiWatchdogStateMachine.this.mConnectionInfo) + "numCheckFailures " + WifiWatchdogStateMachine.this.mNumCheckFailures + ", numAPs " + WifiWatchdogStateMachine.this.mBssids.size());
                WifiWatchdogStateMachine.this.mWifiManager.addToBlacklist(WifiWatchdogStateMachine.this.mConnectionInfo.getBSSID());
                WifiWatchdogStateMachine.this.mWifiManager.reassociate();
                WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mBlacklistedApState);
            }
            return true;
        }
    }

    class OnlineState
    extends State {
        OnlineState() {
        }
    }

    class OnlineWatchState
    extends State {
        boolean unstableSignalChecks = false;
        boolean signalUnstable = false;
        int checkGuard = 0;
        Long lastCheckTime = null;
        HashMap<Integer, InetAddress> pingInfoMap = new HashMap();

        OnlineWatchState() {
        }

        public void enter() {
            this.lastCheckTime = SystemClock.elapsedRealtime();
            this.signalUnstable = false;
            ++this.checkGuard;
            this.unstableSignalChecks = false;
            this.pingInfoMap.clear();
            this.triggerSingleDnsCheck();
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135171: {
                    if (msg.arg1 != WifiWatchdogStateMachine.this.mNetEventCounter) {
                        return true;
                    }
                    int newRssi = msg.arg2;
                    boolean bl = this.signalUnstable = !WifiWatchdogStateMachine.this.rssiStrengthAboveCutoff(newRssi);
                    if (this.signalUnstable && !this.unstableSignalChecks) {
                        this.triggerSingleDnsCheck();
                    }
                    return true;
                }
                case 135270: {
                    if (msg.arg1 != this.checkGuard) {
                        return true;
                    }
                    this.lastCheckTime = SystemClock.elapsedRealtime();
                    this.pingInfoMap.clear();
                    for (InetAddress curDns : WifiWatchdogStateMachine.this.mDnsPinger.getDnsList()) {
                        this.pingInfoMap.put(WifiWatchdogStateMachine.this.mDnsPinger.pingDnsAsync(curDns, WifiWatchdogStateMachine.this.mDnsPingTimeoutMs, 0), curDns);
                    }
                    return true;
                }
                case 327680: {
                    InetAddress curDnsServer = this.pingInfoMap.get(msg.arg1);
                    if (curDnsServer == null) {
                        return true;
                    }
                    this.pingInfoMap.remove(msg.arg1);
                    int responseTime = msg.arg2;
                    if (responseTime >= 0) {
                        this.pingInfoMap.clear();
                        ++this.checkGuard;
                        this.unstableSignalChecks = false;
                        this.triggerSingleDnsCheck();
                    } else if (this.pingInfoMap.isEmpty()) {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mDnsCheckingState);
                    }
                    return true;
                }
            }
            return false;
        }

        public void exit() {
            WifiWatchdogStateMachine.this.mDnsPinger.cancelPings();
        }

        private void triggerSingleDnsCheck() {
            long waitInterval;
            if (this.signalUnstable) {
                waitInterval = WifiWatchdogStateMachine.this.mDnsCheckShortIntervalMs;
                this.unstableSignalChecks = true;
            } else {
                waitInterval = WifiWatchdogStateMachine.this.mDnsCheckLongIntervalMs;
            }
            WifiWatchdogStateMachine.this.sendMessageDelayed(WifiWatchdogStateMachine.this.obtainMessage(135270, this.checkGuard, 0), WifiWatchdogStateMachine.waitTime(waitInterval, this.lastCheckTime));
        }
    }

    class DelayWalledGardenState
    extends State {
        DelayWalledGardenState() {
        }

        public void enter() {
            WifiWatchdogStateMachine.this.sendMessageDelayed(135272, 3000L);
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135272: {
                    WifiWatchdogStateMachine.this.mLastWalledGardenCheckTime = SystemClock.elapsedRealtime();
                    if (WifiWatchdogStateMachine.this.isWalledGardenConnection()) {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mWalledGardenState);
                    } else if (WifiWatchdogStateMachine.this.mPoorNetworkDetectionEnabled) {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineWatchState);
                    } else {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineState);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    class DnsCheckingState
    extends State {
        List<InetAddress> mDnsList;
        int[] dnsCheckSuccesses;
        String dnsCheckLogStr;
        String[] dnsResponseStrs;
        HashMap<Integer, Integer> idDnsMap = new HashMap();

        DnsCheckingState() {
        }

        public void enter() {
            int i;
            this.mDnsList = WifiWatchdogStateMachine.this.mDnsPinger.getDnsList();
            int numDnses = this.mDnsList.size();
            this.dnsCheckSuccesses = new int[numDnses];
            this.dnsResponseStrs = new String[numDnses];
            for (i = 0; i < numDnses; ++i) {
                this.dnsResponseStrs[i] = "";
            }
            this.idDnsMap.clear();
            for (i = 0; i < WifiWatchdogStateMachine.this.mNumDnsPings; ++i) {
                for (int j = 0; j < numDnses; ++j) {
                    this.idDnsMap.put(WifiWatchdogStateMachine.this.mDnsPinger.pingDnsAsync(this.mDnsList.get(j), WifiWatchdogStateMachine.this.mDnsPingTimeoutMs, 1000 + 200 * i), j);
                }
            }
        }

        public boolean processMessage(Message msg) {
            if (msg.what != 327680) {
                return false;
            }
            int pingID = msg.arg1;
            int pingResponseTime = msg.arg2;
            Integer dnsServerId = this.idDnsMap.get(pingID);
            if (dnsServerId == null) {
                WifiWatchdogStateMachine.this.loge("Received a Dns response with unknown ID!");
                return true;
            }
            this.idDnsMap.remove(pingID);
            if (pingResponseTime >= 0) {
                int n = dnsServerId;
                this.dnsCheckSuccesses[n] = this.dnsCheckSuccesses[n] + 1;
            }
            if (this.dnsCheckSuccesses[dnsServerId] >= WifiWatchdogStateMachine.this.mMinDnsResponses) {
                if (!this.shouldCheckWalledGarden()) {
                    WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineWatchState);
                    return true;
                }
                WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mDelayWalledGardenState);
                return true;
            }
            if (this.idDnsMap.isEmpty()) {
                WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mDnsCheckFailureState);
                return true;
            }
            return true;
        }

        private String makeLogString() {
            String logStr = this.dnsCheckLogStr;
            for (String respStr : this.dnsResponseStrs) {
                logStr = logStr + " [" + respStr + "]";
            }
            return logStr;
        }

        public void exit() {
            WifiWatchdogStateMachine.this.mDnsPinger.cancelPings();
        }

        private boolean shouldCheckWalledGarden() {
            if (!WifiWatchdogStateMachine.this.mWalledGardenTestEnabled) {
                return false;
            }
            long waitTime = WifiWatchdogStateMachine.waitTime(WifiWatchdogStateMachine.this.mWalledGardenIntervalMs, WifiWatchdogStateMachine.this.mLastWalledGardenCheckTime);
            return waitTime <= 0L;
        }
    }

    class ConnectedState
    extends State {
        ConnectedState() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135172: {
                    if (WifiWatchdogStateMachine.this.mPoorNetworkDetectionEnabled) {
                        WifiWatchdogStateMachine.this.updateBssids();
                    }
                    return true;
                }
                case 135174: {
                    WifiWatchdogStateMachine.this.updateSettings();
                    if (WifiWatchdogStateMachine.this.mPoorNetworkDetectionEnabled) {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineWatchState);
                    } else {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mOnlineState);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    class NotConnectedState
    extends State {
        NotConnectedState() {
        }
    }

    class WatchdogEnabledState
    extends State {
        WatchdogEnabledState() {
        }

        public void enter() {
            WifiWatchdogStateMachine.this.resetWatchdogState();
            WifiWatchdogStateMachine.this.mContext.registerReceiver(WifiWatchdogStateMachine.this.mBroadcastReceiver, WifiWatchdogStateMachine.this.mIntentFilter);
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135169: {
                    if (!WifiWatchdogStateMachine.this.isWatchdogEnabled()) {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mWatchdogDisabledState);
                    }
                    return true;
                }
                case 135170: {
                    Intent stateChangeIntent = (Intent)msg.obj;
                    NetworkInfo networkInfo = (NetworkInfo)stateChangeIntent.getParcelableExtra("networkInfo");
                    WifiWatchdogStateMachine.this.setDisabledNetworkNotificationVisible(false);
                    WifiWatchdogStateMachine.this.setWalledGardenNotificationVisible(false);
                    switch (networkInfo.getState()) {
                        case CONNECTED: {
                            WifiInfo wifiInfo = (WifiInfo)stateChangeIntent.getParcelableExtra("wifiInfo");
                            if (wifiInfo == null) {
                                WifiWatchdogStateMachine.this.loge("Connected --> WifiInfo object null!");
                                return true;
                            }
                            if (wifiInfo.getSSID() == null || wifiInfo.getBSSID() == null) {
                                WifiWatchdogStateMachine.this.loge("Received wifiInfo object with null elts: " + WifiWatchdogStateMachine.wifiInfoToStr(wifiInfo));
                                return true;
                            }
                            this.initConnection(wifiInfo);
                            WifiWatchdogStateMachine.this.mConnectionInfo = wifiInfo;
                            WifiWatchdogStateMachine.this.mNetEventCounter++;
                            if (WifiWatchdogStateMachine.this.mPoorNetworkDetectionEnabled) {
                                WifiWatchdogStateMachine.this.updateBssids();
                                WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mDnsCheckingState);
                                break;
                            }
                            WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mDelayWalledGardenState);
                            break;
                        }
                        default: {
                            WifiWatchdogStateMachine.this.mNetEventCounter++;
                            WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mNotConnectedState);
                        }
                    }
                    return true;
                }
                case 135173: {
                    if ((Integer)msg.obj == 0) {
                        WifiWatchdogStateMachine.this.resetWatchdogState();
                        WifiWatchdogStateMachine.this.mNetEventCounter++;
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mNotConnectedState);
                    }
                    return true;
                }
            }
            return false;
        }

        private void initConnection(WifiInfo wifiInfo) {
            if (WifiWatchdogStateMachine.this.mConnectionInfo == null || !wifiInfo.getSSID().equals(WifiWatchdogStateMachine.this.mConnectionInfo.getSSID())) {
                WifiWatchdogStateMachine.this.resetWatchdogState();
            } else if (!wifiInfo.getBSSID().equals(WifiWatchdogStateMachine.this.mConnectionInfo.getBSSID())) {
                WifiWatchdogStateMachine.this.mDisableAPNextFailure = false;
            }
        }

        public void exit() {
            WifiWatchdogStateMachine.this.mContext.unregisterReceiver(WifiWatchdogStateMachine.this.mBroadcastReceiver);
        }
    }

    class WatchdogDisabledState
    extends State {
        WatchdogDisabledState() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135169: {
                    if (WifiWatchdogStateMachine.this.isWatchdogEnabled()) {
                        WifiWatchdogStateMachine.this.transitionTo(WifiWatchdogStateMachine.this.mNotConnectedState);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 135174: {
                    WifiWatchdogStateMachine.this.updateSettings();
                    return true;
                }
            }
            return true;
        }
    }
}

