/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.wifi.StateChangeResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiConfigStore;
import android.net.wifi.WifiStateMachine;
import android.net.wifi.WpsInfo;
import android.net.wifi.WpsResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;

class WpsStateMachine
extends StateMachine {
    private static final String TAG = "WpsStateMachine";
    private static final boolean DBG = false;
    private WifiStateMachine mWifiStateMachine;
    private WpsInfo mWpsInfo;
    private Context mContext;
    AsyncChannel mReplyChannel = new AsyncChannel();
    private State mDefaultState = new DefaultState();
    private State mInactiveState = new InactiveState();
    private State mActiveState = new ActiveState();

    public WpsStateMachine(Context context, WifiStateMachine wsm, Handler target) {
        super(TAG, target.getLooper());
        this.mContext = context;
        this.mWifiStateMachine = wsm;
        this.addState(this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mActiveState, this.mDefaultState);
        this.setInitialState(this.mInactiveState);
        this.start();
    }

    class InactiveState
    extends State {
        InactiveState() {
        }

        public void enter() {
        }

        public boolean processMessage(Message message) {
            boolean retValue = true;
            switch (message.what) {
                case 147462: {
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }
    }

    class ActiveState
    extends State {
        ActiveState() {
        }

        public void enter() {
        }

        public boolean processMessage(Message message) {
            boolean retValue = true;
            block0 : switch (message.what) {
                case 147462: {
                    StateChangeResult stateChangeResult = (StateChangeResult)message.obj;
                    SupplicantState supState = stateChangeResult.state;
                    switch (supState) {
                        case COMPLETED: {
                            Log.d(WpsStateMachine.TAG, "WPS set up successful");
                            WifiConfigStore.enableAllNetworks();
                            WifiConfigStore.loadConfiguredNetworks();
                            WifiConfigStore.updateIpAndProxyFromWpsConfig(stateChangeResult.networkId, WpsStateMachine.this.mWpsInfo);
                            WpsStateMachine.this.mWifiStateMachine.sendMessage(131193);
                            WpsStateMachine.this.transitionTo(WpsStateMachine.this.mInactiveState);
                            break block0;
                        }
                        case INACTIVE: {
                            Log.d(WpsStateMachine.TAG, "WPS set up failed, enabling other networks");
                            WifiConfigStore.enableAllNetworks();
                            WpsStateMachine.this.mWifiStateMachine.sendMessage(131193);
                            WpsStateMachine.this.transitionTo(WpsStateMachine.this.mInactiveState);
                            break block0;
                        }
                    }
                    break;
                }
                case 131161: {
                    WpsStateMachine.this.mReplyChannel.replyToMessage(message, 11, new WpsResult(WpsResult.Status.IN_PROGRESS));
                    break;
                }
                default: {
                    retValue = false;
                }
            }
            return retValue;
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        public void enter() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 131161: {
                    WpsResult result;
                    WpsStateMachine.this.mWpsInfo = (WpsInfo)message.obj;
                    switch (((WpsStateMachine)WpsStateMachine.this).mWpsInfo.setup) {
                        case 0: {
                            result = WifiConfigStore.startWpsPbc(WpsStateMachine.this.mWpsInfo);
                            break;
                        }
                        case 2: {
                            result = WifiConfigStore.startWpsWithPinFromAccessPoint(WpsStateMachine.this.mWpsInfo);
                            break;
                        }
                        case 1: {
                            result = WifiConfigStore.startWpsWithPinFromDevice(WpsStateMachine.this.mWpsInfo);
                            break;
                        }
                        default: {
                            result = new WpsResult(WpsResult.Status.FAILURE);
                            Log.e(WpsStateMachine.TAG, "Invalid setup for WPS");
                        }
                    }
                    WpsStateMachine.this.mReplyChannel.replyToMessage(message, 11, result);
                    if (result.status == WpsResult.Status.SUCCESS) {
                        WpsStateMachine.this.transitionTo(WpsStateMachine.this.mActiveState);
                        break;
                    }
                    Log.e(WpsStateMachine.TAG, "Failed to start WPS with config " + WpsStateMachine.this.mWpsInfo.toString());
                    break;
                }
                case 131194: {
                    WpsStateMachine.this.transitionTo(WpsStateMachine.this.mInactiveState);
                    break;
                }
                default: {
                    Log.e(WpsStateMachine.TAG, "Failed to handle " + message);
                }
            }
            return true;
        }
    }
}

