/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.app.AlertDialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.net.DhcpInfoInternal;
import android.net.DhcpStateMachine;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.net.wifi.WifiMonitor;
import android.net.wifi.WifiNative;
import android.net.wifi.WpsInfo;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.Messenger;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collection;

public class WifiP2pService
extends IWifiP2pManager.Stub {
    private static final String TAG = "WifiP2pService";
    private static final boolean DBG = false;
    private static final String NETWORKTYPE = "WIFI_P2P";
    private Context mContext;
    private String mInterface;
    private Notification mNotification;
    INetworkManagementService mNwService;
    private DhcpStateMachine mDhcpStateMachine;
    private int mWifiState = 1;
    private int mWifiApState = 11;
    private P2pStateMachine mP2pStateMachine;
    private AsyncChannel mReplyChannel = new AsyncChannel();
    private AsyncChannel mWifiChannel;
    private static final int GROUP_NEGOTIATION_WAIT_TIME_MS = 120000;
    private static int mGroupNegotiationTimeoutIndex = 0;
    private static final int P2P_RESTART_INTERVAL_MSECS = 5000;
    private static final int P2P_RESTART_TRIES = 5;
    private int mP2pRestartCount = 0;
    private static final int BASE = 143360;
    public static final int P2P_ENABLE_PENDING = 143361;
    public static final int WIFI_ENABLE_PROCEED = 143362;
    public static final int GROUP_NEGOTIATION_TIMED_OUT = 143363;
    private static final int WIFI_DISABLE_USER_ACCEPT = 143364;
    private static final int WIFI_DISABLE_USER_REJECT = 143365;
    private static final int GROUP_NEGOTIATION_USER_ACCEPT = 143366;
    private static final int GROUP_NEGOTIATION_USER_REJECT = 143367;
    private static final int GROUP_INVITATION_USER_ACCEPT = 143368;
    private static final int GROUP_INVITATION_USER_REJECT = 143369;
    private static final int AIRPLANE_MODE_CHANGED = 143370;
    private static final int EMERGENCY_CALLBACK_MODE = 143371;
    private static final int WPS_PBC = 143372;
    private static final int WPS_PIN = 143373;
    private final boolean mP2pSupported;
    private WifiP2pDevice mThisDevice = new WifiP2pDevice();
    private boolean mPersistGroup;
    private NetworkInfo mNetworkInfo;
    private static final String[] DHCP_RANGE = new String[]{"192.168.49.2", "192.168.49.254"};
    private static final String SERVER_ADDRESS = "192.168.49.1";

    public WifiP2pService(Context context) {
        this.mContext = context;
        this.mInterface = SystemProperties.get("wifi.interface", "wlan0");
        this.mNetworkInfo = new NetworkInfo(13, 0, NETWORKTYPE, "");
        this.mP2pSupported = this.mContext.getPackageManager().hasSystemFeature("android.hardware.wifi.direct");
        this.mThisDevice.primaryDeviceType = this.mContext.getResources().getString(17039386);
        this.mThisDevice.deviceName = this.getDefaultDeviceName();
        this.mP2pStateMachine = new P2pStateMachine(TAG, this.mP2pSupported);
        this.mP2pStateMachine.start();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        filter.addAction("android.intent.action.AIRPLANE_MODE");
        filter.addAction("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        filter.addAction("android.net.wifi.WIFI_AP_STATE_CHANGED");
        this.mContext.registerReceiver(new WifiStateReceiver(), filter);
    }

    public void connectivityServiceReady() {
        IBinder b = ServiceManager.getService("network_management");
        this.mNwService = INetworkManagementService.Stub.asInterface(b);
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE", TAG);
    }

    private void enforceChangePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CHANGE_WIFI_STATE", TAG);
    }

    private String getDefaultDeviceName() {
        String id2 = Settings.Secure.getString(this.mContext.getContentResolver(), "android_id");
        return "Android_" + id2.substring(0, 4);
    }

    public Messenger getMessenger() {
        this.enforceAccessPermission();
        this.enforceChangePermission();
        return new Messenger(this.mP2pStateMachine.getHandler());
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump WifiP2pService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
    }

    private class P2pStateMachine
    extends StateMachine {
        private DefaultState mDefaultState;
        private P2pNotSupportedState mP2pNotSupportedState;
        private P2pDisablingState mP2pDisablingState;
        private P2pDisabledState mP2pDisabledState;
        private WaitForUserActionState mWaitForUserActionState;
        private WaitForWifiDisableState mWaitForWifiDisableState;
        private P2pEnablingState mP2pEnablingState;
        private P2pEnabledState mP2pEnabledState;
        private InactiveState mInactiveState;
        private UserAuthorizingGroupNegotiationState mUserAuthorizingGroupNegotiationState;
        private UserAuthorizingGroupInvitationState mUserAuthorizingGroupInvitationState;
        private GroupNegotiationState mGroupNegotiationState;
        private GroupCreatedState mGroupCreatedState;
        private WifiMonitor mWifiMonitor;
        private WifiP2pDeviceList mPeers;
        private WifiP2pInfo mWifiP2pInfo;
        private WifiP2pGroup mGroup;
        private WifiP2pConfig mSavedGoNegotiationConfig;
        private WifiP2pConfig mSavedConnectConfig;
        private WifiP2pGroup mSavedP2pGroup;

        P2pStateMachine(String name, boolean p2pSupported) {
            super(name);
            this.mDefaultState = new DefaultState();
            this.mP2pNotSupportedState = new P2pNotSupportedState();
            this.mP2pDisablingState = new P2pDisablingState();
            this.mP2pDisabledState = new P2pDisabledState();
            this.mWaitForUserActionState = new WaitForUserActionState();
            this.mWaitForWifiDisableState = new WaitForWifiDisableState();
            this.mP2pEnablingState = new P2pEnablingState();
            this.mP2pEnabledState = new P2pEnabledState();
            this.mInactiveState = new InactiveState();
            this.mUserAuthorizingGroupNegotiationState = new UserAuthorizingGroupNegotiationState();
            this.mUserAuthorizingGroupInvitationState = new UserAuthorizingGroupInvitationState();
            this.mGroupNegotiationState = new GroupNegotiationState();
            this.mGroupCreatedState = new GroupCreatedState();
            this.mWifiMonitor = new WifiMonitor(this);
            this.mPeers = new WifiP2pDeviceList();
            this.mWifiP2pInfo = new WifiP2pInfo();
            this.addState(this.mDefaultState);
            this.addState(this.mP2pNotSupportedState, this.mDefaultState);
            this.addState(this.mP2pDisablingState, this.mDefaultState);
            this.addState(this.mP2pDisabledState, this.mDefaultState);
            this.addState(this.mWaitForUserActionState, this.mP2pDisabledState);
            this.addState(this.mWaitForWifiDisableState, this.mP2pDisabledState);
            this.addState(this.mP2pEnablingState, this.mDefaultState);
            this.addState(this.mP2pEnabledState, this.mDefaultState);
            this.addState(this.mInactiveState, this.mP2pEnabledState);
            this.addState(this.mUserAuthorizingGroupNegotiationState, this.mInactiveState);
            this.addState(this.mUserAuthorizingGroupInvitationState, this.mInactiveState);
            this.addState(this.mGroupNegotiationState, this.mP2pEnabledState);
            this.addState(this.mGroupCreatedState, this.mP2pEnabledState);
            if (p2pSupported) {
                this.setInitialState(this.mP2pDisabledState);
            } else {
                this.setInitialState(this.mP2pNotSupportedState);
            }
        }

        private void sendP2pStateChangedBroadcast(boolean enabled) {
            Intent intent = new Intent("android.net.wifi.p2p.STATE_CHANGED");
            intent.addFlags(0x10000000);
            if (enabled) {
                intent.putExtra("wifi_p2p_state", 2);
            } else {
                intent.putExtra("wifi_p2p_state", 1);
            }
            WifiP2pService.this.mContext.sendStickyBroadcast(intent);
        }

        private void sendThisDeviceChangedBroadcast() {
            Intent intent = new Intent("android.net.wifi.p2p.THIS_DEVICE_CHANGED");
            intent.addFlags(0x10000000);
            intent.putExtra("wifiP2pDevice", new WifiP2pDevice(WifiP2pService.this.mThisDevice));
            WifiP2pService.this.mContext.sendStickyBroadcast(intent);
        }

        private void sendP2pPeersChangedBroadcast() {
            Intent intent = new Intent("android.net.wifi.p2p.PEERS_CHANGED");
            intent.addFlags(0x10000000);
            WifiP2pService.this.mContext.sendBroadcast(intent);
        }

        private void sendP2pConnectionChangedBroadcast() {
            Intent intent = new Intent("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
            intent.addFlags(0x30000000);
            intent.putExtra("wifiP2pInfo", new WifiP2pInfo(this.mWifiP2pInfo));
            intent.putExtra("networkInfo", new NetworkInfo(WifiP2pService.this.mNetworkInfo));
            WifiP2pService.this.mContext.sendStickyBroadcast(intent);
        }

        private void startDhcpServer(String intf) {
            InterfaceConfiguration ifcg = null;
            try {
                ifcg = WifiP2pService.this.mNwService.getInterfaceConfig(intf);
                ifcg.addr = new LinkAddress(NetworkUtils.numericToInetAddress(WifiP2pService.SERVER_ADDRESS), 24);
                ifcg.interfaceFlags = "[up]";
                WifiP2pService.this.mNwService.setInterfaceConfig(intf, ifcg);
                WifiP2pService.this.mNwService.startTethering(DHCP_RANGE);
            }
            catch (Exception e) {
                this.loge("Error configuring interface " + intf + ", :" + e);
                return;
            }
            this.logd("Started Dhcp server on " + intf);
        }

        private void stopDhcpServer() {
            try {
                WifiP2pService.this.mNwService.stopTethering();
            }
            catch (Exception e) {
                this.loge("Error stopping Dhcp server" + e);
                return;
            }
            this.logd("Stopped Dhcp server");
        }

        private void notifyP2pEnableFailure() {
            Resources r = Resources.getSystem();
            AlertDialog dialog = new AlertDialog.Builder(WifiP2pService.this.mContext).setTitle(r.getString(17040349)).setMessage(r.getString(17040351)).setPositiveButton(r.getString(17039370), null).create();
            dialog.getWindow().setType(2003);
            dialog.show();
        }

        private void notifyWpsPin(String pin, String peerAddress) {
            Resources r = Resources.getSystem();
            AlertDialog dialog = new AlertDialog.Builder(WifiP2pService.this.mContext).setTitle(r.getString(17040349)).setMessage(r.getString(17040354, pin, peerAddress)).setPositiveButton(r.getString(17039370), null).create();
            dialog.getWindow().setType(2003);
            dialog.show();
        }

        private void notifyP2pGoNegotationRequest(WifiP2pConfig config) {
            Resources r = Resources.getSystem();
            WpsInfo wps = config.wps;
            View textEntryView = LayoutInflater.from(WifiP2pService.this.mContext).inflate(17367221, null);
            final EditText pin = (EditText)textEntryView.findViewById(16909110);
            AlertDialog dialog = new AlertDialog.Builder(WifiP2pService.this.mContext).setTitle(r.getString(17040349)).setView(textEntryView).setPositiveButton(r.getString(17039370), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (pin.getVisibility() == 8) {
                        ((P2pStateMachine)P2pStateMachine.this).mSavedGoNegotiationConfig.wps.setup = 0;
                    } else {
                        ((P2pStateMachine)P2pStateMachine.this).mSavedGoNegotiationConfig.wps.setup = 2;
                        ((P2pStateMachine)P2pStateMachine.this).mSavedGoNegotiationConfig.wps.pin = pin.getText().toString();
                    }
                    P2pStateMachine.this.sendMessage(143366);
                }
            }).setNegativeButton(r.getString(0x1040000), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    P2pStateMachine.this.sendMessage(143367);
                }
            }).create();
            if (wps.setup == 0) {
                pin.setVisibility(8);
                dialog.setMessage(r.getString(17040352, config.deviceAddress));
            } else {
                dialog.setMessage(r.getString(17040353, config.deviceAddress));
            }
            dialog.getWindow().setType(2003);
            dialog.show();
        }

        private void notifyP2pProvDiscPbcRequest(WifiP2pDevice peer) {
            Resources r = Resources.getSystem();
            View textEntryView = LayoutInflater.from(WifiP2pService.this.mContext).inflate(17367221, null);
            EditText pin = (EditText)textEntryView.findViewById(16909110);
            AlertDialog dialog = new AlertDialog.Builder(WifiP2pService.this.mContext).setTitle(r.getString(17040349)).setView(textEntryView).setPositiveButton(r.getString(17039370), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    P2pStateMachine.this.sendMessage(143372);
                }
            }).setNegativeButton(r.getString(0x1040000), null).create();
            pin.setVisibility(8);
            dialog.setMessage(r.getString(17040352, peer.deviceAddress));
            dialog.getWindow().setType(2003);
            dialog.show();
        }

        private void notifyP2pProvDiscPinRequest(WifiP2pDevice peer) {
            Resources r = Resources.getSystem();
            View textEntryView = LayoutInflater.from(WifiP2pService.this.mContext).inflate(17367221, null);
            final EditText pin = (EditText)textEntryView.findViewById(16909110);
            AlertDialog dialog = new AlertDialog.Builder(WifiP2pService.this.mContext).setTitle(r.getString(17040349)).setView(textEntryView).setPositiveButton(r.getString(17039370), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    P2pStateMachine.this.sendMessage(143373, pin.getText().toString());
                }
            }).setNegativeButton(r.getString(0x1040000), null).create();
            dialog.setMessage(r.getString(17040353, peer.deviceAddress));
            dialog.getWindow().setType(2003);
            dialog.show();
        }

        private void notifyP2pInvitationReceived(WifiP2pGroup group) {
            this.mSavedP2pGroup = group;
            Resources r = Resources.getSystem();
            View textEntryView = LayoutInflater.from(WifiP2pService.this.mContext).inflate(17367221, null);
            EditText pin = (EditText)textEntryView.findViewById(16909110);
            AlertDialog dialog = new AlertDialog.Builder(WifiP2pService.this.mContext).setTitle(r.getString(17040349)).setView(textEntryView).setPositiveButton(r.getString(17039370), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    P2pStateMachine.this.sendMessage(143368);
                }
            }).setNegativeButton(r.getString(0x1040000), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    P2pStateMachine.this.sendMessage(143369);
                }
            }).create();
            pin.setVisibility(8);
            dialog.setMessage(r.getString(17040352, group.getOwner().deviceAddress));
            dialog.getWindow().setType(2003);
            dialog.show();
        }

        private void updateDeviceStatus(String deviceAddress, int status) {
            for (WifiP2pDevice d : this.mPeers.getDeviceList()) {
                if (!d.deviceAddress.equals(deviceAddress)) continue;
                d.status = status;
            }
        }

        private boolean isGroupOwner(String deviceAddress) {
            for (WifiP2pDevice d : this.mPeers.getDeviceList()) {
                if (!d.deviceAddress.equals(deviceAddress)) continue;
                return d.isGroupOwner();
            }
            return false;
        }

        private int configuredNetworkId(String deviceAddress) {
            return -1;
        }

        private void setWifiP2pInfoOnGroupFormation(String serverAddress) {
            this.mWifiP2pInfo.groupFormed = true;
            this.mWifiP2pInfo.isGroupOwner = this.mGroup.isGroupOwner();
            this.mWifiP2pInfo.groupOwnerAddress = NetworkUtils.numericToInetAddress(serverAddress);
        }

        private void setWifiP2pInfoOnGroupTermination() {
            this.mWifiP2pInfo.groupFormed = false;
            this.mWifiP2pInfo.isGroupOwner = false;
            this.mWifiP2pInfo.groupOwnerAddress = null;
        }

        private String getDeviceAddress(String interfaceAddress) {
            for (WifiP2pDevice d : this.mPeers.getDeviceList()) {
                if (!interfaceAddress.equals(WifiNative.p2pGetInterfaceAddress(d.deviceAddress))) continue;
                return d.deviceAddress;
            }
            return null;
        }

        private void initializeP2pSettings() {
            WifiNative.setPersistentReconnect(true);
            WifiNative.setDeviceName(((WifiP2pService)WifiP2pService.this).mThisDevice.deviceName);
            WifiNative.setDeviceType(((WifiP2pService)WifiP2pService.this).mThisDevice.primaryDeviceType);
            ((WifiP2pService)WifiP2pService.this).mThisDevice.deviceAddress = WifiNative.p2pGetDeviceAddress();
            this.updateThisDevice(3);
        }

        private void updateThisDevice(int status) {
            ((WifiP2pService)WifiP2pService.this).mThisDevice.status = status;
            this.sendThisDeviceChangedBroadcast();
        }

        private void replyToMessage(Message msg, int what) {
            if (msg.replyTo == null) {
                return;
            }
            Message dstMsg = this.obtainMessage(msg);
            dstMsg.what = what;
            WifiP2pService.this.mReplyChannel.replyToMessage(msg, dstMsg);
        }

        private void replyToMessage(Message msg, int what, int arg1) {
            if (msg.replyTo == null) {
                return;
            }
            Message dstMsg = this.obtainMessage(msg);
            dstMsg.what = what;
            dstMsg.arg1 = arg1;
            WifiP2pService.this.mReplyChannel.replyToMessage(msg, dstMsg);
        }

        private void replyToMessage(Message msg, int what, Object obj) {
            if (msg.replyTo == null) {
                return;
            }
            Message dstMsg = this.obtainMessage(msg);
            dstMsg.what = what;
            dstMsg.obj = obj;
            WifiP2pService.this.mReplyChannel.replyToMessage(msg, dstMsg);
        }

        private Message obtainMessage(Message srcMsg) {
            Message msg = Message.obtain();
            msg.arg2 = srcMsg.arg2;
            return msg;
        }

        private void logd(String s) {
            Slog.d(WifiP2pService.TAG, s);
        }

        private void loge(String s) {
            Slog.e(WifiP2pService.TAG, s);
        }

        private void showNotification() {
            NotificationManager notificationManager = (NotificationManager)WifiP2pService.this.mContext.getSystemService("notification");
            if (notificationManager == null || WifiP2pService.this.mNotification != null) {
                return;
            }
            Intent intent = new Intent("android.settings.WIRELESS_SETTINGS");
            intent.setFlags(0x40000000);
            PendingIntent pi = PendingIntent.getActivity(WifiP2pService.this.mContext, 0, intent, 0);
            Resources r = Resources.getSystem();
            CharSequence title = r.getText(17040355);
            CharSequence message = r.getText(17040356);
            WifiP2pService.this.mNotification = new Notification();
            ((WifiP2pService)WifiP2pService.this).mNotification.when = 0L;
            ((WifiP2pService)WifiP2pService.this).mNotification.icon = 17302838;
            ((WifiP2pService)WifiP2pService.this).mNotification.defaults &= 0xFFFFFFFE;
            ((WifiP2pService)WifiP2pService.this).mNotification.flags = 2;
            ((WifiP2pService)WifiP2pService.this).mNotification.tickerText = title;
            WifiP2pService.this.mNotification.setLatestEventInfo(WifiP2pService.this.mContext, title, message, pi);
            notificationManager.notify(((WifiP2pService)WifiP2pService.this).mNotification.icon, WifiP2pService.this.mNotification);
        }

        private void clearNotification() {
            NotificationManager notificationManager = (NotificationManager)WifiP2pService.this.mContext.getSystemService("notification");
            if (notificationManager != null && WifiP2pService.this.mNotification != null) {
                notificationManager.cancel(((WifiP2pService)WifiP2pService.this).mNotification.icon);
                WifiP2pService.this.mNotification = null;
            }
        }

        private boolean isAirplaneSensitive() {
            String airplaneModeRadios = Settings.System.getString(WifiP2pService.this.mContext.getContentResolver(), "airplane_mode_radios");
            return airplaneModeRadios == null || airplaneModeRadios.contains("wifi");
        }

        private boolean isAirplaneModeOn() {
            return this.isAirplaneSensitive() && Settings.System.getInt(WifiP2pService.this.mContext.getContentResolver(), "airplane_mode_on", 0) == 1;
        }

        class GroupCreatedState
        extends State {
            GroupCreatedState() {
            }

            public void enter() {
                WifiP2pService.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, null);
                P2pStateMachine.this.updateThisDevice(0);
                if (P2pStateMachine.this.mGroup.isGroupOwner()) {
                    P2pStateMachine.this.setWifiP2pInfoOnGroupFormation(WifiP2pService.SERVER_ADDRESS);
                    P2pStateMachine.this.sendP2pConnectionChangedBroadcast();
                }
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147498: {
                        String interfaceAddress = (String)message.obj;
                        String deviceAddress = P2pStateMachine.this.getDeviceAddress(interfaceAddress);
                        if (deviceAddress != null) {
                            P2pStateMachine.this.mGroup.addClient(deviceAddress);
                            P2pStateMachine.this.updateDeviceStatus(deviceAddress, 0);
                            P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                            break;
                        }
                        P2pStateMachine.this.loge("Connect on unknown device address : " + interfaceAddress);
                        break;
                    }
                    case 147497: {
                        String interfaceAddress = (String)message.obj;
                        String deviceAddress = P2pStateMachine.this.getDeviceAddress(interfaceAddress);
                        if (deviceAddress != null) {
                            P2pStateMachine.this.updateDeviceStatus(deviceAddress, 3);
                            if (P2pStateMachine.this.mGroup.removeClient(deviceAddress)) {
                                if (!WifiP2pService.this.mPersistGroup && P2pStateMachine.this.mGroup.isClientListEmpty()) {
                                    Slog.d(WifiP2pService.TAG, "Client list empty, remove non-persistent p2p group");
                                    WifiNative.p2pGroupRemove(P2pStateMachine.this.mGroup.getInterface());
                                }
                            } else {
                                for (WifiP2pDevice c : P2pStateMachine.this.mGroup.getClientList()) {
                                }
                            }
                            P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                            break;
                        }
                        P2pStateMachine.this.loge("Disconnect on unknown device address : " + interfaceAddress);
                        break;
                    }
                    case 196613: {
                        DhcpInfoInternal dhcpInfo = (DhcpInfoInternal)message.obj;
                        if (message.arg1 == 1 && dhcpInfo != null) {
                            P2pStateMachine.this.setWifiP2pInfoOnGroupFormation(dhcpInfo.serverAddress);
                            P2pStateMachine.this.sendP2pConnectionChangedBroadcast();
                            break;
                        }
                        WifiNative.p2pGroupRemove(P2pStateMachine.this.mGroup.getInterface());
                        break;
                    }
                    case 139283: {
                        if (WifiNative.p2pGroupRemove(P2pStateMachine.this.mGroup.getInterface())) {
                            P2pStateMachine.this.replyToMessage(message, 139285);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139284, 0);
                        break;
                    }
                    case 147486: {
                        Collection<WifiP2pDevice> devices = P2pStateMachine.this.mGroup.getClientList();
                        boolean changed = false;
                        for (WifiP2pDevice d : P2pStateMachine.this.mPeers.getDeviceList()) {
                            if (!devices.contains(d) && !P2pStateMachine.this.mGroup.getOwner().equals(d)) continue;
                            d.status = 3;
                            changed = true;
                        }
                        if (P2pStateMachine.this.mGroup.isGroupOwner()) {
                            P2pStateMachine.this.stopDhcpServer();
                        } else {
                            WifiP2pService.this.mDhcpStateMachine.sendMessage(196610);
                            WifiP2pService.this.mDhcpStateMachine.quit();
                            WifiP2pService.this.mDhcpStateMachine = null;
                        }
                        P2pStateMachine.this.mGroup = null;
                        if (changed) {
                            P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                        }
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    case 147478: {
                        WifiP2pDevice device = (WifiP2pDevice)message.obj;
                        if (device.equals(P2pStateMachine.this.mGroup.getOwner())) {
                            P2pStateMachine.this.logd("Lost the group owner, killing p2p connection");
                            WifiNative.p2pGroupRemove(P2pStateMachine.this.mGroup.getInterface());
                        } else if (P2pStateMachine.this.mGroup.removeClient(device) && !WifiP2pService.this.mPersistGroup && P2pStateMachine.this.mGroup.isClientListEmpty()) {
                            Slog.d(WifiP2pService.TAG, "Client list empty, removing a non-persistent p2p group");
                            WifiNative.p2pGroupRemove(P2pStateMachine.this.mGroup.getInterface());
                        }
                        return false;
                    }
                    case 139268: {
                        P2pStateMachine.this.sendMessage(139283);
                        P2pStateMachine.this.deferMessage(message);
                        break;
                    }
                    case 139274: {
                        WifiP2pConfig config = (WifiP2pConfig)message.obj;
                        P2pStateMachine.this.logd("Inviting device : " + config.deviceAddress);
                        if (WifiNative.p2pInvite(P2pStateMachine.this.mGroup, config.deviceAddress)) {
                            P2pStateMachine.this.updateDeviceStatus(config.deviceAddress, 1);
                            P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                            P2pStateMachine.this.replyToMessage(message, 139276);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139275, 0);
                        break;
                    }
                    case 147488: {
                        P2pStateMachine.this.logd("===> INVITATION RESULT EVENT : " + message.obj);
                        break;
                    }
                    case 147489: {
                        P2pStateMachine.this.notifyP2pProvDiscPbcRequest((WifiP2pDevice)message.obj);
                        break;
                    }
                    case 147490: {
                        P2pStateMachine.this.notifyP2pProvDiscPinRequest((WifiP2pDevice)message.obj);
                        break;
                    }
                    case 147485: {
                        Slog.e(WifiP2pService.TAG, "Duplicate group creation event notice, ignore");
                        break;
                    }
                    case 143372: {
                        WifiNative.wpsPbc();
                        break;
                    }
                    case 143373: {
                        WifiNative.wpsPin((String)message.obj);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }

            public void exit() {
                P2pStateMachine.this.updateThisDevice(3);
                P2pStateMachine.this.setWifiP2pInfoOnGroupTermination();
                WifiP2pService.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
                P2pStateMachine.this.sendP2pConnectionChangedBroadcast();
            }
        }

        class GroupNegotiationState
        extends State {
            GroupNegotiationState() {
            }

            public void enter() {
                P2pStateMachine.this.sendMessageDelayed(P2pStateMachine.this.obtainMessage(143363, ++mGroupNegotiationTimeoutIndex, 0), 120000L);
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147481: 
                    case 147483: {
                        break;
                    }
                    case 147482: 
                    case 147484: {
                        P2pStateMachine.this.updateDeviceStatus(((P2pStateMachine)P2pStateMachine.this).mSavedConnectConfig.deviceAddress, 2);
                        P2pStateMachine.this.mSavedConnectConfig = null;
                        P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    case 143363: {
                        if (mGroupNegotiationTimeoutIndex != message.arg1) break;
                        P2pStateMachine.this.updateDeviceStatus(((P2pStateMachine)P2pStateMachine.this).mSavedConnectConfig.deviceAddress, 2);
                        P2pStateMachine.this.mSavedConnectConfig = null;
                        P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    case 139271: {
                        P2pStateMachine.this.replyToMessage(message, 139272, 2);
                        break;
                    }
                    case 139277: {
                        if (WifiNative.p2pCancelConnect()) {
                            P2pStateMachine.this.replyToMessage(message, 139279);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139278, 0);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class UserAuthorizingGroupInvitationState
        extends State {
            UserAuthorizingGroupInvitationState() {
            }

            public void enter() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147479: 
                    case 147487: {
                        break;
                    }
                    case 143368: {
                        WifiP2pConfig config = new WifiP2pConfig();
                        config.deviceAddress = ((P2pStateMachine)P2pStateMachine.this).mSavedP2pGroup.getOwner().deviceAddress;
                        P2pStateMachine.this.sendMessage(139274, config);
                        P2pStateMachine.this.mSavedP2pGroup = null;
                        break;
                    }
                    case 143369: {
                        P2pStateMachine.this.mSavedP2pGroup = null;
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class UserAuthorizingGroupNegotiationState
        extends State {
            UserAuthorizingGroupNegotiationState() {
            }

            public void enter() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147479: 
                    case 147487: {
                        break;
                    }
                    case 143366: {
                        P2pStateMachine.this.sendMessage(139274, P2pStateMachine.this.mSavedGoNegotiationConfig);
                        P2pStateMachine.this.mSavedGoNegotiationConfig = null;
                        break;
                    }
                    case 143367: {
                        P2pStateMachine.this.mSavedGoNegotiationConfig = null;
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class InactiveState
        extends State {
            InactiveState() {
            }

            public void enter() {
                WifiNative.p2pListen();
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147479: {
                        P2pStateMachine.this.mSavedGoNegotiationConfig = (WifiP2pConfig)message.obj;
                        P2pStateMachine.this.notifyP2pGoNegotationRequest(P2pStateMachine.this.mSavedGoNegotiationConfig);
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mUserAuthorizingGroupNegotiationState);
                        break;
                    }
                    case 139280: {
                        WifiP2pService.this.mPersistGroup = true;
                        if (WifiNative.p2pGroupAdd()) {
                            P2pStateMachine.this.replyToMessage(message, 139282);
                        } else {
                            P2pStateMachine.this.replyToMessage(message, 139281, 0);
                        }
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupNegotiationState);
                        break;
                    }
                    case 147487: {
                        WifiP2pGroup group = (WifiP2pGroup)message.obj;
                        P2pStateMachine.this.notifyP2pInvitationReceived(group);
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mUserAuthorizingGroupInvitationState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class P2pEnabledState
        extends State {
            P2pEnabledState() {
            }

            public void enter() {
                P2pStateMachine.this.sendP2pStateChangedBroadcast(true);
                WifiP2pService.this.mNetworkInfo.setIsAvailable(true);
                P2pStateMachine.this.initializeP2pSettings();
                P2pStateMachine.this.showNotification();
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 139265: {
                        P2pStateMachine.this.replyToMessage(message, 139267);
                        break;
                    }
                    case 139268: {
                        if (P2pStateMachine.this.mPeers.clear()) {
                            P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                        }
                        P2pStateMachine.this.replyToMessage(message, 139270);
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pDisablingState);
                        break;
                    }
                    case 139271: {
                        int timeout = message.arg1;
                        if (WifiNative.p2pFind(timeout)) {
                            P2pStateMachine.this.replyToMessage(message, 139273);
                            break;
                        }
                        P2pStateMachine.this.replyToMessage(message, 139272, 0);
                        break;
                    }
                    case 147477: {
                        WifiP2pDevice device = (WifiP2pDevice)message.obj;
                        if (((WifiP2pService)WifiP2pService.this).mThisDevice.deviceAddress.equals(device.deviceAddress)) break;
                        P2pStateMachine.this.mPeers.update(device);
                        P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                        break;
                    }
                    case 147478: {
                        WifiP2pDevice device = (WifiP2pDevice)message.obj;
                        if (!P2pStateMachine.this.mPeers.remove(device)) break;
                        P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                        break;
                    }
                    case 139274: {
                        P2pStateMachine.this.mSavedConnectConfig = (WifiP2pConfig)message.obj;
                        WifiP2pService.this.mPersistGroup = false;
                        int netId = P2pStateMachine.this.configuredNetworkId(((P2pStateMachine)P2pStateMachine.this).mSavedConnectConfig.deviceAddress);
                        if (netId >= 0) {
                            WifiNative.p2pReinvoke(netId, ((P2pStateMachine)P2pStateMachine.this).mSavedConnectConfig.deviceAddress);
                        } else {
                            boolean join = false;
                            if (P2pStateMachine.this.isGroupOwner(((P2pStateMachine)P2pStateMachine.this).mSavedConnectConfig.deviceAddress)) {
                                join = true;
                            }
                            String pin = WifiNative.p2pConnect(P2pStateMachine.this.mSavedConnectConfig, join);
                            try {
                                Integer.parseInt(pin);
                                P2pStateMachine.this.notifyWpsPin(pin, ((P2pStateMachine)P2pStateMachine.this).mSavedConnectConfig.deviceAddress);
                            }
                            catch (NumberFormatException ignore) {
                                // empty catch block
                            }
                        }
                        P2pStateMachine.this.updateDeviceStatus(((P2pStateMachine)P2pStateMachine.this).mSavedConnectConfig.deviceAddress, 1);
                        P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                        P2pStateMachine.this.replyToMessage(message, 139276);
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupNegotiationState);
                        break;
                    }
                    case 147458: {
                        P2pStateMachine.this.loge("Connection lost, restart p2p");
                        WifiNative.killSupplicant();
                        WifiNative.closeSupplicantConnection();
                        if (P2pStateMachine.this.mPeers.clear()) {
                            P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                        }
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pDisabledState);
                        P2pStateMachine.this.sendMessageDelayed(139265, 5000L);
                        break;
                    }
                    case 147485: {
                        P2pStateMachine.this.mGroup = (WifiP2pGroup)message.obj;
                        if (P2pStateMachine.this.mGroup.isGroupOwner()) {
                            P2pStateMachine.this.startDhcpServer(P2pStateMachine.this.mGroup.getInterface());
                        } else {
                            WifiP2pService.this.mDhcpStateMachine = DhcpStateMachine.makeDhcpStateMachine(WifiP2pService.this.mContext, P2pStateMachine.this, P2pStateMachine.this.mGroup.getInterface());
                            WifiP2pService.this.mDhcpStateMachine.sendMessage(196609);
                            WifiP2pDevice groupOwner = P2pStateMachine.this.mGroup.getOwner();
                            P2pStateMachine.this.updateDeviceStatus(groupOwner.deviceAddress, 0);
                            P2pStateMachine.this.sendP2pPeersChangedBroadcast();
                        }
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mGroupCreatedState);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }

            public void exit() {
                P2pStateMachine.this.sendP2pStateChangedBroadcast(false);
                WifiP2pService.this.mNetworkInfo.setIsAvailable(false);
                P2pStateMachine.this.clearNotification();
            }
        }

        class P2pEnablingState
        extends State {
            P2pEnablingState() {
            }

            public void enter() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147457: {
                        P2pStateMachine.this.logd("P2p start successful");
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mInactiveState);
                        break;
                    }
                    case 147458: {
                        if (++WifiP2pService.this.mP2pRestartCount <= 5) {
                            P2pStateMachine.this.loge("Failed to start p2p, retry");
                            WifiNative.killSupplicant();
                            P2pStateMachine.this.sendMessageDelayed(139265, 5000L);
                        } else {
                            P2pStateMachine.this.loge("Failed " + WifiP2pService.this.mP2pRestartCount + " times to start p2p, quit ");
                            WifiP2pService.this.mP2pRestartCount = 0;
                        }
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pDisabledState);
                        break;
                    }
                    case 139265: 
                    case 139268: {
                        P2pStateMachine.this.deferMessage(message);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class WaitForWifiDisableState
        extends State {
            WaitForWifiDisableState() {
            }

            public void enter() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 131204: {
                        try {
                            WifiP2pService.this.mNwService.wifiFirmwareReload(WifiP2pService.this.mInterface, "P2P");
                        }
                        catch (Exception e) {
                            P2pStateMachine.this.loge("Failed to reload p2p firmware " + e);
                        }
                        try {
                            WifiP2pService.this.mNwService.setInterfaceDown(WifiP2pService.this.mInterface);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (WifiNative.startP2pSupplicant()) {
                            P2pStateMachine.this.mWifiMonitor.startMonitoring();
                            P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pEnablingState);
                            break;
                        }
                        P2pStateMachine.this.notifyP2pEnableFailure();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pDisabledState);
                        break;
                    }
                    case 139265: 
                    case 139268: {
                        P2pStateMachine.this.deferMessage(message);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class WaitForUserActionState
        extends State {
            WaitForUserActionState() {
            }

            public void enter() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 143364: {
                        WifiP2pService.this.mWifiChannel.sendMessage(143361);
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mWaitForWifiDisableState);
                        break;
                    }
                    case 143365: {
                        P2pStateMachine.this.logd("User rejected enabling p2p");
                        P2pStateMachine.this.sendP2pStateChangedBroadcast(false);
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pDisabledState);
                        break;
                    }
                    case 139265: 
                    case 139268: {
                        P2pStateMachine.this.deferMessage(message);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class P2pDisabledState
        extends State {
            P2pDisabledState() {
            }

            public void enter() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 139265: {
                        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                if (which == -1) {
                                    P2pStateMachine.this.sendMessage(143364);
                                } else {
                                    P2pStateMachine.this.sendMessage(143365);
                                }
                            }
                        };
                        if (WifiP2pService.this.mWifiState != 1 || WifiP2pService.this.mWifiApState != 11) {
                            Resources r = Resources.getSystem();
                            AlertDialog dialog = new AlertDialog.Builder(WifiP2pService.this.mContext).setTitle(r.getString(17040349)).setMessage(r.getString(17040350)).setPositiveButton(r.getString(17039370), listener).setNegativeButton(r.getString(0x1040000), listener).create();
                            dialog.getWindow().setType(2003);
                            dialog.show();
                            P2pStateMachine.this.transitionTo(P2pStateMachine.this.mWaitForUserActionState);
                        } else {
                            WifiP2pService.this.mWifiChannel.sendMessage(143361);
                            P2pStateMachine.this.transitionTo(P2pStateMachine.this.mWaitForWifiDisableState);
                        }
                        P2pStateMachine.this.replyToMessage(message, 139267);
                        break;
                    }
                    case 139268: {
                        P2pStateMachine.this.replyToMessage(message, 139270);
                        break;
                    }
                    case 131203: {
                        P2pStateMachine.this.replyToMessage(message, 143362);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class P2pDisablingState
        extends State {
            P2pDisablingState() {
            }

            public void enter() {
                P2pStateMachine.this.logd("stopping supplicant");
                if (!WifiNative.stopSupplicant()) {
                    P2pStateMachine.this.loge("Failed to stop supplicant, issue kill");
                    WifiNative.killSupplicant();
                }
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 147458: {
                        P2pStateMachine.this.logd("Supplicant connection lost");
                        WifiNative.closeSupplicantConnection();
                        P2pStateMachine.this.transitionTo(P2pStateMachine.this.mP2pDisabledState);
                        break;
                    }
                    case 139265: 
                    case 139268: {
                        P2pStateMachine.this.deferMessage(message);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class P2pNotSupportedState
        extends State {
            P2pNotSupportedState() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 131203: {
                        P2pStateMachine.this.replyToMessage(message, 143362);
                        break;
                    }
                    case 139265: {
                        P2pStateMachine.this.replyToMessage(message, 139266, 1);
                        break;
                    }
                    case 139268: {
                        P2pStateMachine.this.replyToMessage(message, 139269, 1);
                        break;
                    }
                    case 139271: {
                        P2pStateMachine.this.replyToMessage(message, 139272, 1);
                        break;
                    }
                    case 139274: {
                        P2pStateMachine.this.replyToMessage(message, 139275, 1);
                        break;
                    }
                    case 139277: {
                        P2pStateMachine.this.replyToMessage(message, 139278, 1);
                        break;
                    }
                    case 139280: {
                        P2pStateMachine.this.replyToMessage(message, 139281, 1);
                        break;
                    }
                    case 139283: {
                        P2pStateMachine.this.replyToMessage(message, 139284, 1);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        }

        class DefaultState
        extends State {
            DefaultState() {
            }

            public boolean processMessage(Message message) {
                switch (message.what) {
                    case 69632: {
                        if (message.arg1 == 0) {
                            WifiP2pService.this.mWifiChannel = (AsyncChannel)message.obj;
                            break;
                        }
                        P2pStateMachine.this.loge("Full connection failure, error = " + message.arg1);
                        WifiP2pService.this.mWifiChannel = null;
                        break;
                    }
                    case 69636: {
                        if (message.arg1 == 2) {
                            P2pStateMachine.this.loge("Send failed, client connection lost");
                        } else {
                            P2pStateMachine.this.loge("Client connection lost with reason: " + message.arg1);
                        }
                        WifiP2pService.this.mWifiChannel = null;
                        break;
                    }
                    case 69633: {
                        AsyncChannel ac = new AsyncChannel();
                        ac.connect(WifiP2pService.this.mContext, P2pStateMachine.this.getHandler(), message.replyTo);
                        break;
                    }
                    case 131203: {
                        P2pStateMachine.this.sendMessage(139268);
                        P2pStateMachine.this.deferMessage(message);
                        break;
                    }
                    case 139265: {
                        P2pStateMachine.this.replyToMessage(message, 139266, 2);
                        break;
                    }
                    case 139268: {
                        P2pStateMachine.this.replyToMessage(message, 139269, 2);
                        break;
                    }
                    case 139271: {
                        P2pStateMachine.this.replyToMessage(message, 139272, 2);
                        break;
                    }
                    case 139274: {
                        P2pStateMachine.this.replyToMessage(message, 139275, 2);
                        break;
                    }
                    case 139277: {
                        P2pStateMachine.this.replyToMessage(message, 139278, 2);
                        break;
                    }
                    case 139280: {
                        P2pStateMachine.this.replyToMessage(message, 139281, 2);
                        break;
                    }
                    case 139283: {
                        P2pStateMachine.this.replyToMessage(message, 139284, 2);
                        break;
                    }
                    case 139286: {
                        P2pStateMachine.this.replyToMessage(message, 139287, P2pStateMachine.this.mPeers);
                        break;
                    }
                    case 139288: {
                        P2pStateMachine.this.replyToMessage(message, 139289, P2pStateMachine.this.mWifiP2pInfo);
                        break;
                    }
                    case 139290: {
                        P2pStateMachine.this.replyToMessage(message, 139291, P2pStateMachine.this.mGroup);
                        break;
                    }
                    case 143370: {
                        if (!P2pStateMachine.this.isAirplaneModeOn()) break;
                        P2pStateMachine.this.sendMessage(139268);
                        break;
                    }
                    case 143371: {
                        P2pStateMachine.this.sendMessage(139268);
                        break;
                    }
                    case 143363: 
                    case 143364: 
                    case 143365: 
                    case 143366: 
                    case 143367: 
                    case 143368: 
                    case 143369: {
                        break;
                    }
                    default: {
                        P2pStateMachine.this.loge("Unhandled message " + message);
                        return false;
                    }
                }
                return true;
            }
        }
    }

    private class WifiStateReceiver
    extends BroadcastReceiver {
        private WifiStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                WifiP2pService.this.mWifiState = intent.getIntExtra("wifi_state", 1);
            } else if (action.equals("android.net.wifi.WIFI_AP_STATE_CHANGED")) {
                WifiP2pService.this.mWifiApState = intent.getIntExtra("wifi_state", 11);
            } else if (action.equals("android.intent.action.AIRPLANE_MODE")) {
                WifiP2pService.this.mP2pStateMachine.sendMessage(143370);
            } else if (action.equals("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED") && intent.getBooleanExtra("phoneinECMState", false)) {
                WifiP2pService.this.mP2pStateMachine.sendMessage(143371);
            }
        }
    }
}

