/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.os.Parcel;
import android.os.Parcelable;

public class LlcpPacket
implements Parcelable {
    private final int mRemoteSap;
    private final byte[] mDataBuffer;
    public static final Parcelable.Creator<LlcpPacket> CREATOR = new Parcelable.Creator<LlcpPacket>(){

        @Override
        public LlcpPacket createFromParcel(Parcel in) {
            short sap = (short)in.readInt();
            int dataLength = in.readInt();
            byte[] data = new byte[dataLength];
            in.readByteArray(data);
            return new LlcpPacket(sap, data);
        }

        public LlcpPacket[] newArray(int size) {
            return new LlcpPacket[size];
        }
    };

    public LlcpPacket(int sap, byte[] data) {
        this.mRemoteSap = sap;
        this.mDataBuffer = data;
    }

    public int getRemoteSap() {
        return this.mRemoteSap;
    }

    public byte[] getDataBuffer() {
        return this.mDataBuffer;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRemoteSap);
        dest.writeInt(this.mDataBuffer.length);
        dest.writeByteArray(this.mDataBuffer);
    }
}

