/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.net.Uri;
import android.nfc.FormatException;
import android.os.Parcel;
import android.os.Parcelable;
import java.nio.charset.Charsets;
import java.util.Arrays;

public final class NdefRecord
implements Parcelable {
    public static final short TNF_EMPTY = 0;
    public static final short TNF_WELL_KNOWN = 1;
    public static final short TNF_MIME_MEDIA = 2;
    public static final short TNF_ABSOLUTE_URI = 3;
    public static final short TNF_EXTERNAL_TYPE = 4;
    public static final short TNF_UNKNOWN = 5;
    public static final short TNF_UNCHANGED = 6;
    public static final short TNF_RESERVED = 7;
    public static final byte[] RTD_TEXT = new byte[]{84};
    public static final byte[] RTD_URI = new byte[]{85};
    public static final byte[] RTD_SMART_POSTER = new byte[]{83, 112};
    public static final byte[] RTD_ALTERNATIVE_CARRIER = new byte[]{97, 99};
    public static final byte[] RTD_HANDOVER_CARRIER = new byte[]{72, 99};
    public static final byte[] RTD_HANDOVER_REQUEST = new byte[]{72, 114};
    public static final byte[] RTD_HANDOVER_SELECT = new byte[]{72, 115};
    public static final byte[] RTD_ANDROID_APP = "android.com:pkg".getBytes();
    private static final byte FLAG_MB = -128;
    private static final byte FLAG_ME = 64;
    private static final byte FLAG_CF = 32;
    private static final byte FLAG_SR = 16;
    private static final byte FLAG_IL = 8;
    private static final String[] URI_PREFIX_MAP = new String[]{"", "http://www.", "https://www.", "http://", "https://", "tel:", "mailto:", "ftp://anonymous:anonymous@", "ftp://ftp.", "ftps://", "sftp://", "smb://", "nfs://", "ftp://", "dav://", "news:", "telnet://", "imap:", "rtsp://", "urn:", "pop:", "sip:", "sips:", "tftp:", "btspp://", "btl2cap://", "btgoep://", "tcpobex://", "irdaobex://", "file://", "urn:epc:id:", "urn:epc:tag:", "urn:epc:pat:", "urn:epc:raw:", "urn:epc:"};
    private final byte mFlags;
    private final short mTnf;
    private final byte[] mType;
    private final byte[] mId;
    private final byte[] mPayload;
    public static final Parcelable.Creator<NdefRecord> CREATOR = new Parcelable.Creator<NdefRecord>(){

        @Override
        public NdefRecord createFromParcel(Parcel in) {
            byte flags = (byte)in.readInt();
            short tnf = (short)in.readInt();
            int typeLength = in.readInt();
            byte[] type = new byte[typeLength];
            in.readByteArray(type);
            int idLength = in.readInt();
            byte[] id2 = new byte[idLength];
            in.readByteArray(id2);
            int payloadLength = in.readInt();
            byte[] payload = new byte[payloadLength];
            in.readByteArray(payload);
            return new NdefRecord(tnf, type, id2, payload, flags);
        }

        public NdefRecord[] newArray(int size) {
            return new NdefRecord[size];
        }
    };

    public NdefRecord(short tnf, byte[] type, byte[] id2, byte[] payload) {
        this(tnf, type, id2, payload, -64);
    }

    NdefRecord(short tnf, byte[] type, byte[] id2, byte[] payload, byte flags) {
        if (type == null || id2 == null || payload == null) {
            throw new IllegalArgumentException("Illegal null argument");
        }
        if (tnf < 0 || tnf > 7) {
            throw new IllegalArgumentException("TNF out of range " + tnf);
        }
        if (payload.length < 255) {
            flags = (byte)(flags | 0x10);
        }
        if (id2.length != 0) {
            flags = (byte)(flags | 8);
        }
        this.mFlags = flags;
        this.mTnf = tnf;
        this.mType = (byte[])type.clone();
        this.mId = (byte[])id2.clone();
        this.mPayload = (byte[])payload.clone();
    }

    public NdefRecord(byte[] data) throws FormatException {
        this.mFlags = 0;
        this.mTnf = 0;
        this.mType = null;
        this.mId = null;
        this.mPayload = null;
        if (this.parseNdefRecord(data) == -1) {
            throw new FormatException("Error while parsing NDEF record");
        }
    }

    public short getTnf() {
        return this.mTnf;
    }

    public byte[] getType() {
        return (byte[])this.mType.clone();
    }

    public byte[] getId() {
        return (byte[])this.mId.clone();
    }

    public byte[] getPayload() {
        return (byte[])this.mPayload.clone();
    }

    public static Uri parseWellKnownUriRecord(NdefRecord record) throws FormatException {
        byte[] payload = record.getPayload();
        if (payload.length < 2) {
            throw new FormatException("Payload is not a valid URI (missing prefix)");
        }
        int prefixIndex = payload[0] & 0xFF;
        if (prefixIndex < 0 || prefixIndex >= URI_PREFIX_MAP.length) {
            throw new FormatException("Payload is not a valid URI (invalid prefix)");
        }
        String prefix = URI_PREFIX_MAP[prefixIndex];
        byte[] fullUri = NdefRecord.concat(prefix.getBytes(Charsets.UTF_8), Arrays.copyOfRange(payload, 1, payload.length));
        return Uri.parse(new String(fullUri, Charsets.UTF_8));
    }

    public static NdefRecord createApplicationRecord(String packageName) {
        return new NdefRecord(4, RTD_ANDROID_APP, new byte[0], packageName.getBytes(Charsets.US_ASCII));
    }

    public static NdefRecord createUri(Uri uri) {
        return NdefRecord.createUri(uri.toString());
    }

    public static NdefRecord createUri(String uriString) {
        byte prefix = 0;
        for (int i = 1; i < URI_PREFIX_MAP.length; ++i) {
            if (!uriString.startsWith(URI_PREFIX_MAP[i])) continue;
            prefix = (byte)i;
            uriString = uriString.substring(URI_PREFIX_MAP[i].length());
            break;
        }
        byte[] uriBytes = uriString.getBytes(Charsets.UTF_8);
        byte[] recordBytes = new byte[uriBytes.length + 1];
        recordBytes[0] = prefix;
        System.arraycopy(uriBytes, 0, recordBytes, 1, uriBytes.length);
        return new NdefRecord(1, RTD_URI, new byte[0], recordBytes);
    }

    private static byte[] concat(byte[] ... arrays) {
        int length = 0;
        for (byte[] array2 : arrays) {
            length += array2.length;
        }
        byte[] result = new byte[length];
        int pos = 0;
        for (byte[] array3 : arrays) {
            System.arraycopy(array3, 0, result, pos, array3.length);
            pos += array3.length;
        }
        return result;
    }

    public byte[] toByteArray() {
        return this.generate(this.mFlags, this.mTnf, this.mType, this.mId, this.mPayload);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mFlags);
        dest.writeInt(this.mTnf);
        dest.writeInt(this.mType.length);
        dest.writeByteArray(this.mType);
        dest.writeInt(this.mId.length);
        dest.writeByteArray(this.mId);
        dest.writeInt(this.mPayload.length);
        dest.writeByteArray(this.mPayload);
    }

    private native int parseNdefRecord(byte[] var1);

    private native byte[] generate(short var1, short var2, byte[] var3, byte[] var4, byte[] var5);
}

