/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.nfc.INdefPushCallback;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.nfc.NfcFragment;
import android.os.RemoteException;
import android.util.Log;
import java.util.WeakHashMap;

public final class NfcActivityManager
extends INdefPushCallback.Stub {
    static final String TAG = "NFC";
    static final Boolean DBG = false;
    final NfcAdapter mAdapter;
    final WeakHashMap<Activity, NfcActivityState> mNfcState;
    final NfcEvent mDefaultEvent;

    public NfcActivityManager(NfcAdapter adapter) {
        this.mAdapter = adapter;
        this.mNfcState = new WeakHashMap();
        this.mDefaultEvent = new NfcEvent(this.mAdapter);
    }

    public synchronized void onResume(Activity activity) {
        NfcActivityState state = this.mNfcState.get(activity);
        if (DBG.booleanValue()) {
            Log.d(TAG, "onResume() for " + activity + " " + state);
        }
        if (state != null) {
            state.resumed = true;
            this.updateNfcService(state);
        }
    }

    public synchronized void onPause(Activity activity) {
        NfcActivityState state = this.mNfcState.get(activity);
        if (DBG.booleanValue()) {
            Log.d(TAG, "onPause() for " + activity + " " + state);
        }
        if (state != null) {
            state.resumed = false;
            this.updateNfcService(state);
        }
    }

    public void onDestroy(Activity activity) {
        this.mNfcState.remove(activity);
    }

    public synchronized void setNdefPushMessage(Activity activity, NdefMessage message) {
        NfcActivityState state = this.getOrCreateState(activity, message != null);
        if (state == null || state.ndefMessage == message) {
            return;
        }
        state.ndefMessage = message;
        if (message == null) {
            this.maybeRemoveState(activity, state);
        }
        if (state.resumed) {
            this.updateNfcService(state);
        }
    }

    public synchronized void setNdefPushMessageCallback(Activity activity, NfcAdapter.CreateNdefMessageCallback callback) {
        NfcActivityState state = this.getOrCreateState(activity, callback != null);
        if (state == null || state.ndefMessageCallback == callback) {
            return;
        }
        state.ndefMessageCallback = callback;
        if (callback == null) {
            this.maybeRemoveState(activity, state);
        }
        if (state.resumed) {
            this.updateNfcService(state);
        }
    }

    public synchronized void setOnNdefPushCompleteCallback(Activity activity, NfcAdapter.OnNdefPushCompleteCallback callback) {
        NfcActivityState state = this.getOrCreateState(activity, callback != null);
        if (state == null || state.onNdefPushCompleteCallback == callback) {
            return;
        }
        state.onNdefPushCompleteCallback = callback;
        if (callback == null) {
            this.maybeRemoveState(activity, state);
        }
        if (state.resumed) {
            this.updateNfcService(state);
        }
    }

    synchronized NfcActivityState getOrCreateState(Activity activity, boolean create) {
        NfcActivityState state;
        if (DBG.booleanValue()) {
            Log.d(TAG, "getOrCreateState " + activity + " " + create);
        }
        if ((state = this.mNfcState.get(activity)) == null && create) {
            state = new NfcActivityState();
            this.mNfcState.put(activity, state);
            NfcFragment.attach(activity);
        }
        return state;
    }

    synchronized void maybeRemoveState(Activity activity, NfcActivityState state) {
        if (state.ndefMessage == null && state.ndefMessageCallback == null && state.onNdefPushCompleteCallback == null) {
            NfcFragment.remove(activity);
            this.mNfcState.remove(activity);
        }
    }

    synchronized void updateNfcService(NfcActivityState state) {
        boolean serviceCallbackNeeded = state.ndefMessageCallback != null || state.onNdefPushCompleteCallback != null;
        try {
            NfcAdapter.sService.setForegroundNdefPush(state.resumed ? state.ndefMessage : null, state.resumed && serviceCallbackNeeded ? this : null);
        }
        catch (RemoteException e) {
            this.mAdapter.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdefMessage createMessage() {
        NfcAdapter.CreateNdefMessageCallback callback = null;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            for (NfcActivityState state : this.mNfcState.values()) {
                if (!state.resumed) continue;
                callback = state.ndefMessageCallback;
            }
        }
        if (callback != null) {
            return callback.createNdefMessage(this.mDefaultEvent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNdefPushComplete() {
        NfcAdapter.OnNdefPushCompleteCallback callback = null;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            for (NfcActivityState state : this.mNfcState.values()) {
                if (!state.resumed) continue;
                callback = state.onNdefPushCompleteCallback;
            }
        }
        if (callback != null) {
            callback.onNdefPushComplete(this.mDefaultEvent);
        }
    }

    class NfcActivityState {
        boolean resumed = false;
        NdefMessage ndefMessage;
        NfcAdapter.CreateNdefMessageCallback ndefMessageCallback;
        NfcAdapter.OnNdefPushCompleteCallback onNdefPushCompleteCallback;

        NfcActivityState() {
        }

        public String toString() {
            StringBuilder s = new StringBuilder("[").append(this.resumed).append(" ");
            s.append(this.ndefMessage).append(" ").append(this.ndefMessageCallback).append(" ");
            s.append(this.onNdefPushCompleteCallback).append("]");
            return s.toString();
        }
    }
}

