/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.OnActivityPausedListener;
import android.app.PendingIntent;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.nfc.INfcAdapter;
import android.nfc.INfcAdapterExtras;
import android.nfc.INfcTag;
import android.nfc.NdefMessage;
import android.nfc.NfcActivityManager;
import android.nfc.NfcEvent;
import android.nfc.NfcManager;
import android.nfc.TechListParcel;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.util.HashMap;

public final class NfcAdapter {
    static final String TAG = "NFC";
    public static final String ACTION_NDEF_DISCOVERED = "android.nfc.action.NDEF_DISCOVERED";
    public static final String ACTION_TECH_DISCOVERED = "android.nfc.action.TECH_DISCOVERED";
    public static final String ACTION_TAG_DISCOVERED = "android.nfc.action.TAG_DISCOVERED";
    public static final String ACTION_TAG_LEFT_FIELD = "android.nfc.action.TAG_LOST";
    public static final String EXTRA_TAG = "android.nfc.extra.TAG";
    public static final String EXTRA_NDEF_MESSAGES = "android.nfc.extra.NDEF_MESSAGES";
    public static final String EXTRA_ID = "android.nfc.extra.ID";
    public static final String ACTION_ADAPTER_STATE_CHANGED = "android.nfc.action.ADAPTER_STATE_CHANGED";
    public static final String EXTRA_ADAPTER_STATE = "android.nfc.extra.ADAPTER_STATE";
    public static final int STATE_OFF = 1;
    public static final int STATE_TURNING_ON = 2;
    public static final int STATE_ON = 3;
    public static final int STATE_TURNING_OFF = 4;
    static boolean sIsInitialized = false;
    static INfcAdapter sService;
    static INfcTag sTagService;
    static HashMap<Context, NfcAdapter> sNfcAdapters;
    static NfcAdapter sNullContextNfcAdapter;
    final NfcActivityManager mNfcActivityManager;
    final Context mContext;
    OnActivityPausedListener mForegroundDispatchListener = new OnActivityPausedListener(){

        public void onPaused(Activity activity) {
            NfcAdapter.this.disableForegroundDispatchInternal(activity, true);
        }
    };

    private static boolean hasNfcFeature() {
        IPackageManager pm = ActivityThread.getPackageManager();
        if (pm == null) {
            Log.e(TAG, "Cannot get package manager, assuming no NFC feature");
            return false;
        }
        try {
            return pm.hasSystemFeature("android.hardware.nfc");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Package manager query failed, assuming no NFC feature", e);
            return false;
        }
    }

    public static synchronized NfcAdapter getNfcAdapter(Context context) {
        if (!sIsInitialized) {
            if (!NfcAdapter.hasNfcFeature()) {
                Log.v(TAG, "this device does not have NFC support");
                throw new UnsupportedOperationException();
            }
            sService = NfcAdapter.getServiceInterface();
            if (sService == null) {
                Log.e(TAG, "could not retrieve NFC service");
                throw new UnsupportedOperationException();
            }
            try {
                sTagService = sService.getNfcTagInterface();
            }
            catch (RemoteException e) {
                Log.e(TAG, "could not retrieve NFC Tag service");
                throw new UnsupportedOperationException();
            }
            sIsInitialized = true;
        }
        if (context == null) {
            if (sNullContextNfcAdapter == null) {
                sNullContextNfcAdapter = new NfcAdapter(null);
            }
            return sNullContextNfcAdapter;
        }
        NfcAdapter adapter = sNfcAdapters.get(context);
        if (adapter == null) {
            adapter = new NfcAdapter(context);
            sNfcAdapters.put(context, adapter);
        }
        return adapter;
    }

    private static INfcAdapter getServiceInterface() {
        IBinder b = ServiceManager.getService("nfc");
        if (b == null) {
            return null;
        }
        return INfcAdapter.Stub.asInterface(b);
    }

    public static NfcAdapter getDefaultAdapter(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        NfcManager manager = (NfcManager)(context = context.getApplicationContext()).getSystemService("nfc");
        if (manager == null) {
            return null;
        }
        return manager.getDefaultAdapter();
    }

    @Deprecated
    public static NfcAdapter getDefaultAdapter() {
        Log.w(TAG, "WARNING: NfcAdapter.getDefaultAdapter() is deprecated, use NfcAdapter.getDefaultAdapter(Context) instead", new Exception());
        return NfcAdapter.getNfcAdapter(null);
    }

    NfcAdapter(Context context) {
        this.mContext = context;
        this.mNfcActivityManager = new NfcActivityManager(this);
    }

    public Context getContext() {
        return this.mContext;
    }

    public INfcAdapter getService() {
        this.isEnabled();
        return sService;
    }

    public INfcTag getTagService() {
        this.isEnabled();
        return sTagService;
    }

    public void attemptDeadServiceRecovery(Exception e) {
        Log.e(TAG, "NFC service dead - attempting to recover", e);
        INfcAdapter service = NfcAdapter.getServiceInterface();
        if (service == null) {
            Log.e(TAG, "could not retrieve NFC service during service recovery");
            return;
        }
        sService = service;
        try {
            sTagService = service.getNfcTagInterface();
        }
        catch (RemoteException ee) {
            Log.e(TAG, "could not retrieve NFC tag service during service recovery");
        }
    }

    public boolean isEnabled() {
        try {
            return sService.getState() == 3;
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    public int getAdapterState() {
        try {
            return sService.getState();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return 1;
        }
    }

    public boolean enable() {
        try {
            return sService.enable();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    public boolean disable() {
        try {
            return sService.disable();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    public void setNdefPushMessage(NdefMessage message, Activity activity, Activity ... activities) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        this.mNfcActivityManager.setNdefPushMessage(activity, message);
        for (Activity a : activities) {
            if (a == null) {
                throw new NullPointerException("activities cannot contain null");
            }
            this.mNfcActivityManager.setNdefPushMessage(a, message);
        }
    }

    public void setNdefPushMessageCallback(CreateNdefMessageCallback callback, Activity activity, Activity ... activities) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        this.mNfcActivityManager.setNdefPushMessageCallback(activity, callback);
        for (Activity a : activities) {
            if (a == null) {
                throw new NullPointerException("activities cannot contain null");
            }
            this.mNfcActivityManager.setNdefPushMessageCallback(a, callback);
        }
    }

    public void setOnNdefPushCompleteCallback(OnNdefPushCompleteCallback callback, Activity activity, Activity ... activities) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        this.mNfcActivityManager.setOnNdefPushCompleteCallback(activity, callback);
        for (Activity a : activities) {
            if (a == null) {
                throw new NullPointerException("activities cannot contain null");
            }
            this.mNfcActivityManager.setOnNdefPushCompleteCallback(a, callback);
        }
    }

    public void enableForegroundDispatch(Activity activity, PendingIntent intent, IntentFilter[] filters, String[][] techLists) {
        if (activity == null || intent == null) {
            throw new NullPointerException();
        }
        if (!activity.isResumed()) {
            throw new IllegalStateException("Foreground dispatch can only be enabled when your activity is resumed");
        }
        try {
            TechListParcel parcel = null;
            if (techLists != null && techLists.length > 0) {
                parcel = new TechListParcel(techLists);
            }
            ActivityThread.currentActivityThread().registerOnActivityPausedListener(activity, this.mForegroundDispatchListener);
            sService.setForegroundDispatch(intent, filters, parcel);
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    public void disableForegroundDispatch(Activity activity) {
        ActivityThread.currentActivityThread().unregisterOnActivityPausedListener(activity, this.mForegroundDispatchListener);
        this.disableForegroundDispatchInternal(activity, false);
    }

    void disableForegroundDispatchInternal(Activity activity, boolean force) {
        try {
            sService.setForegroundDispatch(null, null, null);
            if (!force && !activity.isResumed()) {
                throw new IllegalStateException("You must disable foreground dispatching while your activity is still resumed");
            }
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
        }
    }

    @Deprecated
    public void enableForegroundNdefPush(Activity activity, NdefMessage message) {
        if (activity == null || message == null) {
            throw new NullPointerException();
        }
        this.enforceResumed(activity);
        this.mNfcActivityManager.setNdefPushMessage(activity, message);
    }

    public void disableForegroundNdefPush(Activity activity) {
        if (activity == null) {
            throw new NullPointerException();
        }
        this.enforceResumed(activity);
        this.mNfcActivityManager.setNdefPushMessage(activity, null);
        this.mNfcActivityManager.setNdefPushMessageCallback(activity, null);
        this.mNfcActivityManager.setOnNdefPushCompleteCallback(activity, null);
    }

    @Deprecated
    public void enableForegroundNdefPush(Activity activity, NdefPushCallback callback) {
        if (activity == null || callback == null) {
            throw new NullPointerException();
        }
        this.enforceResumed(activity);
        LegacyCallbackWrapper callbackWrapper = new LegacyCallbackWrapper(callback);
        this.mNfcActivityManager.setNdefPushMessageCallback(activity, callbackWrapper);
        this.mNfcActivityManager.setOnNdefPushCompleteCallback(activity, callbackWrapper);
    }

    public boolean enableNdefPush() {
        try {
            return sService.enableNdefPush();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    public boolean disableNdefPush() {
        try {
            return sService.disableNdefPush();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    public boolean isNdefPushEnabled() {
        try {
            return sService.isNdefPushEnabled();
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return false;
        }
    }

    public INfcAdapterExtras getNfcAdapterExtrasInterface() {
        if (this.mContext == null) {
            throw new UnsupportedOperationException("You need a context on NfcAdapter to use the  NFC extras APIs");
        }
        try {
            return sService.getNfcAdapterExtrasInterface(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            this.attemptDeadServiceRecovery(e);
            return null;
        }
    }

    void enforceResumed(Activity activity) {
        if (!activity.isResumed()) {
            throw new IllegalStateException("API cannot be called while activity is paused");
        }
    }

    static {
        sNfcAdapters = new HashMap();
    }

    static final class LegacyCallbackWrapper
    implements CreateNdefMessageCallback,
    OnNdefPushCompleteCallback {
        final NdefPushCallback mLegacyCallback;

        LegacyCallbackWrapper(NdefPushCallback legacyCallback) {
            this.mLegacyCallback = legacyCallback;
        }

        public void onNdefPushComplete(NfcEvent event) {
            this.mLegacyCallback.onMessagePushed();
        }

        public NdefMessage createNdefMessage(NfcEvent event) {
            return this.mLegacyCallback.createMessage();
        }
    }

    @Deprecated
    public static interface NdefPushCallback {
        @Deprecated
        public NdefMessage createMessage();

        @Deprecated
        public void onMessagePushed();
    }

    public static interface CreateNdefMessageCallback {
        public NdefMessage createNdefMessage(NfcEvent var1);
    }

    public static interface OnNdefPushCompleteCallback {
        public void onNdefPushComplete(NfcEvent var1);
    }
}

