/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.nfc.NfcActivityManager;
import android.nfc.NfcAdapter;

public final class NfcFragment
extends Fragment {
    static final String FRAGMENT_TAG = "android.nfc.NfcFragment";
    static boolean sIsInitialized = false;
    static NfcActivityManager sNfcActivityManager;

    public static void attach(Activity activity) {
        FragmentManager manager = activity.getFragmentManager();
        if (manager.findFragmentByTag(FRAGMENT_TAG) == null) {
            manager.beginTransaction().add(new NfcFragment(), FRAGMENT_TAG).commit();
        }
    }

    public static void remove(Activity activity) {
        FragmentManager manager = activity.getFragmentManager();
        Fragment fragment = manager.findFragmentByTag(FRAGMENT_TAG);
        if (fragment != null) {
            manager.beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!sIsInitialized) {
            sIsInitialized = true;
            NfcAdapter adapter = NfcAdapter.getDefaultAdapter(activity.getApplicationContext());
            if (adapter != null) {
                sNfcActivityManager = adapter.mNfcActivityManager;
            }
        }
    }

    public void onResume() {
        super.onResume();
        if (sNfcActivityManager != null) {
            sNfcActivityManager.onResume(this.getActivity());
        }
    }

    public void onPause() {
        super.onPause();
        if (sNfcActivityManager != null) {
            sNfcActivityManager.onPause(this.getActivity());
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (sNfcActivityManager != null) {
            sNfcActivityManager.onDestroy(this.getActivity());
        }
    }
}

