/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.pm.ApplicationInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.telephony.SignalStrength;
import android.util.Printer;
import android.util.SparseArray;
import android.util.TimeUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatteryStats
implements Parcelable {
    private static final boolean LOCAL_LOGV = false;
    public static final int WAKE_TYPE_PARTIAL = 0;
    public static final int WAKE_TYPE_FULL = 1;
    public static final int WAKE_TYPE_WINDOW = 2;
    public static final int SENSOR = 3;
    public static final int WIFI_RUNNING = 4;
    public static final int FULL_WIFI_LOCK = 5;
    public static final int SCAN_WIFI_LOCK = 6;
    public static final int WIFI_MULTICAST_ENABLED = 7;
    public static final int AUDIO_TURNED_ON = 7;
    public static final int VIDEO_TURNED_ON = 8;
    public static final int STATS_SINCE_CHARGED = 0;
    public static final int STATS_LAST = 1;
    public static final int STATS_CURRENT = 2;
    public static final int STATS_SINCE_UNPLUGGED = 3;
    private static final String[] STAT_NAMES = new String[]{"t", "l", "c", "u"};
    private static final int BATTERY_STATS_CHECKIN_VERSION = 5;
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final String UID_DATA = "uid";
    private static final String APK_DATA = "apk";
    private static final String PROCESS_DATA = "pr";
    private static final String SENSOR_DATA = "sr";
    private static final String WAKELOCK_DATA = "wl";
    private static final String KERNEL_WAKELOCK_DATA = "kwl";
    private static final String NETWORK_DATA = "nt";
    private static final String USER_ACTIVITY_DATA = "ua";
    private static final String BATTERY_DATA = "bt";
    private static final String BATTERY_DISCHARGE_DATA = "dc";
    private static final String BATTERY_LEVEL_DATA = "lv";
    private static final String WIFI_LOCK_DATA = "wfl";
    private static final String MISC_DATA = "m";
    private static final String SCREEN_BRIGHTNESS_DATA = "br";
    private static final String SIGNAL_STRENGTH_TIME_DATA = "sgt";
    private static final String SIGNAL_SCANNING_TIME_DATA = "sst";
    private static final String SIGNAL_STRENGTH_COUNT_DATA = "sgc";
    private static final String DATA_CONNECTION_TIME_DATA = "dct";
    private static final String DATA_CONNECTION_COUNT_DATA = "dcc";
    private final StringBuilder mFormatBuilder = new StringBuilder(32);
    private final Formatter mFormatter = new Formatter(this.mFormatBuilder);
    public static final int SCREEN_BRIGHTNESS_DARK = 0;
    public static final int SCREEN_BRIGHTNESS_DIM = 1;
    public static final int SCREEN_BRIGHTNESS_MEDIUM = 2;
    public static final int SCREEN_BRIGHTNESS_LIGHT = 3;
    public static final int SCREEN_BRIGHTNESS_BRIGHT = 4;
    static final String[] SCREEN_BRIGHTNESS_NAMES = new String[]{"dark", "dim", "medium", "light", "bright"};
    public static final int NUM_SCREEN_BRIGHTNESS_BINS = 5;
    public static final int DATA_CONNECTION_NONE = 0;
    public static final int DATA_CONNECTION_GPRS = 1;
    public static final int DATA_CONNECTION_EDGE = 2;
    public static final int DATA_CONNECTION_UMTS = 3;
    public static final int DATA_CONNECTION_CDMA = 4;
    public static final int DATA_CONNECTION_EVDO_0 = 5;
    public static final int DATA_CONNECTION_EVDO_A = 6;
    public static final int DATA_CONNECTION_1xRTT = 7;
    public static final int DATA_CONNECTION_HSDPA = 8;
    public static final int DATA_CONNECTION_HSUPA = 9;
    public static final int DATA_CONNECTION_HSPA = 10;
    public static final int DATA_CONNECTION_IDEN = 11;
    public static final int DATA_CONNECTION_EVDO_B = 12;
    public static final int DATA_CONNECTION_LTE = 13;
    public static final int DATA_CONNECTION_EHRPD = 14;
    public static final int DATA_CONNECTION_OTHER = 15;
    static final String[] DATA_CONNECTION_NAMES = new String[]{"none", "gprs", "edge", "umts", "cdma", "evdo_0", "evdo_A", "1xrtt", "hsdpa", "hsupa", "hspa", "iden", "evdo_b", "lte", "ehrpd", "other"};
    public static final int NUM_DATA_CONNECTION_TYPES = 16;
    public static final BitDescription[] HISTORY_STATE_DESCRIPTIONS = new BitDescription[]{new BitDescription(524288, "plugged"), new BitDescription(0x100000, "screen"), new BitDescription(0x10000000, "gps"), new BitDescription(262144, "phone_in_call"), new BitDescription(0x8000000, "phone_scanning"), new BitDescription(131072, "wifi"), new BitDescription(0x4000000, "wifi_running"), new BitDescription(0x2000000, "wifi_full_lock"), new BitDescription(0x1000000, "wifi_scan_lock"), new BitDescription(0x800000, "wifi_multicast"), new BitDescription(65536, "bluetooth"), new BitDescription(0x400000, "audio"), new BitDescription(0x200000, "video"), new BitDescription(0x40000000, "wake_lock"), new BitDescription(0x20000000, "sensor"), new BitDescription(15, 0, "brightness", SCREEN_BRIGHTNESS_NAMES), new BitDescription(240, 4, "signal_strength", SignalStrength.SIGNAL_STRENGTH_NAMES), new BitDescription(3840, 8, "phone_state", new String[]{"in", "out", "emergency", "off"}), new BitDescription(61440, 12, "data_conn", DATA_CONNECTION_NAMES)};

    public abstract boolean startIteratingHistoryLocked();

    public abstract boolean getNextHistoryLocked(HistoryItem var1);

    public abstract void finishIteratingHistoryLocked();

    public abstract boolean startIteratingOldHistoryLocked();

    public abstract boolean getNextOldHistoryLocked(HistoryItem var1);

    public abstract void finishIteratingOldHistoryLocked();

    public abstract long getHistoryBaseTime();

    public abstract int getStartCount();

    public abstract long getScreenOnTime(long var1, int var3);

    public abstract long getScreenBrightnessTime(int var1, long var2, int var4);

    public abstract int getInputEventCount(int var1);

    public abstract long getPhoneOnTime(long var1, int var3);

    public abstract long getPhoneSignalStrengthTime(int var1, long var2, int var4);

    public abstract long getPhoneSignalScanningTime(long var1, int var3);

    public abstract int getPhoneSignalStrengthCount(int var1, int var2);

    public abstract long getPhoneDataConnectionTime(int var1, long var2, int var4);

    public abstract int getPhoneDataConnectionCount(int var1, int var2);

    public abstract long getWifiOnTime(long var1, int var3);

    public abstract long getGlobalWifiRunningTime(long var1, int var3);

    public abstract long getBluetoothOnTime(long var1, int var3);

    public abstract boolean getIsOnBattery();

    public abstract SparseArray<? extends Uid> getUidStats();

    public abstract long getBatteryUptime(long var1);

    public long getRadioDataUptimeMs() {
        return this.getRadioDataUptime() / 1000L;
    }

    public abstract long getRadioDataUptime();

    public abstract long getBatteryRealtime(long var1);

    public abstract int getDischargeStartLevel();

    public abstract int getDischargeCurrentLevel();

    public abstract int getLowDischargeAmountSinceCharge();

    public abstract int getHighDischargeAmountSinceCharge();

    public abstract int getDischargeAmountScreenOn();

    public abstract int getDischargeAmountScreenOnSinceCharge();

    public abstract int getDischargeAmountScreenOff();

    public abstract int getDischargeAmountScreenOffSinceCharge();

    public abstract long computeBatteryUptime(long var1, int var3);

    public abstract long computeBatteryRealtime(long var1, int var3);

    public abstract long computeUptime(long var1, int var3);

    public abstract long computeRealtime(long var1, int var3);

    public abstract Map<String, ? extends Timer> getKernelWakelockStats();

    public abstract int getCpuSpeedSteps();

    private static final void formatTimeRaw(StringBuilder out, long seconds) {
        long mins;
        long used;
        long hours;
        long days = seconds / 86400L;
        if (days != 0L) {
            out.append(days);
            out.append("d ");
        }
        if ((hours = (seconds - (used = days * 60L * 60L * 24L)) / 3600L) != 0L || used != 0L) {
            out.append(hours);
            out.append("h ");
        }
        if ((mins = (seconds - (used += hours * 60L * 60L)) / 60L) != 0L || used != 0L) {
            out.append(mins);
            out.append("m ");
        }
        if (seconds != 0L || (used += mins * 60L) != 0L) {
            out.append(seconds - used);
            out.append("s ");
        }
    }

    private static final void formatTime(StringBuilder sb, long time) {
        long sec = time / 100L;
        BatteryStats.formatTimeRaw(sb, sec);
        sb.append((time - sec * 100L) * 10L);
        sb.append("ms ");
    }

    private static final void formatTimeMs(StringBuilder sb, long time) {
        long sec = time / 1000L;
        BatteryStats.formatTimeRaw(sb, sec);
        sb.append(time - sec * 1000L);
        sb.append("ms ");
    }

    private final String formatRatioLocked(long num, long den) {
        if (den == 0L) {
            return "---%";
        }
        float perc = (float)num / (float)den * 100.0f;
        this.mFormatBuilder.setLength(0);
        this.mFormatter.format("%.1f%%", Float.valueOf(perc));
        return this.mFormatBuilder.toString();
    }

    private final String formatBytesLocked(long bytes) {
        this.mFormatBuilder.setLength(0);
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            this.mFormatter.format("%.2fKB", (double)bytes / 1024.0);
            return this.mFormatBuilder.toString();
        }
        if (bytes < 0x40000000L) {
            this.mFormatter.format("%.2fMB", (double)bytes / 1048576.0);
            return this.mFormatBuilder.toString();
        }
        this.mFormatter.format("%.2fGB", (double)bytes / 1.073741824E9);
        return this.mFormatBuilder.toString();
    }

    private static long computeWakeLock(Timer timer, long batteryRealtime, int which) {
        if (timer != null) {
            long totalTimeMicros = timer.getTotalTimeLocked(batteryRealtime, which);
            long totalTimeMillis = (totalTimeMicros + 500L) / 1000L;
            return totalTimeMillis;
        }
        return 0L;
    }

    private static final String printWakeLock(StringBuilder sb, Timer timer, long batteryRealtime, String name, int which, String linePrefix) {
        if (timer != null) {
            long totalTimeMillis = BatteryStats.computeWakeLock(timer, batteryRealtime, which);
            int count = timer.getCountLocked(which);
            if (totalTimeMillis != 0L) {
                sb.append(linePrefix);
                BatteryStats.formatTimeMs(sb, totalTimeMillis);
                if (name != null) {
                    sb.append(name);
                }
                sb.append(' ');
                sb.append('(');
                sb.append(count);
                sb.append(" times)");
                return ", ";
            }
        }
        return linePrefix;
    }

    private static final String printWakeLockCheckin(StringBuilder sb, Timer timer, long now, String name, int which, String linePrefix) {
        long totalTimeMicros = 0L;
        int count = 0;
        if (timer != null) {
            totalTimeMicros = timer.getTotalTimeLocked(now, which);
            count = timer.getCountLocked(which);
        }
        sb.append(linePrefix);
        sb.append((totalTimeMicros + 500L) / 1000L);
        sb.append(',');
        sb.append(name != null ? name + "," : "");
        sb.append(count);
        return ",";
    }

    private static final void dumpLine(PrintWriter pw, int uid, String category, String type, Object ... args) {
        pw.print(5);
        pw.print(',');
        pw.print(uid);
        pw.print(',');
        pw.print(category);
        pw.print(',');
        pw.print(type);
        for (Object arg : args) {
            pw.print(',');
            pw.print(arg);
        }
        pw.print('\n');
    }

    public final void dumpCheckinLocked(PrintWriter pw, int which, int reqUid) {
        Map<String, ? extends Timer> kernelWakelocks;
        int i;
        long rawUptime = SystemClock.uptimeMillis() * 1000L;
        long rawRealtime = SystemClock.elapsedRealtime() * 1000L;
        long batteryUptime = this.getBatteryUptime(rawUptime);
        long batteryRealtime = this.getBatteryRealtime(rawRealtime);
        long whichBatteryUptime = this.computeBatteryUptime(rawUptime, which);
        long whichBatteryRealtime = this.computeBatteryRealtime(rawRealtime, which);
        long totalRealtime = this.computeRealtime(rawRealtime, which);
        long totalUptime = this.computeUptime(rawUptime, which);
        long screenOnTime = this.getScreenOnTime(batteryRealtime, which);
        long phoneOnTime = this.getPhoneOnTime(batteryRealtime, which);
        long wifiOnTime = this.getWifiOnTime(batteryRealtime, which);
        long wifiRunningTime = this.getGlobalWifiRunningTime(batteryRealtime, which);
        long bluetoothOnTime = this.getBluetoothOnTime(batteryRealtime, which);
        StringBuilder sb = new StringBuilder(128);
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        int NU = uidStats.size();
        String category = STAT_NAMES[which];
        BatteryStats.dumpLine(pw, 0, category, BATTERY_DATA, which == 0 ? Integer.valueOf(this.getStartCount()) : "N/A", whichBatteryRealtime / 1000L, whichBatteryUptime / 1000L, totalRealtime / 1000L, totalUptime / 1000L);
        long rxTotal = 0L;
        long txTotal = 0L;
        long fullWakeLockTimeTotal = 0L;
        long partialWakeLockTimeTotal = 0L;
        for (int iu = 0; iu < NU; ++iu) {
            Uid u = uidStats.valueAt(iu);
            rxTotal += u.getTcpBytesReceived(which);
            txTotal += u.getTcpBytesSent(which);
            Map<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
            if (wakelocks.size() <= 0) continue;
            for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                Timer partialWakeTimer;
                Uid.Wakelock wl = ent.getValue();
                Timer fullWakeTimer = wl.getWakeTime(1);
                if (fullWakeTimer != null) {
                    fullWakeLockTimeTotal += fullWakeTimer.getTotalTimeLocked(batteryRealtime, which);
                }
                if ((partialWakeTimer = wl.getWakeTime(0)) == null) continue;
                partialWakeLockTimeTotal += partialWakeTimer.getTotalTimeLocked(batteryRealtime, which);
            }
        }
        BatteryStats.dumpLine(pw, 0, category, MISC_DATA, screenOnTime / 1000L, phoneOnTime / 1000L, wifiOnTime / 1000L, wifiRunningTime / 1000L, bluetoothOnTime / 1000L, rxTotal, txTotal, fullWakeLockTimeTotal, partialWakeLockTimeTotal, this.getInputEventCount(which));
        Object[] args = new Object[5];
        for (i = 0; i < 5; ++i) {
            args[i] = this.getScreenBrightnessTime(i, batteryRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, SCREEN_BRIGHTNESS_DATA, args);
        args = new Object[5];
        for (i = 0; i < 5; ++i) {
            args[i] = this.getPhoneSignalStrengthTime(i, batteryRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, SIGNAL_STRENGTH_TIME_DATA, args);
        BatteryStats.dumpLine(pw, 0, category, SIGNAL_SCANNING_TIME_DATA, this.getPhoneSignalScanningTime(batteryRealtime, which) / 1000L);
        for (i = 0; i < 5; ++i) {
            args[i] = this.getPhoneSignalStrengthCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, SIGNAL_STRENGTH_COUNT_DATA, args);
        args = new Object[16];
        for (i = 0; i < 16; ++i) {
            args[i] = this.getPhoneDataConnectionTime(i, batteryRealtime, which) / 1000L;
        }
        BatteryStats.dumpLine(pw, 0, category, DATA_CONNECTION_TIME_DATA, args);
        for (i = 0; i < 16; ++i) {
            args[i] = this.getPhoneDataConnectionCount(i, which);
        }
        BatteryStats.dumpLine(pw, 0, category, DATA_CONNECTION_COUNT_DATA, args);
        if (which == 3) {
            BatteryStats.dumpLine(pw, 0, category, BATTERY_LEVEL_DATA, this.getDischargeStartLevel(), this.getDischargeCurrentLevel());
        }
        if (which == 3) {
            BatteryStats.dumpLine(pw, 0, category, BATTERY_DISCHARGE_DATA, this.getDischargeStartLevel() - this.getDischargeCurrentLevel(), this.getDischargeStartLevel() - this.getDischargeCurrentLevel(), this.getDischargeAmountScreenOn(), this.getDischargeAmountScreenOff());
        } else {
            BatteryStats.dumpLine(pw, 0, category, BATTERY_DISCHARGE_DATA, this.getLowDischargeAmountSinceCharge(), this.getHighDischargeAmountSinceCharge(), this.getDischargeAmountScreenOn(), this.getDischargeAmountScreenOff());
        }
        if (reqUid < 0 && (kernelWakelocks = this.getKernelWakelockStats()).size() > 0) {
            for (Map.Entry<String, ? extends Timer> ent : kernelWakelocks.entrySet()) {
                sb.setLength(0);
                BatteryStats.printWakeLockCheckin(sb, ent.getValue(), batteryRealtime, null, which, "");
                BatteryStats.dumpLine(pw, 0, category, KERNEL_WAKELOCK_DATA, ent.getKey(), sb.toString());
            }
        }
        for (int iu = 0; iu < NU; ++iu) {
            Map<String, ? extends Uid.Pkg> packageStats;
            Map<String, ? extends Uid.Proc> processStats;
            Map<Integer, ? extends Uid.Sensor> sensors;
            Map<String, ? extends Uid.Wakelock> wakelocks;
            int uid = uidStats.keyAt(iu);
            if (reqUid >= 0 && uid != reqUid) continue;
            Uid u = uidStats.valueAt(iu);
            long rx = u.getTcpBytesReceived(which);
            long tx = u.getTcpBytesSent(which);
            long fullWifiLockOnTime = u.getFullWifiLockTime(batteryRealtime, which);
            long scanWifiLockOnTime = u.getScanWifiLockTime(batteryRealtime, which);
            long uidWifiRunningTime = u.getWifiRunningTime(batteryRealtime, which);
            if (rx > 0L || tx > 0L) {
                BatteryStats.dumpLine(pw, uid, category, NETWORK_DATA, rx, tx);
            }
            if (fullWifiLockOnTime != 0L || scanWifiLockOnTime != 0L || uidWifiRunningTime != 0L) {
                BatteryStats.dumpLine(pw, uid, category, WIFI_LOCK_DATA, fullWifiLockOnTime, scanWifiLockOnTime, uidWifiRunningTime);
            }
            if (u.hasUserActivity()) {
                args = new Object[7];
                boolean hasData = false;
                for (int i2 = 0; i2 < 7; ++i2) {
                    int val = u.getUserActivityCount(i2, which);
                    args[i2] = val;
                    if (val == 0) continue;
                    hasData = true;
                }
                if (hasData) {
                    BatteryStats.dumpLine(pw, 0, category, USER_ACTIVITY_DATA, args);
                }
            }
            if ((wakelocks = u.getWakelockStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                    Uid.Wakelock wl = ent.getValue();
                    String linePrefix = "";
                    sb.setLength(0);
                    linePrefix = BatteryStats.printWakeLockCheckin(sb, wl.getWakeTime(1), batteryRealtime, "f", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLockCheckin(sb, wl.getWakeTime(0), batteryRealtime, "p", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLockCheckin(sb, wl.getWakeTime(2), batteryRealtime, "w", which, linePrefix);
                    if (sb.length() <= 0) continue;
                    BatteryStats.dumpLine(pw, uid, category, WAKELOCK_DATA, ent.getKey(), sb.toString());
                }
            }
            if ((sensors = u.getSensorStats()).size() > 0) {
                for (Map.Entry<Integer, ? extends Uid.Sensor> ent : sensors.entrySet()) {
                    Uid.Sensor se = ent.getValue();
                    int sensorNumber = ent.getKey();
                    Timer timer = se.getSensorTime();
                    if (timer == null) continue;
                    long totalTime = (timer.getTotalTimeLocked(batteryRealtime, which) + 500L) / 1000L;
                    int count = timer.getCountLocked(which);
                    if (totalTime == 0L) continue;
                    BatteryStats.dumpLine(pw, uid, category, SENSOR_DATA, sensorNumber, totalTime, count);
                }
            }
            if ((processStats = u.getProcessStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Proc> ent : processStats.entrySet()) {
                    Uid.Proc ps = ent.getValue();
                    long userTime = ps.getUserTime(which);
                    long systemTime = ps.getSystemTime(which);
                    int starts = ps.getStarts(which);
                    if (userTime == 0L && systemTime == 0L && starts == 0) continue;
                    BatteryStats.dumpLine(pw, uid, category, PROCESS_DATA, ent.getKey(), userTime * 10L, systemTime * 10L, starts);
                }
            }
            if ((packageStats = u.getPackageStats()).size() <= 0) continue;
            for (Map.Entry<String, ? extends Uid.Pkg> ent : packageStats.entrySet()) {
                Uid.Pkg ps = ent.getValue();
                int wakeups = ps.getWakeups(which);
                Map<String, ? extends Uid.Pkg.Serv> serviceStats = ps.getServiceStats();
                for (Map.Entry<String, ? extends Uid.Pkg.Serv> sent : serviceStats.entrySet()) {
                    Uid.Pkg.Serv ss = sent.getValue();
                    long startTime = ss.getStartTime(batteryUptime, which);
                    int starts = ss.getStarts(which);
                    int launches = ss.getLaunches(which);
                    if (startTime == 0L && starts == 0 && launches == 0) continue;
                    BatteryStats.dumpLine(pw, uid, category, APK_DATA, wakeups, ent.getKey(), sent.getKey(), startTime / 1000L, starts, launches);
                }
            }
        }
    }

    public final void dumpLocked(PrintWriter pw, String prefix, int which, int reqUid) {
        int i;
        int iu;
        Map<String, ? extends Timer> kernelWakelocks;
        long rawUptime = SystemClock.uptimeMillis() * 1000L;
        long rawRealtime = SystemClock.elapsedRealtime() * 1000L;
        long batteryUptime = this.getBatteryUptime(rawUptime);
        long batteryRealtime = this.getBatteryRealtime(rawRealtime);
        long whichBatteryUptime = this.computeBatteryUptime(rawUptime, which);
        long whichBatteryRealtime = this.computeBatteryRealtime(rawRealtime, which);
        long totalRealtime = this.computeRealtime(rawRealtime, which);
        long totalUptime = this.computeUptime(rawUptime, which);
        StringBuilder sb = new StringBuilder(128);
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        int NU = uidStats.size();
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Time on battery: ");
        BatteryStats.formatTimeMs(sb, whichBatteryRealtime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(whichBatteryRealtime, totalRealtime));
        sb.append(") realtime, ");
        BatteryStats.formatTimeMs(sb, whichBatteryUptime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(whichBatteryUptime, totalRealtime));
        sb.append(") uptime");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Total run time: ");
        BatteryStats.formatTimeMs(sb, totalRealtime / 1000L);
        sb.append("realtime, ");
        BatteryStats.formatTimeMs(sb, totalUptime / 1000L);
        sb.append("uptime, ");
        pw.println(sb.toString());
        long screenOnTime = this.getScreenOnTime(batteryRealtime, which);
        long phoneOnTime = this.getPhoneOnTime(batteryRealtime, which);
        long wifiRunningTime = this.getGlobalWifiRunningTime(batteryRealtime, which);
        long wifiOnTime = this.getWifiOnTime(batteryRealtime, which);
        long bluetoothOnTime = this.getBluetoothOnTime(batteryRealtime, which);
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Screen on: ");
        BatteryStats.formatTimeMs(sb, screenOnTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(screenOnTime, whichBatteryRealtime));
        sb.append("), Input events: ");
        sb.append(this.getInputEventCount(which));
        sb.append(", Active phone call: ");
        BatteryStats.formatTimeMs(sb, phoneOnTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(phoneOnTime, whichBatteryRealtime));
        sb.append(")");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Screen brightnesses: ");
        boolean didOne = false;
        for (int i2 = 0; i2 < 5; ++i2) {
            long time = this.getScreenBrightnessTime(i2, batteryRealtime, which);
            if (time == 0L) continue;
            if (didOne) {
                sb.append(", ");
            }
            didOne = true;
            sb.append(SCREEN_BRIGHTNESS_NAMES[i2]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time, screenOnTime));
            sb.append(")");
        }
        if (!didOne) {
            sb.append("No activity");
        }
        pw.println(sb.toString());
        long rxTotal = 0L;
        long txTotal = 0L;
        long fullWakeLockTimeTotalMicros = 0L;
        long partialWakeLockTimeTotalMicros = 0L;
        if (reqUid < 0 && (kernelWakelocks = this.getKernelWakelockStats()).size() > 0) {
            for (Map.Entry<String, ? extends Timer> ent : kernelWakelocks.entrySet()) {
                String linePrefix = ": ";
                sb.setLength(0);
                sb.append(prefix);
                sb.append("  Kernel Wake lock ");
                sb.append(ent.getKey());
                linePrefix = BatteryStats.printWakeLock(sb, ent.getValue(), batteryRealtime, null, which, linePrefix);
                if (linePrefix.equals(": ")) continue;
                sb.append(" realtime");
                pw.println(sb.toString());
            }
        }
        for (iu = 0; iu < NU; ++iu) {
            Uid u = uidStats.valueAt(iu);
            rxTotal += u.getTcpBytesReceived(which);
            txTotal += u.getTcpBytesSent(which);
            Map<String, ? extends Uid.Wakelock> wakelocks = u.getWakelockStats();
            if (wakelocks.size() <= 0) continue;
            for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                Timer partialWakeTimer;
                Uid.Wakelock wl = ent.getValue();
                Timer fullWakeTimer = wl.getWakeTime(1);
                if (fullWakeTimer != null) {
                    fullWakeLockTimeTotalMicros += fullWakeTimer.getTotalTimeLocked(batteryRealtime, which);
                }
                if ((partialWakeTimer = wl.getWakeTime(0)) == null) continue;
                partialWakeLockTimeTotalMicros += partialWakeTimer.getTotalTimeLocked(batteryRealtime, which);
            }
        }
        pw.print(prefix);
        pw.print("  Total received: ");
        pw.print(this.formatBytesLocked(rxTotal));
        pw.print(", Total sent: ");
        pw.println(this.formatBytesLocked(txTotal));
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Total full wakelock time: ");
        BatteryStats.formatTimeMs(sb, (fullWakeLockTimeTotalMicros + 500L) / 1000L);
        sb.append(", Total partial waklock time: ");
        BatteryStats.formatTimeMs(sb, (partialWakeLockTimeTotalMicros + 500L) / 1000L);
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Signal levels: ");
        didOne = false;
        for (i = 0; i < 5; ++i) {
            long time = this.getPhoneSignalStrengthTime(i, batteryRealtime, which);
            if (time == 0L) continue;
            if (didOne) {
                sb.append(", ");
            }
            didOne = true;
            sb.append(SignalStrength.SIGNAL_STRENGTH_NAMES[i]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getPhoneSignalStrengthCount(i, which));
            sb.append("x");
        }
        if (!didOne) {
            sb.append("No activity");
        }
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Signal scanning time: ");
        BatteryStats.formatTimeMs(sb, this.getPhoneSignalScanningTime(batteryRealtime, which) / 1000L);
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Radio types: ");
        didOne = false;
        for (i = 0; i < 16; ++i) {
            long time = this.getPhoneDataConnectionTime(i, batteryRealtime, which);
            if (time == 0L) continue;
            if (didOne) {
                sb.append(", ");
            }
            didOne = true;
            sb.append(DATA_CONNECTION_NAMES[i]);
            sb.append(" ");
            BatteryStats.formatTimeMs(sb, time / 1000L);
            sb.append("(");
            sb.append(this.formatRatioLocked(time, whichBatteryRealtime));
            sb.append(") ");
            sb.append(this.getPhoneDataConnectionCount(i, which));
            sb.append("x");
        }
        if (!didOne) {
            sb.append("No activity");
        }
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Radio data uptime when unplugged: ");
        sb.append(this.getRadioDataUptime() / 1000L);
        sb.append(" ms");
        pw.println(sb.toString());
        sb.setLength(0);
        sb.append(prefix);
        sb.append("  Wifi on: ");
        BatteryStats.formatTimeMs(sb, wifiOnTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(wifiOnTime, whichBatteryRealtime));
        sb.append("), Wifi running: ");
        BatteryStats.formatTimeMs(sb, wifiRunningTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(wifiRunningTime, whichBatteryRealtime));
        sb.append("), Bluetooth on: ");
        BatteryStats.formatTimeMs(sb, bluetoothOnTime / 1000L);
        sb.append("(");
        sb.append(this.formatRatioLocked(bluetoothOnTime, whichBatteryRealtime));
        sb.append(")");
        pw.println(sb.toString());
        pw.println(" ");
        if (which == 3) {
            if (this.getIsOnBattery()) {
                pw.print(prefix);
                pw.println("  Device is currently unplugged");
                pw.print(prefix);
                pw.print("    Discharge cycle start level: ");
                pw.println(this.getDischargeStartLevel());
                pw.print(prefix);
                pw.print("    Discharge cycle current level: ");
                pw.println(this.getDischargeCurrentLevel());
            } else {
                pw.print(prefix);
                pw.println("  Device is currently plugged into power");
                pw.print(prefix);
                pw.print("    Last discharge cycle start level: ");
                pw.println(this.getDischargeStartLevel());
                pw.print(prefix);
                pw.print("    Last discharge cycle end level: ");
                pw.println(this.getDischargeCurrentLevel());
            }
            pw.print(prefix);
            pw.print("    Amount discharged while screen on: ");
            pw.println(this.getDischargeAmountScreenOn());
            pw.print(prefix);
            pw.print("    Amount discharged while screen off: ");
            pw.println(this.getDischargeAmountScreenOff());
            pw.println(" ");
        } else {
            pw.print(prefix);
            pw.println("  Device battery use since last full charge");
            pw.print(prefix);
            pw.print("    Amount discharged (lower bound): ");
            pw.println(this.getLowDischargeAmountSinceCharge());
            pw.print(prefix);
            pw.print("    Amount discharged (upper bound): ");
            pw.println(this.getHighDischargeAmountSinceCharge());
            pw.print(prefix);
            pw.print("    Amount discharged while screen on: ");
            pw.println(this.getDischargeAmountScreenOnSinceCharge());
            pw.print(prefix);
            pw.print("    Amount discharged while screen off: ");
            pw.println(this.getDischargeAmountScreenOffSinceCharge());
            pw.println(" ");
        }
        for (iu = 0; iu < NU; ++iu) {
            Map<String, ? extends Uid.Pkg> packageStats;
            Map<String, ? extends Uid.Proc> processStats;
            Map<Integer, ? extends Uid.Sensor> sensors;
            Map<String, ? extends Uid.Wakelock> wakelocks;
            int uid = uidStats.keyAt(iu);
            if (reqUid >= 0 && uid != reqUid && uid != 1000) continue;
            Uid u = uidStats.valueAt(iu);
            pw.println(prefix + "  #" + uid + ":");
            boolean uidActivity = false;
            long tcpReceived = u.getTcpBytesReceived(which);
            long tcpSent = u.getTcpBytesSent(which);
            long fullWifiLockOnTime = u.getFullWifiLockTime(batteryRealtime, which);
            long scanWifiLockOnTime = u.getScanWifiLockTime(batteryRealtime, which);
            long uidWifiRunningTime = u.getWifiRunningTime(batteryRealtime, which);
            if (tcpReceived != 0L || tcpSent != 0L) {
                pw.print(prefix);
                pw.print("    Network: ");
                pw.print(this.formatBytesLocked(tcpReceived));
                pw.print(" received, ");
                pw.print(this.formatBytesLocked(tcpSent));
                pw.println(" sent");
            }
            if (u.hasUserActivity()) {
                boolean hasData = false;
                for (int i3 = 0; i3 < 5; ++i3) {
                    int val = u.getUserActivityCount(i3, which);
                    if (val == 0) continue;
                    if (!hasData) {
                        sb.setLength(0);
                        sb.append("    User activity: ");
                        hasData = true;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(val);
                    sb.append(" ");
                    sb.append(Uid.USER_ACTIVITY_TYPES[i3]);
                }
                if (hasData) {
                    pw.println(sb.toString());
                }
            }
            if (fullWifiLockOnTime != 0L || scanWifiLockOnTime != 0L || uidWifiRunningTime != 0L) {
                sb.setLength(0);
                sb.append(prefix);
                sb.append("    Wifi Running: ");
                BatteryStats.formatTimeMs(sb, uidWifiRunningTime / 1000L);
                sb.append("(");
                sb.append(this.formatRatioLocked(uidWifiRunningTime, whichBatteryRealtime));
                sb.append(")\n");
                sb.append(prefix);
                sb.append("    Full Wifi Lock: ");
                BatteryStats.formatTimeMs(sb, fullWifiLockOnTime / 1000L);
                sb.append("(");
                sb.append(this.formatRatioLocked(fullWifiLockOnTime, whichBatteryRealtime));
                sb.append(")\n");
                sb.append(prefix);
                sb.append("    Scan Wifi Lock: ");
                BatteryStats.formatTimeMs(sb, scanWifiLockOnTime / 1000L);
                sb.append("(");
                sb.append(this.formatRatioLocked(scanWifiLockOnTime, whichBatteryRealtime));
                sb.append(")");
                pw.println(sb.toString());
            }
            if ((wakelocks = u.getWakelockStats()).size() > 0) {
                long totalFull = 0L;
                long totalPartial = 0L;
                long totalWindow = 0L;
                int count = 0;
                for (Map.Entry<String, ? extends Uid.Wakelock> ent : wakelocks.entrySet()) {
                    Uid.Wakelock wl = ent.getValue();
                    String linePrefix = ": ";
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Wake lock ");
                    sb.append(ent.getKey());
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(1), batteryRealtime, "full", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(0), batteryRealtime, "partial", which, linePrefix);
                    linePrefix = BatteryStats.printWakeLock(sb, wl.getWakeTime(2), batteryRealtime, "window", which, linePrefix);
                    if (!linePrefix.equals(": ")) {
                        sb.append(" realtime");
                        pw.println(sb.toString());
                        uidActivity = true;
                        ++count;
                    }
                    totalFull += BatteryStats.computeWakeLock(wl.getWakeTime(1), batteryRealtime, which);
                    totalPartial += BatteryStats.computeWakeLock(wl.getWakeTime(0), batteryRealtime, which);
                    totalWindow += BatteryStats.computeWakeLock(wl.getWakeTime(2), batteryRealtime, which);
                }
                if (count > 1 && (totalFull != 0L || totalPartial != 0L || totalWindow != 0L)) {
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    TOTAL wake: ");
                    boolean needComma = false;
                    if (totalFull != 0L) {
                        needComma = true;
                        BatteryStats.formatTimeMs(sb, totalFull);
                        sb.append("full");
                    }
                    if (totalPartial != 0L) {
                        if (needComma) {
                            sb.append(", ");
                        }
                        needComma = true;
                        BatteryStats.formatTimeMs(sb, totalPartial);
                        sb.append("partial");
                    }
                    if (totalWindow != 0L) {
                        if (needComma) {
                            sb.append(", ");
                        }
                        needComma = true;
                        BatteryStats.formatTimeMs(sb, totalWindow);
                        sb.append("window");
                    }
                    sb.append(" realtime");
                    pw.println(sb.toString());
                }
            }
            if ((sensors = u.getSensorStats()).size() > 0) {
                for (Map.Entry<Integer, ? extends Uid.Sensor> ent : sensors.entrySet()) {
                    Uid.Sensor se = ent.getValue();
                    int sensorNumber = ent.getKey();
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Sensor ");
                    int handle = se.getHandle();
                    if (handle == -10000) {
                        sb.append("GPS");
                    } else {
                        sb.append(handle);
                    }
                    sb.append(": ");
                    Timer timer = se.getSensorTime();
                    if (timer != null) {
                        long totalTime = (timer.getTotalTimeLocked(batteryRealtime, which) + 500L) / 1000L;
                        int count = timer.getCountLocked(which);
                        if (totalTime != 0L) {
                            BatteryStats.formatTimeMs(sb, totalTime);
                            sb.append("realtime (");
                            sb.append(count);
                            sb.append(" times)");
                        } else {
                            sb.append("(not used)");
                        }
                    } else {
                        sb.append("(not used)");
                    }
                    pw.println(sb.toString());
                    uidActivity = true;
                }
            }
            if ((processStats = u.getProcessStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Proc> ent : processStats.entrySet()) {
                    int numExcessive;
                    Uid.Proc ps = ent.getValue();
                    long userTime = ps.getUserTime(which);
                    long systemTime = ps.getSystemTime(which);
                    int starts = ps.getStarts(which);
                    int n = numExcessive = which == 0 ? ps.countExcessivePowers() : 0;
                    if (userTime == 0L && systemTime == 0L && starts == 0 && numExcessive == 0) continue;
                    sb.setLength(0);
                    sb.append(prefix);
                    sb.append("    Proc ");
                    sb.append(ent.getKey());
                    sb.append(":\n");
                    sb.append(prefix);
                    sb.append("      CPU: ");
                    BatteryStats.formatTime(sb, userTime);
                    sb.append("usr + ");
                    BatteryStats.formatTime(sb, systemTime);
                    sb.append("krn");
                    if (starts != 0) {
                        sb.append("\n");
                        sb.append(prefix);
                        sb.append("      ");
                        sb.append(starts);
                        sb.append(" proc starts");
                    }
                    pw.println(sb.toString());
                    for (int e = 0; e < numExcessive; ++e) {
                        Uid.Proc.ExcessivePower ew = ps.getExcessivePower(e);
                        if (ew == null) continue;
                        pw.print(prefix);
                        pw.print("      * Killed for ");
                        if (ew.type == 1) {
                            pw.print("wake lock");
                        } else if (ew.type == 2) {
                            pw.print("cpu");
                        } else {
                            pw.print("unknown");
                        }
                        pw.print(" use: ");
                        TimeUtils.formatDuration(ew.usedTime, pw);
                        pw.print(" over ");
                        TimeUtils.formatDuration(ew.overTime, pw);
                        pw.print(" (");
                        pw.print(ew.usedTime * 100L / ew.overTime);
                        pw.println("%)");
                    }
                    uidActivity = true;
                }
            }
            if ((packageStats = u.getPackageStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Pkg> ent : packageStats.entrySet()) {
                    Map<String, ? extends Uid.Pkg.Serv> serviceStats;
                    pw.print(prefix);
                    pw.print("    Apk ");
                    pw.print(ent.getKey());
                    pw.println(":");
                    boolean apkActivity = false;
                    Uid.Pkg ps = ent.getValue();
                    int wakeups = ps.getWakeups(which);
                    if (wakeups != 0) {
                        pw.print(prefix);
                        pw.print("      ");
                        pw.print(wakeups);
                        pw.println(" wakeup alarms");
                        apkActivity = true;
                    }
                    if ((serviceStats = ps.getServiceStats()).size() > 0) {
                        for (Map.Entry<String, ? extends Uid.Pkg.Serv> sent : serviceStats.entrySet()) {
                            Uid.Pkg.Serv ss = sent.getValue();
                            long startTime = ss.getStartTime(batteryUptime, which);
                            int starts = ss.getStarts(which);
                            int launches = ss.getLaunches(which);
                            if (startTime == 0L && starts == 0 && launches == 0) continue;
                            sb.setLength(0);
                            sb.append(prefix);
                            sb.append("      Service ");
                            sb.append(sent.getKey());
                            sb.append(":\n");
                            sb.append(prefix);
                            sb.append("        Created for: ");
                            BatteryStats.formatTimeMs(sb, startTime / 1000L);
                            sb.append(" uptime\n");
                            sb.append(prefix);
                            sb.append("        Starts: ");
                            sb.append(starts);
                            sb.append(", launches: ");
                            sb.append(launches);
                            pw.println(sb.toString());
                            apkActivity = true;
                        }
                    }
                    if (!apkActivity) {
                        pw.print(prefix);
                        pw.println("      (nothing executed)");
                    }
                    uidActivity = true;
                }
            }
            if (uidActivity) continue;
            pw.print(prefix);
            pw.println("    (nothing executed)");
        }
    }

    static void printBitDescriptions(PrintWriter pw, int oldval, int newval, BitDescription[] descriptions) {
        int diff = oldval ^ newval;
        if (diff == 0) {
            return;
        }
        for (int i = 0; i < descriptions.length; ++i) {
            BitDescription bd = descriptions[i];
            if ((diff & bd.mask) == 0) continue;
            if (bd.shift < 0) {
                pw.print((newval & bd.mask) != 0 ? " +" : " -");
                pw.print(bd.name);
                continue;
            }
            pw.print(" ");
            pw.print(bd.name);
            pw.print("=");
            int val = (newval & bd.mask) >> bd.shift;
            if (bd.values != null && val >= 0 && val < bd.values.length) {
                pw.print(bd.values[val]);
                continue;
            }
            pw.print(val);
        }
    }

    public void prepareForDumpLocked() {
    }

    public void dumpLocked(PrintWriter pw) {
        HistoryPrinter hprinter;
        this.prepareForDumpLocked();
        long now = this.getHistoryBaseTime() + SystemClock.elapsedRealtime();
        HistoryItem rec = new HistoryItem();
        if (this.startIteratingHistoryLocked()) {
            pw.println("Battery History:");
            hprinter = new HistoryPrinter();
            while (this.getNextHistoryLocked(rec)) {
                hprinter.printNextItem(pw, rec, now);
            }
            this.finishIteratingHistoryLocked();
            pw.println("");
        }
        if (this.startIteratingOldHistoryLocked()) {
            pw.println("Old battery History:");
            hprinter = new HistoryPrinter();
            while (this.getNextOldHistoryLocked(rec)) {
                hprinter.printNextItem(pw, rec, now);
            }
            this.finishIteratingOldHistoryLocked();
            pw.println("");
        }
        SparseArray<? extends Uid> uidStats = this.getUidStats();
        int NU = uidStats.size();
        boolean didPid = false;
        long nowRealtime = SystemClock.elapsedRealtime();
        for (int i = 0; i < NU; ++i) {
            Uid uid = uidStats.valueAt(i);
            SparseArray<? extends Uid.Pid> pids = uid.getPidStats();
            if (pids == null) continue;
            for (int j = 0; j < pids.size(); ++j) {
                Uid.Pid pid = pids.valueAt(j);
                if (!didPid) {
                    pw.println("Per-PID Stats:");
                    didPid = true;
                }
                long time = pid.mWakeSum + (pid.mWakeStart != 0L ? nowRealtime - pid.mWakeStart : 0L);
                pw.print("  PID ");
                pw.print(pids.keyAt(j));
                pw.print(" wake time: ");
                TimeUtils.formatDuration(time, pw);
                pw.println("");
            }
        }
        if (didPid) {
            pw.println("");
        }
        pw.println("Statistics since last charge:");
        pw.println("  System starts: " + this.getStartCount() + ", currently on battery: " + this.getIsOnBattery());
        this.dumpLocked(pw, "", 0, -1);
        pw.println("");
        pw.println("Statistics since last unplugged:");
        this.dumpLocked(pw, "", 3, -1);
    }

    public void dumpCheckinLocked(PrintWriter pw, String[] args, List<ApplicationInfo> apps) {
        this.prepareForDumpLocked();
        boolean isUnpluggedOnly = false;
        for (String arg : args) {
            if (!"-u".equals(arg)) continue;
            isUnpluggedOnly = true;
        }
        if (apps != null) {
            SparseArray<ArrayList<String>> uids = new SparseArray<ArrayList<String>>();
            for (int i = 0; i < apps.size(); ++i) {
                ApplicationInfo ai = apps.get(i);
                ArrayList<String> pkgs = (ArrayList<String>)uids.get(ai.uid);
                if (pkgs == null) {
                    pkgs = new ArrayList<String>();
                    uids.put(ai.uid, pkgs);
                }
                pkgs.add(ai.packageName);
            }
            SparseArray<? extends Uid> uidStats = this.getUidStats();
            int NU = uidStats.size();
            String[] lineArgs = new String[2];
            for (int i = 0; i < NU; ++i) {
                int uid = uidStats.keyAt(i);
                ArrayList pkgs = (ArrayList)uids.get(uid);
                if (pkgs == null) continue;
                for (int j = 0; j < pkgs.size(); ++j) {
                    lineArgs[0] = Integer.toString(uid);
                    lineArgs[1] = (String)pkgs.get(j);
                    BatteryStats.dumpLine(pw, 0, "i", UID_DATA, lineArgs);
                }
            }
        }
        if (isUnpluggedOnly) {
            this.dumpCheckinLocked(pw, 3, -1);
        } else {
            this.dumpCheckinLocked(pw, 0, -1);
            this.dumpCheckinLocked(pw, 3, -1);
        }
    }

    public static class HistoryPrinter {
        int oldState = 0;
        int oldStatus = -1;
        int oldHealth = -1;
        int oldPlug = -1;
        int oldTemp = -1;
        int oldVolt = -1;

        public void printNextItem(PrintWriter pw, HistoryItem rec, long now) {
            pw.print("  ");
            TimeUtils.formatDuration(rec.time - now, pw, 19);
            pw.print(" ");
            if (rec.cmd == 2) {
                pw.println(" START");
            } else if (rec.cmd == 3) {
                pw.println(" *OVERFLOW*");
            } else {
                if (rec.batteryLevel < 10) {
                    pw.print("00");
                } else if (rec.batteryLevel < 100) {
                    pw.print("0");
                }
                pw.print(rec.batteryLevel);
                pw.print(" ");
                if (rec.states < 16) {
                    pw.print("0000000");
                } else if (rec.states < 256) {
                    pw.print("000000");
                } else if (rec.states < 4096) {
                    pw.print("00000");
                } else if (rec.states < 65536) {
                    pw.print("0000");
                } else if (rec.states < 0x100000) {
                    pw.print("000");
                } else if (rec.states < 0x1000000) {
                    pw.print("00");
                } else if (rec.states < 0x10000000) {
                    pw.print("0");
                }
                pw.print(Integer.toHexString(rec.states));
                if (this.oldStatus != rec.batteryStatus) {
                    this.oldStatus = rec.batteryStatus;
                    pw.print(" status=");
                    switch (this.oldStatus) {
                        case 1: {
                            pw.print("unknown");
                            break;
                        }
                        case 2: {
                            pw.print("charging");
                            break;
                        }
                        case 3: {
                            pw.print("discharging");
                            break;
                        }
                        case 4: {
                            pw.print("not-charging");
                            break;
                        }
                        case 5: {
                            pw.print("full");
                            break;
                        }
                        default: {
                            pw.print(this.oldStatus);
                        }
                    }
                }
                if (this.oldHealth != rec.batteryHealth) {
                    this.oldHealth = rec.batteryHealth;
                    pw.print(" health=");
                    switch (this.oldHealth) {
                        case 1: {
                            pw.print("unknown");
                            break;
                        }
                        case 2: {
                            pw.print("good");
                            break;
                        }
                        case 3: {
                            pw.print("overheat");
                            break;
                        }
                        case 4: {
                            pw.print("dead");
                            break;
                        }
                        case 5: {
                            pw.print("over-voltage");
                            break;
                        }
                        case 6: {
                            pw.print("failure");
                            break;
                        }
                        default: {
                            pw.print(this.oldHealth);
                        }
                    }
                }
                if (this.oldPlug != rec.batteryPlugType) {
                    this.oldPlug = rec.batteryPlugType;
                    pw.print(" plug=");
                    switch (this.oldPlug) {
                        case 0: {
                            pw.print("none");
                            break;
                        }
                        case 1: {
                            pw.print("ac");
                            break;
                        }
                        case 2: {
                            pw.print("usb");
                            break;
                        }
                        default: {
                            pw.print(this.oldPlug);
                        }
                    }
                }
                if (this.oldTemp != rec.batteryTemperature) {
                    this.oldTemp = rec.batteryTemperature;
                    pw.print(" temp=");
                    pw.print(this.oldTemp);
                }
                if (this.oldVolt != rec.batteryVoltage) {
                    this.oldVolt = rec.batteryVoltage;
                    pw.print(" volt=");
                    pw.print(this.oldVolt);
                }
                BatteryStats.printBitDescriptions(pw, this.oldState, rec.states, HISTORY_STATE_DESCRIPTIONS);
                pw.println();
            }
            this.oldState = rec.states;
        }
    }

    public static final class BitDescription {
        public final int mask;
        public final int shift;
        public final String name;
        public final String[] values;

        public BitDescription(int mask, String name) {
            this.mask = mask;
            this.shift = -1;
            this.name = name;
            this.values = null;
        }

        public BitDescription(int mask, int shift, String name, String[] values) {
            this.mask = mask;
            this.shift = shift;
            this.name = name;
            this.values = values;
        }
    }

    public static final class HistoryItem
    implements Parcelable {
        static final String TAG = "HistoryItem";
        static final boolean DEBUG = false;
        public HistoryItem next;
        public long time;
        public static final byte CMD_NULL = 0;
        public static final byte CMD_UPDATE = 1;
        public static final byte CMD_START = 2;
        public static final byte CMD_OVERFLOW = 3;
        public byte cmd = 0;
        public byte batteryLevel;
        public byte batteryStatus;
        public byte batteryHealth;
        public byte batteryPlugType;
        public char batteryTemperature;
        public char batteryVoltage;
        public static final int STATE_BRIGHTNESS_MASK = 15;
        public static final int STATE_BRIGHTNESS_SHIFT = 0;
        public static final int STATE_SIGNAL_STRENGTH_MASK = 240;
        public static final int STATE_SIGNAL_STRENGTH_SHIFT = 4;
        public static final int STATE_PHONE_STATE_MASK = 3840;
        public static final int STATE_PHONE_STATE_SHIFT = 8;
        public static final int STATE_DATA_CONNECTION_MASK = 61440;
        public static final int STATE_DATA_CONNECTION_SHIFT = 12;
        public static final int STATE_WAKE_LOCK_FLAG = 0x40000000;
        public static final int STATE_SENSOR_ON_FLAG = 0x20000000;
        public static final int STATE_GPS_ON_FLAG = 0x10000000;
        public static final int STATE_PHONE_SCANNING_FLAG = 0x8000000;
        public static final int STATE_WIFI_RUNNING_FLAG = 0x4000000;
        public static final int STATE_WIFI_FULL_LOCK_FLAG = 0x2000000;
        public static final int STATE_WIFI_SCAN_LOCK_FLAG = 0x1000000;
        public static final int STATE_WIFI_MULTICAST_ON_FLAG = 0x800000;
        public static final int STATE_AUDIO_ON_FLAG = 0x400000;
        public static final int STATE_VIDEO_ON_FLAG = 0x200000;
        public static final int STATE_SCREEN_ON_FLAG = 0x100000;
        public static final int STATE_BATTERY_PLUGGED_FLAG = 524288;
        public static final int STATE_PHONE_IN_CALL_FLAG = 262144;
        public static final int STATE_WIFI_ON_FLAG = 131072;
        public static final int STATE_BLUETOOTH_ON_FLAG = 65536;
        public static final int MOST_INTERESTING_STATES = 0x101C0000;
        public int states;
        static final int DELTA_TIME_MASK = 262143;
        static final int DELTA_TIME_ABS = 262141;
        static final int DELTA_TIME_INT = 262142;
        static final int DELTA_TIME_LONG = 262143;
        static final int DELTA_CMD_MASK = 3;
        static final int DELTA_CMD_SHIFT = 18;
        static final int DELTA_BATTERY_LEVEL_FLAG = 0x100000;
        static final int DELTA_STATE_FLAG = 0x200000;
        static final int DELTA_STATE_MASK = -4194304;

        public HistoryItem() {
        }

        public HistoryItem(long time, Parcel src) {
            this.time = time;
            this.readFromParcel(src);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.time);
            int bat = this.cmd & 0xFF | this.batteryLevel << 8 & 0xFF00 | this.batteryStatus << 16 & 0xF0000 | this.batteryHealth << 20 & 0xF00000 | this.batteryPlugType << 24 & 0xF000000;
            dest.writeInt(bat);
            bat = this.batteryTemperature & 0xFFFF | this.batteryVoltage << 16 & 0xFFFF0000;
            dest.writeInt(bat);
            dest.writeInt(this.states);
        }

        private void readFromParcel(Parcel src) {
            int bat = src.readInt();
            this.cmd = (byte)(bat & 0xFF);
            this.batteryLevel = (byte)(bat >> 8 & 0xFF);
            this.batteryStatus = (byte)(bat >> 16 & 0xF);
            this.batteryHealth = (byte)(bat >> 20 & 0xF);
            this.batteryPlugType = (byte)(bat >> 24 & 0xF);
            bat = src.readInt();
            this.batteryTemperature = (char)(bat & 0xFFFF);
            this.batteryVoltage = (char)(bat >> 16 & 0xFFFF);
            this.states = src.readInt();
        }

        public void writeDelta(Parcel dest, HistoryItem last) {
            int stateInt;
            boolean stateIntChanged;
            boolean batteryLevelIntChanged;
            if (last == null || last.cmd != 1) {
                dest.writeInt(262141);
                this.writeToParcel(dest, 0);
                return;
            }
            long deltaTime = this.time - last.time;
            int lastBatteryLevelInt = last.buildBatteryLevelInt();
            int lastStateInt = last.buildStateInt();
            int deltaTimeToken = deltaTime < 0L || deltaTime > Integer.MAX_VALUE ? 262143 : (deltaTime >= 262141L ? 262142 : (int)deltaTime);
            int firstToken = deltaTimeToken | this.cmd << 18 | this.states & 0xFFC00000;
            int batteryLevelInt = this.buildBatteryLevelInt();
            boolean bl = batteryLevelIntChanged = batteryLevelInt != lastBatteryLevelInt;
            if (batteryLevelIntChanged) {
                firstToken |= 0x100000;
            }
            boolean bl2 = stateIntChanged = (stateInt = this.buildStateInt()) != lastStateInt;
            if (stateIntChanged) {
                firstToken |= 0x200000;
            }
            dest.writeInt(firstToken);
            if (deltaTimeToken >= 262142) {
                if (deltaTimeToken == 262142) {
                    dest.writeInt((int)deltaTime);
                } else {
                    dest.writeLong(deltaTime);
                }
            }
            if (batteryLevelIntChanged) {
                dest.writeInt(batteryLevelInt);
            }
            if (stateIntChanged) {
                dest.writeInt(stateInt);
            }
        }

        private int buildBatteryLevelInt() {
            return this.batteryLevel << 24 & 0xFF000000 | this.batteryTemperature << 14 & 0xFFC000 | this.batteryVoltage & 0x3FFF;
        }

        private int buildStateInt() {
            return this.batteryStatus << 28 & 0xF0000000 | this.batteryHealth << 24 & 0xF000000 | this.batteryPlugType << 22 & 0xC00000 | this.states & 0x3FFFFF;
        }

        public void readDelta(Parcel src) {
            int firstToken = src.readInt();
            int deltaTimeToken = firstToken & 0x3FFFF;
            this.cmd = (byte)(firstToken >> 18 & 3);
            if (deltaTimeToken < 262141) {
                this.time += (long)deltaTimeToken;
            } else {
                if (deltaTimeToken == 262141) {
                    this.time = src.readLong();
                    this.readFromParcel(src);
                    return;
                }
                if (deltaTimeToken == 262142) {
                    int delta = src.readInt();
                    this.time += (long)delta;
                } else {
                    long delta = src.readLong();
                    this.time += delta;
                }
            }
            if ((firstToken & 0x100000) != 0) {
                int batteryLevelInt = src.readInt();
                this.batteryLevel = (byte)(batteryLevelInt >> 24 & 0xFF);
                this.batteryTemperature = (char)(batteryLevelInt >> 14 & 0x3FF);
                this.batteryVoltage = (char)(batteryLevelInt & 0x3FFF);
            }
            if ((firstToken & 0x200000) != 0) {
                int stateInt = src.readInt();
                this.states = firstToken & 0xFFC00000 | stateInt & 0x3FFFFF;
                this.batteryStatus = (byte)(stateInt >> 28 & 0xF);
                this.batteryHealth = (byte)(stateInt >> 24 & 0xF);
                this.batteryPlugType = (byte)(stateInt >> 22 & 3);
            } else {
                this.states = firstToken & 0xFFC00000 | this.states & 0x3FFFFF;
            }
        }

        public void clear() {
            this.time = 0L;
            this.cmd = 0;
            this.batteryLevel = 0;
            this.batteryStatus = 0;
            this.batteryHealth = 0;
            this.batteryPlugType = 0;
            this.batteryTemperature = '\u0000';
            this.batteryVoltage = '\u0000';
            this.states = 0;
        }

        public void setTo(HistoryItem o) {
            this.time = o.time;
            this.cmd = o.cmd;
            this.batteryLevel = o.batteryLevel;
            this.batteryStatus = o.batteryStatus;
            this.batteryHealth = o.batteryHealth;
            this.batteryPlugType = o.batteryPlugType;
            this.batteryTemperature = o.batteryTemperature;
            this.batteryVoltage = o.batteryVoltage;
            this.states = o.states;
        }

        public void setTo(long time, byte cmd, HistoryItem o) {
            this.time = time;
            this.cmd = cmd;
            this.batteryLevel = o.batteryLevel;
            this.batteryStatus = o.batteryStatus;
            this.batteryHealth = o.batteryHealth;
            this.batteryPlugType = o.batteryPlugType;
            this.batteryTemperature = o.batteryTemperature;
            this.batteryVoltage = o.batteryVoltage;
            this.states = o.states;
        }

        public boolean same(HistoryItem o) {
            return this.batteryLevel == o.batteryLevel && this.batteryStatus == o.batteryStatus && this.batteryHealth == o.batteryHealth && this.batteryPlugType == o.batteryPlugType && this.batteryTemperature == o.batteryTemperature && this.batteryVoltage == o.batteryVoltage && this.states == o.states;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Uid {
        static final String[] USER_ACTIVITY_TYPES = new String[]{"other", "cheek", "touch", "long_touch", "touch_up", "button", "unknown"};
        public static final int NUM_USER_ACTIVITY_TYPES = 7;

        public abstract Map<String, ? extends Wakelock> getWakelockStats();

        public abstract Map<Integer, ? extends Sensor> getSensorStats();

        public abstract SparseArray<? extends Pid> getPidStats();

        public abstract Map<String, ? extends Proc> getProcessStats();

        public abstract Map<String, ? extends Pkg> getPackageStats();

        public abstract int getUid();

        public abstract long getTcpBytesReceived(int var1);

        public abstract long getTcpBytesSent(int var1);

        public abstract void noteWifiRunningLocked();

        public abstract void noteWifiStoppedLocked();

        public abstract void noteFullWifiLockAcquiredLocked();

        public abstract void noteFullWifiLockReleasedLocked();

        public abstract void noteScanWifiLockAcquiredLocked();

        public abstract void noteScanWifiLockReleasedLocked();

        public abstract void noteWifiMulticastEnabledLocked();

        public abstract void noteWifiMulticastDisabledLocked();

        public abstract void noteAudioTurnedOnLocked();

        public abstract void noteAudioTurnedOffLocked();

        public abstract void noteVideoTurnedOnLocked();

        public abstract void noteVideoTurnedOffLocked();

        public abstract long getWifiRunningTime(long var1, int var3);

        public abstract long getFullWifiLockTime(long var1, int var3);

        public abstract long getScanWifiLockTime(long var1, int var3);

        public abstract long getWifiMulticastTime(long var1, int var3);

        public abstract long getAudioTurnedOnTime(long var1, int var3);

        public abstract long getVideoTurnedOnTime(long var1, int var3);

        public abstract void noteUserActivityLocked(int var1);

        public abstract boolean hasUserActivity();

        public abstract int getUserActivityCount(int var1, int var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Pkg {
            public abstract int getWakeups(int var1);

            public abstract Map<String, ? extends Serv> getServiceStats();

            public abstract class Serv {
                public abstract long getStartTime(long var1, int var3);

                public abstract int getStarts(int var1);

                public abstract int getLaunches(int var1);
            }
        }

        public static abstract class Proc {
            public abstract long getUserTime(int var1);

            public abstract long getSystemTime(int var1);

            public abstract int getStarts(int var1);

            public abstract long getForegroundTime(int var1);

            public abstract long getTimeAtCpuSpeedStep(int var1, int var2);

            public abstract int countExcessivePowers();

            public abstract ExcessivePower getExcessivePower(int var1);

            public static class ExcessivePower {
                public static final int TYPE_WAKE = 1;
                public static final int TYPE_CPU = 2;
                public int type;
                public long overTime;
                public long usedTime;
            }
        }

        public class Pid {
            public long mWakeSum;
            public long mWakeStart;
        }

        public static abstract class Sensor {
            public static final int GPS = -10000;

            public abstract int getHandle();

            public abstract Timer getSensorTime();
        }

        public static abstract class Wakelock {
            public abstract Timer getWakeTime(int var1);
        }
    }

    public static abstract class Timer {
        public abstract int getCountLocked(int var1);

        public abstract long getTotalTimeLocked(long var1, int var3);

        public abstract void logState(Printer var1, String var2);
    }

    public static abstract class Counter {
        public abstract int getCountLocked(int var1);

        public abstract void logState(Printer var1, String var2);
    }
}

