/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.TimeUtils;

public final class Message
implements Parcelable {
    public int what;
    public int arg1;
    public int arg2;
    public Object obj;
    public Messenger replyTo;
    static final int FLAG_IN_USE = 1;
    static final int FLAGS_RESERVED = -2;
    static final int FLAGS_TO_CLEAR_ON_COPY_FROM = -1;
    int flags;
    long when;
    Bundle data;
    Handler target;
    Runnable callback;
    Message next;
    private static final Object sPoolSync = new Object();
    private static Message sPool;
    private static int sPoolSize;
    private static final int MAX_POOL_SIZE = 10;
    public static final Parcelable.Creator<Message> CREATOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message obtain() {
        Object object = sPoolSync;
        synchronized (object) {
            if (sPool != null) {
                Message m = sPool;
                sPool = m.next;
                m.next = null;
                --sPoolSize;
                return m;
            }
        }
        return new Message();
    }

    public static Message obtain(Message orig) {
        Message m = Message.obtain();
        m.what = orig.what;
        m.arg1 = orig.arg1;
        m.arg2 = orig.arg2;
        m.obj = orig.obj;
        m.replyTo = orig.replyTo;
        if (orig.data != null) {
            m.data = new Bundle(orig.data);
        }
        m.target = orig.target;
        m.callback = orig.callback;
        return m;
    }

    public static Message obtain(Handler h) {
        Message m = Message.obtain();
        m.target = h;
        return m;
    }

    public static Message obtain(Handler h, Runnable callback) {
        Message m = Message.obtain();
        m.target = h;
        m.callback = callback;
        return m;
    }

    public static Message obtain(Handler h, int what) {
        Message m = Message.obtain();
        m.target = h;
        m.what = what;
        return m;
    }

    public static Message obtain(Handler h, int what, Object obj) {
        Message m = Message.obtain();
        m.target = h;
        m.what = what;
        m.obj = obj;
        return m;
    }

    public static Message obtain(Handler h, int what, int arg1, int arg2) {
        Message m = Message.obtain();
        m.target = h;
        m.what = what;
        m.arg1 = arg1;
        m.arg2 = arg2;
        return m;
    }

    public static Message obtain(Handler h, int what, int arg1, int arg2, Object obj) {
        Message m = Message.obtain();
        m.target = h;
        m.what = what;
        m.arg1 = arg1;
        m.arg2 = arg2;
        m.obj = obj;
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        this.clearForRecycle();
        Object object = sPoolSync;
        synchronized (object) {
            if (sPoolSize < 10) {
                this.next = sPool;
                sPool = this;
                ++sPoolSize;
            }
        }
    }

    public void copyFrom(Message o) {
        this.flags = o.flags & 0;
        this.what = o.what;
        this.arg1 = o.arg1;
        this.arg2 = o.arg2;
        this.obj = o.obj;
        this.replyTo = o.replyTo;
        this.data = o.data != null ? (Bundle)o.data.clone() : null;
    }

    public long getWhen() {
        return this.when;
    }

    public void setTarget(Handler target) {
        this.target = target;
    }

    public Handler getTarget() {
        return this.target;
    }

    public Runnable getCallback() {
        return this.callback;
    }

    public Bundle getData() {
        if (this.data == null) {
            this.data = new Bundle();
        }
        return this.data;
    }

    public Bundle peekData() {
        return this.data;
    }

    public void setData(Bundle data) {
        this.data = data;
    }

    public void sendToTarget() {
        this.target.sendMessage(this);
    }

    void clearForRecycle() {
        this.flags = 0;
        this.what = 0;
        this.arg1 = 0;
        this.arg2 = 0;
        this.obj = null;
        this.replyTo = null;
        this.when = 0L;
        this.target = null;
        this.callback = null;
        this.data = null;
    }

    boolean isInUse() {
        return (this.flags & 1) == 1;
    }

    void markInUse() {
        this.flags |= 1;
    }

    public String toString() {
        return this.toString(SystemClock.uptimeMillis());
    }

    String toString(long now) {
        StringBuilder b = new StringBuilder();
        b.append("{ what=");
        b.append(this.what);
        b.append(" when=");
        TimeUtils.formatDuration(this.when - now, b);
        if (this.arg1 != 0) {
            b.append(" arg1=");
            b.append(this.arg1);
        }
        if (this.arg2 != 0) {
            b.append(" arg2=");
            b.append(this.arg2);
        }
        if (this.obj != null) {
            b.append(" obj=");
            b.append(this.obj);
        }
        b.append(" }");
        return b.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.callback != null) {
            throw new RuntimeException("Can't marshal callbacks across processes.");
        }
        dest.writeInt(this.what);
        dest.writeInt(this.arg1);
        dest.writeInt(this.arg2);
        if (this.obj != null) {
            try {
                Parcelable p = (Parcelable)this.obj;
                dest.writeInt(1);
                dest.writeParcelable(p, flags);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Can't marshal non-Parcelable objects across processes.");
            }
        } else {
            dest.writeInt(0);
        }
        dest.writeLong(this.when);
        dest.writeBundle(this.data);
        Messenger.writeMessengerOrNullToParcel(this.replyTo, dest);
    }

    private final void readFromParcel(Parcel source) {
        this.what = source.readInt();
        this.arg1 = source.readInt();
        this.arg2 = source.readInt();
        if (source.readInt() != 0) {
            this.obj = source.readParcelable(this.getClass().getClassLoader());
        }
        this.when = source.readLong();
        this.data = source.readBundle();
        this.replyTo = Messenger.readMessengerOrNullFromParcel(source);
    }

    static {
        sPoolSize = 0;
        CREATOR = new Parcelable.Creator<Message>(){

            @Override
            public Message createFromParcel(Parcel source) {
                Message msg = Message.obtain();
                msg.readFromParcel(source);
                return msg;
            }

            public Message[] newArray(int size) {
                return new Message[size];
            }
        };
    }
}

