/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.os.Parcel;
import android.os.Parcelable;

public class StorageVolume
implements Parcelable {
    private final String mPath;
    private final String mDescription;
    private final boolean mRemovable;
    private final boolean mEmulated;
    private final int mMtpReserveSpace;
    private final boolean mAllowMassStorage;
    private int mStorageId;
    private final long mMaxFileSize;
    public static final String EXTRA_STORAGE_VOLUME = "storage_volume";
    public static final Parcelable.Creator<StorageVolume> CREATOR = new Parcelable.Creator<StorageVolume>(){

        @Override
        public StorageVolume createFromParcel(Parcel in) {
            String path = in.readString();
            String description = in.readString();
            int removable = in.readInt();
            int emulated = in.readInt();
            int storageId = in.readInt();
            int mtpReserveSpace = in.readInt();
            int allowMassStorage = in.readInt();
            long maxFileSize = in.readLong();
            return new StorageVolume(path, description, removable == 1, emulated == 1, mtpReserveSpace, storageId, allowMassStorage == 1, maxFileSize);
        }

        public StorageVolume[] newArray(int size) {
            return new StorageVolume[size];
        }
    };

    public StorageVolume(String path, String description, boolean removable, boolean emulated, int mtpReserveSpace, boolean allowMassStorage, long maxFileSize) {
        this.mPath = path;
        this.mDescription = description;
        this.mRemovable = removable;
        this.mEmulated = emulated;
        this.mMtpReserveSpace = mtpReserveSpace;
        this.mAllowMassStorage = allowMassStorage;
        this.mMaxFileSize = maxFileSize;
    }

    private StorageVolume(String path, String description, boolean removable, boolean emulated, int mtpReserveSpace, int storageId, boolean allowMassStorage, long maxFileSize) {
        this.mPath = path;
        this.mDescription = description;
        this.mRemovable = removable;
        this.mEmulated = emulated;
        this.mMtpReserveSpace = mtpReserveSpace;
        this.mAllowMassStorage = allowMassStorage;
        this.mStorageId = storageId;
        this.mMaxFileSize = maxFileSize;
    }

    public String getPath() {
        return this.mPath;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean isRemovable() {
        return this.mRemovable;
    }

    public boolean isEmulated() {
        return this.mEmulated;
    }

    public int getStorageId() {
        return this.mStorageId;
    }

    public void setStorageId(int index) {
        this.mStorageId = (index + 1 << 16) + 1;
    }

    public int getMtpReserveSpace() {
        return this.mMtpReserveSpace;
    }

    public boolean allowMassStorage() {
        return this.mAllowMassStorage;
    }

    public long getMaxFileSize() {
        return this.mMaxFileSize;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageVolume && this.mPath != null) {
            StorageVolume volume = (StorageVolume)obj;
            return this.mPath.equals(volume.mPath);
        }
        return false;
    }

    public int hashCode() {
        return this.mPath.hashCode();
    }

    public String toString() {
        return "StorageVolume [mAllowMassStorage=" + this.mAllowMassStorage + ", mDescription=" + this.mDescription + ", mEmulated=" + this.mEmulated + ", mMaxFileSize=" + this.mMaxFileSize + ", mMtpReserveSpace=" + this.mMtpReserveSpace + ", mPath=" + this.mPath + ", mRemovable=" + this.mRemovable + ", mStorageId=" + this.mStorageId + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mPath);
        parcel.writeString(this.mDescription);
        parcel.writeInt(this.mRemovable ? 1 : 0);
        parcel.writeInt(this.mEmulated ? 1 : 0);
        parcel.writeInt(this.mStorageId);
        parcel.writeInt(this.mMtpReserveSpace);
        parcel.writeInt(this.mAllowMassStorage ? 1 : 0);
        parcel.writeLong(this.mMaxFileSize);
    }
}

