/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.preference.SeekBarDialogPreference;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.SeekBar;
import com.android.internal.R;

public class VolumePreference
extends SeekBarDialogPreference
implements PreferenceManager.OnActivityStopListener,
View.OnKeyListener {
    private static final String TAG = "VolumePreference";
    private int mStreamType;
    private SeekBarVolumizer mSeekBarVolumizer;

    public VolumePreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.VolumePreference, 0, 0);
        this.mStreamType = a.getInt(0, 0);
        a.recycle();
    }

    public void setStreamType(int streamType) {
        this.mStreamType = streamType;
    }

    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        SeekBar seekBar = (SeekBar)view.findViewById(16909017);
        this.mSeekBarVolumizer = new SeekBarVolumizer(this.getContext(), seekBar, this.mStreamType);
        this.getPreferenceManager().registerOnActivityStopListener(this);
        view.setOnKeyListener(this);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (this.mSeekBarVolumizer == null) {
            return true;
        }
        boolean isdown = event.getAction() == 0;
        switch (keyCode) {
            case 25: {
                if (isdown) {
                    this.mSeekBarVolumizer.changeVolumeBy(-1);
                }
                return true;
            }
            case 24: {
                if (isdown) {
                    this.mSeekBarVolumizer.changeVolumeBy(1);
                }
                return true;
            }
            case 164: {
                if (isdown) {
                    this.mSeekBarVolumizer.muteVolume();
                }
                return true;
            }
        }
        return false;
    }

    protected void onDialogClosed(boolean positiveResult) {
        super.onDialogClosed(positiveResult);
        if (!positiveResult && this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.revertVolume();
        }
        this.cleanup();
    }

    public void onActivityStop() {
        if (this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.stopSample();
        }
    }

    private void cleanup() {
        this.getPreferenceManager().unregisterOnActivityStopListener(this);
        if (this.mSeekBarVolumizer != null) {
            Dialog dialog = this.getDialog();
            if (dialog != null && dialog.isShowing()) {
                View view = dialog.getWindow().getDecorView().findViewById(16909017);
                if (view != null) {
                    view.setOnKeyListener(null);
                }
                this.mSeekBarVolumizer.revertVolume();
            }
            this.mSeekBarVolumizer.stop();
            this.mSeekBarVolumizer = null;
        }
    }

    protected void onSampleStarting(SeekBarVolumizer volumizer) {
        if (this.mSeekBarVolumizer != null && volumizer != this.mSeekBarVolumizer) {
            this.mSeekBarVolumizer.stopSample();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        if (this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.onSaveInstanceState(myState.getVolumeStore());
        }
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.onRestoreInstanceState(myState.getVolumeStore());
        }
    }

    public class SeekBarVolumizer
    implements SeekBar.OnSeekBarChangeListener,
    Runnable {
        private Context mContext;
        private Handler mHandler = new Handler();
        private AudioManager mAudioManager;
        private int mStreamType;
        private int mOriginalStreamVolume;
        private Ringtone mRingtone;
        private int mLastProgress = -1;
        private SeekBar mSeekBar;
        private int mVolumeBeforeMute = -1;
        private ContentObserver mVolumeObserver = new ContentObserver(this.mHandler){

            public void onChange(boolean selfChange) {
                super.onChange(selfChange);
                if (SeekBarVolumizer.this.mSeekBar != null && SeekBarVolumizer.this.mAudioManager != null) {
                    int volume = SeekBarVolumizer.this.mAudioManager.isStreamMute(SeekBarVolumizer.this.mStreamType) ? SeekBarVolumizer.this.mAudioManager.getLastAudibleStreamVolume(SeekBarVolumizer.this.mStreamType) : SeekBarVolumizer.this.mAudioManager.getStreamVolume(SeekBarVolumizer.this.mStreamType);
                    SeekBarVolumizer.this.mSeekBar.setProgress(volume);
                }
            }
        };

        public SeekBarVolumizer(Context context, SeekBar seekBar, int streamType) {
            this(context, seekBar, streamType, null);
        }

        public SeekBarVolumizer(Context context, SeekBar seekBar, int streamType, Uri defaultUri) {
            this.mContext = context;
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
            this.mStreamType = streamType;
            this.mSeekBar = seekBar;
            this.initSeekBar(seekBar, defaultUri);
        }

        private void initSeekBar(SeekBar seekBar, Uri defaultUri) {
            seekBar.setMax(this.mAudioManager.getStreamMaxVolume(this.mStreamType));
            this.mOriginalStreamVolume = this.mAudioManager.getStreamVolume(this.mStreamType);
            seekBar.setProgress(this.mOriginalStreamVolume);
            seekBar.setOnSeekBarChangeListener(this);
            this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor(Settings.System.VOLUME_SETTINGS[this.mStreamType]), false, this.mVolumeObserver);
            if (defaultUri == null) {
                defaultUri = this.mStreamType == 2 ? Settings.System.DEFAULT_RINGTONE_URI : (this.mStreamType == 5 ? Settings.System.DEFAULT_NOTIFICATION_URI : Settings.System.DEFAULT_ALARM_ALERT_URI);
            }
            this.mRingtone = RingtoneManager.getRingtone(this.mContext, defaultUri);
            if (this.mRingtone != null) {
                this.mRingtone.setStreamType(this.mStreamType);
            }
        }

        public void stop() {
            this.stopSample();
            this.mContext.getContentResolver().unregisterContentObserver(this.mVolumeObserver);
            this.mSeekBar.setOnSeekBarChangeListener(null);
        }

        public void revertVolume() {
            this.mAudioManager.setStreamVolume(this.mStreamType, this.mOriginalStreamVolume, 0);
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromTouch) {
            if (!fromTouch) {
                return;
            }
            this.postSetVolume(progress);
        }

        void postSetVolume(int progress) {
            this.mLastProgress = progress;
            this.mHandler.removeCallbacks(this);
            this.mHandler.post(this);
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            if (!this.isSamplePlaying()) {
                this.startSample();
            }
        }

        public void run() {
            this.mAudioManager.setStreamVolume(this.mStreamType, this.mLastProgress, 0);
        }

        public boolean isSamplePlaying() {
            return this.mRingtone != null && this.mRingtone.isPlaying();
        }

        public void startSample() {
            VolumePreference.this.onSampleStarting(this);
            if (this.mRingtone != null) {
                this.mRingtone.play();
            }
        }

        public void stopSample() {
            if (this.mRingtone != null) {
                this.mRingtone.stop();
            }
        }

        public SeekBar getSeekBar() {
            return this.mSeekBar;
        }

        public void changeVolumeBy(int amount) {
            this.mSeekBar.incrementProgressBy(amount);
            if (!this.isSamplePlaying()) {
                this.startSample();
            }
            this.postSetVolume(this.mSeekBar.getProgress());
            this.mVolumeBeforeMute = -1;
        }

        public void muteVolume() {
            if (this.mVolumeBeforeMute != -1) {
                this.mSeekBar.setProgress(this.mVolumeBeforeMute);
                this.startSample();
                this.postSetVolume(this.mVolumeBeforeMute);
                this.mVolumeBeforeMute = -1;
            } else {
                this.mVolumeBeforeMute = this.mSeekBar.getProgress();
                this.mSeekBar.setProgress(0);
                this.stopSample();
                this.postSetVolume(0);
            }
        }

        public void onSaveInstanceState(VolumeStore volumeStore) {
            if (this.mLastProgress >= 0) {
                volumeStore.volume = this.mLastProgress;
                volumeStore.originalVolume = this.mOriginalStreamVolume;
            }
        }

        public void onRestoreInstanceState(VolumeStore volumeStore) {
            if (volumeStore.volume != -1) {
                this.mOriginalStreamVolume = volumeStore.originalVolume;
                this.mLastProgress = volumeStore.volume;
                this.postSetVolume(this.mLastProgress);
            }
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        VolumeStore mVolumeStore = new VolumeStore();
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.mVolumeStore.volume = source.readInt();
            this.mVolumeStore.originalVolume = source.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mVolumeStore.volume);
            dest.writeInt(this.mVolumeStore.originalVolume);
        }

        VolumeStore getVolumeStore() {
            return this.mVolumeStore;
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }
    }

    public static class VolumeStore {
        public int volume = -1;
        public int originalVolume = -1;
    }
}

