/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.BaseColumns;
import java.util.List;

public class Applications {
    public static final String AUTHORITY = "applications";
    public static final Uri CONTENT_URI = Uri.parse("content://applications");
    public static final String APPLICATION_PATH = "applications";
    public static final String SEARCH_PATH = "search";
    private static final String APPLICATION_SUB_TYPE = "vnd.android.application";
    public static final String APPLICATION_ITEM_TYPE = "vnd.android.cursor.item/vnd.android.application";
    public static final String APPLICATION_DIR_TYPE = "vnd.android.cursor.dir/vnd.android.application";

    private Applications() {
    }

    public static Cursor search(ContentResolver resolver, String query) {
        Uri searchUri = CONTENT_URI.buildUpon().appendPath(SEARCH_PATH).appendPath(query).build();
        return resolver.query(searchUri, null, null, null, null);
    }

    public static ComponentName uriToComponentName(Uri appUri) {
        if (appUri == null) {
            return null;
        }
        if (!"content".equals(appUri.getScheme())) {
            return null;
        }
        if (!"applications".equals(appUri.getAuthority())) {
            return null;
        }
        List<String> pathSegments = appUri.getPathSegments();
        if (pathSegments.size() != 3) {
            return null;
        }
        if (!"applications".equals(pathSegments.get(0))) {
            return null;
        }
        String packageName = pathSegments.get(1);
        String name = pathSegments.get(2);
        return new ComponentName(packageName, name);
    }

    public static Uri componentNameToUri(String packageName, String className) {
        return CONTENT_URI.buildUpon().appendEncodedPath("applications").appendPath(packageName).appendPath(className).build();
    }

    public static interface ApplicationColumns
    extends BaseColumns {
        public static final String NAME = "name";
        public static final String ICON = "icon";
        public static final String URI = "uri";
    }
}

