/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.drm.mobile1.DrmRawContent;
import android.drm.mobile1.DrmRights;
import android.drm.mobile1.DrmRightsManager;
import android.net.Uri;
import android.provider.BaseColumns;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class DrmStore {
    private static final String TAG = "DrmStore";
    public static final String AUTHORITY = "drm";
    private static final String ACCESS_DRM_PERMISSION = "android.permission.ACCESS_DRM";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Intent addDrmFile(ContentResolver cr, File file, String title) {
        FileInputStream fis = null;
        Intent result = null;
        try {
            int lastDot;
            fis = new FileInputStream(file);
            if (title == null && (lastDot = (title = file.getName()).lastIndexOf(46)) > 0) {
                title = title.substring(0, lastDot);
            }
            result = DrmStore.addDrmFile(cr, fis, title);
        }
        catch (Exception e) {
            Log.e(TAG, "pushing file failed", e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException in DrmStore.addDrmFile()", e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Intent addDrmFile(ContentResolver cr, FileInputStream fis, String title) {
        OutputStream os = null;
        Intent result = null;
        try {
            DrmRawContent content = new DrmRawContent(fis, fis.available(), "application/vnd.oma.drm.message");
            String mimeType = content.getContentType();
            long size = fis.getChannel().size();
            DrmRightsManager manager = DrmRightsManager.getInstance();
            DrmRights rights = manager.queryRights(content);
            InputStream stream = content.getContentInputStream(rights);
            Uri contentUri = null;
            if (mimeType.startsWith("audio/")) {
                contentUri = Audio.CONTENT_URI;
            } else if (mimeType.startsWith("image/")) {
                contentUri = Images.CONTENT_URI;
            } else {
                Log.w(TAG, "unsupported mime type " + mimeType);
            }
            if (contentUri != null) {
                ContentValues values = new ContentValues(3);
                values.put("title", title);
                values.put("_size", size);
                values.put("mime_type", mimeType);
                Uri uri = cr.insert(contentUri, values);
                if (uri != null) {
                    int count;
                    os = cr.openOutputStream(uri);
                    byte[] buffer = new byte[1000];
                    while ((count = stream.read(buffer)) != -1) {
                        os.write(buffer, 0, count);
                    }
                    result = new Intent();
                    result.setDataAndType(uri, mimeType);
                }
            }
        }
        catch (Exception e) {
            Log.e(TAG, "pushing file failed", e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException in DrmStore.addDrmFile()", e);
            }
        }
        return result;
    }

    public static void enforceAccessDrmPermission(Context context) {
        if (context.checkCallingOrSelfPermission(ACCESS_DRM_PERMISSION) != 0) {
            throw new SecurityException("Requires DRM permission");
        }
    }

    public static interface Audio
    extends Columns {
        public static final Uri CONTENT_URI = Uri.parse("content://drm/audio");
    }

    public static interface Images
    extends Columns {
        public static final Uri CONTENT_URI = Uri.parse("content://drm/images");
    }

    public static interface Columns
    extends BaseColumns {
        public static final String DATA = "_data";
        public static final String SIZE = "_size";
        public static final String TITLE = "title";
        public static final String MIME_TYPE = "mime_type";
    }
}

