/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.content.Context;
import android.server.BluetoothService;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

class BluetoothAdapterProperties {
    private static final String TAG = "BluetoothAdapterProperties";
    private final Map<String, String> mPropertiesMap = new HashMap<String, String>();
    private final Context mContext;
    private final BluetoothService mService;

    BluetoothAdapterProperties(Context context, BluetoothService service) {
        this.mContext = context;
        this.mService = service;
    }

    synchronized String getProperty(String name) {
        if (this.mPropertiesMap.isEmpty()) {
            this.getAllProperties();
        }
        return this.mPropertiesMap.get(name);
    }

    String getObjectPath() {
        return this.getProperty("ObjectPath");
    }

    synchronized void clear() {
        this.mPropertiesMap.clear();
    }

    synchronized boolean isEmpty() {
        return this.mPropertiesMap.isEmpty();
    }

    synchronized void setProperty(String name, String value) {
        this.mPropertiesMap.put(name, value);
    }

    synchronized void getAllProperties() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
        this.mPropertiesMap.clear();
        String[] properties = (String[])this.mService.getAdapterPropertiesNative();
        if (properties == null) {
            Log.e(TAG, "*Error*: GetAdapterProperties returned NULL");
            return;
        }
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i];
            String newValue = null;
            if (name == null) {
                Log.e(TAG, "Error:Adapter Property at index " + i + " is null");
                continue;
            }
            if (name.equals("Devices") || name.equals("UUIDs")) {
                StringBuilder str = new StringBuilder();
                int len = Integer.valueOf(properties[++i]);
                for (int j = 0; j < len; ++j) {
                    str.append(properties[++i]);
                    str.append(",");
                }
                if (len > 0) {
                    newValue = str.toString();
                }
            } else {
                newValue = properties[++i];
            }
            this.mPropertiesMap.put(name, newValue);
        }
        String adapterPath = this.mService.getAdapterPathNative();
        if (adapterPath != null) {
            this.mPropertiesMap.put("ObjectPath", adapterPath + "/dev_");
        }
    }
}

