/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.server.BluetoothEventLoop;
import android.server.BluetoothService;
import android.util.Log;
import com.android.internal.util.IState;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.PrintWriter;

final class BluetoothAdapterStateMachine
extends StateMachine {
    private static final String TAG = "BluetoothAdapterStateMachine";
    private static final boolean DBG = false;
    static final int USER_TURN_ON = 1;
    static final int USER_TURN_OFF = 2;
    static final int PER_PROCESS_TURN_ON = 3;
    static final int PER_PROCESS_TURN_OFF = 4;
    static final int TURN_HOT = 5;
    static final int SERVICE_RECORD_LOADED = 51;
    static final int ALL_DEVICES_DISCONNECTED = 52;
    static final int SCAN_MODE_CHANGED = 53;
    static final int POWER_STATE_CHANGED = 54;
    static final int AIRPLANE_MODE_ON = 55;
    static final int AIRPLANE_MODE_OFF = 56;
    private static final int TURN_ON_CONTINUE = 101;
    private static final int TURN_COLD = 102;
    private static final int DEVICES_DISCONNECT_TIMEOUT = 103;
    private static final int PREPARE_BLUETOOTH_TIMEOUT = 104;
    private static final int POWER_DOWN_TIMEOUT = 105;
    private Context mContext;
    private BluetoothService mBluetoothService;
    private BluetoothEventLoop mEventLoop;
    private BluetoothOn mBluetoothOn;
    private Switching mSwitching;
    private HotOff mHotOff;
    private WarmUp mWarmUp;
    private PowerOff mPowerOff;
    private PerProcessState mPerProcessState;
    private int mPublicState;
    private static final int DEVICES_DISCONNECT_TIMEOUT_TIME = 3000;
    private static final int PREPARE_BLUETOOTH_TIMEOUT_TIME = 10000;
    private static final int POWER_DOWN_TIMEOUT_TIME = 5000;

    BluetoothAdapterStateMachine(Context context, BluetoothService bluetoothService, BluetoothAdapter bluetoothAdapter) {
        super(TAG);
        this.mContext = context;
        this.mBluetoothService = bluetoothService;
        this.mEventLoop = new BluetoothEventLoop(context, bluetoothAdapter, bluetoothService, this);
        this.mBluetoothOn = new BluetoothOn();
        this.mSwitching = new Switching();
        this.mHotOff = new HotOff();
        this.mWarmUp = new WarmUp();
        this.mPowerOff = new PowerOff();
        this.mPerProcessState = new PerProcessState();
        this.addState(this.mBluetoothOn);
        this.addState(this.mSwitching);
        this.addState(this.mHotOff);
        this.addState(this.mWarmUp);
        this.addState(this.mPowerOff);
        this.addState(this.mPerProcessState);
        this.setInitialState(this.mPowerOff);
        this.mPublicState = 10;
    }

    private void finishSwitchingOff() {
        this.mBluetoothService.finishDisable();
        this.broadcastState(10);
        this.mBluetoothService.cleanupAfterFinishDisable();
    }

    private void shutoffBluetooth() {
        this.mBluetoothService.shutoffBluetooth();
        this.mEventLoop.stop();
        this.mBluetoothService.cleanNativeAfterShutoffBluetooth();
    }

    private void perProcessCallback(boolean on, IBluetoothStateChangeCallback c) {
        if (c == null) {
            return;
        }
        try {
            c.onBluetoothStateChange(on);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void allProcessesCallback(boolean on) {
        for (IBluetoothStateChangeCallback c : this.mBluetoothService.getApplicationStateChangeCallbacks()) {
            this.perProcessCallback(on, c);
        }
        if (!on) {
            this.mBluetoothService.clearApplicationStateChangeTracker();
        }
    }

    int getBluetoothAdapterState() {
        return this.mPublicState;
    }

    BluetoothEventLoop getBluetoothEventLoop() {
        return this.mEventLoop;
    }

    private void persistSwitchSetting(boolean setOn) {
        long origCallerIdentityToken = Binder.clearCallingIdentity();
        Settings.Secure.putInt(this.mContext.getContentResolver(), "bluetooth_on", setOn ? 1 : 0);
        Binder.restoreCallingIdentity(origCallerIdentityToken);
    }

    private boolean getBluetoothPersistedSetting() {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        return Settings.Secure.getInt(contentResolver, "bluetooth_on", 0) > 0;
    }

    private void broadcastState(int newState) {
        BluetoothAdapterStateMachine.log("Bluetooth state " + this.mPublicState + " -> " + newState);
        if (this.mPublicState == newState) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.adapter.action.STATE_CHANGED");
        intent.putExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", this.mPublicState);
        intent.putExtra("android.bluetooth.adapter.extra.STATE", newState);
        intent.addFlags(0x10000000);
        this.mPublicState = newState;
        this.mContext.sendBroadcast(intent, "android.permission.BLUETOOTH");
    }

    private void recoverStateMachine(int what, Object obj) {
        Log.e(TAG, "Get unexpected power on event, reset with: " + what);
        this.transitionTo(this.mHotOff);
        this.deferMessage(this.obtainMessage(102));
        this.deferMessage(this.obtainMessage(what, obj));
    }

    private void dump(PrintWriter pw) {
        IState currentState = this.getCurrentState();
        if (currentState == this.mPowerOff) {
            pw.println("Bluetooth OFF - power down\n");
        } else if (currentState == this.mWarmUp) {
            pw.println("Bluetooth OFF - warm up\n");
        } else if (currentState == this.mHotOff) {
            pw.println("Bluetooth OFF - hot but off\n");
        } else if (currentState == this.mSwitching) {
            pw.println("Bluetooth Switching\n");
        } else if (currentState == this.mBluetoothOn) {
            pw.println("Bluetooth ON\n");
        } else {
            pw.println("ERROR: Bluetooth UNKNOWN STATE ");
        }
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private class PerProcessState
    extends State {
        IBluetoothStateChangeCallback mCallback = null;
        boolean isTurningOn = false;

        private PerProcessState() {
        }

        public void enter() {
            int what = ((BluetoothAdapterStateMachine)BluetoothAdapterStateMachine.this).getCurrentMessage().what;
            if (what == 3) {
                this.isTurningOn = true;
            } else if (what == 2) {
                this.isTurningOn = false;
            } else {
                Log.e(BluetoothAdapterStateMachine.TAG, "enter PerProcessState: wrong msg: " + what);
            }
        }

        public boolean processMessage(Message message) {
            BluetoothAdapterStateMachine.log("PerProcessState process message: " + message.what);
            boolean retValue = true;
            switch (message.what) {
                case 3: {
                    this.mCallback = (IBluetoothStateChangeCallback)((BluetoothAdapterStateMachine)BluetoothAdapterStateMachine.this).getCurrentMessage().obj;
                    if (BluetoothAdapterStateMachine.this.mBluetoothService.getNumberOfApplicationStateChangeTrackers() <= 1) break;
                    BluetoothAdapterStateMachine.this.perProcessCallback(true, this.mCallback);
                    break;
                }
                case 53: {
                    if (!this.isTurningOn) break;
                    BluetoothAdapterStateMachine.this.perProcessCallback(true, this.mCallback);
                    this.isTurningOn = false;
                    break;
                }
                case 54: {
                    BluetoothAdapterStateMachine.this.removeMessages(105);
                    if (!((Boolean)message.obj).booleanValue()) {
                        BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mHotOff);
                        if (BluetoothAdapterStateMachine.this.mContext.getResources().getBoolean(0x1110022)) break;
                        BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(102));
                        break;
                    }
                    if (this.isTurningOn) break;
                    BluetoothAdapterStateMachine.this.recoverStateMachine(102, null);
                    for (IBluetoothStateChangeCallback c : BluetoothAdapterStateMachine.this.mBluetoothService.getApplicationStateChangeCallbacks()) {
                        BluetoothAdapterStateMachine.this.perProcessCallback(false, c);
                        BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(3, c));
                    }
                    break;
                }
                case 105: {
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mHotOff);
                    Log.e(BluetoothAdapterStateMachine.TAG, "Power-down timed out, resetting...");
                    BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(102));
                    if (!BluetoothAdapterStateMachine.this.mContext.getResources().getBoolean(0x1110022)) break;
                    BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(5));
                    break;
                }
                case 1: {
                    BluetoothAdapterStateMachine.this.broadcastState(11);
                    BluetoothAdapterStateMachine.this.persistSwitchSetting(true);
                    BluetoothAdapterStateMachine.this.mBluetoothService.initBluetoothAfterTurningOn();
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mBluetoothOn);
                    BluetoothAdapterStateMachine.this.broadcastState(12);
                    BluetoothAdapterStateMachine.this.mBluetoothService.runBluetooth();
                    break;
                }
                case 5: {
                    BluetoothAdapterStateMachine.this.broadcastState(13);
                    if (BluetoothAdapterStateMachine.this.mBluetoothService.getAdapterConnectionState() != 0) {
                        BluetoothAdapterStateMachine.this.mBluetoothService.disconnectDevices();
                        BluetoothAdapterStateMachine.this.sendMessageDelayed(103, 3000L);
                        break;
                    }
                }
                case 52: {
                    BluetoothAdapterStateMachine.this.removeMessages(103);
                    BluetoothAdapterStateMachine.this.finishSwitchingOff();
                    break;
                }
                case 103: {
                    BluetoothAdapterStateMachine.this.finishSwitchingOff();
                    Log.e(BluetoothAdapterStateMachine.TAG, "Devices fail to disconnect, reseting...");
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mHotOff);
                    BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(102));
                    for (IBluetoothStateChangeCallback c : BluetoothAdapterStateMachine.this.mBluetoothService.getApplicationStateChangeCallbacks()) {
                        BluetoothAdapterStateMachine.this.perProcessCallback(false, c);
                        BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(3, c));
                    }
                    break;
                }
                case 4: {
                    BluetoothAdapterStateMachine.this.perProcessCallback(false, (IBluetoothStateChangeCallback)message.obj);
                    if (!BluetoothAdapterStateMachine.this.mBluetoothService.isApplicationStateChangeTrackerEmpty()) break;
                    BluetoothAdapterStateMachine.this.mBluetoothService.switchConnectable(false);
                    BluetoothAdapterStateMachine.this.sendMessageDelayed(105, 5000L);
                    break;
                }
                case 55: {
                    BluetoothAdapterStateMachine.this.mBluetoothService.switchConnectable(false);
                    BluetoothAdapterStateMachine.this.sendMessageDelayed(105, 5000L);
                    BluetoothAdapterStateMachine.this.allProcessesCallback(false);
                    BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(55));
                    break;
                }
                case 2: {
                    Log.w(BluetoothAdapterStateMachine.TAG, "PerProcessState received: " + message.what);
                    break;
                }
                default: {
                    return false;
                }
            }
            return retValue;
        }
    }

    private class BluetoothOn
    extends State {
        private BluetoothOn() {
        }

        public void enter() {
        }

        public boolean processMessage(Message message) {
            BluetoothAdapterStateMachine.log("BluetoothOn process message: " + message.what);
            boolean retValue = true;
            switch (message.what) {
                case 2: {
                    if (((Boolean)message.obj).booleanValue()) {
                        BluetoothAdapterStateMachine.this.persistSwitchSetting(false);
                    }
                    if (BluetoothAdapterStateMachine.this.mBluetoothService.isDiscovering()) {
                        BluetoothAdapterStateMachine.this.mBluetoothService.cancelDiscovery();
                    }
                    if (!BluetoothAdapterStateMachine.this.mBluetoothService.isApplicationStateChangeTrackerEmpty()) {
                        BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mPerProcessState);
                        BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(5));
                        break;
                    }
                }
                case 55: {
                    BluetoothAdapterStateMachine.this.broadcastState(13);
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mSwitching);
                    if (BluetoothAdapterStateMachine.this.mBluetoothService.getAdapterConnectionState() != 0) {
                        BluetoothAdapterStateMachine.this.mBluetoothService.disconnectDevices();
                        BluetoothAdapterStateMachine.this.sendMessageDelayed(103, 3000L);
                    } else {
                        BluetoothAdapterStateMachine.this.mBluetoothService.switchConnectable(false);
                        BluetoothAdapterStateMachine.this.sendMessageDelayed(105, 5000L);
                    }
                    if (message.what != 55) break;
                    BluetoothAdapterStateMachine.this.allProcessesCallback(false);
                    BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(55));
                    break;
                }
                case 1: 
                case 56: {
                    Log.w(BluetoothAdapterStateMachine.TAG, "BluetoothOn received: " + message.what);
                    break;
                }
                case 3: {
                    BluetoothAdapterStateMachine.this.perProcessCallback(true, (IBluetoothStateChangeCallback)message.obj);
                    break;
                }
                case 4: {
                    BluetoothAdapterStateMachine.this.perProcessCallback(false, (IBluetoothStateChangeCallback)message.obj);
                    break;
                }
                case 54: {
                    if (!((Boolean)message.obj).booleanValue()) break;
                    BluetoothAdapterStateMachine.this.recoverStateMachine(1, false);
                    break;
                }
                default: {
                    return false;
                }
            }
            return retValue;
        }
    }

    private class Switching
    extends State {
        private Switching() {
        }

        public void enter() {
        }

        public boolean processMessage(Message message) {
            BluetoothAdapterStateMachine.log("Switching process message: " + message.what);
            boolean retValue = true;
            switch (message.what) {
                case 53: {
                    if (BluetoothAdapterStateMachine.this.mPublicState != 11) break;
                    BluetoothAdapterStateMachine.this.mBluetoothService.setPairable();
                    BluetoothAdapterStateMachine.this.mBluetoothService.initBluetoothAfterTurningOn();
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mBluetoothOn);
                    BluetoothAdapterStateMachine.this.broadcastState(12);
                    BluetoothAdapterStateMachine.this.mBluetoothService.runBluetooth();
                    break;
                }
                case 54: {
                    BluetoothAdapterStateMachine.this.removeMessages(105);
                    if (!((Boolean)message.obj).booleanValue()) {
                        if (BluetoothAdapterStateMachine.this.mPublicState != 13) break;
                        BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mHotOff);
                        BluetoothAdapterStateMachine.this.finishSwitchingOff();
                        if (BluetoothAdapterStateMachine.this.mContext.getResources().getBoolean(0x1110022)) break;
                        BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(102));
                        break;
                    }
                    if (BluetoothAdapterStateMachine.this.mPublicState == 11) break;
                    if (BluetoothAdapterStateMachine.this.mContext.getResources().getBoolean(0x1110022)) {
                        BluetoothAdapterStateMachine.this.recoverStateMachine(5, null);
                        break;
                    }
                    BluetoothAdapterStateMachine.this.recoverStateMachine(102, null);
                    break;
                }
                case 52: {
                    BluetoothAdapterStateMachine.this.removeMessages(103);
                    BluetoothAdapterStateMachine.this.mBluetoothService.switchConnectable(false);
                    BluetoothAdapterStateMachine.this.sendMessageDelayed(105, 5000L);
                    break;
                }
                case 103: {
                    BluetoothAdapterStateMachine.this.sendMessage(52);
                    Log.e(BluetoothAdapterStateMachine.TAG, "Devices failed to disconnect, reseting...");
                    BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(102));
                    if (!BluetoothAdapterStateMachine.this.mContext.getResources().getBoolean(0x1110022)) break;
                    BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(5));
                    break;
                }
                case 105: {
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mHotOff);
                    BluetoothAdapterStateMachine.this.finishSwitchingOff();
                    Log.e(BluetoothAdapterStateMachine.TAG, "Devices failed to power down, reseting...");
                    BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(102));
                    if (!BluetoothAdapterStateMachine.this.mContext.getResources().getBoolean(0x1110022)) break;
                    BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(5));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 55: 
                case 56: {
                    BluetoothAdapterStateMachine.this.deferMessage(message);
                    break;
                }
                default: {
                    return false;
                }
            }
            return retValue;
        }
    }

    private class HotOff
    extends State {
        private HotOff() {
        }

        public void enter() {
        }

        public boolean processMessage(Message message) {
            BluetoothAdapterStateMachine.log("HotOff process message: " + message.what);
            boolean retValue = true;
            switch (message.what) {
                case 1: {
                    BluetoothAdapterStateMachine.this.broadcastState(11);
                    if (((Boolean)message.obj).booleanValue()) {
                        BluetoothAdapterStateMachine.this.persistSwitchSetting(true);
                    }
                }
                case 101: {
                    BluetoothAdapterStateMachine.this.mBluetoothService.switchConnectable(true);
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mSwitching);
                    break;
                }
                case 55: 
                case 102: {
                    BluetoothAdapterStateMachine.this.shutoffBluetooth();
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mPowerOff);
                    BluetoothAdapterStateMachine.this.broadcastState(10);
                    break;
                }
                case 56: {
                    if (!BluetoothAdapterStateMachine.this.getBluetoothPersistedSetting()) break;
                    BluetoothAdapterStateMachine.this.broadcastState(11);
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mSwitching);
                    BluetoothAdapterStateMachine.this.mBluetoothService.switchConnectable(true);
                    break;
                }
                case 3: {
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mPerProcessState);
                    BluetoothAdapterStateMachine.this.deferMessage(message);
                    BluetoothAdapterStateMachine.this.mBluetoothService.switchConnectable(true);
                    break;
                }
                case 4: {
                    BluetoothAdapterStateMachine.this.perProcessCallback(false, (IBluetoothStateChangeCallback)message.obj);
                    break;
                }
                case 2: {
                    break;
                }
                case 54: {
                    if (!((Boolean)message.obj).booleanValue()) break;
                    BluetoothAdapterStateMachine.this.recoverStateMachine(5, null);
                    break;
                }
                default: {
                    return false;
                }
            }
            return retValue;
        }
    }

    private class WarmUp
    extends State {
        private WarmUp() {
        }

        public void enter() {
        }

        public boolean processMessage(Message message) {
            BluetoothAdapterStateMachine.log("WarmUp process message: " + message.what);
            boolean retValue = true;
            switch (message.what) {
                case 51: {
                    BluetoothAdapterStateMachine.this.removeMessages(104);
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mHotOff);
                    break;
                }
                case 104: {
                    Log.e(BluetoothAdapterStateMachine.TAG, "Bluetooth adapter SDP failed to load");
                    BluetoothAdapterStateMachine.this.shutoffBluetooth();
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mPowerOff);
                    BluetoothAdapterStateMachine.this.broadcastState(10);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 55: 
                case 56: 
                case 101: {
                    BluetoothAdapterStateMachine.this.deferMessage(message);
                    break;
                }
                case 2: {
                    Log.w(BluetoothAdapterStateMachine.TAG, "WarmUp received: " + message.what);
                    break;
                }
                default: {
                    return false;
                }
            }
            return retValue;
        }
    }

    private class PowerOff
    extends State {
        private PowerOff() {
        }

        public void enter() {
        }

        public boolean processMessage(Message message) {
            BluetoothAdapterStateMachine.log("PowerOff process message: " + message.what);
            boolean retValue = true;
            switch (message.what) {
                case 1: {
                    BluetoothAdapterStateMachine.this.broadcastState(11);
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mWarmUp);
                    if (this.prepareBluetooth()) {
                        if (((Boolean)message.obj).booleanValue()) {
                            BluetoothAdapterStateMachine.this.persistSwitchSetting(true);
                        }
                        BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(101));
                        break;
                    }
                    Log.e(BluetoothAdapterStateMachine.TAG, "failed to prepare bluetooth, abort turning on");
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mPowerOff);
                    BluetoothAdapterStateMachine.this.broadcastState(10);
                    break;
                }
                case 5: {
                    if (!this.prepareBluetooth()) break;
                    BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mWarmUp);
                    break;
                }
                case 56: {
                    if (BluetoothAdapterStateMachine.this.getBluetoothPersistedSetting()) {
                        BluetoothAdapterStateMachine.this.broadcastState(11);
                        BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mWarmUp);
                        if (this.prepareBluetooth()) {
                            BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(101));
                            BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mWarmUp);
                            break;
                        }
                        Log.e(BluetoothAdapterStateMachine.TAG, "failed to prepare bluetooth, abort turning on");
                        BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mPowerOff);
                        BluetoothAdapterStateMachine.this.broadcastState(10);
                        break;
                    }
                    if (!BluetoothAdapterStateMachine.this.mContext.getResources().getBoolean(0x1110022)) break;
                    BluetoothAdapterStateMachine.this.sendMessage(5);
                    break;
                }
                case 3: {
                    if (this.prepareBluetooth()) {
                        BluetoothAdapterStateMachine.this.transitionTo(BluetoothAdapterStateMachine.this.mWarmUp);
                    }
                    BluetoothAdapterStateMachine.this.deferMessage(BluetoothAdapterStateMachine.this.obtainMessage(3));
                    break;
                }
                case 4: {
                    BluetoothAdapterStateMachine.this.perProcessCallback(false, (IBluetoothStateChangeCallback)message.obj);
                    break;
                }
                case 2: {
                    Log.w(BluetoothAdapterStateMachine.TAG, "PowerOff received: " + message.what);
                }
                case 55: {
                    break;
                }
                default: {
                    return false;
                }
            }
            return retValue;
        }

        private boolean prepareBluetooth() {
            if (BluetoothAdapterStateMachine.this.mBluetoothService.enableNative() != 0) {
                return false;
            }
            int retryCount = 2;
            boolean eventLoopStarted = false;
            block2: while (retryCount-- > 0 && !eventLoopStarted) {
                BluetoothAdapterStateMachine.this.mEventLoop.start();
                int pollCount = 5;
                while (pollCount-- > 0 && !eventLoopStarted) {
                    if (BluetoothAdapterStateMachine.this.mEventLoop.isEventLoopRunning()) {
                        eventLoopStarted = true;
                        continue block2;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        BluetoothAdapterStateMachine.log("prepareBluetooth sleep interrupted: " + pollCount);
                        continue block2;
                    }
                }
            }
            if (!eventLoopStarted) {
                BluetoothAdapterStateMachine.this.mBluetoothService.disableNative();
                return false;
            }
            if (!BluetoothAdapterStateMachine.this.mBluetoothService.prepareBluetooth()) {
                BluetoothAdapterStateMachine.this.mEventLoop.stop();
                BluetoothAdapterStateMachine.this.mBluetoothService.disableNative();
                return false;
            }
            BluetoothAdapterStateMachine.this.sendMessageDelayed(104, 10000L);
            return true;
        }
    }
}

