/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.server.BluetoothInputProfileHandler;
import android.server.BluetoothService;
import android.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class BluetoothBondState {
    private static final String TAG = "BluetoothBondState";
    private static final boolean DBG = true;
    private final HashMap<String, Integer> mState = new HashMap();
    private final HashMap<String, Integer> mPinAttempt = new HashMap();
    private static final String AUTO_PAIRING_BLACKLIST = "/etc/bluetooth/auto_pairing.conf";
    private static final String DYNAMIC_AUTO_PAIRING_BLACKLIST = "/data/misc/bluetooth/dynamic_auto_pairing.conf";
    private ArrayList<String> mAutoPairingAddressBlacklist;
    private ArrayList<String> mAutoPairingExactNameBlacklist;
    private ArrayList<String> mAutoPairingPartialNameBlacklist;
    private ArrayList<String> mAutoPairingFixedPinZerosKeyboardList;
    private ArrayList<String> mAutoPairingDynamicAddressBlacklist;
    private String mPendingOutgoingBonding;
    private final Context mContext;
    private final BluetoothService mService;
    private final BluetoothInputProfileHandler mBluetoothInputProfileHandler;
    private BluetoothA2dp mA2dpProxy;
    private BluetoothHeadset mHeadsetProxy;
    private ArrayList<String> mPairingRequestRcvd = new ArrayList();
    private BluetoothProfile.ServiceListener mProfileServiceListener = new BluetoothProfile.ServiceListener(){

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile == 2) {
                BluetoothBondState.this.mA2dpProxy = (BluetoothA2dp)proxy;
            } else if (profile == 1) {
                BluetoothBondState.this.mHeadsetProxy = (BluetoothHeadset)proxy;
            }
        }

        public void onServiceDisconnected(int profile) {
            if (profile == 2) {
                BluetoothBondState.this.mA2dpProxy = null;
            } else if (profile == 1) {
                BluetoothBondState.this.mHeadsetProxy = null;
            }
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            String action = intent.getAction();
            if (action.equals("android.bluetooth.device.action.PAIRING_REQUEST")) {
                BluetoothDevice dev = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                String address = dev.getAddress();
                BluetoothBondState.this.mPairingRequestRcvd.add(address);
            }
        }
    };

    BluetoothBondState(Context context, BluetoothService service) {
        this.mContext = context;
        this.mService = service;
        this.mBluetoothInputProfileHandler = BluetoothInputProfileHandler.getInstance(this.mContext, this.mService);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.device.action.PAIRING_REQUEST");
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.readAutoPairingData();
    }

    synchronized void setPendingOutgoingBonding(String address) {
        this.mPendingOutgoingBonding = address;
    }

    public synchronized String getPendingOutgoingBonding() {
        return this.mPendingOutgoingBonding;
    }

    public synchronized void initBondState() {
        this.getProfileProxy();
        this.loadBondState();
    }

    private void loadBondState() {
        if (this.mService.getBluetoothStateInternal() != 11) {
            return;
        }
        String val = this.mService.getAdapterProperties().getProperty("Devices");
        if (val == null) {
            return;
        }
        String[] bonds = val.split(",");
        if (bonds == null) {
            return;
        }
        this.mState.clear();
        Log.d(TAG, "found " + bonds.length + " bonded devices");
        for (String device : bonds) {
            this.mState.put(this.mService.getAddressFromObjectPath(device).toUpperCase(), 12);
        }
    }

    public synchronized void setBondState(String address, int state) {
        this.setBondState(address, state, 0);
    }

    public synchronized void setBondState(String address, int state, int reason) {
        Log.d(TAG, "setBondState address " + state + "reason: " + reason);
        int oldState = this.getBondState(address);
        if (oldState == state) {
            return;
        }
        if (oldState == 11 && address.equals(this.mPendingOutgoingBonding)) {
            this.mPendingOutgoingBonding = null;
        }
        if (state == 12) {
            boolean setTrust = false;
            if (this.mPairingRequestRcvd.contains(address)) {
                setTrust = true;
            }
            this.mService.addProfileState(address, setTrust);
            this.mPairingRequestRcvd.remove(address);
        } else if (state == 11) {
            if (this.mA2dpProxy == null || this.mHeadsetProxy == null) {
                this.getProfileProxy();
            }
        } else if (state == 10) {
            this.mPairingRequestRcvd.remove(address);
        }
        this.setProfilePriorities(address, state);
        Log.d(TAG, address + " bond state " + oldState + " -> " + state + " (" + reason + ")");
        Intent intent = new Intent("android.bluetooth.device.action.BOND_STATE_CHANGED");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mService.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.BOND_STATE", state);
        intent.putExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", oldState);
        if (state == 10) {
            if (reason <= 0) {
                Log.w(TAG, "setBondState() called to unbond device, but reason code is invalid. Overriding reason code with BOND_RESULT_REMOVED");
                reason = 9;
            }
            intent.putExtra("android.bluetooth.device.extra.REASON", reason);
            this.mState.remove(address);
        } else {
            this.mState.put(address, state);
        }
        this.mContext.sendBroadcast(intent, "android.permission.BLUETOOTH");
    }

    public boolean isAutoPairingBlacklisted(String address) {
        String name;
        if (this.mAutoPairingAddressBlacklist != null) {
            for (String blacklistAddress : this.mAutoPairingAddressBlacklist) {
                if (!address.startsWith(blacklistAddress)) continue;
                return true;
            }
        }
        if (this.mAutoPairingDynamicAddressBlacklist != null) {
            for (String blacklistAddress : this.mAutoPairingDynamicAddressBlacklist) {
                if (!address.equals(blacklistAddress)) continue;
                return true;
            }
        }
        if ((name = this.mService.getRemoteName(address)) != null) {
            if (this.mAutoPairingExactNameBlacklist != null) {
                for (String blacklistName : this.mAutoPairingExactNameBlacklist) {
                    if (!name.equals(blacklistName)) continue;
                    return true;
                }
            }
            if (this.mAutoPairingPartialNameBlacklist != null) {
                for (String blacklistName : this.mAutoPairingPartialNameBlacklist) {
                    if (!name.startsWith(blacklistName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFixedPinZerosAutoPairKeyboard(String address) {
        if (this.mAutoPairingFixedPinZerosKeyboardList != null) {
            for (String blacklistAddress : this.mAutoPairingFixedPinZerosKeyboardList) {
                if (!address.startsWith(blacklistAddress)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized int getBondState(String address) {
        Integer state = this.mState.get(address);
        if (state == null) {
            return 10;
        }
        return state;
    }

    synchronized String[] listInState(int state) {
        ArrayList<String> result = new ArrayList<String>(this.mState.size());
        for (Map.Entry<String, Integer> e : this.mState.entrySet()) {
            if (e.getValue() != state) continue;
            result.add(e.getKey());
        }
        return result.toArray(new String[result.size()]);
    }

    public synchronized void addAutoPairingFailure(String address) {
        if (this.mAutoPairingDynamicAddressBlacklist == null) {
            this.mAutoPairingDynamicAddressBlacklist = new ArrayList();
        }
        this.updateAutoPairingData(address);
        this.mAutoPairingDynamicAddressBlacklist.add(address);
    }

    public synchronized boolean isAutoPairingAttemptsInProgress(String address) {
        return this.getAttempt(address) != 0;
    }

    public synchronized void clearPinAttempts(String address) {
        Log.d(TAG, "clearPinAttempts: " + address);
        this.mPinAttempt.remove(address);
    }

    public synchronized boolean hasAutoPairingFailed(String address) {
        if (this.mAutoPairingDynamicAddressBlacklist == null) {
            return false;
        }
        return this.mAutoPairingDynamicAddressBlacklist.contains(address);
    }

    public synchronized int getAttempt(String address) {
        Integer attempt = this.mPinAttempt.get(address);
        if (attempt == null) {
            return 0;
        }
        return attempt;
    }

    public synchronized void attempt(String address) {
        Integer attempt = this.mPinAttempt.get(address);
        int newAttempt = attempt == null ? 1 : attempt + 1;
        Log.d(TAG, "attemp newAttempt: " + newAttempt);
        this.mPinAttempt.put(address, new Integer(newAttempt));
    }

    private void getProfileProxy() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mA2dpProxy == null) {
            bluetoothAdapter.getProfileProxy(this.mContext, this.mProfileServiceListener, 2);
        }
        if (this.mHeadsetProxy == null) {
            bluetoothAdapter.getProfileProxy(this.mContext, this.mProfileServiceListener, 1);
        }
    }

    private void closeProfileProxy() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mA2dpProxy != null) {
            bluetoothAdapter.closeProfileProxy(2, this.mA2dpProxy);
        }
        if (this.mHeadsetProxy != null) {
            bluetoothAdapter.closeProfileProxy(1, this.mHeadsetProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAutoPairingData() {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            File file = new File(DYNAMIC_AUTO_PAIRING_BLACKLIST);
            if (file.exists()) {
                return;
            }
            in = new FileInputStream(AUTO_PAIRING_BLACKLIST);
            out = new FileOutputStream(DYNAMIC_AUTO_PAIRING_BLACKLIST);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "FileNotFoundException: copyAutoPairingData " + e);
        }
        catch (IOException e) {
            Log.e(TAG, "IOException: copyAutoPairingData " + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readAutoPairingData() {
        if (this.mAutoPairingAddressBlacklist != null) {
            return;
        }
        this.copyAutoPairingData();
        FileInputStream fstream = null;
        try {
            String line;
            fstream = new FileInputStream(DYNAMIC_AUTO_PAIRING_BLACKLIST);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader file = new BufferedReader(new InputStreamReader(in));
            while ((line = file.readLine()) != null) {
                String[] value;
                if ((line = line.trim()).length() == 0 || line.startsWith("//") || (value = line.split("=")) == null || value.length != 2) continue;
                String[] val = value[1].split(",");
                if (value[0].equalsIgnoreCase("AddressBlacklist")) {
                    this.mAutoPairingAddressBlacklist = new ArrayList<String>(Arrays.asList(val));
                    continue;
                }
                if (value[0].equalsIgnoreCase("ExactNameBlacklist")) {
                    this.mAutoPairingExactNameBlacklist = new ArrayList<String>(Arrays.asList(val));
                    continue;
                }
                if (value[0].equalsIgnoreCase("PartialNameBlacklist")) {
                    this.mAutoPairingPartialNameBlacklist = new ArrayList<String>(Arrays.asList(val));
                    continue;
                }
                if (value[0].equalsIgnoreCase("FixedPinZerosKeyboardBlacklist")) {
                    this.mAutoPairingFixedPinZerosKeyboardList = new ArrayList<String>(Arrays.asList(val));
                    continue;
                }
                if (value[0].equalsIgnoreCase("DynamicAddressBlacklist")) {
                    this.mAutoPairingDynamicAddressBlacklist = new ArrayList<String>(Arrays.asList(val));
                    continue;
                }
                Log.e(TAG, "Error parsing Auto pairing blacklist file");
            }
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "FileNotFoundException: readAutoPairingData " + e);
        }
        catch (IOException e) {
            Log.e(TAG, "IOException: readAutoPairingData " + e);
        }
        finally {
            if (fstream != null) {
                try {
                    fstream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAutoPairingData(String address) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(DYNAMIC_AUTO_PAIRING_BLACKLIST, true));
            StringBuilder str = new StringBuilder();
            if (this.mAutoPairingDynamicAddressBlacklist.size() == 0) {
                str.append("DynamicAddressBlacklist=");
            }
            str.append(address);
            str.append(",");
            out.write(str.toString());
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "FileNotFoundException: updateAutoPairingData " + e);
        }
        catch (IOException e) {
            Log.e(TAG, "IOException: updateAutoPairingData " + e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void setProfilePriorities(String address, int state) {
        BluetoothDevice remoteDevice = this.mService.getRemoteDevice(address);
        this.mBluetoothInputProfileHandler.setInitialInputDevicePriority(remoteDevice, state);
        if (state == 12) {
            if (this.mA2dpProxy != null && this.mA2dpProxy.getPriority(remoteDevice) == -1) {
                this.mA2dpProxy.setPriority(remoteDevice, 100);
            }
            if (this.mHeadsetProxy != null && this.mHeadsetProxy.getPriority(remoteDevice) == -1) {
                this.mHeadsetProxy.setPriority(remoteDevice, 100);
            }
        } else if (state == 10) {
            if (this.mA2dpProxy != null) {
                this.mA2dpProxy.setPriority(remoteDevice, -1);
            }
            if (this.mHeadsetProxy != null) {
                this.mHeadsetProxy.setPriority(remoteDevice, -1);
            }
        }
        if (this.mA2dpProxy == null || this.mHeadsetProxy == null) {
            Log.e(TAG, "Proxy is null:" + this.mA2dpProxy + ":" + this.mHeadsetProxy);
        }
    }
}

