/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.server.BluetoothService;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BluetoothDeviceProperties {
    private static final String TAG = "BluetoothDeviceProperties";
    private final HashMap<String, Map<String, String>> mPropertiesMap = new HashMap();
    private final BluetoothService mService;

    BluetoothDeviceProperties(BluetoothService service) {
        this.mService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> addProperties(String address, String[] properties) {
        Map<String, String> propertyValues;
        HashMap<String, Map<String, String>> hashMap = this.mPropertiesMap;
        synchronized (hashMap) {
            propertyValues = this.mPropertiesMap.get(address);
            if (propertyValues == null) {
                propertyValues = new HashMap<String, String>();
            }
            for (int i = 0; i < properties.length; ++i) {
                String name = properties[i];
                String newValue = null;
                if (name == null) {
                    Log.e(TAG, "Error: Remote Device Property at index " + i + " is null");
                    continue;
                }
                if (name.equals("UUIDs") || name.equals("Nodes")) {
                    StringBuilder str = new StringBuilder();
                    int len = Integer.valueOf(properties[++i]);
                    for (int j = 0; j < len; ++j) {
                        str.append(properties[++i]);
                        str.append(",");
                    }
                    if (len > 0) {
                        newValue = str.toString();
                    }
                } else {
                    newValue = properties[++i];
                }
                propertyValues.put(name, newValue);
            }
            this.mPropertiesMap.put(address, propertyValues);
        }
        this.mService.updateDeviceServiceChannelCache(address);
        return propertyValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProperty(String address, String name, String value) {
        HashMap<String, Map<String, String>> hashMap = this.mPropertiesMap;
        synchronized (hashMap) {
            Map<String, String> propVal = this.mPropertiesMap.get(address);
            if (propVal != null) {
                propVal.put(name, value);
                this.mPropertiesMap.put(address, propVal);
            } else {
                Log.e(TAG, "setRemoteDeviceProperty for a device not in cache:" + address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInCache(String address) {
        HashMap<String, Map<String, String>> hashMap = this.mPropertiesMap;
        synchronized (hashMap) {
            return this.mPropertiesMap.get(address) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        HashMap<String, Map<String, String>> hashMap = this.mPropertiesMap;
        synchronized (hashMap) {
            return this.mPropertiesMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> keySet() {
        HashMap<String, Map<String, String>> hashMap = this.mPropertiesMap;
        synchronized (hashMap) {
            return this.mPropertiesMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getProperty(String address, String property) {
        HashMap<String, Map<String, String>> hashMap = this.mPropertiesMap;
        synchronized (hashMap) {
            Map<String, String> properties = this.mPropertiesMap.get(address);
            if (properties != null) {
                return properties.get(property);
            }
            properties = this.updateCache(address);
            if (properties != null) {
                return properties.get(property);
            }
        }
        Log.e(TAG, "getRemoteDeviceProperty: " + property + " not present: " + address);
        return null;
    }

    Map<String, String> updateCache(String address) {
        String[] propValues = this.mService.getRemoteDeviceProperties(address);
        if (propValues != null) {
            return this.addProperties(address, propValues);
        }
        return null;
    }
}

