/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothUuid;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelUuid;
import android.os.PowerManager;
import android.server.BluetoothAdapterProperties;
import android.server.BluetoothAdapterStateMachine;
import android.server.BluetoothDeviceProperties;
import android.server.BluetoothService;
import android.util.Log;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BluetoothEventLoop {
    private static final String TAG = "BluetoothEventLoop";
    private static final boolean DBG = false;
    private int mNativeData;
    private Thread mThread;
    private boolean mStarted;
    private boolean mInterrupted;
    private final HashMap<String, Integer> mPasskeyAgentRequestData;
    private final HashMap<String, Integer> mAuthorizationAgentRequestData;
    private final BluetoothService mBluetoothService;
    private final BluetoothAdapter mAdapter;
    private final BluetoothAdapterStateMachine mBluetoothState;
    private BluetoothA2dp mA2dp;
    private final Context mContext;
    private PowerManager.WakeLock mWakeLock;
    private static final int EVENT_PAIRING_CONSENT_DELAYED_ACCEPT = 1;
    private static final int EVENT_AGENT_CANCEL = 2;
    private static final int CREATE_DEVICE_ALREADY_EXISTS = 1;
    private static final int CREATE_DEVICE_SUCCESS = 0;
    private static final int CREATE_DEVICE_FAILED = -1;
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            String address = null;
            switch (msg.what) {
                case 1: {
                    address = (String)msg.obj;
                    if (address == null) break;
                    BluetoothEventLoop.this.mBluetoothService.setPairingConfirmation(address, true);
                    break;
                }
                case 2: {
                    String[] devices = BluetoothEventLoop.this.mBluetoothService.listInState(11);
                    if (devices.length == 0) break;
                    if (devices.length > 1) {
                        Log.e(BluetoothEventLoop.TAG, " There is more than one device in the Bonding State");
                        break;
                    }
                    address = devices[0];
                    BluetoothEventLoop.this.mBluetoothService.setBondState(address, 10, 8);
                }
            }
        }
    };
    private BluetoothProfile.ServiceListener mProfileServiceListener = new BluetoothProfile.ServiceListener(){

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile == 2) {
                BluetoothEventLoop.this.mA2dp = (BluetoothA2dp)proxy;
            }
        }

        public void onServiceDisconnected(int profile) {
            if (profile == 2) {
                BluetoothEventLoop.this.mA2dp = null;
            }
        }
    };

    private static native void classInitNative();

    BluetoothEventLoop(Context context, BluetoothAdapter adapter, BluetoothService bluetoothService, BluetoothAdapterStateMachine bluetoothState) {
        this.mBluetoothService = bluetoothService;
        this.mContext = context;
        this.mBluetoothState = bluetoothState;
        this.mPasskeyAgentRequestData = new HashMap();
        this.mAuthorizationAgentRequestData = new HashMap();
        this.mAdapter = adapter;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(805306394, TAG);
        this.mWakeLock.setReferenceCounted(false);
        this.initializeNativeDataNative();
    }

    void getProfileProxy() {
        this.mAdapter.getProfileProxy(this.mContext, this.mProfileServiceListener, 2);
        this.mAdapter.getProfileProxy(this.mContext, this.mProfileServiceListener, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cleanupNativeDataNative();
        }
        finally {
            super.finalize();
        }
    }

    HashMap<String, Integer> getPasskeyAgentRequestData() {
        return this.mPasskeyAgentRequestData;
    }

    HashMap<String, Integer> getAuthorizationAgentRequestData() {
        return this.mAuthorizationAgentRequestData;
    }

    void start() {
        if (!this.isEventLoopRunningNative()) {
            this.startEventLoopNative();
        }
    }

    public void stop() {
        if (this.isEventLoopRunningNative()) {
            this.stopEventLoopNative();
        }
    }

    public boolean isEventLoopRunning() {
        return this.isEventLoopRunningNative();
    }

    private void addDevice(String address, String[] properties) {
        BluetoothDeviceProperties deviceProperties = this.mBluetoothService.getDeviceProperties();
        deviceProperties.addProperties(address, properties);
        String rssi = deviceProperties.getProperty(address, "RSSI");
        String classValue = deviceProperties.getProperty(address, "Class");
        String name = deviceProperties.getProperty(address, "Name");
        short rssiValue = rssi != null ? (short)((short)Integer.valueOf(rssi).intValue()) : (short)Short.MIN_VALUE;
        if (classValue != null) {
            Intent intent = new Intent("android.bluetooth.device.action.FOUND");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
            intent.putExtra("android.bluetooth.device.extra.CLASS", new BluetoothClass(Integer.valueOf(classValue)));
            intent.putExtra("android.bluetooth.device.extra.RSSI", rssiValue);
            intent.putExtra("android.bluetooth.device.extra.NAME", name);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else {
            BluetoothEventLoop.log("ClassValue: " + classValue + " for remote device: " + address + " is null");
        }
    }

    private void onDeviceFound(String address, String[] properties) {
        if (properties == null) {
            Log.e(TAG, "ERROR: Remote device properties are null");
            return;
        }
        this.addDevice(address, properties);
    }

    private void onDeviceDisappeared(String address) {
        Intent intent = new Intent("android.bluetooth.device.action.DISAPPEARED");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
    }

    private void onDeviceDisconnectRequested(String deviceObjectPath) {
        String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
        if (address == null) {
            Log.e(TAG, "onDeviceDisconnectRequested: Address of the remote device in null");
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
    }

    private void onCreatePairedDeviceResult(String address, int result) {
        address = address.toUpperCase();
        this.mBluetoothService.onCreatePairedDeviceResult(address, result);
    }

    private void onDeviceCreated(String deviceObjectPath) {
        String[] properties;
        String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
        if (!this.mBluetoothService.isRemoteDeviceInCache(address) && (properties = this.mBluetoothService.getRemoteDeviceProperties(address)) != null) {
            this.addDevice(address, properties);
        }
    }

    private void onDeviceRemoved(String deviceObjectPath) {
        String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
        if (address != null) {
            this.mBluetoothService.setBondState(address.toUpperCase(), 10, 9);
            this.mBluetoothService.setRemoteDeviceProperty(address, "UUIDs", null);
        }
    }

    void onPropertyChanged(String[] propValues) {
        BluetoothAdapterProperties adapterProperties = this.mBluetoothService.getAdapterProperties();
        if (adapterProperties.isEmpty()) {
            adapterProperties.getAllProperties();
        }
        BluetoothEventLoop.log("Property Changed: " + propValues[0] + " : " + propValues[1]);
        String name = propValues[0];
        if (name.equals("Name")) {
            adapterProperties.setProperty(name, propValues[1]);
            Intent intent = new Intent("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED");
            intent.putExtra("android.bluetooth.adapter.extra.LOCAL_NAME", propValues[1]);
            intent.addFlags(0x10000000);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else if (name.equals("Pairable") || name.equals("Discoverable")) {
            String discoverable;
            adapterProperties.setProperty(name, propValues[1]);
            if (name.equals("Discoverable")) {
                this.mBluetoothState.sendMessage(53);
            }
            String pairable = name.equals("Pairable") ? propValues[1] : adapterProperties.getProperty("Pairable");
            String string2 = discoverable = name.equals("Discoverable") ? propValues[1] : adapterProperties.getProperty("Discoverable");
            if (pairable == null || discoverable == null) {
                return;
            }
            int mode = BluetoothService.bluezStringToScanMode(pairable.equals("true"), discoverable.equals("true"));
            if (mode >= 0) {
                Intent intent = new Intent("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
                intent.putExtra("android.bluetooth.adapter.extra.SCAN_MODE", mode);
                intent.addFlags(0x10000000);
                this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            }
        } else if (name.equals("Discovering")) {
            Intent intent;
            adapterProperties.setProperty(name, propValues[1]);
            if (propValues[1].equals("true")) {
                intent = new Intent("android.bluetooth.adapter.action.DISCOVERY_STARTED");
            } else {
                this.mBluetoothService.cancelDiscovery();
                intent = new Intent("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
            }
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else if (name.equals("Devices") || name.equals("UUIDs")) {
            String value = null;
            int len = Integer.valueOf(propValues[1]);
            if (len > 0) {
                StringBuilder str = new StringBuilder();
                for (int i = 2; i < propValues.length; ++i) {
                    str.append(propValues[i]);
                    str.append(",");
                }
                value = str.toString();
            }
            adapterProperties.setProperty(name, value);
            if (name.equals("UUIDs")) {
                this.mBluetoothService.updateBluetoothState(value);
            }
        } else if (name.equals("Powered")) {
            this.mBluetoothState.sendMessage(54, propValues[1].equals("true") ? new Boolean(true) : new Boolean(false));
        } else if (name.equals("DiscoverableTimeout")) {
            adapterProperties.setProperty(name, propValues[1]);
        }
    }

    private void onDevicePropertyChanged(String deviceObjectPath, String[] propValues) {
        String name = propValues[0];
        String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
        if (address == null) {
            Log.e(TAG, "onDevicePropertyChanged: Address of the remote device in null");
            return;
        }
        BluetoothEventLoop.log("Device property changed: " + address + " property: " + name + " value: " + propValues[1]);
        BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
        if (name.equals("Name")) {
            this.mBluetoothService.setRemoteDeviceProperty(address, name, propValues[1]);
            Intent intent = new Intent("android.bluetooth.device.action.NAME_CHANGED");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", device);
            intent.putExtra("android.bluetooth.device.extra.NAME", propValues[1]);
            intent.addFlags(0x10000000);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else if (name.equals("Alias")) {
            this.mBluetoothService.setRemoteDeviceProperty(address, name, propValues[1]);
        } else if (name.equals("Class")) {
            this.mBluetoothService.setRemoteDeviceProperty(address, name, propValues[1]);
            Intent intent = new Intent("android.bluetooth.device.action.CLASS_CHANGED");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", device);
            intent.putExtra("android.bluetooth.device.extra.CLASS", new BluetoothClass(Integer.valueOf(propValues[1])));
            intent.addFlags(0x10000000);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else if (name.equals("Connected")) {
            this.mBluetoothService.setRemoteDeviceProperty(address, name, propValues[1]);
            Intent intent = null;
            if (propValues[1].equals("true")) {
                intent = new Intent("android.bluetooth.device.action.ACL_CONNECTED");
                if (this.mBluetoothService.isBluetoothDock(address)) {
                    this.mBluetoothService.setLinkTimeout(address, 8000);
                }
            } else {
                intent = new Intent("android.bluetooth.device.action.ACL_DISCONNECTED");
            }
            intent.putExtra("android.bluetooth.device.extra.DEVICE", device);
            intent.addFlags(0x10000000);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        } else if (name.equals("UUIDs")) {
            String uuid = null;
            int len = Integer.valueOf(propValues[1]);
            if (len > 0) {
                StringBuilder str = new StringBuilder();
                for (int i = 2; i < propValues.length; ++i) {
                    str.append(propValues[i]);
                    str.append(",");
                }
                uuid = str.toString();
            }
            this.mBluetoothService.setRemoteDeviceProperty(address, name, uuid);
            this.mBluetoothService.updateDeviceServiceChannelCache(address);
            this.mBluetoothService.sendUuidIntent(address);
        } else if (name.equals("Paired")) {
            if (propValues[1].equals("true")) {
                if (null == this.mBluetoothService.getPendingOutgoingBonding()) {
                    this.mBluetoothService.setBondState(address, 12);
                }
            } else {
                this.mBluetoothService.setBondState(address, 10);
                this.mBluetoothService.setRemoteDeviceProperty(address, "Trusted", "false");
            }
        } else if (name.equals("Trusted")) {
            this.mBluetoothService.setRemoteDeviceProperty(address, name, propValues[1]);
        }
    }

    private void onInputDevicePropertyChanged(String path, String[] propValues) {
        String address = this.mBluetoothService.getAddressFromObjectPath(path);
        if (address == null) {
            Log.e(TAG, "onInputDevicePropertyChanged: Address of the remote device is null");
            return;
        }
        BluetoothEventLoop.log("Input Device : Name of Property is: " + propValues[0]);
        boolean state = false;
        if (propValues[1].equals("true")) {
            state = true;
        }
        this.mBluetoothService.handleInputDevicePropertyChange(address, state);
    }

    private void onPanDevicePropertyChanged(String deviceObjectPath, String[] propValues) {
        String iface;
        String name = propValues[0];
        String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
        if (address == null) {
            Log.e(TAG, "onPanDevicePropertyChanged: Address of the remote device in null");
            return;
        }
        BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
        if (name.equals("Connected")) {
            if (propValues[1].equals("false")) {
                this.mBluetoothService.handlePanDeviceStateChange(device, 0, 2);
            }
        } else if (name.equals("Interface") && !(iface = propValues[1]).equals("")) {
            this.mBluetoothService.handlePanDeviceStateChange(device, iface, 2, 2);
        }
    }

    private String checkPairingRequestAndGetAddress(String objectPath, int nativeData) {
        String address = this.mBluetoothService.getAddressFromObjectPath(objectPath);
        if (address == null) {
            Log.e(TAG, "Unable to get device address in checkPairingRequestAndGetAddress, returning null");
            return null;
        }
        address = address.toUpperCase();
        this.mPasskeyAgentRequestData.put(address, new Integer(nativeData));
        if (this.mBluetoothService.getBluetoothState() == 13) {
            this.mBluetoothService.cancelPairingUserInput(address);
            return null;
        }
        if (this.mBluetoothService.getBondState(address) != 12) {
            this.mBluetoothService.setBondState(address, 11);
        }
        return address;
    }

    private void onRequestPairingConsent(String objectPath, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        if (this.mBluetoothService.getBondState(address) == 12) {
            Message message = this.mHandler.obtainMessage(1);
            message.obj = address;
            this.mHandler.sendMessageDelayed(message, 1500L);
            return;
        }
        this.mWakeLock.acquire();
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 3);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        this.mWakeLock.release();
    }

    private void onRequestPasskeyConfirmation(String objectPath, int passkey, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        this.mWakeLock.acquire();
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_KEY", passkey);
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 2);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        this.mWakeLock.release();
    }

    private void onRequestPasskey(String objectPath, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        this.mWakeLock.acquire();
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 1);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        this.mWakeLock.release();
    }

    private void onRequestPinCode(String objectPath, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        String pendingOutgoingAddress = this.mBluetoothService.getPendingOutgoingBonding();
        BluetoothClass btClass = new BluetoothClass(this.mBluetoothService.getRemoteClass(address));
        int btDeviceClass = btClass.getDeviceClass();
        if (address.equals(pendingOutgoingAddress)) {
            if (this.mBluetoothService.isBluetoothDock(address)) {
                String pin = this.mBluetoothService.getDockPin();
                this.mBluetoothService.setPin(address, BluetoothDevice.convertPinToBytes(pin));
                return;
            }
            switch (btDeviceClass) {
                case 1028: 
                case 1032: 
                case 1048: 
                case 1052: 
                case 1064: {
                    if (!this.mBluetoothService.attemptAutoPair(address)) break;
                    return;
                }
            }
        }
        if (btDeviceClass == 1344 || btDeviceClass == 1472) {
            if (this.mBluetoothService.isFixedPinZerosAutoPairKeyboard(address)) {
                this.mBluetoothService.setPin(address, BluetoothDevice.convertPinToBytes("0000"));
                return;
            }
            int pin = (int)Math.floor(Math.random() * 10000.0);
            this.sendDisplayPinIntent(address, pin);
            return;
        }
        this.mWakeLock.acquire();
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 0);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        this.mWakeLock.release();
    }

    private void onDisplayPasskey(String objectPath, int passkey, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        this.mWakeLock.acquire();
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_KEY", passkey);
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 4);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        this.mWakeLock.release();
    }

    private void sendDisplayPinIntent(String address, int pin) {
        this.mWakeLock.acquire();
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_KEY", pin);
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 5);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        this.mWakeLock.release();
    }

    private void onRequestOobData(String objectPath, int nativeData) {
        String address = this.checkPairingRequestAndGetAddress(objectPath, nativeData);
        if (address == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 6);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onAgentAuthorize(String objectPath, String deviceUuid, int nativeData) {
        if (!this.mBluetoothService.isEnabled()) {
            return;
        }
        String address = this.mBluetoothService.getAddressFromObjectPath(objectPath);
        if (address == null) {
            Log.e(TAG, "Unable to get device address in onAuthAgentAuthorize");
            return;
        }
        boolean authorized = false;
        ParcelUuid uuid = ParcelUuid.fromString(deviceUuid);
        BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
        this.mAuthorizationAgentRequestData.put(address, new Integer(nativeData));
        if (this.mA2dp != null && (BluetoothUuid.isAudioSource(uuid) || BluetoothUuid.isAvrcpTarget(uuid) || BluetoothUuid.isAdvAudioDist(uuid)) && !this.isOtherSinkInNonDisconnectedState(address)) {
            boolean bl = authorized = this.mA2dp.getPriority(device) > 0;
            if (authorized && !BluetoothUuid.isAvrcpTarget(uuid)) {
                Log.i(TAG, "First check pass for incoming A2DP / AVRCP connection from " + address);
                this.mBluetoothService.notifyIncomingA2dpConnection(address, false);
            } else {
                Log.i(TAG, "" + authorized + "Incoming A2DP / AVRCP connection from " + address);
                this.mA2dp.allowIncomingConnect(device, authorized);
                this.mBluetoothService.notifyIncomingA2dpConnection(address, true);
            }
        } else if (BluetoothUuid.isInputDevice(uuid)) {
            boolean bl = authorized = this.mBluetoothService.getInputDevicePriority(device) > 0;
            if (authorized) {
                Log.i(TAG, "First check pass for incoming HID connection from " + address);
                this.mBluetoothService.notifyIncomingHidConnection(address);
            } else {
                Log.i(TAG, "Rejecting incoming HID connection from " + address);
                this.mBluetoothService.allowIncomingProfileConnect(device, authorized);
            }
        } else if (BluetoothUuid.isBnep(uuid)) {
            authorized = this.mBluetoothService.allowIncomingTethering();
            this.mBluetoothService.allowIncomingProfileConnect(device, authorized);
        } else {
            Log.i(TAG, "Rejecting incoming " + deviceUuid + " connection from " + address);
            this.mBluetoothService.allowIncomingProfileConnect(device, authorized);
        }
        BluetoothEventLoop.log("onAgentAuthorize(" + objectPath + ", " + deviceUuid + ") = " + authorized);
    }

    private boolean onAgentOutOfBandDataAvailable(String objectPath) {
        if (!this.mBluetoothService.isEnabled()) {
            return false;
        }
        String address = this.mBluetoothService.getAddressFromObjectPath(objectPath);
        if (address == null) {
            return false;
        }
        return this.mBluetoothService.getDeviceOutOfBandData(this.mAdapter.getRemoteDevice(address)) != null;
    }

    private boolean isOtherSinkInNonDisconnectedState(String address) {
        List<BluetoothDevice> devices = this.mA2dp.getDevicesMatchingConnectionStates(new int[]{2, 1, 3});
        if (devices.size() == 0) {
            return false;
        }
        for (BluetoothDevice dev : devices) {
            if (dev.getAddress().equals(address)) continue;
            return true;
        }
        return false;
    }

    private void onAgentCancel() {
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_CANCEL");
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), 1500L);
    }

    private void onDiscoverServicesResult(String deviceObjectPath, boolean result) {
        String address = this.mBluetoothService.getAddressFromObjectPath(deviceObjectPath);
        if (address == null) {
            return;
        }
        if (result) {
            this.mBluetoothService.updateRemoteDevicePropertiesCache(address);
        }
        this.mBluetoothService.sendUuidIntent(address);
        this.mBluetoothService.makeServiceChannelCallbacks(address);
    }

    private void onCreateDeviceResult(String address, int result) {
        switch (result) {
            case 1: {
                String path = this.mBluetoothService.getObjectPathFromAddress(address);
                if (path != null) {
                    this.mBluetoothService.discoverServicesNative(path, "");
                    break;
                }
                Log.w(TAG, "Device exists, but we don't have the bluez path, failing");
            }
            case -1: {
                this.mBluetoothService.sendUuidIntent(address);
                this.mBluetoothService.makeServiceChannelCallbacks(address);
                break;
            }
        }
    }

    private void onInputDeviceConnectionResult(String path, int result) {
        if (result != 5004) {
            String address = this.mBluetoothService.getAddressFromObjectPath(path);
            if (address == null) {
                return;
            }
            boolean connected = false;
            BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
            int state = this.mBluetoothService.getInputDeviceConnectionState(device);
            if (state == 1) {
                connected = result == 5001;
            } else if (state == 3) {
                connected = result != 5000;
            } else {
                Log.e(TAG, "Error onInputDeviceConnectionResult. State is:" + state);
            }
            this.mBluetoothService.handleInputDevicePropertyChange(address, connected);
        }
    }

    private void onPanDeviceConnectionResult(String path, int result) {
        BluetoothEventLoop.log("onPanDeviceConnectionResult " + path + " " + result);
        if (result != 1004) {
            String address = this.mBluetoothService.getAddressFromObjectPath(path);
            if (address == null) {
                return;
            }
            boolean connected = false;
            BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
            int state = this.mBluetoothService.getPanDeviceConnectionState(device);
            if (state == 1) {
                connected = result == 1001;
            } else if (state == 3) {
                connected = result != 1000;
            } else {
                Log.e(TAG, "Error onPanDeviceConnectionResult. State is: " + state + " result: " + result);
            }
            int newState = connected ? 2 : 0;
            this.mBluetoothService.handlePanDeviceStateChange(device, newState, 2);
        }
    }

    private void onHealthDeviceConnectionResult(int chanCode, int result) {
        BluetoothEventLoop.log("onHealthDeviceConnectionResult " + chanCode + " " + result);
        if (result != 6000) {
            this.mBluetoothService.onHealthDeviceChannelConnectionError(chanCode, 0);
        }
    }

    private void onNetworkDeviceDisconnected(String address) {
        BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
        this.mBluetoothService.handlePanDeviceStateChange(device, 0, 1);
    }

    private void onNetworkDeviceConnected(String address, String iface, int destUuid) {
        BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
        this.mBluetoothService.handlePanDeviceStateChange(device, iface, 2, 1);
    }

    private void onHealthDevicePropertyChanged(String devicePath, String[] propValues) {
        BluetoothEventLoop.log("Health Device : Name of Property is: " + propValues[0] + " Value:" + propValues[1]);
        this.mBluetoothService.onHealthDevicePropertyChanged(devicePath, propValues[1]);
    }

    private void onHealthDeviceChannelChanged(String devicePath, String channelPath, boolean exists) {
        BluetoothEventLoop.log("Health Device : devicePath: " + devicePath + ":channelPath:" + channelPath + ":exists" + exists);
        this.mBluetoothService.onHealthDeviceChannelChanged(devicePath, channelPath, exists);
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private native void initializeNativeDataNative();

    private native void startEventLoopNative();

    private native void stopEventLoopNative();

    private native boolean isEventLoopRunningNative();

    private native void cleanupNativeDataNative();

    static {
        BluetoothEventLoop.classInitNative();
    }
}

