/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHealthAppConfiguration;
import android.bluetooth.IBluetoothHealthCallback;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.server.BluetoothService;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BluetoothHealthProfileHandler {
    private static final String TAG = "BluetoothHealthProfileHandler";
    private static final boolean DBG = false;
    private static BluetoothHealthProfileHandler sInstance;
    private BluetoothService mBluetoothService;
    private ArrayList<HealthChannel> mHealthChannels;
    private HashMap<BluetoothHealthAppConfiguration, String> mHealthAppConfigs;
    private HashMap<BluetoothDevice, Integer> mHealthDevices;
    private HashMap<BluetoothHealthAppConfiguration, IBluetoothHealthCallback> mCallbacks;
    private static final int MESSAGE_REGISTER_APPLICATION = 0;
    private static final int MESSAGE_UNREGISTER_APPLICATION = 1;
    private static final int MESSAGE_CONNECT_CHANNEL = 2;
    private static final AtomicInteger sChannelId;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    BluetoothHealthAppConfiguration registerApp = (BluetoothHealthAppConfiguration)msg.obj;
                    int role = registerApp.getRole();
                    String path = null;
                    path = role == 2 ? BluetoothHealthProfileHandler.this.mBluetoothService.registerHealthApplicationNative(registerApp.getDataType(), BluetoothHealthProfileHandler.this.getStringRole(role), registerApp.getName()) : BluetoothHealthProfileHandler.this.mBluetoothService.registerHealthApplicationNative(registerApp.getDataType(), BluetoothHealthProfileHandler.this.getStringRole(role), registerApp.getName(), BluetoothHealthProfileHandler.this.getStringChannelType(registerApp.getChannelType()));
                    if (path == null) {
                        BluetoothHealthProfileHandler.this.callHealthApplicationStatusCallback(registerApp, 1);
                        BluetoothHealthProfileHandler.this.mCallbacks.remove(registerApp);
                        break;
                    }
                    BluetoothHealthProfileHandler.this.mHealthAppConfigs.put(registerApp, path);
                    BluetoothHealthProfileHandler.this.callHealthApplicationStatusCallback(registerApp, 0);
                    break;
                }
                case 1: {
                    BluetoothHealthAppConfiguration unregisterApp = (BluetoothHealthAppConfiguration)msg.obj;
                    for (HealthChannel chan : BluetoothHealthProfileHandler.this.mHealthChannels) {
                        if (!chan.mConfig.equals(unregisterApp) || chan.mState == 0) continue;
                        BluetoothHealthProfileHandler.this.disconnectChannel(chan.mDevice, unregisterApp, chan.mId);
                    }
                    boolean result = BluetoothHealthProfileHandler.this.mBluetoothService.unregisterHealthApplicationNative((String)BluetoothHealthProfileHandler.this.mHealthAppConfigs.get(unregisterApp));
                    if (result) {
                        BluetoothHealthProfileHandler.this.callHealthApplicationStatusCallback(unregisterApp, 2);
                        BluetoothHealthProfileHandler.this.mCallbacks.remove(unregisterApp);
                        BluetoothHealthProfileHandler.this.mHealthAppConfigs.remove(unregisterApp);
                        break;
                    }
                    BluetoothHealthProfileHandler.this.callHealthApplicationStatusCallback(unregisterApp, 3);
                    break;
                }
                case 2: {
                    HealthChannel chan = (HealthChannel)msg.obj;
                    String deviceObjectPath = BluetoothHealthProfileHandler.this.mBluetoothService.getObjectPathFromAddress(chan.mDevice.getAddress());
                    String configPath = (String)BluetoothHealthProfileHandler.this.mHealthAppConfigs.get(chan.mConfig);
                    String channelType = BluetoothHealthProfileHandler.this.getStringChannelType(chan.mChannelType);
                    if (BluetoothHealthProfileHandler.this.mBluetoothService.createChannelNative(deviceObjectPath, configPath, channelType, chan.mId)) break;
                    int prevState = chan.mState;
                    int state = 0;
                    BluetoothHealthProfileHandler.this.callHealthChannelCallback(chan.mConfig, chan.mDevice, prevState, state, null, chan.mId);
                    BluetoothHealthProfileHandler.this.mHealthChannels.remove(chan);
                }
            }
        }
    };

    private BluetoothHealthProfileHandler(Context context, BluetoothService service) {
        this.mBluetoothService = service;
        this.mHealthAppConfigs = new HashMap();
        this.mHealthChannels = new ArrayList();
        this.mHealthDevices = new HashMap();
        this.mCallbacks = new HashMap();
    }

    static synchronized BluetoothHealthProfileHandler getInstance(Context context, BluetoothService service) {
        if (sInstance == null) {
            sInstance = new BluetoothHealthProfileHandler(context, service);
        }
        return sInstance;
    }

    boolean registerAppConfiguration(BluetoothHealthAppConfiguration config, IBluetoothHealthCallback callback) {
        Message msg = this.mHandler.obtainMessage(0);
        msg.obj = config;
        this.mHandler.sendMessage(msg);
        this.mCallbacks.put(config, callback);
        return true;
    }

    boolean unregisterAppConfiguration(BluetoothHealthAppConfiguration config) {
        String path = this.mHealthAppConfigs.get(config);
        if (path == null) {
            return false;
        }
        Message msg = this.mHandler.obtainMessage(1);
        msg.obj = config;
        this.mHandler.sendMessage(msg);
        return true;
    }

    boolean connectChannelToSource(BluetoothDevice device, BluetoothHealthAppConfiguration config) {
        return this.connectChannel(device, config, 12);
    }

    private HealthChannel getMainChannel(BluetoothDevice device, BluetoothHealthAppConfiguration config) {
        for (HealthChannel chan : this.mHealthChannels) {
            if (!chan.mDevice.equals(device) || !chan.mConfig.equals(config) || !chan.mMainChannel) continue;
            return chan;
        }
        return null;
    }

    boolean connectChannel(BluetoothDevice device, BluetoothHealthAppConfiguration config, int channelType) {
        String deviceObjectPath = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        if (deviceObjectPath == null) {
            return false;
        }
        String configPath = this.mHealthAppConfigs.get(config);
        if (configPath == null) {
            return false;
        }
        HealthChannel chan = new HealthChannel(device, config, null, false, null);
        chan.mState = 1;
        chan.mChannelType = channelType;
        this.mHealthChannels.add(chan);
        int prevState = 0;
        int state = 1;
        this.callHealthChannelCallback(config, device, prevState, state, null, chan.mId);
        Message msg = this.mHandler.obtainMessage(2);
        msg.obj = chan;
        this.mHandler.sendMessage(msg);
        return true;
    }

    private String getStringChannelType(int type) {
        if (type == 10) {
            return "Reliable";
        }
        if (type == 11) {
            return "Streaming";
        }
        return "Any";
    }

    private String getStringRole(int role) {
        if (role == 2) {
            return "Sink";
        }
        if (role == 1) {
            return "Streaming";
        }
        return null;
    }

    private int getChannelId() {
        int id2;
        boolean found;
        do {
            id2 = sChannelId.incrementAndGet();
            found = false;
            for (HealthChannel chan : this.mHealthChannels) {
                if (chan.mId != id2) continue;
                found = true;
            }
        } while (found);
        return id2;
    }

    boolean disconnectChannel(BluetoothDevice device, BluetoothHealthAppConfiguration config, int id2) {
        HealthChannel chan = this.findChannelById(id2);
        if (chan == null) {
            return false;
        }
        String deviceObjectPath = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        this.mBluetoothService.releaseChannelFdNative(chan.mChannelPath);
        int prevState = chan.mState;
        chan.mState = 3;
        this.callHealthChannelCallback(config, device, prevState, chan.mState, null, chan.mId);
        if (!this.mBluetoothService.destroyChannelNative(deviceObjectPath, chan.mChannelPath, chan.mId)) {
            prevState = chan.mState;
            chan.mState = 2;
            this.callHealthChannelCallback(config, device, prevState, chan.mState, chan.mChannelFd, chan.mId);
            return false;
        }
        return true;
    }

    private HealthChannel findChannelById(int id2) {
        for (HealthChannel chan : this.mHealthChannels) {
            if (chan.mId != id2) continue;
            return chan;
        }
        return null;
    }

    private HealthChannel findChannelByPath(BluetoothDevice device, String path) {
        for (HealthChannel chan : this.mHealthChannels) {
            if (!path.equals(chan.mChannelPath) || !device.equals(chan.mDevice)) continue;
            return chan;
        }
        return null;
    }

    private List<HealthChannel> findChannelByStates(BluetoothDevice device, int[] states) {
        ArrayList<HealthChannel> channels = new ArrayList<HealthChannel>();
        for (HealthChannel chan : this.mHealthChannels) {
            if (!chan.mDevice.equals(device)) continue;
            for (int state : states) {
                if (chan.mState != state) continue;
                channels.add(chan);
            }
        }
        return channels;
    }

    private HealthChannel findConnectingChannel(BluetoothDevice device, BluetoothHealthAppConfiguration config) {
        for (HealthChannel chan : this.mHealthChannels) {
            if (!chan.mDevice.equals(device) || !chan.mConfig.equals(config) || chan.mState != 1) continue;
            return chan;
        }
        return null;
    }

    ParcelFileDescriptor getMainChannelFd(BluetoothDevice device, BluetoothHealthAppConfiguration config) {
        HealthChannel chan = this.getMainChannel(device, config);
        if (chan != null) {
            ParcelFileDescriptor pfd = null;
            try {
                pfd = chan.mChannelFd.dup();
                return pfd;
            }
            catch (IOException e) {
                return null;
            }
        }
        String objectPath = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        if (objectPath == null) {
            return null;
        }
        String mainChannelPath = this.mBluetoothService.getMainChannelNative(objectPath);
        if (mainChannelPath == null) {
            return null;
        }
        chan = this.findChannelByPath(device, mainChannelPath);
        if (chan == null) {
            BluetoothHealthProfileHandler.errorLog("Main Channel present but we don't have any account of it:" + device + ":" + config);
            return null;
        }
        chan.mMainChannel = true;
        try {
            return chan.mChannelFd.dup();
        }
        catch (IOException e) {
            return null;
        }
    }

    void onHealthDevicePropertyChanged(String devicePath, String channelPath) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        String address = this.mBluetoothService.getAddressFromObjectPath(devicePath);
        if (address == null) {
            return;
        }
        if (channelPath.equals("/")) {
            return;
        }
        BluetoothDevice device = adapter.getRemoteDevice(address);
        BluetoothHealthAppConfiguration config = this.findHealthApplication(device, channelPath);
        if (config != null) {
            HealthChannel chan = this.findChannelByPath(device, channelPath);
            if (chan == null) {
                BluetoothHealthProfileHandler.errorLog("Health Channel is not present:" + channelPath);
            } else {
                chan.mMainChannel = true;
            }
        }
    }

    void onHealthDeviceChannelConnectionError(int chanCode, int state) {
        HealthChannel channel = this.findChannelById(chanCode);
        if (channel == null) {
            BluetoothHealthProfileHandler.errorLog("No record of this channel:" + chanCode);
        }
        this.callHealthChannelCallback(channel.mConfig, channel.mDevice, channel.mState, state, null, chanCode);
    }

    private BluetoothHealthAppConfiguration findHealthApplication(BluetoothDevice device, String channelPath) {
        BluetoothHealthAppConfiguration config = null;
        HealthChannel chan = this.findChannelByPath(device, channelPath);
        if (chan != null) {
            config = chan.mConfig;
        } else {
            String configPath = this.mBluetoothService.getChannelApplicationNative(channelPath);
            if (configPath == null) {
                BluetoothHealthProfileHandler.errorLog("Config path is null for application");
            } else {
                for (Map.Entry<BluetoothHealthAppConfiguration, String> e : this.mHealthAppConfigs.entrySet()) {
                    if (!e.getValue().equals(configPath)) continue;
                    config = e.getKey();
                }
                if (config == null) {
                    BluetoothHealthProfileHandler.errorLog("No associated application for path:" + configPath);
                }
            }
        }
        return config;
    }

    void onHealthDeviceChannelChanged(String devicePath, String channelPath, boolean exists) {
        int state;
        HealthChannel channel;
        BluetoothHealthProfileHandler.debugLog("onHealthDeviceChannelChanged: devicePath: " + devicePath + "ChannelPath: " + channelPath + "Exists: " + exists);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        String address = this.mBluetoothService.getAddressFromObjectPath(devicePath);
        if (address == null) {
            return;
        }
        BluetoothDevice device = adapter.getRemoteDevice(address);
        int prevState = 0;
        BluetoothHealthAppConfiguration config = this.findHealthApplication(device, channelPath);
        if (exists) {
            boolean mainChannel;
            channel = this.findConnectingChannel(device, config);
            if (channel == null) {
                channel = new HealthChannel(device, config, null, false, channelPath);
                channel.mState = 0;
                this.mHealthChannels.add(channel);
            }
            channel.mChannelPath = channelPath;
            ParcelFileDescriptor fd = this.mBluetoothService.getChannelFdNative(channelPath);
            if (fd == null) {
                BluetoothHealthProfileHandler.errorLog("Error obtaining fd for channel:" + channelPath);
                this.disconnectChannel(device, config, channel.mId);
                return;
            }
            boolean bl = mainChannel = this.getMainChannel(device, config) != null;
            if (!mainChannel) {
                String mainChannelPath = this.mBluetoothService.getMainChannelNative(devicePath);
                if (mainChannelPath == null) {
                    BluetoothHealthProfileHandler.errorLog("Main Channel Path is null for devicePath:" + devicePath);
                    return;
                }
                if (mainChannelPath.equals(channelPath)) {
                    mainChannel = true;
                }
            }
            channel.mChannelFd = fd;
            channel.mMainChannel = mainChannel;
            prevState = channel.mState;
            state = 2;
        } else {
            channel = this.findChannelByPath(device, channelPath);
            if (channel == null) {
                BluetoothHealthProfileHandler.errorLog("Channel not found:" + config + ":" + channelPath);
                return;
            }
            this.mHealthChannels.remove(channel);
            channel.mChannelFd = null;
            prevState = channel.mState;
            state = 0;
        }
        channel.mState = state;
        this.callHealthChannelCallback(config, device, prevState, state, channel.mChannelFd, channel.mId);
    }

    private void callHealthChannelCallback(BluetoothHealthAppConfiguration config, BluetoothDevice device, int prevState, int state, ParcelFileDescriptor fd, int id2) {
        IBluetoothHealthCallback callback;
        this.broadcastHealthDeviceStateChange(device, prevState, state);
        BluetoothHealthProfileHandler.debugLog("Health Device Callback: " + device + " State Change: " + prevState + "->" + state);
        ParcelFileDescriptor dupedFd = null;
        if (fd != null) {
            try {
                dupedFd = fd.dup();
            }
            catch (IOException e) {
                dupedFd = null;
                BluetoothHealthProfileHandler.errorLog("Exception while duping: " + e);
            }
        }
        if ((callback = this.mCallbacks.get(config)) != null) {
            try {
                callback.onHealthChannelStateChange(config, device, prevState, state, dupedFd, id2);
            }
            catch (RemoteException e) {
                BluetoothHealthProfileHandler.errorLog("Remote Exception:" + e);
            }
        }
    }

    private void callHealthApplicationStatusCallback(BluetoothHealthAppConfiguration config, int status) {
        BluetoothHealthProfileHandler.debugLog("Health Device Application: " + config + " State Change: status:" + status);
        IBluetoothHealthCallback callback = this.mCallbacks.get(config);
        if (callback != null) {
            try {
                callback.onHealthAppConfigurationStatusChange(config, status);
            }
            catch (RemoteException e) {
                BluetoothHealthProfileHandler.errorLog("Remote Exception:" + e);
            }
        }
    }

    int getHealthDeviceConnectionState(BluetoothDevice device) {
        if (this.mHealthDevices.get(device) == null) {
            return 0;
        }
        return this.mHealthDevices.get(device);
    }

    List<BluetoothDevice> getConnectedHealthDevices() {
        List<BluetoothDevice> devices = this.lookupHealthDevicesMatchingStates(new int[]{2});
        return devices;
    }

    List<BluetoothDevice> getHealthDevicesMatchingConnectionStates(int[] states) {
        List<BluetoothDevice> devices = this.lookupHealthDevicesMatchingStates(states);
        return devices;
    }

    List<BluetoothDevice> lookupHealthDevicesMatchingStates(int[] states) {
        ArrayList<BluetoothDevice> healthDevices = new ArrayList<BluetoothDevice>();
        block0: for (BluetoothDevice device : this.mHealthDevices.keySet()) {
            int healthDeviceState = this.getHealthDeviceConnectionState(device);
            for (int state : states) {
                if (state != healthDeviceState) continue;
                healthDevices.add(device);
                continue block0;
            }
        }
        return healthDevices;
    }

    private void broadcastHealthDeviceStateChange(BluetoothDevice device, int prevChannelState, int newChannelState) {
        int newDeviceState;
        int currDeviceState;
        if (this.mHealthDevices.get(device) == null) {
            this.mHealthDevices.put(device, 0);
        }
        if ((currDeviceState = this.mHealthDevices.get(device).intValue()) != (newDeviceState = this.convertState(newChannelState))) {
            switch (currDeviceState) {
                case 0: {
                    this.updateAndSendIntent(device, currDeviceState, newDeviceState);
                    break;
                }
                case 1: {
                    if (newDeviceState == 2) {
                        this.updateAndSendIntent(device, currDeviceState, newDeviceState);
                        break;
                    }
                    List<HealthChannel> chan = this.findChannelByStates(device, new int[]{1, 3});
                    if (!chan.isEmpty()) break;
                    this.updateAndSendIntent(device, currDeviceState, newDeviceState);
                    break;
                }
                case 2: {
                    List<HealthChannel> chan = this.findChannelByStates(device, new int[]{1, 2});
                    if (!chan.isEmpty()) break;
                    this.updateAndSendIntent(device, currDeviceState, newDeviceState);
                    break;
                }
                case 3: {
                    List<HealthChannel> chan = this.findChannelByStates(device, new int[]{1, 3});
                    if (!chan.isEmpty()) break;
                    this.updateAndSendIntent(device, currDeviceState, newDeviceState);
                }
            }
        }
    }

    private void updateAndSendIntent(BluetoothDevice device, int prevDeviceState, int newDeviceState) {
        this.mHealthDevices.put(device, newDeviceState);
        this.mBluetoothService.sendConnectionStateChange(device, 3, newDeviceState, prevDeviceState);
    }

    private int convertState(int state) {
        switch (state) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 0: {
                return 0;
            }
        }
        BluetoothHealthProfileHandler.errorLog("Mismatch in Channel and Health Device State");
        return -1;
    }

    private static void debugLog(String msg) {
    }

    private static void errorLog(String msg) {
        Log.e(TAG, msg);
    }

    static {
        sChannelId = new AtomicInteger();
    }

    class HealthChannel {
        private ParcelFileDescriptor mChannelFd;
        private boolean mMainChannel;
        private String mChannelPath;
        private BluetoothDevice mDevice;
        private BluetoothHealthAppConfiguration mConfig;
        private int mState;
        private int mChannelType;
        private int mId;

        HealthChannel(BluetoothDevice device, BluetoothHealthAppConfiguration config, ParcelFileDescriptor fd, boolean mainChannel, String channelPath) {
            this.mChannelFd = fd;
            this.mMainChannel = mainChannel;
            this.mChannelPath = channelPath;
            this.mDevice = device;
            this.mConfig = config;
            this.mState = 0;
            this.mId = BluetoothHealthProfileHandler.this.getChannelId();
        }
    }
}

