/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothDeviceProfileState;
import android.bluetooth.BluetoothProfileState;
import android.content.Context;
import android.content.Intent;
import android.os.Message;
import android.provider.Settings;
import android.server.BluetoothService;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BluetoothInputProfileHandler {
    private static final String TAG = "BluetoothInputProfileHandler";
    private static final boolean DBG = true;
    public static BluetoothInputProfileHandler sInstance;
    private Context mContext;
    private BluetoothService mBluetoothService;
    private final HashMap<BluetoothDevice, Integer> mInputDevices;
    private final BluetoothProfileState mHidProfileState;

    private BluetoothInputProfileHandler(Context context, BluetoothService service) {
        this.mContext = context;
        this.mBluetoothService = service;
        this.mInputDevices = new HashMap();
        this.mHidProfileState = new BluetoothProfileState(this.mContext, 2);
        this.mHidProfileState.start();
    }

    static synchronized BluetoothInputProfileHandler getInstance(Context context, BluetoothService service) {
        if (sInstance == null) {
            sInstance = new BluetoothInputProfileHandler(context, service);
        }
        return sInstance;
    }

    boolean connectInputDevice(BluetoothDevice device, BluetoothDeviceProfileState state) {
        String objectPath = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        if (objectPath == null || this.getInputDeviceConnectionState(device) != 0 || this.getInputDevicePriority(device) == 0) {
            return false;
        }
        if (state != null) {
            Message msg = new Message();
            msg.arg1 = 5;
            msg.obj = state;
            this.mHidProfileState.sendMessage(msg);
            return true;
        }
        return false;
    }

    boolean connectInputDeviceInternal(BluetoothDevice device) {
        String objectPath = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        this.handleInputDeviceStateChange(device, 1);
        if (!this.mBluetoothService.connectInputDeviceNative(objectPath)) {
            this.handleInputDeviceStateChange(device, 0);
            return false;
        }
        return true;
    }

    boolean disconnectInputDevice(BluetoothDevice device, BluetoothDeviceProfileState state) {
        String objectPath = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        if (objectPath == null || this.getInputDeviceConnectionState(device) == 0) {
            return false;
        }
        if (state != null) {
            Message msg = new Message();
            msg.arg1 = 54;
            msg.obj = state;
            this.mHidProfileState.sendMessage(msg);
            return true;
        }
        return false;
    }

    boolean disconnectInputDeviceInternal(BluetoothDevice device) {
        String objectPath = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        this.handleInputDeviceStateChange(device, 3);
        if (!this.mBluetoothService.disconnectInputDeviceNative(objectPath)) {
            this.handleInputDeviceStateChange(device, 2);
            return false;
        }
        return true;
    }

    int getInputDeviceConnectionState(BluetoothDevice device) {
        if (this.mInputDevices.get(device) == null) {
            return 0;
        }
        return this.mInputDevices.get(device);
    }

    List<BluetoothDevice> getConnectedInputDevices() {
        List<BluetoothDevice> devices = this.lookupInputDevicesMatchingStates(new int[]{2});
        return devices;
    }

    List<BluetoothDevice> getInputDevicesMatchingConnectionStates(int[] states) {
        List<BluetoothDevice> devices = this.lookupInputDevicesMatchingStates(states);
        return devices;
    }

    int getInputDevicePriority(BluetoothDevice device) {
        return Settings.Secure.getInt(this.mContext.getContentResolver(), Settings.Secure.getBluetoothInputDevicePriorityKey(device.getAddress()), -1);
    }

    boolean setInputDevicePriority(BluetoothDevice device, int priority) {
        if (!BluetoothAdapter.checkBluetoothAddress(device.getAddress())) {
            return false;
        }
        return Settings.Secure.putInt(this.mContext.getContentResolver(), Settings.Secure.getBluetoothInputDevicePriorityKey(device.getAddress()), priority);
    }

    List<BluetoothDevice> lookupInputDevicesMatchingStates(int[] states) {
        ArrayList<BluetoothDevice> inputDevices = new ArrayList<BluetoothDevice>();
        block0: for (BluetoothDevice device : this.mInputDevices.keySet()) {
            int inputDeviceState = this.getInputDeviceConnectionState(device);
            for (int state : states) {
                if (state != inputDeviceState) continue;
                inputDevices.add(device);
                continue block0;
            }
        }
        return inputDevices;
    }

    private void handleInputDeviceStateChange(BluetoothDevice device, int state) {
        int prevState = this.mInputDevices.get(device) == null ? 0 : this.mInputDevices.get(device);
        if (prevState == state) {
            return;
        }
        this.mInputDevices.put(device, state);
        if (this.getInputDevicePriority(device) > 0 && state == 1 || state == 2) {
            this.setInputDevicePriority(device, 1000);
        }
        Intent intent = new Intent("android.bluetooth.input.profile.action.CONNECTION_STATE_CHANGED");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", device);
        intent.putExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", prevState);
        intent.putExtra("android.bluetooth.profile.extra.STATE", state);
        intent.addFlags(0x10000000);
        this.mContext.sendBroadcast(intent, "android.permission.BLUETOOTH");
        BluetoothInputProfileHandler.debugLog("InputDevice state : device: " + device + " State:" + prevState + "->" + state);
        this.mBluetoothService.sendConnectionStateChange(device, 4, state, prevState);
    }

    void handleInputDevicePropertyChange(String address, boolean connected) {
        int state = connected ? 2 : 0;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        BluetoothDevice device = adapter.getRemoteDevice(address);
        this.handleInputDeviceStateChange(device, state);
    }

    void setInitialInputDevicePriority(BluetoothDevice device, int state) {
        switch (state) {
            case 12: {
                if (this.getInputDevicePriority(device) != -1) break;
                this.setInputDevicePriority(device, 100);
                break;
            }
            case 10: {
                this.setInputDevicePriority(device, -1);
            }
        }
    }

    private static void debugLog(String msg) {
        Log.d(TAG, msg);
    }

    private static void errorLog(String msg) {
        Log.e(TAG, msg);
    }
}

