/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothTetheringDataTracker;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.InterfaceConfiguration;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.ServiceManager;
import android.server.BluetoothService;
import android.util.Log;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BluetoothPanProfileHandler {
    private static final String TAG = "BluetoothPanProfileHandler";
    private static final boolean DBG = true;
    private ArrayList<String> mBluetoothIfaceAddresses;
    private int mMaxPanDevices;
    private static final String BLUETOOTH_IFACE_ADDR_START = "192.168.44.1";
    private static final int BLUETOOTH_MAX_PAN_CONNECTIONS = 5;
    private static final int BLUETOOTH_PREFIX_LENGTH = 24;
    public static BluetoothPanProfileHandler sInstance;
    private final HashMap<BluetoothDevice, BluetoothPanDevice> mPanDevices;
    private boolean mTetheringOn;
    private Context mContext;
    private BluetoothService mBluetoothService;
    static final String NAP_ROLE = "nap";
    static final String NAP_BRIDGE = "pan1";
    private BroadcastReceiver mTetheringReceiver = null;

    private BluetoothPanProfileHandler(Context context, BluetoothService service) {
        this.mContext = context;
        this.mPanDevices = new HashMap();
        this.mBluetoothService = service;
        this.mTetheringOn = false;
        this.mBluetoothIfaceAddresses = new ArrayList();
        try {
            this.mMaxPanDevices = context.getResources().getInteger(17694728);
        }
        catch (Resources.NotFoundException e) {
            this.mMaxPanDevices = 5;
        }
    }

    static BluetoothPanProfileHandler getInstance(Context context, BluetoothService service) {
        if (sInstance == null) {
            sInstance = new BluetoothPanProfileHandler(context, service);
        }
        return sInstance;
    }

    boolean isTetheringOn() {
        return this.mTetheringOn;
    }

    boolean allowIncomingTethering() {
        return this.isTetheringOn() && this.getConnectedPanDevices().size() < this.mMaxPanDevices;
    }

    void setBluetoothTethering(boolean value) {
        if (!value) {
            this.disconnectPanServerDevices();
        }
        if (this.mBluetoothService.getBluetoothState() != 12 && value) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            this.mTetheringReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 10) == 12) {
                        BluetoothPanProfileHandler.this.mTetheringOn = true;
                        BluetoothPanProfileHandler.this.mContext.unregisterReceiver(BluetoothPanProfileHandler.this.mTetheringReceiver);
                    }
                }
            };
            this.mContext.registerReceiver(this.mTetheringReceiver, filter);
        } else {
            this.mTetheringOn = value;
        }
    }

    int getPanDeviceConnectionState(BluetoothDevice device) {
        BluetoothPanDevice panDevice = this.mPanDevices.get(device);
        if (panDevice == null) {
            return 0;
        }
        return panDevice.mState;
    }

    boolean connectPanDevice(BluetoothDevice device) {
        String objectPath = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        Log.d(TAG, "connect PAN(" + objectPath + ")");
        if (this.getPanDeviceConnectionState(device) != 0) {
            BluetoothPanProfileHandler.errorLog(device + " already connected to PAN");
        }
        int connectedCount = 0;
        for (BluetoothDevice panDevice : this.mPanDevices.keySet()) {
            if (this.getPanDeviceConnectionState(panDevice) != 2) continue;
            ++connectedCount;
        }
        if (connectedCount > 8) {
            BluetoothPanProfileHandler.debugLog(device + " could not connect to PAN because 8 other devices are" + "already connected");
            return false;
        }
        this.handlePanDeviceStateChange(device, null, 1, 2);
        if (this.mBluetoothService.connectPanDeviceNative(objectPath, NAP_ROLE)) {
            BluetoothPanProfileHandler.debugLog("connecting to PAN");
            return true;
        }
        this.handlePanDeviceStateChange(device, null, 0, 2);
        BluetoothPanProfileHandler.errorLog("could not connect to PAN");
        return false;
    }

    private boolean disconnectPanServerDevices() {
        BluetoothPanProfileHandler.debugLog("disconnect all PAN devices");
        for (BluetoothDevice device : this.mPanDevices.keySet()) {
            BluetoothPanDevice panDevice = this.mPanDevices.get(device);
            int state = panDevice.mState;
            if (state != 2 || panDevice.mLocalRole != 1) continue;
            String objectPath = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
            this.handlePanDeviceStateChange(device, panDevice.mIface, 3, panDevice.mLocalRole);
            if (this.mBluetoothService.disconnectPanServerDeviceNative(objectPath, device.getAddress(), panDevice.mIface)) continue;
            BluetoothPanProfileHandler.errorLog("could not disconnect Pan Server Device " + device.getAddress());
            this.handlePanDeviceStateChange(device, panDevice.mIface, state, panDevice.mLocalRole);
            return false;
        }
        return true;
    }

    List<BluetoothDevice> getConnectedPanDevices() {
        ArrayList<BluetoothDevice> devices = new ArrayList<BluetoothDevice>();
        for (BluetoothDevice device : this.mPanDevices.keySet()) {
            if (this.getPanDeviceConnectionState(device) != 2) continue;
            devices.add(device);
        }
        return devices;
    }

    List<BluetoothDevice> getPanDevicesMatchingConnectionStates(int[] states) {
        ArrayList<BluetoothDevice> devices = new ArrayList<BluetoothDevice>();
        block0: for (BluetoothDevice device : this.mPanDevices.keySet()) {
            int panDeviceState = this.getPanDeviceConnectionState(device);
            for (int state : states) {
                if (state != panDeviceState) continue;
                devices.add(device);
                continue block0;
            }
        }
        return devices;
    }

    boolean disconnectPanDevice(BluetoothDevice device) {
        String objectPath = this.mBluetoothService.getObjectPathFromAddress(device.getAddress());
        BluetoothPanProfileHandler.debugLog("disconnect PAN(" + objectPath + ")");
        int state = this.getPanDeviceConnectionState(device);
        if (state != 2) {
            BluetoothPanProfileHandler.debugLog(device + " already disconnected from PAN");
            return false;
        }
        BluetoothPanDevice panDevice = this.mPanDevices.get(device);
        if (panDevice == null) {
            BluetoothPanProfileHandler.errorLog("No record for this Pan device:" + device);
            return false;
        }
        this.handlePanDeviceStateChange(device, panDevice.mIface, 3, panDevice.mLocalRole);
        if (panDevice.mLocalRole == 1) {
            if (!this.mBluetoothService.disconnectPanServerDeviceNative(objectPath, device.getAddress(), panDevice.mIface)) {
                this.handlePanDeviceStateChange(device, panDevice.mIface, state, panDevice.mLocalRole);
                return false;
            }
        } else if (!this.mBluetoothService.disconnectPanDeviceNative(objectPath)) {
            this.handlePanDeviceStateChange(device, panDevice.mIface, state, panDevice.mLocalRole);
            return false;
        }
        return true;
    }

    void handlePanDeviceStateChange(BluetoothDevice device, String iface, int state, int role) {
        int prevState;
        String ifaceAddr = null;
        BluetoothPanDevice panDevice = this.mPanDevices.get(device);
        if (panDevice == null) {
            prevState = 0;
        } else {
            prevState = panDevice.mState;
            ifaceAddr = panDevice.mIfaceAddr;
        }
        if (prevState == state) {
            return;
        }
        if (role == 1) {
            if (state == 2) {
                ifaceAddr = this.enableTethering(iface);
                if (ifaceAddr == null) {
                    Log.e(TAG, "Error seting up tether interface");
                }
            } else if (state == 0 && ifaceAddr != null) {
                this.mBluetoothIfaceAddresses.remove(ifaceAddr);
                ifaceAddr = null;
            }
        } else if (state == 2) {
            BluetoothTetheringDataTracker.getInstance().startReverseTether(iface, device);
        } else if (state == 0 && (prevState == 2 || prevState == 3)) {
            BluetoothTetheringDataTracker.getInstance().stopReverseTether(panDevice.mIface);
        }
        if (panDevice == null) {
            panDevice = new BluetoothPanDevice(state, ifaceAddr, iface, role);
            this.mPanDevices.put(device, panDevice);
        } else {
            panDevice.mState = state;
            panDevice.mIfaceAddr = ifaceAddr;
            panDevice.mLocalRole = role;
            panDevice.mIface = iface;
        }
        Intent intent = new Intent("android.bluetooth.pan.profile.action.CONNECTION_STATE_CHANGED");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", device);
        intent.putExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", prevState);
        intent.putExtra("android.bluetooth.profile.extra.STATE", state);
        intent.putExtra("android.bluetooth.pan.extra.LOCAL_ROLE", role);
        this.mContext.sendBroadcast(intent, "android.permission.BLUETOOTH");
        BluetoothPanProfileHandler.debugLog("Pan Device state : device: " + device + " State:" + prevState + "->" + state);
        this.mBluetoothService.sendConnectionStateChange(device, 5, state, prevState);
    }

    private String createNewTetheringAddressLocked() {
        if (this.getConnectedPanDevices().size() == this.mMaxPanDevices) {
            BluetoothPanProfileHandler.debugLog("Max PAN device connections reached");
            return null;
        }
        String address = BLUETOOTH_IFACE_ADDR_START;
        while (this.mBluetoothIfaceAddresses.contains(address)) {
            String[] addr = address.split("\\.");
            Integer newIp = Integer.parseInt(addr[2]) + 1;
            address = address.replace(addr[2], newIp.toString());
        }
        this.mBluetoothIfaceAddresses.add(address);
        return address;
    }

    private String enableTethering(String iface) {
        BluetoothPanProfileHandler.debugLog("updateTetherState:" + iface);
        IBinder b = ServiceManager.getService("network_management");
        INetworkManagementService service = INetworkManagementService.Stub.asInterface(b);
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        String[] bluetoothRegexs = cm.getTetherableBluetoothRegexs();
        String[] currentIfaces = new String[]{};
        try {
            currentIfaces = service.listInterfaces();
        }
        catch (Exception e) {
            Log.e(TAG, "Error listing Interfaces :" + e);
            return null;
        }
        boolean found = false;
        for (String currIface : currentIfaces) {
            if (!currIface.equals(iface)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        String address = this.createNewTetheringAddressLocked();
        if (address == null) {
            return null;
        }
        InterfaceConfiguration ifcg = null;
        try {
            ifcg = service.getInterfaceConfig(iface);
            if (ifcg != null) {
                InetAddress addr = null;
                if (ifcg.addr == null || (addr = ifcg.addr.getAddress()) == null || addr.equals(NetworkUtils.numericToInetAddress("0.0.0.0")) || addr.equals(NetworkUtils.numericToInetAddress("::0"))) {
                    addr = NetworkUtils.numericToInetAddress(address);
                }
                ifcg.interfaceFlags = ifcg.interfaceFlags.replace("down", "up");
                ifcg.addr = new LinkAddress(addr, 24);
                ifcg.interfaceFlags = ifcg.interfaceFlags.replace("running", "");
                ifcg.interfaceFlags = ifcg.interfaceFlags.replace("  ", " ");
                service.setInterfaceConfig(iface, ifcg);
                if (cm.tether(iface) != 0) {
                    Log.e(TAG, "Error tethering " + iface);
                }
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Error configuring interface " + iface + ", :" + e);
            return null;
        }
        return address;
    }

    private static void debugLog(String msg) {
        Log.d(TAG, msg);
    }

    private static void errorLog(String msg) {
        Log.e(TAG, msg);
    }

    private class BluetoothPanDevice {
        private int mState;
        private String mIfaceAddr;
        private String mIface;
        private int mLocalRole;

        BluetoothPanDevice(int state, String ifaceAddr, String iface, int localRole) {
            this.mState = state;
            this.mIfaceAddr = ifaceAddr;
            this.mIface = iface;
            this.mLocalRole = localRole;
        }
    }
}

