/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothDeviceProfileState;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHealthAppConfiguration;
import android.bluetooth.BluetoothInputDevice;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileState;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothCallback;
import android.bluetooth.IBluetoothHealthCallback;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.server.BluetoothA2dpService;
import android.server.BluetoothAdapterProperties;
import android.server.BluetoothAdapterStateMachine;
import android.server.BluetoothBondState;
import android.server.BluetoothDeviceProperties;
import android.server.BluetoothEventLoop;
import android.server.BluetoothHealthProfileHandler;
import android.server.BluetoothInputProfileHandler;
import android.server.BluetoothPanProfileHandler;
import android.util.Log;
import android.util.Pair;
import com.android.internal.app.IBatteryStats;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothService
extends IBluetooth.Stub {
    private static final String TAG = "BluetoothService";
    private static final boolean DBG = true;
    private int mNativeData;
    private BluetoothEventLoop mEventLoop;
    private BluetoothHeadset mHeadsetProxy;
    private BluetoothInputDevice mInputDevice;
    private BluetoothPan mPan;
    private boolean mIsAirplaneSensitive;
    private boolean mIsAirplaneToggleable;
    private BluetoothAdapterStateMachine mBluetoothState;
    private int[] mAdapterSdpHandles;
    private ParcelUuid[] mAdapterUuids;
    private BluetoothAdapter mAdapter;
    private final BluetoothBondState mBondState;
    private final IBatteryStats mBatteryStats;
    private final Context mContext;
    private Map<Integer, IBluetoothStateChangeCallback> mStateChangeTracker = Collections.synchronizedMap(new HashMap());
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final String DOCK_ADDRESS_PATH = "/sys/class/switch/dock/bt_addr";
    private static final String DOCK_PIN_PATH = "/sys/class/switch/dock/bt_pin";
    private static final String SHARED_PREFERENCE_DOCK_ADDRESS = "dock_bluetooth_address";
    private static final String SHARED_PREFERENCES_NAME = "bluetooth_service_settings";
    private static final int MESSAGE_UUID_INTENT = 1;
    private static final int MESSAGE_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 2;
    private static final int MESSAGE_REMOVE_SERVICE_RECORD = 3;
    private static final int RFCOMM_RECORD_REAPER = 10;
    private static final int STATE_CHANGE_REAPER = 11;
    private static final long INIT_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 3000L;
    private static final long MAX_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 12000L;
    private static final int UUID_INTENT_DELAY = 6000;
    private static final ParcelUuid[] RFCOMM_UUIDS = new ParcelUuid[]{BluetoothUuid.Handsfree, BluetoothUuid.HSP, BluetoothUuid.ObexObjectPush};
    private final BluetoothAdapterProperties mAdapterProperties;
    private final BluetoothDeviceProperties mDeviceProperties;
    private final HashMap<String, Map<ParcelUuid, Integer>> mDeviceServiceChannelCache;
    private final ArrayList<String> mUuidIntentTracker;
    private final HashMap<RemoteService, IBluetoothCallback> mUuidCallbackTracker;
    private final HashMap<Integer, ServiceRecordClient> mServiceRecordToPid;
    private final HashMap<String, BluetoothDeviceProfileState> mDeviceProfileState;
    private final BluetoothProfileState mA2dpProfileState;
    private final BluetoothProfileState mHfpProfileState;
    private BluetoothA2dpService mA2dpService;
    private final HashMap<String, Pair<byte[], byte[]>> mDeviceOobData;
    private int mProfilesConnected = 0;
    private int mProfilesConnecting = 0;
    private int mProfilesDisconnecting = 0;
    private static String mDockAddress;
    private String mDockPin;
    private int mAdapterConnectionState = 0;
    private BluetoothPanProfileHandler mBluetoothPanProfileHandler;
    private BluetoothInputProfileHandler mBluetoothInputProfileHandler;
    private BluetoothHealthProfileHandler mBluetoothHealthProfileHandler;
    private static final String INCOMING_CONNECTION_FILE = "/data/misc/bluetooth/incoming_connection.conf";
    private HashMap<String, Pair<Integer, String>> mIncomingConnections;
    private HashMap<Integer, Pair<Integer, Integer>> mProfileConnectionState;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    String address = (String)msg.obj;
                    if (address == null) break;
                    BluetoothService.this.sendUuidIntent(address);
                    BluetoothService.this.makeServiceChannelCallbacks(address);
                    break;
                }
                case 2: {
                    String address = (String)msg.obj;
                    if (address == null) {
                        return;
                    }
                    int attempt = BluetoothService.this.mBondState.getAttempt(address);
                    if (attempt > 0 && attempt <= 2) {
                        BluetoothService.this.mBondState.attempt(address);
                        BluetoothService.this.createBond(address);
                        return;
                    }
                    if (attempt <= 0) break;
                    BluetoothService.this.mBondState.clearPinAttempts(address);
                    break;
                }
                case 3: {
                    Pair pair = (Pair)msg.obj;
                    BluetoothService.this.checkAndRemoveRecord((Integer)pair.first, (Integer)pair.second);
                }
            }
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            String action = intent.getAction();
            if (action.equals("android.intent.action.AIRPLANE_MODE")) {
                ContentResolver resolver = context.getContentResolver();
                if (BluetoothService.this.isAirplaneModeOn()) {
                    BluetoothService.this.mBluetoothState.sendMessage(55);
                } else {
                    BluetoothService.this.mBluetoothState.sendMessage(56);
                }
            } else if ("android.intent.action.DOCK_EVENT".equals(action)) {
                int state = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                Log.v(BluetoothService.TAG, "Received ACTION_DOCK_EVENT with State:" + state);
                if (state == 0) {
                    mDockAddress = null;
                    BluetoothService.this.mDockPin = null;
                } else {
                    Context context2 = BluetoothService.this.mContext;
                    BluetoothService.this.mContext;
                    SharedPreferences.Editor editor = context2.getSharedPreferences(BluetoothService.SHARED_PREFERENCES_NAME, 0).edit();
                    editor.putBoolean(BluetoothService.SHARED_PREFERENCE_DOCK_ADDRESS + mDockAddress, true);
                    editor.apply();
                }
            }
        }
    };
    private BluetoothProfile.ServiceListener mBluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile == 1) {
                BluetoothService.this.mHeadsetProxy = (BluetoothHeadset)proxy;
            } else if (profile == 4) {
                BluetoothService.this.mInputDevice = (BluetoothInputDevice)proxy;
            } else if (profile == 5) {
                BluetoothService.this.mPan = (BluetoothPan)proxy;
            }
        }

        public void onServiceDisconnected(int profile) {
            if (profile == 1) {
                BluetoothService.this.mHeadsetProxy = null;
            } else if (profile == 4) {
                BluetoothService.this.mInputDevice = null;
            } else if (profile == 5) {
                BluetoothService.this.mPan = null;
            }
        }
    };

    public BluetoothService(Context context) {
        this.mContext = context;
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batteryinfo"));
        this.initializeNativeDataNative();
        if (this.isEnabledNative() == 1) {
            Log.w(TAG, "Bluetooth daemons already running - runtime restart? ");
            this.disableNative();
        }
        this.mBondState = new BluetoothBondState(context, this);
        this.mAdapterProperties = new BluetoothAdapterProperties(context, this);
        this.mDeviceProperties = new BluetoothDeviceProperties(this);
        this.mDeviceServiceChannelCache = new HashMap();
        this.mDeviceOobData = new HashMap();
        this.mUuidIntentTracker = new ArrayList();
        this.mUuidCallbackTracker = new HashMap();
        this.mServiceRecordToPid = new HashMap();
        this.mDeviceProfileState = new HashMap();
        this.mA2dpProfileState = new BluetoothProfileState(this.mContext, 1);
        this.mHfpProfileState = new BluetoothProfileState(this.mContext, 0);
        this.mHfpProfileState.start();
        this.mA2dpProfileState.start();
        IntentFilter filter = new IntentFilter();
        this.registerForAirplaneMode(filter);
        filter.addAction("android.intent.action.DOCK_EVENT");
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.mBluetoothInputProfileHandler = BluetoothInputProfileHandler.getInstance(this.mContext, this);
        this.mBluetoothPanProfileHandler = BluetoothPanProfileHandler.getInstance(this.mContext, this);
        this.mBluetoothHealthProfileHandler = BluetoothHealthProfileHandler.getInstance(this.mContext, this);
        this.mIncomingConnections = new HashMap();
        this.mProfileConnectionState = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String readDockBluetoothAddress() {
        if (mDockAddress != null) {
            return mDockAddress;
        }
        BufferedInputStream file = null;
        try {
            file = new BufferedInputStream(new FileInputStream(DOCK_ADDRESS_PATH));
            byte[] address = new byte[17];
            file.read(address);
            String dockAddress = new String(address);
            dockAddress = dockAddress.toUpperCase();
            if (BluetoothAdapter.checkBluetoothAddress(dockAddress)) {
                String string2 = mDockAddress = dockAddress;
                return string2;
            }
            Log.e(TAG, "CheckBluetoothAddress failed for car dock address: " + dockAddress);
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "FileNotFoundException while trying to read dock address");
        }
        catch (IOException e) {
            Log.e(TAG, "IOException while trying to read dock address");
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {}
            }
        }
        mDockAddress = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean writeDockPin() {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(DOCK_PIN_PATH));
            int pin = (int)Math.floor(Math.random() * 10000.0);
            this.mDockPin = String.format("%04d", pin);
            out.write(this.mDockPin);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "FileNotFoundException while trying to write dock pairing pin");
        }
        catch (IOException e) {
            Log.e(TAG, "IOException while while trying to write dock pairing pin");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        this.mDockPin = null;
        return false;
    }

    synchronized String getDockPin() {
        return this.mDockPin;
    }

    public synchronized void initAfterRegistration() {
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mBluetoothState = new BluetoothAdapterStateMachine(this.mContext, this, this.mAdapter);
        this.mBluetoothState.start();
        if (this.mContext.getResources().getBoolean(0x1110022)) {
            this.mBluetoothState.sendMessage(5);
        }
        this.mEventLoop = this.mBluetoothState.getBluetoothEventLoop();
    }

    public synchronized void initAfterA2dpRegistration() {
        this.mEventLoop.getProfileProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalize() throws Throwable {
        this.mContext.unregisterReceiver(this.mReceiver);
        try {
            this.cleanupNativeDataNative();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public boolean isEnabled() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.isEnabledInternal();
    }

    private boolean isEnabledInternal() {
        return this.getBluetoothStateInternal() == 12;
    }

    @Override
    public int getBluetoothState() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.getBluetoothStateInternal();
    }

    int getBluetoothStateInternal() {
        return this.mBluetoothState.getBluetoothAdapterState();
    }

    public boolean disable() {
        return this.disable(true);
    }

    @Override
    public synchronized boolean disable(boolean saveSetting) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        int adapterState = this.getBluetoothStateInternal();
        switch (adapterState) {
            case 10: {
                return true;
            }
            case 12: {
                break;
            }
            default: {
                return false;
            }
        }
        this.mBluetoothState.sendMessage(2, saveSetting);
        return true;
    }

    synchronized void disconnectDevices() {
        for (BluetoothDevice device : this.getConnectedInputDevices()) {
            this.disconnectInputDevice(device);
        }
        for (BluetoothDevice device : this.getConnectedPanDevices()) {
            this.disconnectPanDevice(device);
        }
    }

    synchronized void finishDisable() {
        for (String address : this.mBondState.listInState(11)) {
            this.mBondState.setBondState(address, 10, 3);
        }
        for (String address : this.mBondState.listInState(12)) {
            this.removeProfileState(address);
        }
        Intent intent = new Intent("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
        intent.putExtra("android.bluetooth.adapter.extra.SCAN_MODE", 20);
        this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanupAfterFinishDisable() {
        this.mAdapterProperties.clear();
        for (Integer srHandle : this.mServiceRecordToPid.keySet()) {
            this.removeServiceRecordNative(srHandle);
        }
        this.mServiceRecordToPid.clear();
        this.mProfilesConnected = 0;
        this.mProfilesConnecting = 0;
        this.mProfilesDisconnecting = 0;
        this.mAdapterConnectionState = 0;
        this.mAdapterUuids = null;
        this.mAdapterSdpHandles = null;
        long ident = Binder.clearCallingIdentity();
        try {
            this.mBatteryStats.noteBluetoothOff();
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    synchronized void shutoffBluetooth() {
        if (this.mAdapterSdpHandles != null) {
            this.removeReservedServiceRecordsNative(this.mAdapterSdpHandles);
        }
        this.setBluetoothTetheringNative(false, "nap", "pan1");
        this.tearDownNativeDataNative();
    }

    synchronized void cleanNativeAfterShutoffBluetooth() {
        this.mAdapterProperties.clear();
        this.disableNative();
    }

    @Override
    public boolean enable() {
        return this.enable(true);
    }

    public synchronized boolean enable(boolean saveSetting) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (this.mIsAirplaneSensitive && this.isAirplaneModeOn() && !this.mIsAirplaneToggleable) {
            return false;
        }
        this.mBluetoothState.sendMessage(1, saveSetting);
        return true;
    }

    synchronized boolean prepareBluetooth() {
        if (!this.setupNativeDataNative()) {
            return false;
        }
        this.switchConnectable(false);
        this.updateSdpRecords();
        return true;
    }

    private synchronized void addReservedSdpRecords(ArrayList<ParcelUuid> uuids) {
        int[] svcIdentifiers = new int[uuids.size()];
        for (int i = 0; i < uuids.size(); ++i) {
            svcIdentifiers[i] = BluetoothUuid.getServiceIdentifierFromParcelUuid(uuids.get(i));
        }
        this.mAdapterSdpHandles = this.addReservedServiceRecordsNative(svcIdentifiers);
    }

    private synchronized void updateSdpRecords() {
        ArrayList<ParcelUuid> uuids = new ArrayList<ParcelUuid>();
        uuids.add(BluetoothUuid.HSP_AG);
        uuids.add(BluetoothUuid.ObexObjectPush);
        if (this.mContext.getResources().getBoolean(17891363)) {
            uuids.add(BluetoothUuid.Handsfree_AG);
            uuids.add(BluetoothUuid.PBAP_PSE);
        }
        this.addReservedSdpRecords(uuids);
        this.setBluetoothTetheringNative(true, "nap", "pan1");
        uuids.add(BluetoothUuid.AudioSource);
        uuids.add(BluetoothUuid.AvrcpTarget);
        uuids.add(BluetoothUuid.NAP);
        this.mAdapterUuids = new ParcelUuid[uuids.size()];
        for (int i = 0; i < uuids.size(); ++i) {
            this.mAdapterUuids[i] = uuids.get(i);
        }
    }

    synchronized void updateBluetoothState(String uuids) {
        ParcelUuid[] adapterUuids = this.convertStringToParcelUuid(uuids);
        if (this.mAdapterUuids != null && BluetoothUuid.containsAllUuids(adapterUuids, this.mAdapterUuids)) {
            this.mBluetoothState.sendMessage(51);
        }
    }

    void initBluetoothAfterTurningOn() {
        String discoverable = this.getProperty("Discoverable", false);
        String timeout = this.getProperty("DiscoverableTimeout", false);
        if (discoverable.equals("true") && Integer.valueOf(timeout) != 0) {
            this.setAdapterPropertyBooleanNative("Discoverable", 0);
        }
        this.mBondState.initBondState();
        this.initProfileState();
        this.getProfileProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runBluetooth() {
        this.autoConnect();
        long ident = Binder.clearCallingIdentity();
        try {
            this.mBatteryStats.noteBluetoothOn();
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    synchronized boolean attemptAutoPair(String address) {
        if (!this.mBondState.hasAutoPairingFailed(address) && !this.mBondState.isAutoPairingBlacklisted(address)) {
            this.mBondState.attempt(address);
            this.setPin(address, BluetoothDevice.convertPinToBytes("0000"));
            return true;
        }
        return false;
    }

    synchronized boolean isFixedPinZerosAutoPairKeyboard(String address) {
        return this.mBondState.isFixedPinZerosAutoPairKeyboard(address);
    }

    synchronized void onCreatePairedDeviceResult(String address, int result) {
        if (result == 0) {
            this.setBondState(address, 12);
            if (this.mBondState.isAutoPairingAttemptsInProgress(address)) {
                this.mBondState.clearPinAttempts(address);
            }
        } else if (result == 1 && this.mBondState.getAttempt(address) == 1) {
            this.mBondState.addAutoPairingFailure(address);
            this.pairingAttempt(address, result);
        } else if (result == 4 && this.mBondState.isAutoPairingAttemptsInProgress(address)) {
            this.pairingAttempt(address, result);
        } else {
            this.setBondState(address, 10, result);
            if (this.mBondState.isAutoPairingAttemptsInProgress(address)) {
                this.mBondState.clearPinAttempts(address);
            }
        }
    }

    synchronized String getPendingOutgoingBonding() {
        return this.mBondState.getPendingOutgoingBonding();
    }

    private void pairingAttempt(String address, int result) {
        int attempt = this.mBondState.getAttempt(address);
        if ((long)attempt * 3000L > 12000L) {
            this.mBondState.clearPinAttempts(address);
            this.setBondState(address, 10, result);
            return;
        }
        Message message = this.mHandler.obtainMessage(2);
        message.obj = address;
        boolean postResult = this.mHandler.sendMessageDelayed(message, (long)attempt * 3000L);
        if (!postResult) {
            this.mBondState.clearPinAttempts(address);
            this.setBondState(address, 10, result);
            return;
        }
    }

    BluetoothDevice getRemoteDevice(String address) {
        return this.mAdapter.getRemoteDevice(address);
    }

    private static String toBondStateString(int bondState) {
        switch (bondState) {
            case 10: {
                return "not bonded";
            }
            case 11: {
                return "bonding";
            }
            case 12: {
                return "bonded";
            }
        }
        return "??????";
    }

    @Override
    public synchronized boolean setName(String name) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (name == null) {
            return false;
        }
        return this.setPropertyString("Name", name);
    }

    private boolean setPropertyString(String key, String value) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.setAdapterPropertyStringNative(key, value);
    }

    private boolean setPropertyInteger(String key, int value) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.setAdapterPropertyIntegerNative(key, value);
    }

    private boolean setPropertyBoolean(String key, boolean value) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.setAdapterPropertyBooleanNative(key, value ? 1 : 0);
    }

    @Override
    public synchronized boolean setDiscoverableTimeout(int timeout) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        return this.setPropertyInteger("DiscoverableTimeout", timeout);
    }

    @Override
    public synchronized boolean setScanMode(int mode, int duration) {
        boolean discoverable;
        boolean pairable;
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", "Need WRITE_SECURE_SETTINGS permission");
        switch (mode) {
            case 20: {
                pairable = false;
                discoverable = false;
                break;
            }
            case 21: {
                pairable = true;
                discoverable = false;
                break;
            }
            case 23: {
                pairable = true;
                discoverable = true;
                Log.d(TAG, "BT Discoverable for " + duration + " seconds");
                break;
            }
            default: {
                Log.w(TAG, "Requested invalid scan mode " + mode);
                return false;
            }
        }
        this.setPropertyBoolean("Discoverable", discoverable);
        this.setPropertyBoolean("Pairable", pairable);
        return true;
    }

    synchronized void switchConnectable(boolean on) {
        this.setAdapterPropertyBooleanNative("Powered", on ? 1 : 0);
    }

    synchronized void setPairable() {
        String pairableString = this.getProperty("Pairable", false);
        if (pairableString == null) {
            Log.e(TAG, "null pairableString");
            return;
        }
        if (pairableString.equals("false")) {
            this.setAdapterPropertyBooleanNative("Pairable", 1);
        }
    }

    String getProperty(String name, boolean checkState) {
        if (checkState ? !this.isEnabledInternal() : !this.mEventLoop.isEventLoopRunning()) {
            return null;
        }
        return this.mAdapterProperties.getProperty(name);
    }

    BluetoothAdapterProperties getAdapterProperties() {
        return this.mAdapterProperties;
    }

    BluetoothDeviceProperties getDeviceProperties() {
        return this.mDeviceProperties;
    }

    boolean isRemoteDeviceInCache(String address) {
        return this.mDeviceProperties.isInCache(address);
    }

    void setRemoteDeviceProperty(String address, String name, String value) {
        this.mDeviceProperties.setProperty(address, name, value);
    }

    void updateRemoteDevicePropertiesCache(String address) {
        this.mDeviceProperties.updateCache(address);
    }

    @Override
    public synchronized String getAddress() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.getProperty("Address", false);
    }

    @Override
    public synchronized String getName() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.getProperty("Name", false);
    }

    @Override
    public ParcelUuid[] getUuids() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        String value = this.getProperty("UUIDs", true);
        if (value == null) {
            return null;
        }
        return this.convertStringToParcelUuid(value);
    }

    private ParcelUuid[] convertStringToParcelUuid(String value) {
        String[] uuidStrings = null;
        uuidStrings = value.split(",");
        ParcelUuid[] uuids = new ParcelUuid[uuidStrings.length];
        for (int i = 0; i < uuidStrings.length; ++i) {
            uuids[i] = ParcelUuid.fromString(uuidStrings[i]);
        }
        return uuids;
    }

    @Override
    public synchronized String getRemoteName(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return null;
        }
        return this.mDeviceProperties.getProperty(address, "Name");
    }

    @Override
    public synchronized String getRemoteAlias(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return null;
        }
        return this.mDeviceProperties.getProperty(address, "Alias");
    }

    @Override
    public synchronized boolean setRemoteAlias(String address, String alias) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        return this.setDevicePropertyStringNative(this.getObjectPathFromAddress(address), "Alias", alias);
    }

    @Override
    public int getDiscoverableTimeout() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        String timeout = this.getProperty("DiscoverableTimeout", true);
        if (timeout != null) {
            return Integer.valueOf(timeout);
        }
        return -1;
    }

    @Override
    public int getScanMode() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return 20;
        }
        boolean pairable = this.getProperty("Pairable", true).equals("true");
        boolean discoverable = this.getProperty("Discoverable", true).equals("true");
        return BluetoothService.bluezStringToScanMode(pairable, discoverable);
    }

    @Override
    public synchronized boolean startDiscovery() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.startDiscoveryNative();
    }

    @Override
    public synchronized boolean cancelDiscovery() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.stopDiscoveryNative();
    }

    @Override
    public boolean isDiscovering() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        String discoveringProperty = this.getProperty("Discovering", false);
        if (discoveringProperty == null) {
            return false;
        }
        return discoveringProperty.equals("true");
    }

    private boolean isBondingFeasible(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        address = address.toUpperCase();
        if (this.mBondState.getPendingOutgoingBonding() != null) {
            Log.d(TAG, "Ignoring createBond(): another device is bonding");
            return false;
        }
        if (!this.mBondState.isAutoPairingAttemptsInProgress(address) && this.mBondState.getBondState(address) != 10) {
            Log.d(TAG, "Ignoring createBond(): this device is already bonding or bonded");
            return false;
        }
        if (address.equals(mDockAddress) && !this.writeDockPin()) {
            Log.e(TAG, "Error while writing Pin for the dock");
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean createBond(String address) {
        if (!this.isBondingFeasible(address)) {
            return false;
        }
        if (!this.createPairedDeviceNative(address, 60000)) {
            return false;
        }
        this.mBondState.setPendingOutgoingBonding(address);
        this.mBondState.setBondState(address, 11);
        return true;
    }

    @Override
    public synchronized boolean createBondOutOfBand(String address, byte[] hash, byte[] randomizer) {
        if (!this.isBondingFeasible(address)) {
            return false;
        }
        if (!this.createPairedDeviceOutOfBandNative(address, 60000)) {
            return false;
        }
        this.setDeviceOutOfBandData(address, hash, randomizer);
        this.mBondState.setPendingOutgoingBonding(address);
        this.mBondState.setBondState(address, 11);
        return true;
    }

    @Override
    public synchronized boolean setDeviceOutOfBandData(String address, byte[] hash, byte[] randomizer) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        Pair<byte[], byte[]> value = new Pair<byte[], byte[]>(hash, randomizer);
        Log.d(TAG, "Setting out of band data for: " + address + ":" + Arrays.toString(hash) + ":" + Arrays.toString(randomizer));
        this.mDeviceOobData.put(address, value);
        return true;
    }

    Pair<byte[], byte[]> getDeviceOutOfBandData(BluetoothDevice device) {
        return this.mDeviceOobData.get(device.getAddress());
    }

    @Override
    public synchronized byte[] readOutOfBandData() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return null;
        }
        return this.readAdapterOutOfBandDataNative();
    }

    @Override
    public synchronized boolean cancelBondProcess(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        if (this.mBondState.getBondState(address = address.toUpperCase()) != 11) {
            return false;
        }
        this.mBondState.setBondState(address, 10, 3);
        this.cancelDeviceCreationNative(address);
        return true;
    }

    @Override
    public synchronized boolean removeBond(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            state.sendMessage(100);
            return true;
        }
        return false;
    }

    public synchronized boolean removeBondInternal(String address) {
        this.setTrust(address, false);
        return this.removeDeviceNative(this.getObjectPathFromAddress(address));
    }

    @Override
    public synchronized String[] listBonds() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.mBondState.listInState(12);
    }

    synchronized String[] listInState(int state) {
        return this.mBondState.listInState(state);
    }

    @Override
    public synchronized int getBondState(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return Integer.MIN_VALUE;
        }
        return this.mBondState.getBondState(address.toUpperCase());
    }

    synchronized boolean setBondState(String address, int state) {
        return this.setBondState(address, state, 0);
    }

    synchronized boolean setBondState(String address, int state, int reason) {
        this.mBondState.setBondState(address.toUpperCase(), state, reason);
        return true;
    }

    @Override
    public synchronized boolean isBluetoothDock(String address) {
        SharedPreferences sp = this.mContext.getSharedPreferences(SHARED_PREFERENCES_NAME, 0);
        return sp.contains(SHARED_PREFERENCE_DOCK_ADDRESS + address);
    }

    String[] getRemoteDeviceProperties(String address) {
        if (!this.isEnabledInternal()) {
            return null;
        }
        String objectPath = this.getObjectPathFromAddress(address);
        return (String[])this.getDevicePropertiesNative(objectPath);
    }

    @Override
    public synchronized boolean setTrust(String address, boolean value) {
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
            return false;
        }
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.setDevicePropertyBooleanNative(this.getObjectPathFromAddress(address), "Trusted", value ? 1 : 0);
    }

    @Override
    public synchronized boolean getTrustState(String address) {
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            return false;
        }
        String val = this.mDeviceProperties.getProperty(address, "Trusted");
        if (val == null) {
            return false;
        }
        return val.equals("true");
    }

    @Override
    public synchronized int getRemoteClass(String address) {
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            return -16777216;
        }
        String val = this.mDeviceProperties.getProperty(address, "Class");
        if (val == null) {
            return -16777216;
        }
        return Integer.valueOf(val);
    }

    @Override
    public synchronized ParcelUuid[] getRemoteUuids(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return null;
        }
        return this.getUuidFromCache(address);
    }

    ParcelUuid[] getUuidFromCache(String address) {
        String value = this.mDeviceProperties.getProperty(address, "UUIDs");
        if (value == null) {
            return null;
        }
        String[] uuidStrings = null;
        uuidStrings = value.split(",");
        ParcelUuid[] uuids = new ParcelUuid[uuidStrings.length];
        for (int i = 0; i < uuidStrings.length; ++i) {
            uuids[i] = ParcelUuid.fromString(uuidStrings[i]);
        }
        return uuids;
    }

    @Override
    public synchronized boolean fetchRemoteUuids(String address, ParcelUuid uuid, IBluetoothCallback callback) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        RemoteService service = new RemoteService(address, uuid);
        if (uuid != null && this.mUuidCallbackTracker.get(service) != null) {
            return false;
        }
        if (this.mUuidIntentTracker.contains(address)) {
            if (uuid != null) {
                this.mUuidCallbackTracker.put(new RemoteService(address, uuid), callback);
            }
            return true;
        }
        boolean ret = this.createDeviceNative(address);
        this.mUuidIntentTracker.add(address);
        if (uuid != null) {
            this.mUuidCallbackTracker.put(new RemoteService(address, uuid), callback);
        }
        Message message = this.mHandler.obtainMessage(1);
        message.obj = address;
        this.mHandler.sendMessageDelayed(message, 6000L);
        return ret;
    }

    @Override
    public int getRemoteServiceChannel(String address, ParcelUuid uuid) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return -1;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return Integer.MIN_VALUE;
        }
        if (this.mDeviceProperties.isEmpty() && this.mDeviceProperties.updateCache(address) == null) {
            return -1;
        }
        Map<ParcelUuid, Integer> value = this.mDeviceServiceChannelCache.get(address);
        if (value != null && value.containsKey(uuid)) {
            return value.get(uuid);
        }
        return -1;
    }

    @Override
    public synchronized boolean setPin(String address, byte[] pin) {
        String pinString;
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (pin == null || pin.length <= 0 || pin.length > 16 || !BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        address = address.toUpperCase();
        Integer data = this.mEventLoop.getPasskeyAgentRequestData().remove(address);
        if (data == null) {
            Log.w(TAG, "setPin(" + address + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
            return false;
        }
        try {
            pinString = new String(pin, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            Log.e(TAG, "UTF8 not supported?!?");
            return false;
        }
        return this.setPinNative(address, pinString, data);
    }

    @Override
    public synchronized boolean setPasskey(String address, int passkey) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (passkey < 0 || passkey > 999999 || !BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        address = address.toUpperCase();
        Integer data = this.mEventLoop.getPasskeyAgentRequestData().remove(address);
        if (data == null) {
            Log.w(TAG, "setPasskey(" + address + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
            return false;
        }
        return this.setPasskeyNative(address, passkey, data);
    }

    @Override
    public synchronized boolean setPairingConfirmation(String address, boolean confirm) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        address = address.toUpperCase();
        Integer data = this.mEventLoop.getPasskeyAgentRequestData().remove(address);
        if (data == null) {
            Log.w(TAG, "setPasskey(" + address + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
            return false;
        }
        return this.setPairingConfirmationNative(address, confirm, data);
    }

    @Override
    public synchronized boolean setRemoteOutOfBandData(String address) {
        byte[] randomizer;
        byte[] hash;
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        address = address.toUpperCase();
        Integer data = this.mEventLoop.getPasskeyAgentRequestData().remove(address);
        if (data == null) {
            Log.w(TAG, "setRemoteOobData(" + address + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
            return false;
        }
        Pair<byte[], byte[]> val = this.mDeviceOobData.get(address);
        if (val == null) {
            hash = new byte[16];
            randomizer = new byte[16];
        } else {
            hash = (byte[])val.first;
            randomizer = (byte[])val.second;
        }
        return this.setRemoteOutOfBandDataNative(address, hash, randomizer, data);
    }

    @Override
    public synchronized boolean cancelPairingUserInput(String address) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        this.mBondState.setBondState(address, 10, 3);
        address = address.toUpperCase();
        Integer data = this.mEventLoop.getPasskeyAgentRequestData().remove(address);
        if (data == null) {
            Log.w(TAG, "cancelUserInputNative(" + address + ") called but no native data " + "available, ignoring. Maybe the PasskeyAgent Request was already cancelled " + "by the remote or by bluez.\n");
            return false;
        }
        return this.cancelPairingUserInputNative(address, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDeviceServiceChannelCache(String address) {
        Log.d(TAG, "updateDeviceServiceChannelCache(" + address + ")");
        ParcelUuid[] deviceUuids = this.getRemoteUuids(address);
        ArrayList<ParcelUuid> applicationUuids = new ArrayList<ParcelUuid>();
        BluetoothService bluetoothService = this;
        synchronized (bluetoothService) {
            for (RemoteService service : this.mUuidCallbackTracker.keySet()) {
                if (!service.address.equals(address)) continue;
                applicationUuids.add(service.uuid);
            }
        }
        HashMap<ParcelUuid, Integer> uuidToChannelMap = new HashMap<ParcelUuid, Integer>();
        for (ParcelUuid uuid : RFCOMM_UUIDS) {
            if (!BluetoothUuid.isUuidPresent(deviceUuids, uuid)) continue;
            int channel = this.getDeviceServiceChannelForUuid(address, uuid);
            uuidToChannelMap.put(uuid, channel);
            Log.d(TAG, "\tuuid(system): " + uuid + " " + channel);
        }
        for (ParcelUuid uuid : applicationUuids) {
            if (!BluetoothUuid.isUuidPresent(deviceUuids, uuid)) continue;
            int channel = this.getDeviceServiceChannelForUuid(address, uuid);
            uuidToChannelMap.put(uuid, channel);
            Log.d(TAG, "\tuuid(application): " + uuid + " " + channel);
        }
        BluetoothService bluetoothService2 = this;
        synchronized (bluetoothService2) {
            Iterator<RemoteService> iter = this.mUuidCallbackTracker.keySet().iterator();
            while (iter.hasNext()) {
                RemoteService service = iter.next();
                if (!service.address.equals(address) || !uuidToChannelMap.containsKey(service.uuid)) continue;
                int channel = (Integer)uuidToChannelMap.get(service.uuid);
                Log.d(TAG, "Making callback for " + service.uuid + " with result " + channel);
                IBluetoothCallback callback = this.mUuidCallbackTracker.get(service);
                if (callback != null) {
                    try {
                        callback.onRfcommChannelFound(channel);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "", e);
                    }
                }
                iter.remove();
            }
            this.mDeviceServiceChannelCache.put(address, uuidToChannelMap);
        }
    }

    private int getDeviceServiceChannelForUuid(String address, ParcelUuid uuid) {
        return this.getDeviceServiceChannelNative(this.getObjectPathFromAddress(address), uuid.toString(), 4);
    }

    @Override
    public synchronized int addRfcommServiceRecord(String serviceName, ParcelUuid uuid, int channel, IBinder b) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return -1;
        }
        if (serviceName == null || uuid == null || channel < 1 || channel > 30) {
            return -1;
        }
        if (BluetoothUuid.isUuidPresent(BluetoothUuid.RESERVED_UUIDS, uuid)) {
            Log.w(TAG, "Attempted to register a reserved UUID: " + uuid);
            return -1;
        }
        int handle = this.addRfcommServiceRecordNative(serviceName, uuid.getUuid().getMostSignificantBits(), uuid.getUuid().getLeastSignificantBits(), (short)channel);
        Log.d(TAG, "new handle " + Integer.toHexString(handle));
        if (handle == -1) {
            return -1;
        }
        ServiceRecordClient client = new ServiceRecordClient();
        client.pid = Binder.getCallingPid();
        client.binder = b;
        client.death = new Reaper(handle, client.pid, 10);
        this.mServiceRecordToPid.put(new Integer(handle), client);
        try {
            b.linkToDeath(client.death, 0);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            client.death = null;
        }
        return handle;
    }

    @Override
    public void removeServiceRecord(int handle) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (this.getBluetoothStateInternal() == 10) {
            return;
        }
        Message message = this.mHandler.obtainMessage(3);
        message.obj = new Pair<Integer, Integer>(handle, Binder.getCallingPid());
        this.mHandler.sendMessage(message);
    }

    private synchronized void checkAndRemoveRecord(int handle, int pid) {
        ServiceRecordClient client = this.mServiceRecordToPid.get(handle);
        if (client != null && pid == client.pid) {
            Log.d(TAG, "Removing service record " + Integer.toHexString(handle) + " for pid " + pid);
            if (client.death != null) {
                client.binder.unlinkToDeath(client.death, 0);
            }
            this.mServiceRecordToPid.remove(handle);
            this.removeServiceRecordNative(handle);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean changeApplicationBluetoothState(boolean on, IBluetoothStateChangeCallback callback, IBinder binder) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        int pid = Binder.getCallingPid();
        if (!this.mStateChangeTracker.containsKey(pid)) {
            if (!on) return false;
            this.mStateChangeTracker.put(pid, callback);
        } else if (!on) {
            this.mStateChangeTracker.remove(pid);
        }
        if (binder != null) {
            try {
                binder.linkToDeath(new Reaper(pid, 11), 0);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
                return false;
            }
        }
        int type = on ? 3 : 4;
        this.mBluetoothState.sendMessage(type, callback);
        return true;
    }

    boolean isApplicationStateChangeTrackerEmpty() {
        return this.mStateChangeTracker.isEmpty();
    }

    void clearApplicationStateChangeTracker() {
        this.mStateChangeTracker.clear();
    }

    Collection<IBluetoothStateChangeCallback> getApplicationStateChangeCallbacks() {
        return this.mStateChangeTracker.values();
    }

    int getNumberOfApplicationStateChangeTrackers() {
        return this.mStateChangeTracker.size();
    }

    private void registerForAirplaneMode(IntentFilter filter) {
        ContentResolver resolver = this.mContext.getContentResolver();
        String airplaneModeRadios = Settings.System.getString(resolver, "airplane_mode_radios");
        String toggleableRadios = Settings.System.getString(resolver, "airplane_mode_toggleable_radios");
        this.mIsAirplaneSensitive = airplaneModeRadios == null ? true : airplaneModeRadios.contains("bluetooth");
        boolean bl = this.mIsAirplaneToggleable = toggleableRadios == null ? false : toggleableRadios.contains("bluetooth");
        if (this.mIsAirplaneSensitive) {
            filter.addAction("android.intent.action.AIRPLANE_MODE");
        }
    }

    private final boolean isAirplaneModeOn() {
        return Settings.System.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) == 1;
    }

    synchronized void sendUuidIntent(String address) {
        Parcelable[] uuid = this.getUuidFromCache(address);
        Intent intent = new Intent("android.bluetooth.device.action.UUID");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(address));
        intent.putExtra("android.bluetooth.device.extra.UUID", uuid);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        this.mUuidIntentTracker.remove(address);
    }

    synchronized void makeServiceChannelCallbacks(String address) {
        Iterator<RemoteService> iter = this.mUuidCallbackTracker.keySet().iterator();
        while (iter.hasNext()) {
            RemoteService service = iter.next();
            if (!service.address.equals(address)) continue;
            Log.d(TAG, "Cleaning up failed UUID channel lookup: " + service.address + " " + service.uuid);
            IBluetoothCallback callback = this.mUuidCallbackTracker.get(service);
            if (callback != null) {
                try {
                    callback.onRfcommChannelFound(-1);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "", e);
                }
            }
            iter.remove();
        }
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.getBluetoothStateInternal() != 12) {
            return;
        }
        pw.println("mIsAirplaneSensitive = " + this.mIsAirplaneSensitive);
        pw.println("mIsAirplaneToggleable = " + this.mIsAirplaneToggleable);
        pw.println("Local address = " + this.getAddress());
        pw.println("Local name = " + this.getName());
        pw.println("isDiscovering() = " + this.isDiscovering());
        this.mAdapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 1);
        this.mAdapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 4);
        this.mAdapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 5);
        this.dumpKnownDevices(pw);
        this.dumpAclConnectedDevices(pw);
        this.dumpHeadsetService(pw);
        this.dumpInputDeviceProfile(pw);
        this.dumpPanProfile(pw);
        this.dumpApplicationServiceRecords(pw);
        this.dumpProfileState(pw);
    }

    private void dumpProfileState(PrintWriter pw) {
        pw.println("\n--Profile State dump--");
        pw.println("\n Headset profile state:" + this.mAdapter.getProfileConnectionState(1));
        pw.println("\n A2dp profile state:" + this.mAdapter.getProfileConnectionState(2));
        pw.println("\n HID profile state:" + this.mAdapter.getProfileConnectionState(4));
        pw.println("\n PAN profile state:" + this.mAdapter.getProfileConnectionState(5));
    }

    private void dumpHeadsetService(PrintWriter pw) {
        pw.println("\n--Headset Service--");
        if (this.mHeadsetProxy != null) {
            List<BluetoothDevice> deviceList = this.mHeadsetProxy.getConnectedDevices();
            if (deviceList.size() == 0) {
                pw.println("No headsets connected");
            } else {
                BluetoothDevice device = deviceList.get(0);
                pw.println("\ngetConnectedDevices[0] = " + device);
                this.dumpHeadsetConnectionState(pw, device);
                pw.println("getBatteryUsageHint() = " + this.mHeadsetProxy.getBatteryUsageHint(device));
            }
            deviceList.clear();
            deviceList = this.mHeadsetProxy.getDevicesMatchingConnectionStates(new int[]{2, 0});
            pw.println("--Connected and Disconnected Headsets");
            for (BluetoothDevice device : deviceList) {
                pw.println(device);
                if (!this.mHeadsetProxy.isAudioConnected(device)) continue;
                pw.println("SCO audio connected to device:" + device);
            }
        }
    }

    private void dumpInputDeviceProfile(PrintWriter pw) {
        pw.println("\n--Bluetooth Service- Input Device Profile");
        if (this.mInputDevice != null) {
            List<BluetoothDevice> deviceList = this.mInputDevice.getConnectedDevices();
            if (deviceList.size() == 0) {
                pw.println("No input devices connected");
            } else {
                pw.println("Number of connected devices:" + deviceList.size());
                BluetoothDevice device = deviceList.get(0);
                pw.println("getConnectedDevices[0] = " + device);
                pw.println("Priority of Connected device = " + this.mInputDevice.getPriority(device));
                switch (this.mInputDevice.getConnectionState(device)) {
                    case 1: {
                        pw.println("getConnectionState() = STATE_CONNECTING");
                        break;
                    }
                    case 2: {
                        pw.println("getConnectionState() = STATE_CONNECTED");
                        break;
                    }
                    case 3: {
                        pw.println("getConnectionState() = STATE_DISCONNECTING");
                    }
                }
            }
            deviceList.clear();
            deviceList = this.mInputDevice.getDevicesMatchingConnectionStates(new int[]{2, 0});
            pw.println("--Connected and Disconnected input devices");
            for (BluetoothDevice device : deviceList) {
                pw.println(device);
            }
        }
    }

    private void dumpPanProfile(PrintWriter pw) {
        pw.println("\n--Bluetooth Service- Pan Profile");
        if (this.mPan != null) {
            List<BluetoothDevice> deviceList = this.mPan.getConnectedDevices();
            if (deviceList.size() == 0) {
                pw.println("No Pan devices connected");
            } else {
                pw.println("Number of connected devices:" + deviceList.size());
                BluetoothDevice device = deviceList.get(0);
                pw.println("getConnectedDevices[0] = " + device);
                switch (this.mPan.getConnectionState(device)) {
                    case 1: {
                        pw.println("getConnectionState() = STATE_CONNECTING");
                        break;
                    }
                    case 2: {
                        pw.println("getConnectionState() = STATE_CONNECTED");
                        break;
                    }
                    case 3: {
                        pw.println("getConnectionState() = STATE_DISCONNECTING");
                    }
                }
            }
            deviceList.clear();
            deviceList = this.mPan.getDevicesMatchingConnectionStates(new int[]{2, 0});
            pw.println("--Connected and Disconnected Pan devices");
            for (BluetoothDevice device : deviceList) {
                pw.println(device);
            }
        }
    }

    private void dumpHeadsetConnectionState(PrintWriter pw, BluetoothDevice device) {
        switch (this.mHeadsetProxy.getConnectionState(device)) {
            case 1: {
                pw.println("getConnectionState() = STATE_CONNECTING");
                break;
            }
            case 2: {
                pw.println("getConnectionState() = STATE_CONNECTED");
                break;
            }
            case 3: {
                pw.println("getConnectionState() = STATE_DISCONNECTING");
                break;
            }
            case 12: {
                pw.println("getConnectionState() = STATE_AUDIO_CONNECTED");
            }
        }
    }

    private void dumpApplicationServiceRecords(PrintWriter pw) {
        pw.println("\n--Application Service Records--");
        for (Integer handle : this.mServiceRecordToPid.keySet()) {
            Integer pid = this.mServiceRecordToPid.get((Object)handle).pid;
            pw.println("\tpid " + pid + " handle " + Integer.toHexString(handle));
        }
    }

    private void dumpAclConnectedDevices(PrintWriter pw) {
        String[] devicesObjectPath = this.getKnownDevices();
        pw.println("\n--ACL connected devices--");
        if (devicesObjectPath != null) {
            for (String device : devicesObjectPath) {
                pw.println(this.getAddressFromObjectPath(device));
            }
        }
    }

    private void dumpKnownDevices(PrintWriter pw) {
        pw.println("\n--Known devices--");
        for (String address : this.mDeviceProperties.keySet()) {
            int bondState = this.mBondState.getBondState(address);
            pw.printf("%s %10s (%d) %s\n", address, BluetoothService.toBondStateString(bondState), this.mBondState.getAttempt(address), this.getRemoteName(address));
            Map<ParcelUuid, Integer> uuidChannels = this.mDeviceServiceChannelCache.get(address);
            if (uuidChannels == null) {
                pw.println("\tuuids = null");
            } else {
                for (ParcelUuid uuid : uuidChannels.keySet()) {
                    Integer channel = uuidChannels.get(uuid);
                    if (channel == null) {
                        pw.println("\t" + uuid);
                        continue;
                    }
                    pw.println("\t" + uuid + " RFCOMM channel = " + channel);
                }
            }
            for (RemoteService service : this.mUuidCallbackTracker.keySet()) {
                if (!service.address.equals(address)) continue;
                pw.println("\tPENDING CALLBACK: " + service.uuid);
            }
        }
    }

    private void getProfileProxy() {
        this.mAdapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 1);
    }

    static int bluezStringToScanMode(boolean pairable, boolean discoverable) {
        if (pairable && discoverable) {
            return 23;
        }
        if (pairable && !discoverable) {
            return 21;
        }
        return 20;
    }

    static String scanModeToBluezString(int mode) {
        switch (mode) {
            case 20: {
                return "off";
            }
            case 21: {
                return "connectable";
            }
            case 23: {
                return "discoverable";
            }
        }
        return null;
    }

    String getAddressFromObjectPath(String objectPath) {
        String adapterObjectPath = this.mAdapterProperties.getObjectPath();
        if (adapterObjectPath == null || objectPath == null) {
            Log.e(TAG, "getAddressFromObjectPath: AdapterObjectPath:" + adapterObjectPath + "  or deviceObjectPath:" + objectPath + " is null");
            return null;
        }
        if (!objectPath.startsWith(adapterObjectPath)) {
            Log.e(TAG, "getAddressFromObjectPath: AdapterObjectPath:" + adapterObjectPath + "  is not a prefix of deviceObjectPath:" + objectPath + "bluetoothd crashed ?");
            return null;
        }
        String address = objectPath.substring(adapterObjectPath.length());
        if (address != null) {
            return address.replace('_', ':');
        }
        Log.e(TAG, "getAddressFromObjectPath: Address being returned is null");
        return null;
    }

    String getObjectPathFromAddress(String address) {
        String path = this.mAdapterProperties.getObjectPath();
        if (path == null) {
            Log.e(TAG, "Error: Object Path is null");
            return null;
        }
        path = path + address.replace(":", "_");
        return path;
    }

    void setLinkTimeout(String address, int num_slots) {
        String path = this.getObjectPathFromAddress(address);
        boolean result = this.setLinkTimeoutNative(path, num_slots);
        if (!result) {
            Log.d(TAG, "Set Link Timeout to " + num_slots + " slots failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTetheringOn() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothPanProfileHandler bluetoothPanProfileHandler = this.mBluetoothPanProfileHandler;
        synchronized (bluetoothPanProfileHandler) {
            return this.mBluetoothPanProfileHandler.isTetheringOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean allowIncomingTethering() {
        BluetoothPanProfileHandler bluetoothPanProfileHandler = this.mBluetoothPanProfileHandler;
        synchronized (bluetoothPanProfileHandler) {
            return this.mBluetoothPanProfileHandler.allowIncomingTethering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBluetoothTethering(boolean value) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothPanProfileHandler bluetoothPanProfileHandler = this.mBluetoothPanProfileHandler;
        synchronized (bluetoothPanProfileHandler) {
            this.mBluetoothPanProfileHandler.setBluetoothTethering(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPanDeviceConnectionState(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothPanProfileHandler bluetoothPanProfileHandler = this.mBluetoothPanProfileHandler;
        synchronized (bluetoothPanProfileHandler) {
            return this.mBluetoothPanProfileHandler.getPanDeviceConnectionState(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectPanDevice(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        BluetoothPanProfileHandler bluetoothPanProfileHandler = this.mBluetoothPanProfileHandler;
        synchronized (bluetoothPanProfileHandler) {
            return this.mBluetoothPanProfileHandler.connectPanDevice(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BluetoothDevice> getConnectedPanDevices() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothPanProfileHandler bluetoothPanProfileHandler = this.mBluetoothPanProfileHandler;
        synchronized (bluetoothPanProfileHandler) {
            return this.mBluetoothPanProfileHandler.getConnectedPanDevices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BluetoothDevice> getPanDevicesMatchingConnectionStates(int[] states) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothPanProfileHandler bluetoothPanProfileHandler = this.mBluetoothPanProfileHandler;
        synchronized (bluetoothPanProfileHandler) {
            return this.mBluetoothPanProfileHandler.getPanDevicesMatchingConnectionStates(states);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disconnectPanDevice(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        BluetoothPanProfileHandler bluetoothPanProfileHandler = this.mBluetoothPanProfileHandler;
        synchronized (bluetoothPanProfileHandler) {
            return this.mBluetoothPanProfileHandler.disconnectPanDevice(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePanDeviceStateChange(BluetoothDevice device, String iface, int state, int role) {
        BluetoothPanProfileHandler bluetoothPanProfileHandler = this.mBluetoothPanProfileHandler;
        synchronized (bluetoothPanProfileHandler) {
            this.mBluetoothPanProfileHandler.handlePanDeviceStateChange(device, iface, state, role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePanDeviceStateChange(BluetoothDevice device, int state, int role) {
        BluetoothPanProfileHandler bluetoothPanProfileHandler = this.mBluetoothPanProfileHandler;
        synchronized (bluetoothPanProfileHandler) {
            this.mBluetoothPanProfileHandler.handlePanDeviceStateChange(device, null, state, role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectInputDevice(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(device.getAddress());
        BluetoothInputProfileHandler bluetoothInputProfileHandler = this.mBluetoothInputProfileHandler;
        synchronized (bluetoothInputProfileHandler) {
            return this.mBluetoothInputProfileHandler.connectInputDevice(device, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectInputDeviceInternal(BluetoothDevice device) {
        BluetoothInputProfileHandler bluetoothInputProfileHandler = this.mBluetoothInputProfileHandler;
        synchronized (bluetoothInputProfileHandler) {
            return this.mBluetoothInputProfileHandler.connectInputDeviceInternal(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disconnectInputDevice(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(device.getAddress());
        BluetoothInputProfileHandler bluetoothInputProfileHandler = this.mBluetoothInputProfileHandler;
        synchronized (bluetoothInputProfileHandler) {
            return this.mBluetoothInputProfileHandler.disconnectInputDevice(device, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnectInputDeviceInternal(BluetoothDevice device) {
        BluetoothInputProfileHandler bluetoothInputProfileHandler = this.mBluetoothInputProfileHandler;
        synchronized (bluetoothInputProfileHandler) {
            return this.mBluetoothInputProfileHandler.disconnectInputDeviceInternal(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInputDeviceConnectionState(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothInputProfileHandler bluetoothInputProfileHandler = this.mBluetoothInputProfileHandler;
        synchronized (bluetoothInputProfileHandler) {
            return this.mBluetoothInputProfileHandler.getInputDeviceConnectionState(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BluetoothDevice> getConnectedInputDevices() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothInputProfileHandler bluetoothInputProfileHandler = this.mBluetoothInputProfileHandler;
        synchronized (bluetoothInputProfileHandler) {
            return this.mBluetoothInputProfileHandler.getConnectedInputDevices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BluetoothDevice> getInputDevicesMatchingConnectionStates(int[] states) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothInputProfileHandler bluetoothInputProfileHandler = this.mBluetoothInputProfileHandler;
        synchronized (bluetoothInputProfileHandler) {
            return this.mBluetoothInputProfileHandler.getInputDevicesMatchingConnectionStates(states);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInputDevicePriority(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothInputProfileHandler bluetoothInputProfileHandler = this.mBluetoothInputProfileHandler;
        synchronized (bluetoothInputProfileHandler) {
            return this.mBluetoothInputProfileHandler.getInputDevicePriority(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setInputDevicePriority(BluetoothDevice device, int priority) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        BluetoothInputProfileHandler bluetoothInputProfileHandler = this.mBluetoothInputProfileHandler;
        synchronized (bluetoothInputProfileHandler) {
            return this.mBluetoothInputProfileHandler.setInputDevicePriority(device, priority);
        }
    }

    @Override
    public boolean allowIncomingProfileConnect(BluetoothDevice device, boolean allow) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        String address = device.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            return false;
        }
        Integer data = this.getAuthorizationAgentRequestData(address);
        if (data == null) {
            Log.w(TAG, "allowIncomingProfileConnect(" + device + ") called but no native data available");
            return false;
        }
        BluetoothService.log("allowIncomingProfileConnect: " + device + " : " + allow + " : " + data);
        return this.setAuthorizationNative(address, allow, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BluetoothDevice> lookupInputDevicesMatchingStates(int[] states) {
        BluetoothInputProfileHandler bluetoothInputProfileHandler = this.mBluetoothInputProfileHandler;
        synchronized (bluetoothInputProfileHandler) {
            return this.mBluetoothInputProfileHandler.lookupInputDevicesMatchingStates(states);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleInputDevicePropertyChange(String address, boolean connected) {
        BluetoothInputProfileHandler bluetoothInputProfileHandler = this.mBluetoothInputProfileHandler;
        synchronized (bluetoothInputProfileHandler) {
            this.mBluetoothInputProfileHandler.handleInputDevicePropertyChange(address, connected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerAppConfiguration(BluetoothHealthAppConfiguration config, IBluetoothHealthCallback callback) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            return this.mBluetoothHealthProfileHandler.registerAppConfiguration(config, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregisterAppConfiguration(BluetoothHealthAppConfiguration config) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            return this.mBluetoothHealthProfileHandler.unregisterAppConfiguration(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectChannelToSource(BluetoothDevice device, BluetoothHealthAppConfiguration config) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            return this.mBluetoothHealthProfileHandler.connectChannelToSource(device, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectChannelToSink(BluetoothDevice device, BluetoothHealthAppConfiguration config, int channelType) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            return this.mBluetoothHealthProfileHandler.connectChannel(device, config, channelType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disconnectChannel(BluetoothDevice device, BluetoothHealthAppConfiguration config, int id2) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            return this.mBluetoothHealthProfileHandler.disconnectChannel(device, config, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor getMainChannelFd(BluetoothDevice device, BluetoothHealthAppConfiguration config) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            return this.mBluetoothHealthProfileHandler.getMainChannelFd(device, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onHealthDevicePropertyChanged(String devicePath, String channelPath) {
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            this.mBluetoothHealthProfileHandler.onHealthDevicePropertyChanged(devicePath, channelPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onHealthDeviceChannelChanged(String devicePath, String channelPath, boolean exists) {
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            this.mBluetoothHealthProfileHandler.onHealthDeviceChannelChanged(devicePath, channelPath, exists);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onHealthDeviceChannelConnectionError(int channelCode, int newState) {
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            this.mBluetoothHealthProfileHandler.onHealthDeviceChannelConnectionError(channelCode, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHealthDeviceConnectionState(BluetoothDevice device) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            return this.mBluetoothHealthProfileHandler.getHealthDeviceConnectionState(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BluetoothDevice> getConnectedHealthDevices() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            return this.mBluetoothHealthProfileHandler.getConnectedHealthDevices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BluetoothDevice> getHealthDevicesMatchingConnectionStates(int[] states) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        BluetoothHealthProfileHandler bluetoothHealthProfileHandler = this.mBluetoothHealthProfileHandler;
        synchronized (bluetoothHealthProfileHandler) {
            return this.mBluetoothHealthProfileHandler.getHealthDevicesMatchingConnectionStates(states);
        }
    }

    boolean notifyIncomingHidConnection(String address) {
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state == null) {
            return false;
        }
        Message msg = new Message();
        msg.what = 6;
        state.sendMessage(msg);
        return true;
    }

    @Override
    public boolean connectHeadset(String address) {
        if (this.getBondState(address) != 12) {
            return false;
        }
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            msg.arg1 = 1;
            msg.obj = state;
            this.mHfpProfileState.sendMessage(msg);
            return true;
        }
        return false;
    }

    @Override
    public boolean disconnectHeadset(String address) {
        if (this.getBondState(address) != 12) {
            return false;
        }
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            msg.arg1 = 50;
            msg.obj = state;
            this.mHfpProfileState.sendMessage(msg);
            return true;
        }
        return false;
    }

    public boolean connectSink(String address) {
        if (this.getBondState(address) != 12) {
            return false;
        }
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            msg.arg1 = 3;
            msg.obj = state;
            this.mA2dpProfileState.sendMessage(msg);
            return true;
        }
        return false;
    }

    public boolean disconnectSink(String address) {
        if (this.getBondState(address) != 12) {
            return false;
        }
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            msg.arg1 = 52;
            msg.obj = state;
            this.mA2dpProfileState.sendMessage(msg);
            return true;
        }
        return false;
    }

    BluetoothDeviceProfileState addProfileState(String address, boolean setTrust) {
        BluetoothDeviceProfileState state = new BluetoothDeviceProfileState(this.mContext, address, this, this.mA2dpService, setTrust);
        this.mDeviceProfileState.put(address, state);
        state.start();
        return state;
    }

    void removeProfileState(String address) {
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state == null) {
            return;
        }
        state.quit();
        this.mDeviceProfileState.remove(address);
    }

    String[] getKnownDevices() {
        String[] bonds = null;
        String val = this.getProperty("Devices", true);
        if (val != null) {
            bonds = val.split(",");
        }
        return bonds;
    }

    private void initProfileState() {
        String[] bonds = null;
        String val = this.getProperty("Devices", false);
        if (val != null) {
            bonds = val.split(",");
        }
        if (bonds == null) {
            return;
        }
        for (String path : bonds) {
            String address = this.getAddressFromObjectPath(path);
            BluetoothDeviceProfileState state = this.addProfileState(address, false);
        }
    }

    private void autoConnect() {
        String[] bonds = this.getKnownDevices();
        if (bonds == null) {
            return;
        }
        for (String path : bonds) {
            String address = this.getAddressFromObjectPath(path);
            BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
            if (state == null) continue;
            Message msg = new Message();
            msg.what = 101;
            state.sendMessage(msg);
        }
    }

    @Override
    public boolean notifyIncomingConnection(String address, boolean rejected) {
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            if (rejected) {
                if (this.mA2dpService.getPriority(this.getRemoteDevice(address)) >= 100) {
                    msg.what = 103;
                    msg.arg1 = 3;
                    state.sendMessageDelayed(msg, 4000L);
                }
            } else {
                msg.what = 2;
                state.sendMessage(msg);
            }
            return true;
        }
        return false;
    }

    boolean notifyIncomingA2dpConnection(String address, boolean rejected) {
        BluetoothDeviceProfileState state = this.mDeviceProfileState.get(address);
        if (state != null) {
            Message msg = new Message();
            if (rejected) {
                if (this.mHeadsetProxy.getPriority(this.getRemoteDevice(address)) >= 100) {
                    msg.what = 103;
                    msg.arg1 = 1;
                    state.sendMessageDelayed(msg, 4000L);
                }
            } else {
                msg.what = 4;
                state.sendMessage(msg);
            }
            return true;
        }
        return false;
    }

    void setA2dpService(BluetoothA2dpService a2dpService) {
        this.mA2dpService = a2dpService;
    }

    Integer getAuthorizationAgentRequestData(String address) {
        Integer data = this.mEventLoop.getAuthorizationAgentRequestData().remove(address);
        return data;
    }

    public void sendProfileStateMessage(int profile, int cmd) {
        Message msg = new Message();
        msg.what = cmd;
        if (profile == 0) {
            this.mHfpProfileState.sendMessage(msg);
        } else if (profile == 1) {
            this.mA2dpProfileState.sendMessage(msg);
        }
    }

    @Override
    public int getAdapterConnectionState() {
        return this.mAdapterConnectionState;
    }

    @Override
    public int getProfileConnectionState(int profile) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        Pair<Integer, Integer> state = this.mProfileConnectionState.get(profile);
        if (state == null) {
            return 0;
        }
        return (Integer)state.first;
    }

    private void updateProfileConnectionState(int profile, int newState, int oldState) {
        int numDev = 1;
        int newHashState = newState;
        boolean update = true;
        Pair<Integer, Integer> stateNumDev = this.mProfileConnectionState.get(profile);
        if (stateNumDev != null) {
            int currHashState = (Integer)stateNumDev.first;
            numDev = (Integer)stateNumDev.second;
            if (newState == currHashState) {
                ++numDev;
            } else if (newState == 2 || newState == 1 && currHashState != 2) {
                numDev = 1;
            } else if (numDev == 1 && oldState == currHashState) {
                update = true;
            } else if (numDev > 1 && oldState == currHashState) {
                --numDev;
                if (currHashState == 2 || currHashState == 1) {
                    newHashState = currHashState;
                }
            } else {
                update = false;
            }
        }
        if (update) {
            this.mProfileConnectionState.put(profile, new Pair<Integer, Integer>(newHashState, numDev));
        }
    }

    @Override
    public synchronized void sendConnectionStateChange(BluetoothDevice device, int profile, int state, int prevState) {
        if (this.getBluetoothStateInternal() == 10) {
            return;
        }
        if (!this.validateProfileConnectionState(state) || !this.validateProfileConnectionState(prevState)) {
            Log.e(TAG, "Error in sendConnectionStateChange: prevState " + prevState + " state " + state);
            return;
        }
        this.updateProfileConnectionState(profile, state, prevState);
        if (this.updateCountersAndCheckForConnectionStateChange(state, prevState)) {
            this.mAdapterConnectionState = state;
            if (state == 0) {
                this.mBluetoothState.sendMessage(52);
            }
            Intent intent = new Intent("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", device);
            intent.putExtra("android.bluetooth.adapter.extra.CONNECTION_STATE", this.convertToAdapterState(state));
            intent.putExtra("android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE", this.convertToAdapterState(prevState));
            intent.addFlags(0x10000000);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            Log.d(TAG, "CONNECTION_STATE_CHANGE: " + device + ": " + prevState + " -> " + state);
        }
    }

    private boolean validateProfileConnectionState(int state) {
        return state == 0 || state == 1 || state == 2 || state == 3;
    }

    private int convertToAdapterState(int state) {
        switch (state) {
            case 0: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        Log.e(TAG, "Error in convertToAdapterState");
        return -1;
    }

    private boolean updateCountersAndCheckForConnectionStateChange(int state, int prevState) {
        switch (prevState) {
            case 1: {
                --this.mProfilesConnecting;
                break;
            }
            case 2: {
                --this.mProfilesConnected;
                break;
            }
            case 3: {
                --this.mProfilesDisconnecting;
            }
        }
        switch (state) {
            case 1: {
                ++this.mProfilesConnecting;
                return this.mProfilesConnected == 0 && this.mProfilesConnecting == 1;
            }
            case 2: {
                ++this.mProfilesConnected;
                return this.mProfilesConnected == 1;
            }
            case 3: {
                ++this.mProfilesDisconnecting;
                return this.mProfilesConnected == 0 && this.mProfilesDisconnecting == 1;
            }
            case 0: {
                return this.mProfilesConnected == 0 && this.mProfilesConnecting == 0;
            }
        }
        return true;
    }

    private void createIncomingConnectionStateFile() {
        File f = new File(INCOMING_CONNECTION_FILE);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                Log.e(TAG, "IOException: cannot create file");
            }
        }
    }

    public Pair<Integer, String> getIncomingState(String address) {
        if (this.mIncomingConnections.isEmpty()) {
            this.createIncomingConnectionStateFile();
            this.readIncomingConnectionState();
        }
        return this.mIncomingConnections.get(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIncomingConnectionState() {
        HashMap<String, Pair<Integer, String>> hashMap = this.mIncomingConnections;
        synchronized (hashMap) {
            FileInputStream fstream = null;
            try {
                String line;
                fstream = new FileInputStream(INCOMING_CONNECTION_FILE);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader file = new BufferedReader(new InputStreamReader(in));
                while ((line = file.readLine()) != null) {
                    String[] value;
                    if ((line = line.trim()).length() == 0 || (value = line.split(",")) == null || value.length != 3) continue;
                    Integer val1 = Integer.parseInt(value[1]);
                    Pair<Integer, String> val = new Pair<Integer, String>(val1, value[2]);
                    this.mIncomingConnections.put(value[0], val);
                }
            }
            catch (FileNotFoundException e) {
                BluetoothService.log("FileNotFoundException: readIncomingConnectionState" + e.toString());
            }
            catch (IOException e) {
                BluetoothService.log("IOException: readIncomingConnectionState" + e.toString());
            }
            finally {
                if (fstream != null) {
                    try {
                        fstream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncateIncomingConnectionFile() {
        RandomAccessFile r = null;
        try {
            r = new RandomAccessFile(INCOMING_CONNECTION_FILE, "rw");
            r.setLength(0L);
        }
        catch (FileNotFoundException e) {
            BluetoothService.log("FileNotFoundException: truncateIncomingConnectionState" + e.toString());
        }
        catch (IOException e) {
            BluetoothService.log("IOException: truncateIncomingConnectionState" + e.toString());
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIncomingConnectionState(String address, Pair<Integer, String> data) {
        HashMap<String, Pair<Integer, String>> hashMap = this.mIncomingConnections;
        synchronized (hashMap) {
            this.mIncomingConnections.put(address, data);
            this.truncateIncomingConnectionFile();
            BufferedWriter out = null;
            StringBuilder value = new StringBuilder();
            try {
                out = new BufferedWriter(new FileWriter(INCOMING_CONNECTION_FILE, true));
                for (String devAddress : this.mIncomingConnections.keySet()) {
                    Pair<Integer, String> val = this.mIncomingConnections.get(devAddress);
                    value.append(devAddress);
                    value.append(",");
                    value.append(((Integer)val.first).toString());
                    value.append(",");
                    value.append((String)val.second);
                    value.append("\n");
                }
                out.write(value.toString());
            }
            catch (FileNotFoundException e) {
                BluetoothService.log("FileNotFoundException: writeIncomingConnectionState" + e.toString());
            }
            catch (IOException e) {
                BluetoothService.log("IOException: writeIncomingConnectionState" + e.toString());
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private static native void classInitNative();

    private native void initializeNativeDataNative();

    private native boolean setupNativeDataNative();

    private native boolean tearDownNativeDataNative();

    private native void cleanupNativeDataNative();

    native String getAdapterPathNative();

    private native int isEnabledNative();

    native int enableNative();

    native int disableNative();

    native Object[] getAdapterPropertiesNative();

    private native Object[] getDevicePropertiesNative(String var1);

    private native boolean setAdapterPropertyStringNative(String var1, String var2);

    private native boolean setAdapterPropertyIntegerNative(String var1, int var2);

    private native boolean setAdapterPropertyBooleanNative(String var1, int var2);

    private native boolean startDiscoveryNative();

    private native boolean stopDiscoveryNative();

    private native boolean createPairedDeviceNative(String var1, int var2);

    private native boolean createPairedDeviceOutOfBandNative(String var1, int var2);

    private native byte[] readAdapterOutOfBandDataNative();

    private native boolean cancelDeviceCreationNative(String var1);

    private native boolean removeDeviceNative(String var1);

    private native int getDeviceServiceChannelNative(String var1, String var2, int var3);

    private native boolean cancelPairingUserInputNative(String var1, int var2);

    private native boolean setPinNative(String var1, String var2, int var3);

    private native boolean setPasskeyNative(String var1, int var2, int var3);

    private native boolean setPairingConfirmationNative(String var1, boolean var2, int var3);

    private native boolean setRemoteOutOfBandDataNative(String var1, byte[] var2, byte[] var3, int var4);

    private native boolean setDevicePropertyBooleanNative(String var1, String var2, int var3);

    private native boolean setDevicePropertyStringNative(String var1, String var2, String var3);

    private native boolean createDeviceNative(String var1);

    native boolean discoverServicesNative(String var1, String var2);

    private native int addRfcommServiceRecordNative(String var1, long var2, long var4, short var6);

    private native boolean removeServiceRecordNative(int var1);

    private native boolean setLinkTimeoutNative(String var1, int var2);

    native boolean connectInputDeviceNative(String var1);

    native boolean disconnectInputDeviceNative(String var1);

    native boolean setBluetoothTetheringNative(boolean var1, String var2, String var3);

    native boolean connectPanDeviceNative(String var1, String var2);

    native boolean disconnectPanDeviceNative(String var1);

    native boolean disconnectPanServerDeviceNative(String var1, String var2, String var3);

    private native int[] addReservedServiceRecordsNative(int[] var1);

    private native boolean removeReservedServiceRecordsNative(int[] var1);

    native String registerHealthApplicationNative(int var1, String var2, String var3, String var4);

    native String registerHealthApplicationNative(int var1, String var2, String var3);

    native boolean unregisterHealthApplicationNative(String var1);

    native boolean createChannelNative(String var1, String var2, String var3, int var4);

    native boolean destroyChannelNative(String var1, String var2, int var3);

    native String getMainChannelNative(String var1);

    native String getChannelApplicationNative(String var1);

    native ParcelFileDescriptor getChannelFdNative(String var1);

    native boolean releaseChannelFdNative(String var1);

    native boolean setAuthorizationNative(String var1, boolean var2, int var3);

    static {
        BluetoothService.classInitNative();
    }

    private class Reaper
    implements IBinder.DeathRecipient {
        int mPid;
        int mHandle;
        int mType;

        Reaper(int handle, int pid, int type) {
            this.mPid = pid;
            this.mHandle = handle;
            this.mType = type;
        }

        Reaper(int pid, int type) {
            this.mPid = pid;
            this.mType = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            BluetoothService bluetoothService = BluetoothService.this;
            synchronized (bluetoothService) {
                Log.d(BluetoothService.TAG, "Tracked app " + this.mPid + " died" + "Type:" + this.mType);
                if (this.mType == 10) {
                    BluetoothService.this.checkAndRemoveRecord(this.mHandle, this.mPid);
                } else if (this.mType == 11) {
                    BluetoothService.this.mStateChangeTracker.remove(this.mPid);
                }
            }
        }
    }

    private static class RemoteService {
        public String address;
        public ParcelUuid uuid;

        public RemoteService(String address, ParcelUuid uuid) {
            this.address = address;
            this.uuid = uuid;
        }

        public boolean equals(Object o) {
            if (o instanceof RemoteService) {
                RemoteService service = (RemoteService)o;
                return this.address.equals(service.address) && this.uuid.equals(service.uuid);
            }
            return false;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + (this.address == null ? 0 : this.address.hashCode());
            hash = hash * 31 + (this.uuid == null ? 0 : this.uuid.hashCode());
            return hash;
        }
    }

    private static class ServiceRecordClient {
        int pid;
        IBinder binder;
        IBinder.DeathRecipient death;

        private ServiceRecordClient() {
        }
    }
}

