/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.media.AudioTrack;
import android.speech.tts.AudioMessageParams;
import android.speech.tts.MessageParams;
import android.speech.tts.SilenceMessageParams;
import android.speech.tts.SynthesisMessageParams;
import android.text.TextUtils;
import android.util.Log;
import java.util.Iterator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

class AudioPlaybackHandler {
    private static final String TAG = "TTS.AudioPlaybackHandler";
    private static final boolean DBG_THREADING = false;
    private static final boolean DBG = false;
    private static final int MIN_AUDIO_BUFFER_SIZE = 8192;
    private static final int SYNTHESIS_START = 1;
    private static final int SYNTHESIS_DATA_AVAILABLE = 2;
    private static final int SYNTHESIS_DONE = 3;
    private static final int PLAY_AUDIO = 5;
    private static final int PLAY_SILENCE = 6;
    private static final int SHUTDOWN = -1;
    private static final int DEFAULT_PRIORITY = 1;
    private static final int HIGH_PRIORITY = 0;
    private final PriorityBlockingQueue<ListEntry> mQueue = new PriorityBlockingQueue();
    private final Thread mHandlerThread;
    private volatile MessageParams mCurrentParams = null;
    private volatile SynthesisMessageParams mLastSynthesisRequest = null;
    private final AtomicLong mSequenceIdCtr = new AtomicLong(0L);
    private static final long MIN_SLEEP_TIME_MS = 20L;
    private static final long MAX_SLEEP_TIME_MS = 2500L;
    private static final long MAX_PROGRESS_WAIT_MS = 2500L;

    AudioPlaybackHandler() {
        this.mHandlerThread = new Thread((Runnable)new MessageLoop(), "TTS.AudioPlaybackThread");
    }

    public void start() {
        this.mHandlerThread.start();
    }

    private void stop(MessageParams token) {
        if (token == null) {
            return;
        }
        if (token.getType() == 1) {
            AudioTrack current = ((SynthesisMessageParams)token).getAudioTrack();
            if (current != null) {
                current.stop();
            }
            this.mQueue.add(new ListEntry(3, token, 0));
        } else if (token.getType() == 2) {
            ((AudioMessageParams)token).getPlayer().stop();
        } else if (token.getType() == 3) {
            ((SilenceMessageParams)token).getConditionVariable().open();
        }
    }

    public synchronized void removePlaybackItems(String callingApp) {
        SynthesisMessageParams lastSynthesis;
        this.removeMessages(callingApp);
        MessageParams current = this.getCurrentParams();
        if (current != null && TextUtils.equals(callingApp, current.getCallingApp())) {
            this.stop(current);
        }
        if ((lastSynthesis = this.mLastSynthesisRequest) != null && lastSynthesis != current && TextUtils.equals(callingApp, lastSynthesis.getCallingApp())) {
            this.stop(lastSynthesis);
        }
    }

    public synchronized void removeAllItems() {
        this.removeAllMessages();
        MessageParams current = this.getCurrentParams();
        SynthesisMessageParams lastSynthesis = this.mLastSynthesisRequest;
        this.stop(current);
        if (lastSynthesis != null && lastSynthesis != current) {
            this.stop(lastSynthesis);
        }
    }

    public boolean isSpeaking() {
        return this.mQueue.peek() != null || this.mCurrentParams != null;
    }

    public synchronized void quit() {
        this.removeAllMessages();
        this.stop(this.getCurrentParams());
        this.mQueue.add(new ListEntry(-1, null, 0));
    }

    synchronized void enqueueSynthesisStart(SynthesisMessageParams token) {
        this.mQueue.add(new ListEntry(1, (MessageParams)token));
    }

    synchronized void enqueueSynthesisDataAvailable(SynthesisMessageParams token) {
        this.mQueue.add(new ListEntry(2, (MessageParams)token));
    }

    synchronized void enqueueSynthesisDone(SynthesisMessageParams token) {
        this.mQueue.add(new ListEntry(3, (MessageParams)token));
    }

    synchronized void enqueueAudio(AudioMessageParams token) {
        this.mQueue.add(new ListEntry(5, (MessageParams)token));
    }

    synchronized void enqueueSilence(SilenceMessageParams token) {
        this.mQueue.add(new ListEntry(6, (MessageParams)token));
    }

    private synchronized void removeAllMessages() {
        this.mQueue.clear();
    }

    private synchronized void removeMessages(String callingApp) {
        Iterator<ListEntry> it = this.mQueue.iterator();
        while (it.hasNext()) {
            ListEntry current = it.next();
            if (current.mMessage == null || !callingApp.equals(current.mMessage.getCallingApp())) continue;
            it.remove();
        }
    }

    private void setCurrentParams(MessageParams p) {
        this.mCurrentParams = p;
    }

    private MessageParams getCurrentParams() {
        return this.mCurrentParams;
    }

    private void handleMessage(ListEntry entry) {
        MessageParams msg = entry.mMessage;
        if (entry.mWhat == 1) {
            this.handleSynthesisStart(msg);
        } else if (entry.mWhat == 2) {
            this.handleSynthesisDataAvailable(msg);
        } else if (entry.mWhat == 3) {
            this.handleSynthesisDone(msg);
        } else if (entry.mWhat == 5) {
            this.handleAudio(msg);
        } else if (entry.mWhat == 6) {
            this.handleSilence(msg);
        }
    }

    private void handleSilence(MessageParams msg) {
        SilenceMessageParams params = (SilenceMessageParams)msg;
        params.getDispatcher().dispatchOnStart();
        if (params.getSilenceDurationMs() > 0L) {
            params.getConditionVariable().block(params.getSilenceDurationMs());
        }
        params.getDispatcher().dispatchOnDone();
    }

    private void handleAudio(MessageParams msg) {
        AudioMessageParams params = (AudioMessageParams)msg;
        params.getDispatcher().dispatchOnStart();
        params.getPlayer().startAndWait();
        params.getDispatcher().dispatchOnDone();
    }

    private void handleSynthesisStart(MessageParams msg) {
        SynthesisMessageParams param = (SynthesisMessageParams)msg;
        if (this.mLastSynthesisRequest != null) {
            Log.e(TAG, "Error : Missing call to done() for request : " + this.mLastSynthesisRequest);
            this.handleSynthesisDone(this.mLastSynthesisRequest);
        }
        this.mLastSynthesisRequest = param;
        AudioTrack audioTrack = AudioPlaybackHandler.createStreamingAudioTrack(param);
        param.setAudioTrack(audioTrack);
        msg.getDispatcher().dispatchOnStart();
    }

    private void handleSynthesisDataAvailable(MessageParams msg) {
        int count;
        int written;
        SynthesisMessageParams param = (SynthesisMessageParams)msg;
        if (param.getAudioTrack() == null) {
            Log.w(TAG, "Error : null audio track in handleDataAvailable : " + param);
            return;
        }
        if (param != this.mLastSynthesisRequest) {
            Log.e(TAG, "Call to dataAvailable without done() / start()");
            return;
        }
        AudioTrack audioTrack = param.getAudioTrack();
        SynthesisMessageParams.ListEntry bufferCopy = param.getNextBuffer();
        if (bufferCopy == null) {
            Log.e(TAG, "No buffers available to play.");
            return;
        }
        int playState = audioTrack.getPlayState();
        if (playState == 1) {
            audioTrack.play();
        }
        for (count = 0; count < bufferCopy.mBytes.length && (written = audioTrack.write(bufferCopy.mBytes, count, bufferCopy.mBytes.length)) > 0; count += written) {
        }
        param.mBytesWritten += count;
        param.mLogger.onPlaybackStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSynthesisDone(MessageParams msg) {
        SynthesisMessageParams params = (SynthesisMessageParams)msg;
        AudioTrack audioTrack = params.getAudioTrack();
        if (audioTrack == null) {
            return;
        }
        if (params.mBytesWritten < params.mAudioBufferSize) {
            params.mIsShortUtterance = true;
            audioTrack.stop();
        }
        AudioPlaybackHandler.blockUntilDone(params);
        AudioPlaybackHandler audioPlaybackHandler = this;
        synchronized (audioPlaybackHandler) {
            audioTrack.release();
            params.setAudioTrack(null);
        }
        if (params.isError()) {
            params.getDispatcher().dispatchOnError();
        } else {
            params.getDispatcher().dispatchOnDone();
        }
        this.mLastSynthesisRequest = null;
        params.mLogger.onWriteData();
    }

    private static void blockUntilDone(SynthesisMessageParams params) {
        if (params.mAudioTrack == null || params.mBytesWritten <= 0) {
            return;
        }
        if (params.mIsShortUtterance) {
            AudioPlaybackHandler.blockUntilEstimatedCompletion(params);
        } else {
            AudioPlaybackHandler.blockUntilCompletion(params);
        }
    }

    private static void blockUntilEstimatedCompletion(SynthesisMessageParams params) {
        int lengthInFrames = params.mBytesWritten / params.mBytesPerFrame;
        long estimatedTimeMs = lengthInFrames * 1000 / params.mSampleRateInHz;
        try {
            Thread.sleep(estimatedTimeMs);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    private static void blockUntilCompletion(SynthesisMessageParams params) {
        AudioTrack audioTrack = params.mAudioTrack;
        int lengthInFrames = params.mBytesWritten / params.mBytesPerFrame;
        int previousPosition = -1;
        int currentPosition = 0;
        long blockedTimeMs = 0L;
        while ((currentPosition = audioTrack.getPlaybackHeadPosition()) < lengthInFrames && audioTrack.getPlayState() == 3) {
            long estimatedTimeMs = (lengthInFrames - currentPosition) * 1000 / audioTrack.getSampleRate();
            long sleepTimeMs = AudioPlaybackHandler.clip(estimatedTimeMs, 20L, 2500L);
            if (currentPosition == previousPosition) {
                if ((blockedTimeMs += sleepTimeMs) > 2500L) {
                    Log.w(TAG, "Waited unsuccessfully for 2500ms for AudioTrack to make progress, Aborting");
                    break;
                }
            } else {
                blockedTimeMs = 0L;
            }
            previousPosition = currentPosition;
            try {
                Thread.sleep(sleepTimeMs);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
    }

    private static final long clip(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private static AudioTrack createStreamingAudioTrack(SynthesisMessageParams params) {
        int minBufferSizeInBytes;
        int bufferSizeInBytes;
        int audioFormat;
        int sampleRateInHz = params.mSampleRateInHz;
        int channelConfig = AudioPlaybackHandler.getChannelConfig(params.mChannelCount);
        AudioTrack audioTrack = new AudioTrack(params.mStreamType, sampleRateInHz, channelConfig, audioFormat = params.mAudioFormat, bufferSizeInBytes = Math.max(8192, minBufferSizeInBytes = AudioTrack.getMinBufferSize(sampleRateInHz, channelConfig, audioFormat)), 1);
        if (audioTrack.getState() != 1) {
            Log.w(TAG, "Unable to create audio track.");
            audioTrack.release();
            return null;
        }
        params.mAudioBufferSize = bufferSizeInBytes;
        AudioPlaybackHandler.setupVolume(audioTrack, params.mVolume, params.mPan);
        return audioTrack;
    }

    static int getChannelConfig(int channelCount) {
        if (channelCount == 1) {
            return 4;
        }
        if (channelCount == 2) {
            return 12;
        }
        return 0;
    }

    private static void setupVolume(AudioTrack audioTrack, float volume, float pan) {
        float vol = AudioPlaybackHandler.clip(volume, 0.0f, 1.0f);
        float panning = AudioPlaybackHandler.clip(pan, -1.0f, 1.0f);
        float volLeft = vol;
        float volRight = vol;
        if (panning > 0.0f) {
            volLeft *= 1.0f - panning;
        } else if (panning < 0.0f) {
            volRight *= 1.0f + panning;
        }
        if (audioTrack.setStereoVolume(volLeft, volRight) != 0) {
            Log.e(TAG, "Failed to set volume");
        }
    }

    private static float clip(float value, float min, float max) {
        return value > max ? max : (value < min ? min : value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ListEntry
    implements Comparable<ListEntry> {
        final int mWhat;
        final MessageParams mMessage;
        final int mPriority;
        final long mSequenceId;

        private ListEntry(int what, MessageParams message) {
            this(what, message, 1);
        }

        private ListEntry(int what, MessageParams message, int priority) {
            this.mWhat = what;
            this.mMessage = message;
            this.mPriority = priority;
            this.mSequenceId = AudioPlaybackHandler.this.mSequenceIdCtr.incrementAndGet();
        }

        @Override
        public int compareTo(ListEntry that) {
            if (that == this) {
                return 0;
            }
            int priorityDiff = this.mPriority - that.mPriority;
            if (priorityDiff == 0) {
                return this.mSequenceId < that.mSequenceId ? -1 : 1;
            }
            return priorityDiff;
        }
    }

    private final class MessageLoop
    implements Runnable {
        private MessageLoop() {
        }

        public void run() {
            while (true) {
                ListEntry entry = null;
                try {
                    entry = (ListEntry)AudioPlaybackHandler.this.mQueue.take();
                }
                catch (InterruptedException ie) {
                    return;
                }
                if (entry.mWhat == -1) {
                    return;
                }
                AudioPlaybackHandler.this.setCurrentParams(entry.mMessage);
                AudioPlaybackHandler.this.handleMessage(entry);
                AudioPlaybackHandler.this.setCurrentParams(null);
            }
        }
    }
}

