/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;

class BlockingMediaPlayer {
    private static final String TAG = "BlockMediaPlayer";
    private static final String MEDIA_PLAYER_THREAD_NAME = "TTS-MediaPlayer";
    private final Context mContext;
    private final Uri mUri;
    private final int mStreamType;
    private final ConditionVariable mDone;
    private MediaPlayer mPlayer;
    private volatile boolean mFinished;

    public BlockingMediaPlayer(Context context, Uri uri, int streamType) {
        this.mContext = context;
        this.mUri = uri;
        this.mStreamType = streamType;
        this.mDone = new ConditionVariable();
    }

    public boolean startAndWait() {
        HandlerThread thread = new HandlerThread(MEDIA_PLAYER_THREAD_NAME);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        this.mFinished = false;
        handler.post(new Runnable(){

            public void run() {
                BlockingMediaPlayer.this.startPlaying();
            }
        });
        this.mDone.block();
        handler.post(new Runnable(){

            public void run() {
                BlockingMediaPlayer.this.finish();
                Looper.myLooper().quit();
            }
        });
        return this.mFinished;
    }

    public void stop() {
        this.mDone.open();
    }

    private void startPlaying() {
        this.mPlayer = MediaPlayer.create(this.mContext, this.mUri);
        if (this.mPlayer == null) {
            Log.w(TAG, "Failed to play " + this.mUri);
            this.mDone.open();
            return;
        }
        try {
            this.mPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mp, int what, int extra) {
                    Log.w(BlockingMediaPlayer.TAG, "Audio playback error: " + what + ", " + extra);
                    BlockingMediaPlayer.this.mDone.open();
                    return true;
                }
            });
            this.mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    BlockingMediaPlayer.this.mFinished = true;
                    BlockingMediaPlayer.this.mDone.open();
                }
            });
            this.mPlayer.setAudioStreamType(this.mStreamType);
            this.mPlayer.start();
        }
        catch (IllegalArgumentException ex) {
            Log.w(TAG, "MediaPlayer failed", ex);
            this.mDone.open();
        }
    }

    private void finish() {
        try {
            this.mPlayer.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.mPlayer.release();
    }
}

