/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.os.SystemClock;
import android.speech.tts.EventLogTags;
import android.speech.tts.SynthesisRequest;
import android.text.TextUtils;

class EventLogger {
    private final SynthesisRequest mRequest;
    private final String mCallingApp;
    private final String mServiceApp;
    private final long mReceivedTime;
    private long mPlaybackStartTime = -1L;
    private volatile long mRequestProcessingStartTime = -1L;
    private volatile long mEngineStartTime = -1L;
    private volatile long mEngineCompleteTime = -1L;
    private volatile boolean mError = false;
    private volatile boolean mStopped = false;
    private boolean mLogWritten = false;

    EventLogger(SynthesisRequest request, String callingApp, String serviceApp) {
        this.mRequest = request;
        this.mCallingApp = callingApp;
        this.mServiceApp = serviceApp;
        this.mReceivedTime = SystemClock.elapsedRealtime();
    }

    public void onRequestProcessingStart() {
        this.mRequestProcessingStartTime = SystemClock.elapsedRealtime();
    }

    public void onEngineDataReceived() {
        if (this.mEngineStartTime == -1L) {
            this.mEngineStartTime = SystemClock.elapsedRealtime();
        }
    }

    public void onEngineComplete() {
        this.mEngineCompleteTime = SystemClock.elapsedRealtime();
    }

    public void onPlaybackStart() {
        if (this.mPlaybackStartTime == -1L) {
            this.mPlaybackStartTime = SystemClock.elapsedRealtime();
        }
    }

    public void onStopped() {
        this.mStopped = false;
    }

    public void onError() {
        this.mError = true;
    }

    public void onWriteData() {
        if (this.mLogWritten) {
            return;
        }
        this.mLogWritten = true;
        long completionTime = SystemClock.elapsedRealtime();
        if (this.mError || this.mPlaybackStartTime == -1L || this.mEngineCompleteTime == -1L) {
            EventLogTags.writeTtsSpeakFailure(this.mServiceApp, this.mCallingApp, this.getUtteranceLength(), this.getLocaleString(), this.mRequest.getSpeechRate(), this.mRequest.getPitch());
            return;
        }
        if (this.mStopped) {
            return;
        }
        long audioLatency = this.mPlaybackStartTime - this.mReceivedTime;
        long engineLatency = this.mEngineStartTime - this.mRequestProcessingStartTime;
        long engineTotal = this.mEngineCompleteTime - this.mRequestProcessingStartTime;
        EventLogTags.writeTtsSpeakSuccess(this.mServiceApp, this.mCallingApp, this.getUtteranceLength(), this.getLocaleString(), this.mRequest.getSpeechRate(), this.mRequest.getPitch(), engineLatency, engineTotal, audioLatency);
    }

    private int getUtteranceLength() {
        String utterance = this.mRequest.getText();
        return utterance == null ? 0 : utterance.length();
    }

    private String getLocaleString() {
        StringBuilder sb = new StringBuilder(this.mRequest.getLanguage());
        if (!TextUtils.isEmpty(this.mRequest.getCountry())) {
            sb.append('-');
            sb.append(this.mRequest.getCountry());
            if (!TextUtils.isEmpty(this.mRequest.getVariant())) {
                sb.append('-');
                sb.append(this.mRequest.getVariant());
            }
        }
        return sb.toString();
    }
}

