/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.os.FileUtils;
import android.speech.tts.AbstractSynthesisCallback;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class FileSynthesisCallback
extends AbstractSynthesisCallback {
    private static final String TAG = "FileSynthesisRequest";
    private static final boolean DBG = false;
    private static final int MAX_AUDIO_BUFFER_SIZE = 8192;
    private static final int WAV_HEADER_LENGTH = 44;
    private static final short WAV_FORMAT_PCM = 1;
    private final Object mStateLock = new Object();
    private final File mFileName;
    private int mSampleRateInHz;
    private int mAudioFormat;
    private int mChannelCount;
    private RandomAccessFile mFile;
    private boolean mStopped = false;
    private boolean mDone = false;

    FileSynthesisCallback(File fileName) {
        this.mFileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.mStopped = true;
            this.cleanUp();
        }
    }

    private void cleanUp() {
        this.closeFileAndWidenPermissions();
        if (this.mFile != null) {
            this.mFileName.delete();
        }
    }

    private void closeFileAndWidenPermissions() {
        try {
            if (this.mFile != null) {
                this.mFile.close();
                this.mFile = null;
            }
        }
        catch (IOException ex) {
            Log.e(TAG, "Failed to close " + this.mFileName + ": " + ex);
        }
        try {
            FileUtils.setPermissions(this.mFileName.getAbsolutePath(), 438, -1, -1);
        }
        catch (SecurityException se) {
            Log.e(TAG, "Security exception setting rw permissions on : " + this.mFileName);
        }
    }

    public int getMaxBufferSize() {
        return 8192;
    }

    boolean isDone() {
        return this.mDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start(int sampleRateInHz, int audioFormat, int channelCount) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStopped) {
                return -1;
            }
            if (this.mFile != null) {
                this.cleanUp();
                throw new IllegalArgumentException("FileSynthesisRequest.start() called twice");
            }
            this.mSampleRateInHz = sampleRateInHz;
            this.mAudioFormat = audioFormat;
            this.mChannelCount = channelCount;
            try {
                this.mFile = new RandomAccessFile(this.mFileName, "rw");
                this.mFile.write(new byte[44]);
                return 0;
            }
            catch (IOException ex) {
                Log.e(TAG, "Failed to open " + this.mFileName + ": " + ex);
                this.cleanUp();
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int audioAvailable(byte[] buffer, int offset, int length) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStopped) {
                return -1;
            }
            if (this.mFile == null) {
                Log.e(TAG, "File not open");
                return -1;
            }
            try {
                this.mFile.write(buffer, offset, length);
                return 0;
            }
            catch (IOException ex) {
                Log.e(TAG, "Failed to write to " + this.mFileName + ": " + ex);
                this.cleanUp();
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int done() {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStopped) {
                return -1;
            }
            if (this.mFile == null) {
                Log.e(TAG, "File not open");
                return -1;
            }
            try {
                this.mFile.seek(0L);
                int dataLength = (int)(this.mFile.length() - 44L);
                this.mFile.write(this.makeWavHeader(this.mSampleRateInHz, this.mAudioFormat, this.mChannelCount, dataLength));
                this.closeFileAndWidenPermissions();
                this.mDone = true;
                return 0;
            }
            catch (IOException ex) {
                Log.e(TAG, "Failed to write to " + this.mFileName + ": " + ex);
                this.cleanUp();
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error() {
        Object object = this.mStateLock;
        synchronized (object) {
            this.cleanUp();
        }
    }

    private byte[] makeWavHeader(int sampleRateInHz, int audioFormat, int channelCount, int dataLength) {
        int sampleSizeInBytes = audioFormat == 3 ? 1 : 2;
        int byteRate = sampleRateInHz * sampleSizeInBytes * channelCount;
        short blockAlign = (short)(sampleSizeInBytes * channelCount);
        short bitsPerSample = (short)(sampleSizeInBytes * 8);
        byte[] headerBuf = new byte[44];
        ByteBuffer header = ByteBuffer.wrap(headerBuf);
        header.order(ByteOrder.LITTLE_ENDIAN);
        header.put(new byte[]{82, 73, 70, 70});
        header.putInt(dataLength + 44 - 8);
        header.put(new byte[]{87, 65, 86, 69});
        header.put(new byte[]{102, 109, 116, 32});
        header.putInt(16);
        header.putShort((short)1);
        header.putShort((short)channelCount);
        header.putInt(sampleRateInHz);
        header.putInt(byteRate);
        header.putShort(blockAlign);
        header.putShort(bitsPerSample);
        header.put(new byte[]{100, 97, 116, 97});
        header.putInt(dataLength);
        return headerBuf;
    }
}

