/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.speech.tts.AbstractSynthesisCallback;
import android.speech.tts.AudioPlaybackHandler;
import android.speech.tts.EventLogger;
import android.speech.tts.SynthesisMessageParams;
import android.speech.tts.TextToSpeechService;
import android.util.Log;

class PlaybackSynthesisCallback
extends AbstractSynthesisCallback {
    private static final String TAG = "PlaybackSynthesisRequest";
    private static final boolean DBG = false;
    private static final int MIN_AUDIO_BUFFER_SIZE = 8192;
    private final int mStreamType;
    private final float mVolume;
    private final float mPan;
    private final Object mStateLock = new Object();
    private final AudioPlaybackHandler mAudioTrackHandler;
    private SynthesisMessageParams mToken = null;
    private boolean mStopped = false;
    private volatile boolean mDone = false;
    private final TextToSpeechService.UtteranceProgressDispatcher mDispatcher;
    private final String mCallingApp;
    private final EventLogger mLogger;

    PlaybackSynthesisCallback(int streamType, float volume, float pan, AudioPlaybackHandler audioTrackHandler, TextToSpeechService.UtteranceProgressDispatcher dispatcher, String callingApp, EventLogger logger) {
        this.mStreamType = streamType;
        this.mVolume = volume;
        this.mPan = pan;
        this.mAudioTrackHandler = audioTrackHandler;
        this.mDispatcher = dispatcher;
        this.mCallingApp = callingApp;
        this.mLogger = logger;
    }

    void stop() {
        this.stopImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopImpl(boolean wasError) {
        SynthesisMessageParams token;
        this.mLogger.onStopped();
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStopped) {
                Log.w(TAG, "stop() called twice");
                return;
            }
            token = this.mToken;
            this.mStopped = true;
        }
        if (token != null) {
            token.setIsError(wasError);
            token.clearBuffers();
            if (wasError) {
                this.mAudioTrackHandler.enqueueSynthesisDone(token);
            }
        } else {
            this.mLogger.onWriteData();
            if (wasError) {
                this.mDispatcher.dispatchOnError();
            }
        }
    }

    public int getMaxBufferSize() {
        return 8192;
    }

    boolean isDone() {
        return this.mDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start(int sampleRateInHz, int audioFormat, int channelCount) {
        int channelConfig = AudioPlaybackHandler.getChannelConfig(channelCount);
        if (channelConfig == 0) {
            Log.e(TAG, "Unsupported number of channels :" + channelCount);
            return -1;
        }
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStopped) {
                return -1;
            }
            SynthesisMessageParams params = new SynthesisMessageParams(this.mStreamType, sampleRateInHz, audioFormat, channelCount, this.mVolume, this.mPan, this.mDispatcher, this.mCallingApp, this.mLogger);
            this.mAudioTrackHandler.enqueueSynthesisStart(params);
            this.mToken = params;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int audioAvailable(byte[] buffer, int offset, int length) {
        if (length > this.getMaxBufferSize() || length <= 0) {
            throw new IllegalArgumentException("buffer is too large or of zero length (" + length + " bytes)");
        }
        SynthesisMessageParams token = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mToken == null || this.mStopped) {
                return -1;
            }
            token = this.mToken;
        }
        byte[] bufferCopy = new byte[length];
        System.arraycopy(buffer, offset, bufferCopy, 0, length);
        token.addBuffer(bufferCopy);
        this.mAudioTrackHandler.enqueueSynthesisDataAvailable(token);
        this.mLogger.onEngineDataReceived();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int done() {
        SynthesisMessageParams token = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                Log.w(TAG, "Duplicate call to done()");
                return -1;
            }
            this.mDone = true;
            if (this.mToken == null) {
                return -1;
            }
            token = this.mToken;
        }
        this.mAudioTrackHandler.enqueueSynthesisDone(token);
        this.mLogger.onEngineComplete();
        return 0;
    }

    public void error() {
        this.mLogger.onError();
        this.stopImpl(true);
    }
}

