/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.media.AudioTrack;
import android.speech.tts.EventLogger;
import android.speech.tts.MessageParams;
import android.speech.tts.TextToSpeechService;
import java.util.LinkedList;

final class SynthesisMessageParams
extends MessageParams {
    private static final long MAX_UNCONSUMED_AUDIO_MS = 500L;
    final int mStreamType;
    final int mSampleRateInHz;
    final int mAudioFormat;
    final int mChannelCount;
    final float mVolume;
    final float mPan;
    final EventLogger mLogger;
    final int mBytesPerFrame;
    volatile AudioTrack mAudioTrack;
    volatile int mBytesWritten;
    boolean mIsShortUtterance;
    int mAudioBufferSize;
    int mUnconsumedBytes;
    volatile boolean mIsError;
    private final LinkedList<ListEntry> mDataBufferList = new LinkedList();

    SynthesisMessageParams(int streamType, int sampleRate, int audioFormat, int channelCount, float volume, float pan, TextToSpeechService.UtteranceProgressDispatcher dispatcher, String callingApp, EventLogger logger) {
        super(dispatcher, callingApp);
        this.mStreamType = streamType;
        this.mSampleRateInHz = sampleRate;
        this.mAudioFormat = audioFormat;
        this.mChannelCount = channelCount;
        this.mVolume = volume;
        this.mPan = pan;
        this.mLogger = logger;
        this.mBytesPerFrame = SynthesisMessageParams.getBytesPerFrame(this.mAudioFormat) * this.mChannelCount;
        this.mAudioTrack = null;
        this.mBytesWritten = 0;
        this.mAudioBufferSize = 0;
        this.mIsError = false;
    }

    int getType() {
        return 1;
    }

    synchronized void addBuffer(byte[] buffer) {
        long unconsumedAudioMs = 0L;
        while ((unconsumedAudioMs = this.getUnconsumedAudioLengthMs()) > 500L) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                return;
            }
        }
        this.mDataBufferList.add(new ListEntry(buffer));
        this.mUnconsumedBytes += buffer.length;
    }

    synchronized void clearBuffers() {
        this.mDataBufferList.clear();
        this.mUnconsumedBytes = 0;
        this.notifyAll();
    }

    synchronized ListEntry getNextBuffer() {
        ListEntry entry = this.mDataBufferList.poll();
        if (entry != null) {
            this.mUnconsumedBytes -= entry.mBytes.length;
            this.notifyAll();
        }
        return entry;
    }

    void setAudioTrack(AudioTrack audioTrack) {
        this.mAudioTrack = audioTrack;
    }

    AudioTrack getAudioTrack() {
        return this.mAudioTrack;
    }

    void setIsError(boolean isError) {
        this.mIsError = isError;
    }

    boolean isError() {
        return this.mIsError;
    }

    private long getUnconsumedAudioLengthMs() {
        int unconsumedFrames = this.mUnconsumedBytes / this.mBytesPerFrame;
        long estimatedTimeMs = unconsumedFrames * 1000 / this.mSampleRateInHz;
        return estimatedTimeMs;
    }

    private static int getBytesPerFrame(int audioFormat) {
        if (audioFormat == 3) {
            return 1;
        }
        if (audioFormat == 2) {
            return 2;
        }
        return -1;
    }

    static final class ListEntry {
        final byte[] mBytes;

        ListEntry(byte[] bytes) {
            this.mBytes = bytes;
        }
    }
}

