/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.app.Service;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.provider.Settings;
import android.speech.tts.AbstractSynthesisCallback;
import android.speech.tts.AudioMessageParams;
import android.speech.tts.AudioPlaybackHandler;
import android.speech.tts.BlockingMediaPlayer;
import android.speech.tts.EventLogger;
import android.speech.tts.FileSynthesisCallback;
import android.speech.tts.ITextToSpeechCallback;
import android.speech.tts.ITextToSpeechService;
import android.speech.tts.PlaybackSynthesisCallback;
import android.speech.tts.SilenceMessageParams;
import android.speech.tts.SynthesisCallback;
import android.speech.tts.SynthesisRequest;
import android.speech.tts.TtsEngines;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextToSpeechService
extends Service {
    private static final boolean DBG = false;
    private static final String TAG = "TextToSpeechService";
    private static final int MAX_SPEECH_ITEM_CHAR_LENGTH = 4000;
    private static final String SYNTH_THREAD_NAME = "SynthThread";
    private SynthHandler mSynthHandler;
    private AudioPlaybackHandler mAudioPlaybackHandler;
    private TtsEngines mEngineHelper;
    private CallbackMap mCallbacks;
    private String mPackageName;
    private final ITextToSpeechService.Stub mBinder = new ITextToSpeechService.Stub(){

        public int speak(String callingApp, String text, int queueMode, Bundle params) {
            if (!this.checkNonNull(callingApp, text, params)) {
                return -1;
            }
            SynthesisSpeechItem item = new SynthesisSpeechItem(this.intern(callingApp), params, text);
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(queueMode, item);
        }

        public int synthesizeToFile(String callingApp, String text, String filename, Bundle params) {
            if (!this.checkNonNull(callingApp, text, filename, params)) {
                return -1;
            }
            File file = new File(filename);
            SynthesisToFileSpeechItem item = new SynthesisToFileSpeechItem(this.intern(callingApp), params, text, file);
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(1, item);
        }

        public int playAudio(String callingApp, Uri audioUri, int queueMode, Bundle params) {
            if (!this.checkNonNull(callingApp, audioUri, params)) {
                return -1;
            }
            AudioSpeechItem item = new AudioSpeechItem(this.intern(callingApp), params, audioUri);
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(queueMode, item);
        }

        public int playSilence(String callingApp, long duration, int queueMode, Bundle params) {
            if (!this.checkNonNull(callingApp, params)) {
                return -1;
            }
            SilenceSpeechItem item = new SilenceSpeechItem(this.intern(callingApp), params, duration);
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(queueMode, item);
        }

        public boolean isSpeaking() {
            return TextToSpeechService.this.mSynthHandler.isSpeaking() || TextToSpeechService.this.mAudioPlaybackHandler.isSpeaking();
        }

        public int stop(String callingApp) {
            if (!this.checkNonNull(callingApp)) {
                return -1;
            }
            return TextToSpeechService.this.mSynthHandler.stopForApp(this.intern(callingApp));
        }

        public String[] getLanguage() {
            return TextToSpeechService.this.onGetLanguage();
        }

        public int isLanguageAvailable(String lang, String country, String variant) {
            if (!this.checkNonNull(lang)) {
                return -1;
            }
            return TextToSpeechService.this.onIsLanguageAvailable(lang, country, variant);
        }

        public String[] getFeaturesForLanguage(String lang, String country, String variant) {
            Set<String> features = TextToSpeechService.this.onGetFeaturesForLanguage(lang, country, variant);
            String[] featuresArray = null;
            if (features != null) {
                featuresArray = new String[features.size()];
                features.toArray(featuresArray);
            } else {
                featuresArray = new String[]{};
            }
            return featuresArray;
        }

        public int loadLanguage(String lang, String country, String variant) {
            if (!this.checkNonNull(lang)) {
                return -1;
            }
            return TextToSpeechService.this.onLoadLanguage(lang, country, variant);
        }

        public void setCallback(String packageName, ITextToSpeechCallback cb) {
            if (!this.checkNonNull(packageName)) {
                return;
            }
            TextToSpeechService.this.mCallbacks.setCallback(packageName, cb);
        }

        private String intern(String in) {
            return in.intern();
        }

        private boolean checkNonNull(Object ... args) {
            for (Object o : args) {
                if (o != null) continue;
                return false;
            }
            return true;
        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        SynthThread synthThread = new SynthThread();
        synthThread.start();
        this.mSynthHandler = new SynthHandler(synthThread.getLooper());
        this.mAudioPlaybackHandler = new AudioPlaybackHandler();
        this.mAudioPlaybackHandler.start();
        this.mEngineHelper = new TtsEngines(this);
        this.mCallbacks = new CallbackMap();
        this.mPackageName = this.getApplicationInfo().packageName;
        String[] defaultLocale = this.getSettingsLocale();
        this.onLoadLanguage(defaultLocale[0], defaultLocale[1], defaultLocale[2]);
    }

    @Override
    public void onDestroy() {
        this.mSynthHandler.quit();
        this.mAudioPlaybackHandler.quit();
        this.mCallbacks.kill();
        super.onDestroy();
    }

    protected abstract int onIsLanguageAvailable(String var1, String var2, String var3);

    protected abstract String[] onGetLanguage();

    protected abstract int onLoadLanguage(String var1, String var2, String var3);

    protected abstract void onStop();

    protected abstract void onSynthesizeText(SynthesisRequest var1, SynthesisCallback var2);

    protected Set<String> onGetFeaturesForLanguage(String lang, String country, String variant) {
        return null;
    }

    private int getDefaultSpeechRate() {
        return this.getSecureSettingInt("tts_default_rate", 100);
    }

    private String[] getSettingsLocale() {
        String locale = this.mEngineHelper.getLocalePrefForEngine(this.mPackageName);
        return TtsEngines.parseLocalePref(locale);
    }

    private int getSecureSettingInt(String name, int defaultValue) {
        return Settings.Secure.getInt(this.getContentResolver(), name, defaultValue);
    }

    @Override
    public IBinder onBind(Intent intent) {
        if ("android.intent.action.TTS_SERVICE".equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallbackMap
    extends RemoteCallbackList<ITextToSpeechCallback> {
        private final HashMap<String, ITextToSpeechCallback> mAppToCallback = new HashMap();

        private CallbackMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCallback(String packageName, ITextToSpeechCallback cb) {
            HashMap<String, ITextToSpeechCallback> hashMap = this.mAppToCallback;
            synchronized (hashMap) {
                ITextToSpeechCallback old;
                if (cb != null) {
                    this.register(cb, packageName);
                    old = this.mAppToCallback.put(packageName, cb);
                } else {
                    old = this.mAppToCallback.remove(packageName);
                }
                if (old != null && old != cb) {
                    this.unregister(old);
                }
            }
        }

        public void dispatchOnDone(String packageName, String utteranceId) {
            ITextToSpeechCallback cb = this.getCallbackFor(packageName);
            if (cb == null) {
                return;
            }
            try {
                cb.onDone(utteranceId);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback onDone failed: " + e);
            }
        }

        public void dispatchOnStart(String packageName, String utteranceId) {
            ITextToSpeechCallback cb = this.getCallbackFor(packageName);
            if (cb == null) {
                return;
            }
            try {
                cb.onStart(utteranceId);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback onStart failed: " + e);
            }
        }

        public void dispatchOnError(String packageName, String utteranceId) {
            ITextToSpeechCallback cb = this.getCallbackFor(packageName);
            if (cb == null) {
                return;
            }
            try {
                cb.onError(utteranceId);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback onError failed: " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallbackDied(ITextToSpeechCallback callback, Object cookie) {
            String packageName = (String)cookie;
            HashMap<String, ITextToSpeechCallback> hashMap = this.mAppToCallback;
            synchronized (hashMap) {
                this.mAppToCallback.remove(packageName);
            }
            TextToSpeechService.this.mSynthHandler.stopForApp(packageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void kill() {
            HashMap<String, ITextToSpeechCallback> hashMap = this.mAppToCallback;
            synchronized (hashMap) {
                this.mAppToCallback.clear();
                super.kill();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ITextToSpeechCallback getCallbackFor(String packageName) {
            ITextToSpeechCallback cb;
            HashMap<String, ITextToSpeechCallback> hashMap = this.mAppToCallback;
            synchronized (hashMap) {
                cb = this.mAppToCallback.get(packageName);
            }
            return cb;
        }
    }

    private class SilenceSpeechItem
    extends SpeechItem {
        private final long mDuration;
        private SilenceMessageParams mToken;

        public SilenceSpeechItem(String callingApp, Bundle params, long duration) {
            super(callingApp, params);
            this.mDuration = duration;
        }

        public boolean isValid() {
            return true;
        }

        protected int playImpl() {
            this.mToken = new SilenceMessageParams(this, this.getCallingApp(), this.mDuration);
            TextToSpeechService.this.mAudioPlaybackHandler.enqueueSilence(this.mToken);
            return 0;
        }

        protected void stopImpl() {
        }
    }

    private class AudioSpeechItem
    extends SpeechItem {
        private final BlockingMediaPlayer mPlayer;
        private AudioMessageParams mToken;

        public AudioSpeechItem(String callingApp, Bundle params, Uri uri) {
            super(callingApp, params);
            this.mPlayer = new BlockingMediaPlayer(TextToSpeechService.this, uri, this.getStreamType());
        }

        public boolean isValid() {
            return true;
        }

        protected int playImpl() {
            this.mToken = new AudioMessageParams(this, this.getCallingApp(), this.mPlayer);
            TextToSpeechService.this.mAudioPlaybackHandler.enqueueAudio(this.mToken);
            return 0;
        }

        protected void stopImpl() {
        }
    }

    private class SynthesisToFileSpeechItem
    extends SynthesisSpeechItem {
        private final File mFile;

        public SynthesisToFileSpeechItem(String callingApp, Bundle params, String text, File file) {
            super(callingApp, params, text);
            this.mFile = file;
        }

        public boolean isValid() {
            if (!super.isValid()) {
                return false;
            }
            return this.checkFile(this.mFile);
        }

        protected AbstractSynthesisCallback createSynthesisCallback() {
            return new FileSynthesisCallback(this.mFile);
        }

        protected int playImpl() {
            this.dispatchOnStart();
            int status = super.playImpl();
            if (status == 0) {
                this.dispatchOnDone();
            } else {
                this.dispatchOnError();
            }
            return status;
        }

        private boolean checkFile(File file) {
            try {
                if (file.exists()) {
                    Log.v(TextToSpeechService.TAG, "File " + file + " exists, deleting.");
                    if (!file.delete()) {
                        Log.e(TextToSpeechService.TAG, "Failed to delete " + file);
                        return false;
                    }
                }
                if (!file.createNewFile()) {
                    Log.e(TextToSpeechService.TAG, "Can't create file " + file);
                    return false;
                }
                if (!file.delete()) {
                    Log.e(TextToSpeechService.TAG, "Failed to delete " + file);
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                Log.e(TextToSpeechService.TAG, "Can't use " + file + " due to exception " + e);
                return false;
            }
        }
    }

    class SynthesisSpeechItem
    extends SpeechItem {
        private final String mText;
        private final SynthesisRequest mSynthesisRequest;
        private final String[] mDefaultLocale;
        private AbstractSynthesisCallback mSynthesisCallback;
        private final EventLogger mEventLogger;

        public SynthesisSpeechItem(String callingApp, Bundle params, String text) {
            super(callingApp, params);
            this.mText = text;
            this.mSynthesisRequest = new SynthesisRequest(this.mText, this.mParams);
            this.mDefaultLocale = TextToSpeechService.this.getSettingsLocale();
            this.setRequestParams(this.mSynthesisRequest);
            this.mEventLogger = new EventLogger(this.mSynthesisRequest, this.getCallingApp(), TextToSpeechService.this.mPackageName);
        }

        public String getText() {
            return this.mText;
        }

        public boolean isValid() {
            if (this.mText == null) {
                Log.wtf(TextToSpeechService.TAG, "Got null text");
                return false;
            }
            if (this.mText.length() >= 4000) {
                Log.w(TextToSpeechService.TAG, "Text too long: " + this.mText.length() + " chars");
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int playImpl() {
            AbstractSynthesisCallback synthesisCallback;
            this.mEventLogger.onRequestProcessingStart();
            SynthesisSpeechItem synthesisSpeechItem = this;
            synchronized (synthesisSpeechItem) {
                if (this.isStopped()) {
                    return -1;
                }
                synthesisCallback = this.mSynthesisCallback = this.createSynthesisCallback();
            }
            TextToSpeechService.this.onSynthesizeText(this.mSynthesisRequest, synthesisCallback);
            return synthesisCallback.isDone() ? 0 : -1;
        }

        protected AbstractSynthesisCallback createSynthesisCallback() {
            return new PlaybackSynthesisCallback(this.getStreamType(), this.getVolume(), this.getPan(), TextToSpeechService.this.mAudioPlaybackHandler, this, this.getCallingApp(), this.mEventLogger);
        }

        private void setRequestParams(SynthesisRequest request) {
            request.setLanguage(this.getLanguage(), this.getCountry(), this.getVariant());
            request.setSpeechRate(this.getSpeechRate());
            request.setPitch(this.getPitch());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopImpl() {
            AbstractSynthesisCallback synthesisCallback;
            SynthesisSpeechItem synthesisSpeechItem = this;
            synchronized (synthesisSpeechItem) {
                synthesisCallback = this.mSynthesisCallback;
            }
            if (synthesisCallback != null) {
                synthesisCallback.stop();
                TextToSpeechService.this.onStop();
            }
        }

        public String getLanguage() {
            return this.getStringParam("language", this.mDefaultLocale[0]);
        }

        private boolean hasLanguage() {
            return !TextUtils.isEmpty(this.getStringParam("language", null));
        }

        private String getCountry() {
            if (!this.hasLanguage()) {
                return this.mDefaultLocale[1];
            }
            return this.getStringParam("country", "");
        }

        private String getVariant() {
            if (!this.hasLanguage()) {
                return this.mDefaultLocale[2];
            }
            return this.getStringParam("variant", "");
        }

        private int getSpeechRate() {
            return this.getIntParam("rate", TextToSpeechService.this.getDefaultSpeechRate());
        }

        private int getPitch() {
            return this.getIntParam("pitch", 100);
        }
    }

    private abstract class SpeechItem
    implements UtteranceProgressDispatcher {
        private final String mCallingApp;
        protected final Bundle mParams;
        private boolean mStarted = false;
        private boolean mStopped = false;

        public SpeechItem(String callingApp, Bundle params) {
            this.mCallingApp = callingApp;
            this.mParams = params;
        }

        public String getCallingApp() {
            return this.mCallingApp;
        }

        public abstract boolean isValid();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int play() {
            SpeechItem speechItem = this;
            synchronized (speechItem) {
                if (this.mStarted) {
                    throw new IllegalStateException("play() called twice");
                }
                this.mStarted = true;
            }
            return this.playImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            SpeechItem speechItem = this;
            synchronized (speechItem) {
                if (this.mStopped) {
                    throw new IllegalStateException("stop() called twice");
                }
                this.mStopped = true;
            }
            this.stopImpl();
        }

        public void dispatchOnDone() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnDone(this.getCallingApp(), utteranceId);
            }
        }

        public void dispatchOnStart() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnStart(this.getCallingApp(), utteranceId);
            }
        }

        public void dispatchOnError() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnError(this.getCallingApp(), utteranceId);
            }
        }

        protected synchronized boolean isStopped() {
            return this.mStopped;
        }

        protected abstract int playImpl();

        protected abstract void stopImpl();

        public int getStreamType() {
            return this.getIntParam("streamType", 3);
        }

        public float getVolume() {
            return this.getFloatParam("volume", 1.0f);
        }

        public float getPan() {
            return this.getFloatParam("pan", 0.0f);
        }

        public String getUtteranceId() {
            return this.getStringParam("utteranceId", null);
        }

        protected String getStringParam(String key, String defaultValue) {
            return this.mParams == null ? defaultValue : this.mParams.getString(key, defaultValue);
        }

        protected int getIntParam(String key, int defaultValue) {
            return this.mParams == null ? defaultValue : this.mParams.getInt(key, defaultValue);
        }

        protected float getFloatParam(String key, float defaultValue) {
            return this.mParams == null ? defaultValue : this.mParams.getFloat(key, defaultValue);
        }
    }

    static interface UtteranceProgressDispatcher {
        public void dispatchOnDone();

        public void dispatchOnStart();

        public void dispatchOnError();
    }

    private class SynthHandler
    extends Handler {
        private SpeechItem mCurrentSpeechItem;

        public SynthHandler(Looper looper) {
            super(looper);
            this.mCurrentSpeechItem = null;
        }

        private synchronized SpeechItem getCurrentSpeechItem() {
            return this.mCurrentSpeechItem;
        }

        private synchronized SpeechItem setCurrentSpeechItem(SpeechItem speechItem) {
            SpeechItem old = this.mCurrentSpeechItem;
            this.mCurrentSpeechItem = speechItem;
            return old;
        }

        private synchronized SpeechItem maybeRemoveCurrentSpeechItem(String callingApp) {
            if (this.mCurrentSpeechItem != null && TextUtils.equals(this.mCurrentSpeechItem.getCallingApp(), callingApp)) {
                SpeechItem current = this.mCurrentSpeechItem;
                this.mCurrentSpeechItem = null;
                return current;
            }
            return null;
        }

        public boolean isSpeaking() {
            return this.getCurrentSpeechItem() != null;
        }

        public void quit() {
            this.getLooper().quit();
            SpeechItem current = this.setCurrentSpeechItem(null);
            if (current != null) {
                current.stop();
            }
        }

        public int enqueueSpeechItem(int queueMode, final SpeechItem speechItem) {
            if (!speechItem.isValid()) {
                speechItem.dispatchOnError();
                return -1;
            }
            if (queueMode == 0) {
                this.stopForApp(speechItem.getCallingApp());
            } else if (queueMode == 2) {
                this.stopAll();
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    SynthHandler.this.setCurrentSpeechItem(speechItem);
                    speechItem.play();
                    SynthHandler.this.setCurrentSpeechItem(null);
                }
            };
            Message msg = Message.obtain((Handler)this, runnable);
            msg.obj = speechItem.getCallingApp();
            if (this.sendMessage(msg)) {
                return 0;
            }
            Log.w(TextToSpeechService.TAG, "SynthThread has quit");
            speechItem.dispatchOnError();
            return -1;
        }

        public int stopForApp(String callingApp) {
            if (TextUtils.isEmpty(callingApp)) {
                return -1;
            }
            this.removeCallbacksAndMessages(callingApp);
            SpeechItem current = this.maybeRemoveCurrentSpeechItem(callingApp);
            if (current != null) {
                current.stop();
            }
            TextToSpeechService.this.mAudioPlaybackHandler.removePlaybackItems(callingApp);
            return 0;
        }

        public int stopAll() {
            SpeechItem current = this.setCurrentSpeechItem(null);
            if (current != null) {
                current.stop();
            }
            this.removeCallbacksAndMessages(null);
            TextToSpeechService.this.mAudioPlaybackHandler.removeAllItems();
            return 0;
        }
    }

    private class SynthThread
    extends HandlerThread
    implements MessageQueue.IdleHandler {
        private boolean mFirstIdle;

        public SynthThread() {
            super(TextToSpeechService.SYNTH_THREAD_NAME, 0);
            this.mFirstIdle = true;
        }

        protected void onLooperPrepared() {
            this.getLooper().getQueue().addIdleHandler(this);
        }

        public boolean queueIdle() {
            if (this.mFirstIdle) {
                this.mFirstIdle = false;
            } else {
                this.broadcastTtsQueueProcessingCompleted();
            }
            return true;
        }

        private void broadcastTtsQueueProcessingCompleted() {
            Intent i = new Intent("android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED");
            TextToSpeechService.this.sendBroadcast(i);
        }
    }
}

