/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.PendingIntent;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import com.android.internal.telephony.ISms;
import com.android.internal.telephony.SmsRawData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmsManager {
    private static final SmsManager sInstance = new SmsManager();
    public static final int STATUS_ON_ICC_FREE = 0;
    public static final int STATUS_ON_ICC_READ = 1;
    public static final int STATUS_ON_ICC_UNREAD = 3;
    public static final int STATUS_ON_ICC_SENT = 5;
    public static final int STATUS_ON_ICC_UNSENT = 7;
    public static final int RESULT_ERROR_GENERIC_FAILURE = 1;
    public static final int RESULT_ERROR_RADIO_OFF = 2;
    public static final int RESULT_ERROR_NULL_PDU = 3;
    public static final int RESULT_ERROR_NO_SERVICE = 4;
    public static final int RESULT_ERROR_LIMIT_EXCEEDED = 5;
    public static final int RESULT_ERROR_FDN_CHECK_FAILURE = 6;

    public void sendTextMessage(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (TextUtils.isEmpty(text)) {
            throw new IllegalArgumentException("Invalid message body");
        }
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                iccISms.sendText(destinationAddress, scAddress, text, sentIntent, deliveryIntent);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public ArrayList<String> divideMessage(String text) {
        return SmsMessage.fragmentText(text);
    }

    public void sendMultipartTextMessage(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (parts == null || parts.size() < 1) {
            throw new IllegalArgumentException("Invalid message body");
        }
        if (parts.size() > 1) {
            try {
                ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
                if (iccISms != null) {
                    iccISms.sendMultipartText(destinationAddress, scAddress, parts, sentIntents, deliveryIntents);
                }
            }
            catch (RemoteException ex) {}
        } else {
            PendingIntent sentIntent = null;
            PendingIntent deliveryIntent = null;
            if (sentIntents != null && sentIntents.size() > 0) {
                sentIntent = sentIntents.get(0);
            }
            if (deliveryIntents != null && deliveryIntents.size() > 0) {
                deliveryIntent = deliveryIntents.get(0);
            }
            this.sendTextMessage(destinationAddress, scAddress, parts.get(0), sentIntent, deliveryIntent);
        }
    }

    public void sendDataMessage(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty(destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Invalid message data");
        }
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                iccISms.sendData(destinationAddress, scAddress, destinationPort & 0xFFFF, data, sentIntent, deliveryIntent);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    public static SmsManager getDefault() {
        return sInstance;
    }

    private SmsManager() {
    }

    public boolean copyMessageToIcc(byte[] smsc, byte[] pdu, int status) {
        boolean success = false;
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                success = iccISms.copyMessageToIccEf(status, pdu, smsc);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return success;
    }

    public boolean deleteMessageFromIcc(int messageIndex) {
        boolean success = false;
        byte[] pdu = new byte[175];
        Arrays.fill(pdu, (byte)-1);
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                success = iccISms.updateMessageOnIccEf(messageIndex, 0, pdu);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return success;
    }

    public boolean updateMessageOnIcc(int messageIndex, int newStatus, byte[] pdu) {
        boolean success = false;
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                success = iccISms.updateMessageOnIccEf(messageIndex, newStatus, pdu);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return success;
    }

    public static ArrayList<SmsMessage> getAllMessagesFromIcc() {
        List<SmsRawData> records = null;
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                records = iccISms.getAllMessagesFromIccEf();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return SmsManager.createMessageListFromRawRecords(records);
    }

    public boolean enableCellBroadcast(int messageIdentifier) {
        boolean success = false;
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                success = iccISms.enableCellBroadcast(messageIdentifier);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    public boolean disableCellBroadcast(int messageIdentifier) {
        boolean success = false;
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                success = iccISms.disableCellBroadcast(messageIdentifier);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return success;
    }

    public boolean enableCellBroadcastRange(int startMessageId, int endMessageId) {
        boolean success = false;
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                success = iccISms.enableCellBroadcastRange(startMessageId, endMessageId);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return success;
    }

    public boolean disableCellBroadcastRange(int startMessageId, int endMessageId) {
        boolean success = false;
        try {
            ISms iccISms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iccISms != null) {
                success = iccISms.disableCellBroadcastRange(startMessageId, endMessageId);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return success;
    }

    private static ArrayList<SmsMessage> createMessageListFromRawRecords(List<SmsRawData> records) {
        ArrayList<SmsMessage> messages = new ArrayList<SmsMessage>();
        if (records != null) {
            int count = records.size();
            for (int i = 0; i < count; ++i) {
                SmsMessage sms;
                SmsRawData data = records.get(i);
                if (data == null || (sms = SmsMessage.createFromEfRecord(i + 1, data.getBytes())) == null) continue;
                messages.add(sms);
            }
        }
        return messages;
    }
}

