/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Editable;
import android.text.GetChars;
import android.text.GraphicsOperations;
import android.text.InputFilter;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import com.android.internal.util.ArrayUtils;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpannableStringBuilder
implements CharSequence,
GetChars,
Spannable,
Editable,
Appendable,
GraphicsOperations {
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private InputFilter[] mFilters = NO_FILTERS;
    private char[] mText;
    private int mGapStart;
    private int mGapLength;
    private Object[] mSpans;
    private int[] mSpanStarts;
    private int[] mSpanEnds;
    private int[] mSpanFlags;
    private int mSpanCount;
    private static final int POINT = 2;
    private static final int PARAGRAPH = 3;
    private static final int START_MASK = 240;
    private static final int END_MASK = 15;
    private static final int START_SHIFT = 4;

    public SpannableStringBuilder() {
        this("");
    }

    public SpannableStringBuilder(CharSequence text) {
        this(text, 0, text.length());
    }

    public SpannableStringBuilder(CharSequence text, int start, int end) {
        int srclen = end - start;
        int len = ArrayUtils.idealCharArraySize(srclen + 1);
        this.mText = new char[len];
        this.mGapStart = srclen;
        this.mGapLength = len - srclen;
        TextUtils.getChars(text, start, end, this.mText, 0);
        this.mSpanCount = 0;
        int alloc = ArrayUtils.idealIntArraySize(0);
        this.mSpans = new Object[alloc];
        this.mSpanStarts = new int[alloc];
        this.mSpanEnds = new int[alloc];
        this.mSpanFlags = new int[alloc];
        if (text instanceof Spanned) {
            Spanned sp = (Spanned)text;
            Object[] spans = sp.getSpans(start, end, Object.class);
            for (int i = 0; i < spans.length; ++i) {
                if (spans[i] instanceof NoCopySpan) continue;
                int st = sp.getSpanStart(spans[i]) - start;
                int en = sp.getSpanEnd(spans[i]) - start;
                int fl = sp.getSpanFlags(spans[i]);
                if (st < 0) {
                    st = 0;
                }
                if (st > end - start) {
                    st = end - start;
                }
                if (en < 0) {
                    en = 0;
                }
                if (en > end - start) {
                    en = end - start;
                }
                this.setSpan(spans[i], st, en, fl);
            }
        }
    }

    public static SpannableStringBuilder valueOf(CharSequence source) {
        if (source instanceof SpannableStringBuilder) {
            return (SpannableStringBuilder)source;
        }
        return new SpannableStringBuilder(source);
    }

    @Override
    public char charAt(int where) {
        int len = this.length();
        if (where < 0) {
            throw new IndexOutOfBoundsException("charAt: " + where + " < 0");
        }
        if (where >= len) {
            throw new IndexOutOfBoundsException("charAt: " + where + " >= length " + len);
        }
        if (where >= this.mGapStart) {
            return this.mText[where + this.mGapLength];
        }
        return this.mText[where];
    }

    @Override
    public int length() {
        return this.mText.length - this.mGapLength;
    }

    private void resizeFor(int size) {
        int newlen = ArrayUtils.idealCharArraySize(size + 1);
        char[] newtext = new char[newlen];
        int after = this.mText.length - (this.mGapStart + this.mGapLength);
        System.arraycopy(this.mText, 0, newtext, 0, this.mGapStart);
        System.arraycopy(this.mText, this.mText.length - after, newtext, newlen - after, after);
        for (int i = 0; i < this.mSpanCount; ++i) {
            if (this.mSpanStarts[i] > this.mGapStart) {
                int n = i;
                this.mSpanStarts[n] = this.mSpanStarts[n] + (newlen - this.mText.length);
            }
            if (this.mSpanEnds[i] <= this.mGapStart) continue;
            int n = i;
            this.mSpanEnds[n] = this.mSpanEnds[n] + (newlen - this.mText.length);
        }
        int oldlen = this.mText.length;
        this.mText = newtext;
        this.mGapLength += this.mText.length - oldlen;
        if (this.mGapLength < 1) {
            new Exception("mGapLength < 1").printStackTrace();
        }
    }

    private void moveGapTo(int where) {
        int overlap;
        boolean atend;
        if (where == this.mGapStart) {
            return;
        }
        boolean bl = atend = where == this.length();
        if (where < this.mGapStart) {
            overlap = this.mGapStart - where;
            System.arraycopy(this.mText, where, this.mText, this.mGapStart + this.mGapLength - overlap, overlap);
        } else {
            overlap = where - this.mGapStart;
            System.arraycopy(this.mText, where + this.mGapLength - overlap, this.mText, this.mGapStart, overlap);
        }
        for (int i = 0; i < this.mSpanCount; ++i) {
            int flag;
            int start = this.mSpanStarts[i];
            int end = this.mSpanEnds[i];
            if (start > this.mGapStart) {
                start -= this.mGapLength;
            }
            if (start > where) {
                start += this.mGapLength;
            } else if (start == where && ((flag = (this.mSpanFlags[i] & 0xF0) >> 4) == 2 || atend && flag == 3)) {
                start += this.mGapLength;
            }
            if (end > this.mGapStart) {
                end -= this.mGapLength;
            }
            if (end > where) {
                end += this.mGapLength;
            } else if (end == where && ((flag = this.mSpanFlags[i] & 0xF) == 2 || atend && flag == 3)) {
                end += this.mGapLength;
            }
            this.mSpanStarts[i] = start;
            this.mSpanEnds[i] = end;
        }
        this.mGapStart = where;
    }

    @Override
    public SpannableStringBuilder insert(int where, CharSequence tb, int start, int end) {
        return this.replace(where, where, tb, start, end);
    }

    @Override
    public SpannableStringBuilder insert(int where, CharSequence tb) {
        return this.replace(where, where, tb, 0, tb.length());
    }

    @Override
    public SpannableStringBuilder delete(int start, int end) {
        SpannableStringBuilder ret = this.replace(start, end, "", 0, 0);
        if (this.mGapLength > 2 * this.length()) {
            this.resizeFor(this.length());
        }
        return ret;
    }

    @Override
    public void clear() {
        this.replace(0, this.length(), "", 0, 0);
    }

    @Override
    public void clearSpans() {
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            Object what = this.mSpans[i];
            int ostart = this.mSpanStarts[i];
            int oend = this.mSpanEnds[i];
            if (ostart > this.mGapStart) {
                ostart -= this.mGapLength;
            }
            if (oend > this.mGapStart) {
                oend -= this.mGapLength;
            }
            this.mSpanCount = i;
            this.mSpans[i] = null;
            this.sendSpanRemoved(what, ostart, oend);
        }
    }

    @Override
    public SpannableStringBuilder append(CharSequence text) {
        int length = this.length();
        return this.replace(length, length, text, 0, text.length());
    }

    @Override
    public SpannableStringBuilder append(CharSequence text, int start, int end) {
        int length = this.length();
        return this.replace(length, length, text, start, end);
    }

    @Override
    public SpannableStringBuilder append(char text) {
        return this.append(String.valueOf(text));
    }

    private int change(int start, int end, CharSequence tb, int tbstart, int tbend) {
        return this.change(true, start, end, tb, tbstart, tbend);
    }

    private int change(boolean notify, int start, int end, CharSequence tb, int tbstart, int tbend) {
        this.checkRange("replace", start, end);
        int ret = tbend - tbstart;
        TextWatcher[] recipients = null;
        if (notify) {
            recipients = this.sendTextWillChange(start, end - start, tbend - tbstart);
        }
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            int en;
            if ((this.mSpanFlags[i] & 0x33) != 51) continue;
            int st = this.mSpanStarts[i];
            if (st > this.mGapStart) {
                st -= this.mGapLength;
            }
            if ((en = this.mSpanEnds[i]) > this.mGapStart) {
                en -= this.mGapLength;
            }
            int ost = st;
            int oen = en;
            int clen = this.length();
            if (st > start && st <= end) {
                for (st = end; st < clen && (st <= end || this.charAt(st - 1) != '\n'); ++st) {
                }
            }
            if (en > start && en <= end) {
                for (en = end; en < clen && (en <= end || this.charAt(en - 1) != '\n'); ++en) {
                }
            }
            if (st == ost && en == oen) continue;
            this.setSpan(this.mSpans[i], st, en, this.mSpanFlags[i]);
        }
        this.moveGapTo(end);
        int nbNewChars = tbend - tbstart - (end - start);
        if (nbNewChars >= this.mGapLength) {
            this.resizeFor(this.mText.length + nbNewChars - this.mGapLength);
        }
        this.mGapStart += nbNewChars;
        this.mGapLength -= nbNewChars;
        if (this.mGapLength < 1) {
            new Exception("mGapLength < 1").printStackTrace();
        }
        TextUtils.getChars(tb, tbstart, tbend, this.mText, start);
        if (tb instanceof Spanned) {
            Spanned sp = (Spanned)tb;
            Object[] spans = sp.getSpans(tbstart, tbend, Object.class);
            for (int i = 0; i < spans.length; ++i) {
                int st = sp.getSpanStart(spans[i]);
                int en = sp.getSpanEnd(spans[i]);
                if (st < tbstart) {
                    st = tbstart;
                }
                if (en > tbend) {
                    en = tbend;
                }
                if (this.getSpanStart(spans[i]) >= 0) continue;
                this.setSpan(false, spans[i], st - tbstart + start, en - tbstart + start, sp.getSpanFlags(spans[i]));
            }
        }
        if (tbend > tbstart && end - start == 0) {
            if (notify) {
                this.sendTextChange(recipients, start, end - start, tbend - tbstart);
                this.sendTextHasChanged(recipients);
            }
            return ret;
        }
        boolean atend = this.mGapStart + this.mGapLength == this.mText.length;
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            int flag;
            if (this.mSpanStarts[i] >= start && this.mSpanStarts[i] < this.mGapStart + this.mGapLength) {
                flag = (this.mSpanFlags[i] & 0xF0) >> 4;
                this.mSpanStarts[i] = flag == 2 || flag == 3 && atend ? this.mGapStart + this.mGapLength : start;
            }
            if (this.mSpanEnds[i] >= start && this.mSpanEnds[i] < this.mGapStart + this.mGapLength) {
                flag = this.mSpanFlags[i] & 0xF;
                this.mSpanEnds[i] = flag == 2 || flag == 3 && atend ? this.mGapStart + this.mGapLength : start;
            }
            if (this.mSpanEnds[i] >= this.mSpanStarts[i]) continue;
            this.removeSpan(i);
        }
        if (notify) {
            this.sendTextChange(recipients, start, end - start, tbend - tbstart);
            this.sendTextHasChanged(recipients);
        }
        return ret;
    }

    private void removeSpan(int i) {
        Object object = this.mSpans[i];
        int start = this.mSpanStarts[i];
        int end = this.mSpanEnds[i];
        if (start > this.mGapStart) {
            start -= this.mGapLength;
        }
        if (end > this.mGapStart) {
            end -= this.mGapLength;
        }
        int count = this.mSpanCount - (i + 1);
        System.arraycopy(this.mSpans, i + 1, this.mSpans, i, count);
        System.arraycopy(this.mSpanStarts, i + 1, this.mSpanStarts, i, count);
        System.arraycopy(this.mSpanEnds, i + 1, this.mSpanEnds, i, count);
        System.arraycopy(this.mSpanFlags, i + 1, this.mSpanFlags, i, count);
        --this.mSpanCount;
        this.mSpans[this.mSpanCount] = null;
        this.sendSpanRemoved(object, start, end);
    }

    @Override
    public SpannableStringBuilder replace(int start, int end, CharSequence tb) {
        return this.replace(start, end, tb, 0, tb.length());
    }

    @Override
    public SpannableStringBuilder replace(int start, int end, CharSequence tb, int tbstart, int tbend) {
        int filtercount = this.mFilters.length;
        for (int i = 0; i < filtercount; ++i) {
            CharSequence repl = this.mFilters[i].filter(tb, tbstart, tbend, this, start, end);
            if (repl == null) continue;
            tb = repl;
            tbstart = 0;
            tbend = repl.length();
        }
        if (end == start && tbstart == tbend) {
            return this;
        }
        if (end == start || tbstart == tbend) {
            this.change(start, end, tb, tbstart, tbend);
        } else {
            long off;
            int selstart = Selection.getSelectionStart(this);
            int selend = Selection.getSelectionEnd(this);
            this.checkRange("replace", start, end);
            this.moveGapTo(end);
            int origlen = end - start;
            TextWatcher[] recipients = this.sendTextWillChange(start, origlen, tbend - tbstart);
            if (this.mGapLength < 2) {
                this.resizeFor(this.length() + 1);
            }
            for (int i = this.mSpanCount - 1; i >= 0; --i) {
                if (this.mSpanStarts[i] == this.mGapStart) {
                    int n = i;
                    this.mSpanStarts[n] = this.mSpanStarts[n] + 1;
                }
                if (this.mSpanEnds[i] != this.mGapStart) continue;
                int n = i;
                this.mSpanEnds[n] = this.mSpanEnds[n] + 1;
            }
            this.mText[this.mGapStart] = 32;
            ++this.mGapStart;
            --this.mGapLength;
            if (this.mGapLength < 1) {
                new Exception("mGapLength < 1").printStackTrace();
            }
            int inserted = this.change(false, start + 1, start + 1, tb, tbstart, tbend);
            this.change(false, start, start + 1, "", 0, 0);
            this.change(false, start + inserted, start + inserted + origlen, "", 0, 0);
            if (selstart > start && selstart < end) {
                off = selstart - start;
                off = off * (long)inserted / (long)(end - start);
                selstart = (int)off + start;
                this.setSpan(false, Selection.SELECTION_START, selstart, selstart, 34);
            }
            if (selend > start && selend < end) {
                off = selend - start;
                off = off * (long)inserted / (long)(end - start);
                selend = (int)off + start;
                this.setSpan(false, Selection.SELECTION_END, selend, selend, 34);
            }
            this.sendTextChange(recipients, start, origlen, inserted);
            this.sendTextHasChanged(recipients);
        }
        return this;
    }

    @Override
    public void setSpan(Object what, int start, int end, int flags) {
        this.setSpan(true, what, start, end, flags);
    }

    private void setSpan(boolean send, Object what, int start, int end, int flags) {
        int flag;
        char c;
        int nstart = start;
        int nend = end;
        this.checkRange("setSpan", start, end);
        if ((flags & 0xF0) == 48 && start != 0 && start != this.length() && (c = this.charAt(start - 1)) != '\n') {
            throw new RuntimeException("PARAGRAPH span must start at paragraph boundary");
        }
        if ((flags & 0xF) == 3 && end != 0 && end != this.length() && (c = this.charAt(end - 1)) != '\n') {
            throw new RuntimeException("PARAGRAPH span must end at paragraph boundary");
        }
        if (start > this.mGapStart) {
            start += this.mGapLength;
        } else if (start == this.mGapStart && ((flag = (flags & 0xF0) >> 4) == 2 || flag == 3 && start == this.length())) {
            start += this.mGapLength;
        }
        if (end > this.mGapStart) {
            end += this.mGapLength;
        } else if (end == this.mGapStart && ((flag = flags & 0xF) == 2 || flag == 3 && end == this.length())) {
            end += this.mGapLength;
        }
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        for (int i = 0; i < count; ++i) {
            if (spans[i] != what) continue;
            int ostart = this.mSpanStarts[i];
            int oend = this.mSpanEnds[i];
            if (ostart > this.mGapStart) {
                ostart -= this.mGapLength;
            }
            if (oend > this.mGapStart) {
                oend -= this.mGapLength;
            }
            this.mSpanStarts[i] = start;
            this.mSpanEnds[i] = end;
            this.mSpanFlags[i] = flags;
            if (send) {
                this.sendSpanChanged(what, ostart, oend, nstart, nend);
            }
            return;
        }
        if (this.mSpanCount + 1 >= this.mSpans.length) {
            int newsize = ArrayUtils.idealIntArraySize(this.mSpanCount + 1);
            Object[] newspans = new Object[newsize];
            int[] newspanstarts = new int[newsize];
            int[] newspanends = new int[newsize];
            int[] newspanflags = new int[newsize];
            System.arraycopy(this.mSpans, 0, newspans, 0, this.mSpanCount);
            System.arraycopy(this.mSpanStarts, 0, newspanstarts, 0, this.mSpanCount);
            System.arraycopy(this.mSpanEnds, 0, newspanends, 0, this.mSpanCount);
            System.arraycopy(this.mSpanFlags, 0, newspanflags, 0, this.mSpanCount);
            this.mSpans = newspans;
            this.mSpanStarts = newspanstarts;
            this.mSpanEnds = newspanends;
            this.mSpanFlags = newspanflags;
        }
        this.mSpans[this.mSpanCount] = what;
        this.mSpanStarts[this.mSpanCount] = start;
        this.mSpanEnds[this.mSpanCount] = end;
        this.mSpanFlags[this.mSpanCount] = flags;
        ++this.mSpanCount;
        if (send) {
            this.sendSpanAdded(what, nstart, nend);
        }
    }

    @Override
    public void removeSpan(Object what) {
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            if (this.mSpans[i] != what) continue;
            this.removeSpan(i);
            return;
        }
    }

    @Override
    public int getSpanStart(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            int where = this.mSpanStarts[i];
            if (where > this.mGapStart) {
                where -= this.mGapLength;
            }
            return where;
        }
        return -1;
    }

    @Override
    public int getSpanEnd(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            int where = this.mSpanEnds[i];
            if (where > this.mGapStart) {
                where -= this.mGapLength;
            }
            return where;
        }
        return -1;
    }

    @Override
    public int getSpanFlags(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return this.mSpanFlags[i];
        }
        return 0;
    }

    @Override
    public <T> T[] getSpans(int queryStart, int queryEnd, Class<T> kind) {
        if (kind == null) {
            return ArrayUtils.emptyArray(kind);
        }
        int spanCount = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] starts = this.mSpanStarts;
        int[] ends = this.mSpanEnds;
        int[] flags = this.mSpanFlags;
        int gapstart = this.mGapStart;
        int gaplen = this.mGapLength;
        int count = 0;
        Object[] ret = null;
        Object ret1 = null;
        for (int i = 0; i < spanCount; ++i) {
            int prio;
            int spanStart = starts[i];
            if (spanStart > gapstart) {
                spanStart -= gaplen;
            }
            if (spanStart > queryEnd) continue;
            int spanEnd = ends[i];
            if (spanEnd > gapstart) {
                spanEnd -= gaplen;
            }
            if (spanEnd < queryStart || spanStart != spanEnd && queryStart != queryEnd && (spanStart == queryEnd || spanEnd == queryStart) || !kind.isInstance(spans[i])) continue;
            if (count == 0) {
                ret1 = spans[i];
                ++count;
                continue;
            }
            if (count == 1) {
                ret = (Object[])Array.newInstance(kind, spanCount - i + 1);
                ret[0] = ret1;
            }
            if ((prio = flags[i] & 0xFF0000) != 0) {
                int p;
                int j;
                for (j = 0; j < count && prio <= (p = this.getSpanFlags(ret[j]) & 0xFF0000); ++j) {
                }
                System.arraycopy(ret, j, ret, j + 1, count - j);
                ret[j] = spans[i];
                ++count;
                continue;
            }
            ret[count++] = spans[i];
        }
        if (count == 0) {
            return ArrayUtils.emptyArray(kind);
        }
        if (count == 1) {
            ret = (Object[])Array.newInstance(kind, 1);
            ret[0] = ret1;
            return ret;
        }
        if (count == ret.length) {
            return ret;
        }
        Object[] nret = (Object[])Array.newInstance(kind, count);
        System.arraycopy(ret, 0, nret, 0, count);
        return nret;
    }

    @Override
    public int nextSpanTransition(int start, int limit, Class kind) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] starts = this.mSpanStarts;
        int[] ends = this.mSpanEnds;
        int gapstart = this.mGapStart;
        int gaplen = this.mGapLength;
        if (kind == null) {
            kind = Object.class;
        }
        for (int i = 0; i < count; ++i) {
            int st = starts[i];
            int en = ends[i];
            if (st > gapstart) {
                st -= gaplen;
            }
            if (en > gapstart) {
                en -= gaplen;
            }
            if (st > start && st < limit && kind.isInstance(spans[i])) {
                limit = st;
            }
            if (en <= start || en >= limit || !kind.isInstance(spans[i])) continue;
            limit = en;
        }
        return limit;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new SpannableStringBuilder(this, start, end);
    }

    @Override
    public void getChars(int start, int end, char[] dest, int destoff) {
        this.checkRange("getChars", start, end);
        if (end <= this.mGapStart) {
            System.arraycopy(this.mText, start, dest, destoff, end - start);
        } else if (start >= this.mGapStart) {
            System.arraycopy(this.mText, start + this.mGapLength, dest, destoff, end - start);
        } else {
            System.arraycopy(this.mText, start, dest, destoff, this.mGapStart - start);
            System.arraycopy(this.mText, this.mGapStart + this.mGapLength, dest, destoff + (this.mGapStart - start), end - this.mGapStart);
        }
    }

    @Override
    public String toString() {
        int len = this.length();
        char[] buf = new char[len];
        this.getChars(0, len, buf, 0);
        return new String(buf);
    }

    public String substring(int start, int end) {
        char[] buf = new char[end - start];
        this.getChars(start, end, buf, 0);
        return new String(buf);
    }

    private TextWatcher[] sendTextWillChange(int start, int before, int after) {
        TextWatcher[] recip = this.getSpans(start, start + before, TextWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].beforeTextChanged(this, start, before, after);
        }
        return recip;
    }

    private void sendTextChange(TextWatcher[] recip, int start, int before, int after) {
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onTextChanged(this, start, before, after);
        }
    }

    private void sendTextHasChanged(TextWatcher[] recip) {
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].afterTextChanged(this);
        }
    }

    private void sendSpanAdded(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanAdded(this, what, start, end);
        }
    }

    private void sendSpanRemoved(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanRemoved(this, what, start, end);
        }
    }

    private void sendSpanChanged(Object what, int s, int e, int st, int en) {
        SpanWatcher[] recip = this.getSpans(Math.min(s, st), Math.max(e, en), SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanChanged(this, what, s, e, st, en);
        }
    }

    private static String region(int start, int end) {
        return "(" + start + " ... " + end + ")";
    }

    private void checkRange(String operation, int start, int end) {
        if (end < start) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringBuilder.region(start, end) + " has end before start");
        }
        int len = this.length();
        if (start > len || end > len) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringBuilder.region(start, end) + " ends beyond length " + len);
        }
        if (start < 0 || end < 0) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringBuilder.region(start, end) + " starts before 0");
        }
    }

    @Override
    public void drawText(Canvas c, int start, int end, float x, float y, Paint p) {
        this.checkRange("drawText", start, end);
        if (end <= this.mGapStart) {
            c.drawText(this.mText, start, end - start, x, y, p);
        } else if (start >= this.mGapStart) {
            c.drawText(this.mText, start + this.mGapLength, end - start, x, y, p);
        } else {
            char[] buf = TextUtils.obtain(end - start);
            this.getChars(start, end, buf, 0);
            c.drawText(buf, 0, end - start, x, y, p);
            TextUtils.recycle(buf);
        }
    }

    @Override
    public void drawTextRun(Canvas c, int start, int end, int contextStart, int contextEnd, float x, float y, int flags, Paint p) {
        this.checkRange("drawTextRun", start, end);
        int contextLen = contextEnd - contextStart;
        int len = end - start;
        if (contextEnd <= this.mGapStart) {
            c.drawTextRun(this.mText, start, len, contextStart, contextLen, x, y, flags, p);
        } else if (contextStart >= this.mGapStart) {
            c.drawTextRun(this.mText, start + this.mGapLength, len, contextStart + this.mGapLength, contextLen, x, y, flags, p);
        } else {
            char[] buf = TextUtils.obtain(contextLen);
            this.getChars(contextStart, contextEnd, buf, 0);
            c.drawTextRun(buf, start - contextStart, len, 0, contextLen, x, y, flags, p);
            TextUtils.recycle(buf);
        }
    }

    @Override
    public float measureText(int start, int end, Paint p) {
        float ret;
        this.checkRange("measureText", start, end);
        if (end <= this.mGapStart) {
            ret = p.measureText(this.mText, start, end - start);
        } else if (start >= this.mGapStart) {
            ret = p.measureText(this.mText, start + this.mGapLength, end - start);
        } else {
            char[] buf = TextUtils.obtain(end - start);
            this.getChars(start, end, buf, 0);
            ret = p.measureText(buf, 0, end - start);
            TextUtils.recycle(buf);
        }
        return ret;
    }

    @Override
    public int getTextWidths(int start, int end, float[] widths, Paint p) {
        int ret;
        this.checkRange("getTextWidths", start, end);
        if (end <= this.mGapStart) {
            ret = p.getTextWidths(this.mText, start, end - start, widths);
        } else if (start >= this.mGapStart) {
            ret = p.getTextWidths(this.mText, start + this.mGapLength, end - start, widths);
        } else {
            char[] buf = TextUtils.obtain(end - start);
            this.getChars(start, end, buf, 0);
            ret = p.getTextWidths(buf, 0, end - start, widths);
            TextUtils.recycle(buf);
        }
        return ret;
    }

    @Override
    public float getTextRunAdvances(int start, int end, int contextStart, int contextEnd, int flags, float[] advances, int advancesPos, Paint p) {
        float ret;
        int contextLen = contextEnd - contextStart;
        int len = end - start;
        if (end <= this.mGapStart) {
            ret = p.getTextRunAdvances(this.mText, start, len, contextStart, contextLen, flags, advances, advancesPos);
        } else if (start >= this.mGapStart) {
            ret = p.getTextRunAdvances(this.mText, start + this.mGapLength, len, contextStart + this.mGapLength, contextLen, flags, advances, advancesPos);
        } else {
            char[] buf = TextUtils.obtain(contextLen);
            this.getChars(contextStart, contextEnd, buf, 0);
            ret = p.getTextRunAdvances(buf, start - contextStart, len, 0, contextLen, flags, advances, advancesPos);
            TextUtils.recycle(buf);
        }
        return ret;
    }

    @Override
    public float getTextRunAdvances(int start, int end, int contextStart, int contextEnd, int flags, float[] advances, int advancesPos, Paint p, int reserved) {
        float ret;
        int contextLen = contextEnd - contextStart;
        int len = end - start;
        if (end <= this.mGapStart) {
            ret = p.getTextRunAdvances(this.mText, start, len, contextStart, contextLen, flags, advances, advancesPos, reserved);
        } else if (start >= this.mGapStart) {
            ret = p.getTextRunAdvances(this.mText, start + this.mGapLength, len, contextStart + this.mGapLength, contextLen, flags, advances, advancesPos, reserved);
        } else {
            char[] buf = TextUtils.obtain(contextLen);
            this.getChars(contextStart, contextEnd, buf, 0);
            ret = p.getTextRunAdvances(buf, start - contextStart, len, 0, contextLen, flags, advances, advancesPos, reserved);
            TextUtils.recycle(buf);
        }
        return ret;
    }

    @Override
    @Deprecated
    public int getTextRunCursor(int contextStart, int contextEnd, int flags, int offset, int cursorOpt, Paint p) {
        int ret;
        int contextLen = contextEnd - contextStart;
        if (contextEnd <= this.mGapStart) {
            ret = p.getTextRunCursor(this.mText, contextStart, contextLen, flags, offset, cursorOpt);
        } else if (contextStart >= this.mGapStart) {
            ret = p.getTextRunCursor(this.mText, contextStart + this.mGapLength, contextLen, flags, offset + this.mGapLength, cursorOpt) - this.mGapLength;
        } else {
            char[] buf = TextUtils.obtain(contextLen);
            this.getChars(contextStart, contextEnd, buf, 0);
            ret = p.getTextRunCursor(buf, 0, contextLen, flags, offset - contextStart, cursorOpt) + contextStart;
            TextUtils.recycle(buf);
        }
        return ret;
    }

    @Override
    public void setFilters(InputFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException();
        }
        this.mFilters = filters;
    }

    @Override
    public InputFilter[] getFilters() {
        return this.mFilters;
    }
}

