/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import com.android.internal.util.ArrayUtils;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SpannableStringInternal {
    private String mText;
    private Object[] mSpans;
    private int[] mSpanData;
    private int mSpanCount;
    static final Object[] EMPTY = new Object[0];
    private static final int START = 0;
    private static final int END = 1;
    private static final int FLAGS = 2;
    private static final int COLUMNS = 3;

    SpannableStringInternal(CharSequence source, int start, int end) {
        this.mText = start == 0 && end == source.length() ? ((Object)source).toString() : ((Object)source).toString().substring(start, end);
        int initial = ArrayUtils.idealIntArraySize(0);
        this.mSpans = new Object[initial];
        this.mSpanData = new int[initial * 3];
        if (source instanceof Spanned) {
            Spanned sp = (Spanned)source;
            Object[] spans = sp.getSpans(start, end, Object.class);
            for (int i = 0; i < spans.length; ++i) {
                int st = sp.getSpanStart(spans[i]);
                int en = sp.getSpanEnd(spans[i]);
                int fl = sp.getSpanFlags(spans[i]);
                if (st < start) {
                    st = start;
                }
                if (en > end) {
                    en = end;
                }
                this.setSpan(spans[i], st - start, en - start, fl);
            }
        }
    }

    public final int length() {
        return this.mText.length();
    }

    public final char charAt(int i) {
        return this.mText.charAt(i);
    }

    public final String toString() {
        return this.mText;
    }

    public final void getChars(int start, int end, char[] dest, int off) {
        this.mText.getChars(start, end, dest, off);
    }

    void setSpan(Object what, int start, int end, int flags) {
        int nstart = start;
        int nend = end;
        this.checkRange("setSpan", start, end);
        if ((flags & 0x33) == 51) {
            char c;
            if (start != 0 && start != this.length() && (c = this.charAt(start - 1)) != '\n') {
                throw new RuntimeException("PARAGRAPH span must start at paragraph boundary (" + start + " follows " + c + ")");
            }
            if (end != 0 && end != this.length() && (c = this.charAt(end - 1)) != '\n') {
                throw new RuntimeException("PARAGRAPH span must end at paragraph boundary (" + end + " follows " + c + ")");
            }
        }
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = 0; i < count; ++i) {
            if (spans[i] != what) continue;
            int ostart = data[i * 3 + 0];
            int oend = data[i * 3 + 1];
            data[i * 3 + 0] = start;
            data[i * 3 + 1] = end;
            data[i * 3 + 2] = flags;
            this.sendSpanChanged(what, ostart, oend, nstart, nend);
            return;
        }
        if (this.mSpanCount + 1 >= this.mSpans.length) {
            int newsize = ArrayUtils.idealIntArraySize(this.mSpanCount + 1);
            Object[] newtags = new Object[newsize];
            int[] newdata = new int[newsize * 3];
            System.arraycopy(this.mSpans, 0, newtags, 0, this.mSpanCount);
            System.arraycopy(this.mSpanData, 0, newdata, 0, this.mSpanCount * 3);
            this.mSpans = newtags;
            this.mSpanData = newdata;
        }
        this.mSpans[this.mSpanCount] = what;
        this.mSpanData[this.mSpanCount * 3 + 0] = start;
        this.mSpanData[this.mSpanCount * 3 + 1] = end;
        this.mSpanData[this.mSpanCount * 3 + 2] = flags;
        ++this.mSpanCount;
        if (this instanceof Spannable) {
            this.sendSpanAdded(what, nstart, nend);
        }
    }

    void removeSpan(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            int ostart = data[i * 3 + 0];
            int oend = data[i * 3 + 1];
            int c = count - (i + 1);
            System.arraycopy(spans, i + 1, spans, i, c);
            System.arraycopy(data, (i + 1) * 3, data, i * 3, c * 3);
            --this.mSpanCount;
            this.sendSpanRemoved(what, ostart, oend);
            return;
        }
    }

    public int getSpanStart(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 0];
        }
        return -1;
    }

    public int getSpanEnd(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 1];
        }
        return -1;
    }

    public int getSpanFlags(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 2];
        }
        return 0;
    }

    public <T> T[] getSpans(int queryStart, int queryEnd, Class<T> kind) {
        int count = 0;
        int spanCount = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        Object[] ret = null;
        Object ret1 = null;
        for (int i = 0; i < spanCount; ++i) {
            int prio;
            if (kind != null && !kind.isInstance(spans[i])) continue;
            int spanStart = data[i * 3 + 0];
            int spanEnd = data[i * 3 + 1];
            if (spanStart > queryEnd || spanEnd < queryStart || spanStart != spanEnd && queryStart != queryEnd && (spanStart == queryEnd || spanEnd == queryStart)) continue;
            if (count == 0) {
                ret1 = spans[i];
                ++count;
                continue;
            }
            if (count == 1) {
                ret = (Object[])Array.newInstance(kind, spanCount - i + 1);
                ret[0] = ret1;
            }
            if ((prio = data[i * 3 + 2] & 0xFF0000) != 0) {
                int p;
                int j;
                for (j = 0; j < count && prio <= (p = this.getSpanFlags(ret[j]) & 0xFF0000); ++j) {
                }
                System.arraycopy(ret, j, ret, j + 1, count - j);
                ret[j] = spans[i];
                ++count;
                continue;
            }
            ret[count++] = spans[i];
        }
        if (count == 0) {
            return ArrayUtils.emptyArray(kind);
        }
        if (count == 1) {
            ret = (Object[])Array.newInstance(kind, 1);
            ret[0] = ret1;
            return ret;
        }
        if (count == ret.length) {
            return ret;
        }
        Object[] nret = (Object[])Array.newInstance(kind, count);
        System.arraycopy(ret, 0, nret, 0, count);
        return nret;
    }

    public int nextSpanTransition(int start, int limit, Class kind) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        if (kind == null) {
            kind = Object.class;
        }
        for (int i = 0; i < count; ++i) {
            int st = data[i * 3 + 0];
            int en = data[i * 3 + 1];
            if (st > start && st < limit && kind.isInstance(spans[i])) {
                limit = st;
            }
            if (en <= start || en >= limit || !kind.isInstance(spans[i])) continue;
            limit = en;
        }
        return limit;
    }

    private void sendSpanAdded(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanAdded((Spannable)((Object)this), what, start, end);
        }
    }

    private void sendSpanRemoved(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanRemoved((Spannable)((Object)this), what, start, end);
        }
    }

    private void sendSpanChanged(Object what, int s, int e, int st, int en) {
        SpanWatcher[] recip = this.getSpans(Math.min(s, st), Math.max(e, en), SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanChanged((Spannable)((Object)this), what, s, e, st, en);
        }
    }

    private static String region(int start, int end) {
        return "(" + start + " ... " + end + ")";
    }

    private void checkRange(String operation, int start, int end) {
        if (end < start) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringInternal.region(start, end) + " has end before start");
        }
        int len = this.length();
        if (start > len || end > len) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringInternal.region(start, end) + " ends beyond length " + len);
        }
        if (start < 0 || end < 0) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringInternal.region(start, end) + " starts before 0");
        }
    }
}

