/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.res.Resources;
import java.util.Locale;
import java.util.TimeZone;

public class Time {
    private static final String Y_M_D_T_H_M_S_000 = "%Y-%m-%dT%H:%M:%S.000";
    private static final String Y_M_D_T_H_M_S_000_Z = "%Y-%m-%dT%H:%M:%S.000Z";
    private static final String Y_M_D = "%Y-%m-%d";
    public static final String TIMEZONE_UTC = "UTC";
    public static final int EPOCH_JULIAN_DAY = 2440588;
    public static final int MONDAY_BEFORE_JULIAN_EPOCH = 2440585;
    public boolean allDay;
    public int second;
    public int minute;
    public int hour;
    public int monthDay;
    public int month;
    public int year;
    public int weekDay;
    public int yearDay;
    public int isDst;
    public long gmtoff;
    public String timezone;
    public static final int SECOND = 1;
    public static final int MINUTE = 2;
    public static final int HOUR = 3;
    public static final int MONTH_DAY = 4;
    public static final int MONTH = 5;
    public static final int YEAR = 6;
    public static final int WEEK_DAY = 7;
    public static final int YEAR_DAY = 8;
    public static final int WEEK_NUM = 9;
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    private static Locale sLocale;
    private static String[] sShortMonths;
    private static String[] sLongMonths;
    private static String[] sLongStandaloneMonths;
    private static String[] sShortWeekdays;
    private static String[] sLongWeekdays;
    private static String sTimeOnlyFormat;
    private static String sDateOnlyFormat;
    private static String sDateTimeFormat;
    private static String sAm;
    private static String sPm;
    private static String sDateCommand;
    private static final int[] DAYS_PER_MONTH;
    private static final int[] sThursdayOffset;

    public Time(String timezone) {
        if (timezone == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.timezone = timezone;
        this.year = 1970;
        this.monthDay = 1;
        this.isDst = -1;
    }

    public Time() {
        this(TimeZone.getDefault().getID());
    }

    public Time(Time other) {
        this.set(other);
    }

    public native long normalize(boolean var1);

    public native void switchTimezone(String var1);

    public int getActualMaximum(int field) {
        switch (field) {
            case 1: {
                return 59;
            }
            case 2: {
                return 59;
            }
            case 3: {
                return 23;
            }
            case 4: {
                int n = DAYS_PER_MONTH[this.month];
                if (n != 28) {
                    return n;
                }
                int y = this.year;
                return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 29 : 28;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 2037;
            }
            case 7: {
                return 6;
            }
            case 8: {
                int y = this.year;
                return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 365 : 364;
            }
            case 9: {
                throw new RuntimeException("WEEK_NUM not implemented");
            }
        }
        throw new RuntimeException("bad field=" + field);
    }

    public void clear(String timezone) {
        if (timezone == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.timezone = timezone;
        this.allDay = false;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = 0;
        this.month = 0;
        this.year = 0;
        this.weekDay = 0;
        this.yearDay = 0;
        this.gmtoff = 0L;
        this.isDst = -1;
    }

    public static int compare(Time a, Time b) {
        if (a == null) {
            throw new NullPointerException("a == null");
        }
        if (b == null) {
            throw new NullPointerException("b == null");
        }
        return Time.nativeCompare(a, b);
    }

    private static native int nativeCompare(Time var0, Time var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(String format) {
        Class<Time> clazz = Time.class;
        synchronized (Time.class) {
            Locale locale = Locale.getDefault();
            if (sLocale == null || locale == null || !locale.equals(sLocale)) {
                Resources r = Resources.getSystem();
                sShortMonths = new String[]{r.getString(0x1040041), r.getString(17039426), r.getString(17039427), r.getString(0x1040044), r.getString(17039429), r.getString(17039430), r.getString(17039431), r.getString(17039432), r.getString(17039433), r.getString(17039434), r.getString(17039435), r.getString(17039436)};
                sLongMonths = new String[]{r.getString(17039413), r.getString(17039414), r.getString(17039415), r.getString(17039416), r.getString(17039417), r.getString(17039418), r.getString(17039419), r.getString(17039420), r.getString(17039421), r.getString(17039422), r.getString(17039423), r.getString(0x1040040)};
                sLongStandaloneMonths = new String[]{r.getString(17039401), r.getString(17039402), r.getString(17039403), r.getString(17039404), r.getString(17039405), r.getString(17039406), r.getString(17039407), r.getString(17039408), r.getString(17039409), r.getString(17039410), r.getString(17039411), r.getString(17039412)};
                sShortWeekdays = new String[]{r.getString(17039456), r.getString(17039457), r.getString(17039458), r.getString(17039459), r.getString(17039460), r.getString(17039461), r.getString(17039462)};
                sLongWeekdays = new String[]{r.getString(17039449), r.getString(17039450), r.getString(17039451), r.getString(17039452), r.getString(17039453), r.getString(17039454), r.getString(17039455)};
                sTimeOnlyFormat = r.getString(17039491);
                sDateOnlyFormat = r.getString(17039490);
                sDateTimeFormat = r.getString(17039492);
                sAm = r.getString(17039477);
                sPm = r.getString(17039478);
                sLocale = locale;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.format1(format);
        }
    }

    private native String format1(String var1);

    public native String toString();

    public boolean parse(String s) {
        if (this.nativeParse(s)) {
            this.timezone = TIMEZONE_UTC;
            return true;
        }
        return false;
    }

    private native boolean nativeParse(String var1);

    public boolean parse3339(String s) {
        if (this.nativeParse3339(s)) {
            this.timezone = TIMEZONE_UTC;
            return true;
        }
        return false;
    }

    private native boolean nativeParse3339(String var1);

    public static String getCurrentTimezone() {
        return TimeZone.getDefault().getID();
    }

    public native void setToNow();

    public native long toMillis(boolean var1);

    public native void set(long var1);

    public native String format2445();

    public void set(Time that) {
        this.timezone = that.timezone;
        this.allDay = that.allDay;
        this.second = that.second;
        this.minute = that.minute;
        this.hour = that.hour;
        this.monthDay = that.monthDay;
        this.month = that.month;
        this.year = that.year;
        this.weekDay = that.weekDay;
        this.yearDay = that.yearDay;
        this.isDst = that.isDst;
        this.gmtoff = that.gmtoff;
    }

    public void set(int second, int minute, int hour, int monthDay, int month, int year) {
        this.allDay = false;
        this.second = second;
        this.minute = minute;
        this.hour = hour;
        this.monthDay = monthDay;
        this.month = month;
        this.year = year;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    public void set(int monthDay, int month, int year) {
        this.allDay = true;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
        this.monthDay = monthDay;
        this.month = month;
        this.year = year;
        this.weekDay = 0;
        this.yearDay = 0;
        this.isDst = -1;
        this.gmtoff = 0L;
    }

    public boolean before(Time that) {
        return Time.compare(this, that) < 0;
    }

    public boolean after(Time that) {
        return Time.compare(this, that) > 0;
    }

    public int getWeekNumber() {
        int closestThursday = this.yearDay + sThursdayOffset[this.weekDay];
        if (closestThursday >= 0 && closestThursday <= 364) {
            return closestThursday / 7 + 1;
        }
        Time temp = new Time(this);
        temp.monthDay += sThursdayOffset[this.weekDay];
        temp.normalize(true);
        return temp.yearDay / 7 + 1;
    }

    public String format3339(boolean allDay) {
        if (allDay) {
            return this.format(Y_M_D);
        }
        if (TIMEZONE_UTC.equals(this.timezone)) {
            return this.format(Y_M_D_T_H_M_S_000_Z);
        }
        String base = this.format(Y_M_D_T_H_M_S_000);
        String sign = this.gmtoff < 0L ? "-" : "+";
        int offset = (int)Math.abs(this.gmtoff);
        int minutes = offset % 3600 / 60;
        int hours = offset / 3600;
        return String.format("%s%s%02d:%02d", base, sign, hours, minutes);
    }

    public static boolean isEpoch(Time time) {
        long millis = time.toMillis(true);
        return Time.getJulianDay(millis, 0L) == 2440588;
    }

    public static int getJulianDay(long millis, long gmtoff) {
        long offsetMillis = gmtoff * 1000L;
        long julianDay = (millis + offsetMillis) / 86400000L;
        return (int)julianDay + 2440588;
    }

    public long setJulianDay(int julianDay) {
        long millis = (long)(julianDay - 2440588) * 86400000L;
        this.set(millis);
        int approximateDay = Time.getJulianDay(millis, this.gmtoff);
        int diff = julianDay - approximateDay;
        this.monthDay += diff;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        millis = this.normalize(true);
        return millis;
    }

    public static int getWeeksSinceEpochFromJulianDay(int julianDay, int firstDayOfWeek) {
        int diff = 4 - firstDayOfWeek;
        if (diff < 0) {
            diff += 7;
        }
        int refDay = 2440588 - diff;
        return (julianDay - refDay) / 7;
    }

    public static int getJulianMondayFromWeeksSinceEpoch(int week) {
        return 2440585 + week * 7;
    }

    static {
        sDateCommand = "%a %b %e %H:%M:%S %Z %Y";
        DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        sThursdayOffset = new int[]{-3, 3, 2, 1, 0, -1, -2};
    }
}

