/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.view.CompatibilityInfoHolder;
import android.view.IWindowManager;

public class Display {
    static final String TAG = "Display";
    static final boolean DEBUG_DISPLAY_SIZE = false;
    public static final int DEFAULT_DISPLAY = 0;
    private final CompatibilityInfoHolder mCompatibilityInfo;
    private final int mDisplay;
    private int mPixelFormat;
    private float mRefreshRate;
    float mDensity;
    float mDpiX;
    float mDpiY;
    private final Point mTmpPoint = new Point();
    private final DisplayMetrics mTmpMetrics = new DisplayMetrics();
    private float mLastGetTime;
    private static final Object sStaticInit = new Object();
    private static boolean sInitialized = false;
    private static IWindowManager sWindowManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Display(int display, CompatibilityInfoHolder compatInfo) {
        Object object = sStaticInit;
        synchronized (object) {
            if (!sInitialized) {
                Display.nativeClassInit();
                sInitialized = true;
            }
        }
        this.mCompatibilityInfo = compatInfo != null ? compatInfo : new CompatibilityInfoHolder();
        this.mDisplay = display;
        this.init(display);
    }

    public int getDisplayId() {
        return this.mDisplay;
    }

    static native int getDisplayCount();

    public void getSize(Point outSize) {
        this.getSizeInternal(outSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSizeInternal(Point outSize, boolean doCompat) {
        block6: {
            try {
                IWindowManager wm = Display.getWindowManager();
                if (wm != null) {
                    CompatibilityInfo ci;
                    wm.getDisplaySize(outSize);
                    if (!doCompat || (ci = this.mCompatibilityInfo.getIfNeeded()) == null) break block6;
                    DisplayMetrics displayMetrics = this.mTmpMetrics;
                    synchronized (displayMetrics) {
                        this.mTmpMetrics.noncompatWidthPixels = outSize.x;
                        this.mTmpMetrics.noncompatHeightPixels = outSize.y;
                        this.mTmpMetrics.density = this.mDensity;
                        ci.applyToDisplayMetrics(this.mTmpMetrics);
                        outSize.x = this.mTmpMetrics.widthPixels;
                        outSize.y = this.mTmpMetrics.heightPixels;
                        break block6;
                    }
                }
                outSize.x = this.getRawWidth();
                outSize.y = this.getRawHeight();
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Unable to get display size", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRectSize(Rect outSize) {
        Point point = this.mTmpPoint;
        synchronized (point) {
            this.getSizeInternal(this.mTmpPoint, true);
            outSize.set(0, 0, this.mTmpPoint.x, this.mTmpPoint.y);
        }
    }

    public int getMaximumSizeDimension() {
        try {
            IWindowManager wm = Display.getWindowManager();
            return wm.getMaximumSizeDimension();
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Unable to get display maximum size dimension", e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getWidth() {
        Point point = this.mTmpPoint;
        synchronized (point) {
            long now = SystemClock.uptimeMillis();
            if ((float)now > this.mLastGetTime + 20.0f) {
                this.getSizeInternal(this.mTmpPoint, true);
                this.mLastGetTime = now;
            }
            return this.mTmpPoint.x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getHeight() {
        Point point = this.mTmpPoint;
        synchronized (point) {
            long now = SystemClock.uptimeMillis();
            if ((float)now > this.mLastGetTime + 20.0f) {
                this.getSizeInternal(this.mTmpPoint, true);
                this.mLastGetTime = now;
            }
            return this.mTmpPoint.y;
        }
    }

    public void getRealSize(Point outSize) {
        try {
            IWindowManager wm = Display.getWindowManager();
            if (wm != null) {
                wm.getRealDisplaySize(outSize);
            } else {
                outSize.x = this.getRawWidth();
                outSize.y = this.getRawHeight();
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Unable to get real display size", e);
        }
    }

    public int getRawWidth() {
        int w = this.getRawWidthNative();
        return w;
    }

    private native int getRawWidthNative();

    public int getRawHeight() {
        int h = this.getRawHeightNative();
        return h;
    }

    private native int getRawHeightNative();

    public int getRotation() {
        return this.getOrientation();
    }

    @Deprecated
    public native int getOrientation();

    public int getPixelFormat() {
        return this.mPixelFormat;
    }

    public float getRefreshRate() {
        return this.mRefreshRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMetrics(DisplayMetrics outMetrics) {
        Point point = this.mTmpPoint;
        synchronized (point) {
            this.getSizeInternal(this.mTmpPoint, false);
            this.getMetricsWithSize(outMetrics, this.mTmpPoint.x, this.mTmpPoint.y);
        }
        CompatibilityInfo ci = this.mCompatibilityInfo.getIfNeeded();
        if (ci != null) {
            ci.applyToDisplayMetrics(outMetrics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRealMetrics(DisplayMetrics outMetrics) {
        Point point = this.mTmpPoint;
        synchronized (point) {
            this.getRealSize(this.mTmpPoint);
            this.getMetricsWithSize(outMetrics, this.mTmpPoint.x, this.mTmpPoint.y);
        }
    }

    public int getRawExternalWidth() {
        return 1280;
    }

    public int getRawExternalHeight() {
        return 720;
    }

    public void getMetricsWithSize(DisplayMetrics outMetrics, int width, int height) {
        outMetrics.densityDpi = (int)(this.mDensity * 160.0f + 0.5f);
        outMetrics.noncompatWidthPixels = outMetrics.widthPixels = width;
        outMetrics.noncompatHeightPixels = outMetrics.heightPixels = height;
        outMetrics.scaledDensity = outMetrics.noncompatScaledDensity = (outMetrics.density = (outMetrics.noncompatDensity = this.mDensity));
        outMetrics.xdpi = outMetrics.noncompatXdpi = this.mDpiX;
        outMetrics.ydpi = outMetrics.noncompatYdpi = this.mDpiY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IWindowManager getWindowManager() {
        Object object = sStaticInit;
        synchronized (object) {
            if (sWindowManager == null) {
                sWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
            }
            return sWindowManager;
        }
    }

    private static native void nativeClassInit();

    private native void init(int var1);

    public static Display createCompatibleDisplay(int displayId, CompatibilityInfoHolder compat) {
        return new Display(displayId, compat);
    }
}

