/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.SurfaceTexture;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.DisplayList;
import android.view.GLES20DisplayList;
import android.view.GLES20Layer;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;

class GLES20Canvas
extends HardwareCanvas {
    private static final int MODIFIER_NONE = 0;
    private static final int MODIFIER_SHADOW = 1;
    private static final int MODIFIER_SHADER = 2;
    private static final int MODIFIER_COLOR_FILTER = 4;
    private final boolean mOpaque;
    private int mRenderer;
    private CanvasFinalizer mFinalizer;
    private int mWidth;
    private int mHeight;
    private final float[] mPoint = new float[2];
    private final float[] mLine = new float[4];
    private final Rect mClipBounds = new Rect();
    private DrawFilter mFilter;
    private static boolean sIsAvailable = GLES20Canvas.nIsAvailable();
    public static final int FLUSH_CACHES_LAYERS = 0;
    public static final int FLUSH_CACHES_MODERATE = 1;
    public static final int FLUSH_CACHES_FULL = 2;

    private static native boolean nIsAvailable();

    static boolean isAvailable() {
        return sIsAvailable;
    }

    GLES20Canvas(boolean translucent) {
        this(false, translucent);
    }

    GLES20Canvas(int layer, boolean translucent) {
        this.mOpaque = !translucent;
        this.mRenderer = GLES20Canvas.nCreateLayerRenderer(layer);
        this.setupFinalizer();
    }

    protected GLES20Canvas(boolean record, boolean translucent) {
        this.mOpaque = !translucent;
        this.mRenderer = record ? GLES20Canvas.nCreateDisplayListRenderer() : GLES20Canvas.nCreateRenderer();
        this.setupFinalizer();
    }

    private void setupFinalizer() {
        if (this.mRenderer == 0) {
            throw new IllegalStateException("Could not create GLES20Canvas renderer");
        }
        this.mFinalizer = new CanvasFinalizer(this.mRenderer);
    }

    protected void resetDisplayListRenderer() {
        GLES20Canvas.nResetDisplayListRenderer(this.mRenderer);
    }

    private static native int nCreateRenderer();

    private static native int nCreateLayerRenderer(int var0);

    private static native int nCreateDisplayListRenderer();

    private static native void nResetDisplayListRenderer(int var0);

    private static native void nDestroyRenderer(int var0);

    static native int nCreateTextureLayer(boolean var0, int[] var1);

    static native int nCreateLayer(int var0, int var1, boolean var2, int[] var3);

    static native void nResizeLayer(int var0, int var1, int var2, int[] var3);

    static native void nUpdateTextureLayer(int var0, int var1, int var2, boolean var3, SurfaceTexture var4);

    static native void nSetTextureLayerTransform(int var0, int var1);

    static native void nDestroyLayer(int var0);

    static native void nDestroyLayerDeferred(int var0);

    static native boolean nCopyLayer(int var0, int var1);

    public boolean isOpaque() {
        return this.mOpaque;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getMaximumBitmapWidth() {
        return GLES20Canvas.nGetMaximumTextureWidth();
    }

    public int getMaximumBitmapHeight() {
        return GLES20Canvas.nGetMaximumTextureHeight();
    }

    private static native int nGetMaximumTextureWidth();

    private static native int nGetMaximumTextureHeight();

    public void setViewport(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        GLES20Canvas.nSetViewport(this.mRenderer, width, height);
    }

    private static native void nSetViewport(int var0, int var1, int var2);

    public static boolean preserveBackBuffer() {
        return GLES20Canvas.nPreserveBackBuffer();
    }

    private static native boolean nPreserveBackBuffer();

    public static boolean isBackBufferPreserved() {
        return GLES20Canvas.nIsBackBufferPreserved();
    }

    private static native boolean nIsBackBufferPreserved();

    public static void disableVsync() {
        GLES20Canvas.nDisableVsync();
    }

    private static native void nDisableVsync();

    void onPreDraw(Rect dirty) {
        if (dirty != null) {
            GLES20Canvas.nPrepareDirty(this.mRenderer, dirty.left, dirty.top, dirty.right, dirty.bottom, this.mOpaque);
        } else {
            GLES20Canvas.nPrepare(this.mRenderer, this.mOpaque);
        }
    }

    private static native void nPrepare(int var0, boolean var1);

    private static native void nPrepareDirty(int var0, int var1, int var2, int var3, int var4, boolean var5);

    void onPostDraw() {
        GLES20Canvas.nFinish(this.mRenderer);
    }

    private static native void nFinish(int var0);

    public boolean callDrawGLFunction(int drawGLFunction) {
        return GLES20Canvas.nCallDrawGLFunction(this.mRenderer, drawGLFunction);
    }

    private static native boolean nCallDrawGLFunction(int var0, int var1);

    public static void flushCaches(int level) {
        GLES20Canvas.nFlushCaches(level);
    }

    private static native void nFlushCaches(int var0);

    public static void terminateCaches() {
        GLES20Canvas.nTerminateCaches();
    }

    private static native void nTerminateCaches();

    public static void initCaches() {
        GLES20Canvas.nInitCaches();
    }

    private static native void nInitCaches();

    int getDisplayList(int displayList) {
        return GLES20Canvas.nGetDisplayList(this.mRenderer, displayList);
    }

    private static native int nGetDisplayList(int var0, int var1);

    static void destroyDisplayList(int displayList) {
        GLES20Canvas.nDestroyDisplayList(displayList);
    }

    private static native void nDestroyDisplayList(int var0);

    static int getDisplayListSize(int displayList) {
        return GLES20Canvas.nGetDisplayListSize(displayList);
    }

    private static native int nGetDisplayListSize(int var0);

    public boolean drawDisplayList(DisplayList displayList, int width, int height, Rect dirty) {
        return GLES20Canvas.nDrawDisplayList(this.mRenderer, ((GLES20DisplayList)displayList).getNativeDisplayList(), width, height, dirty);
    }

    private static native boolean nDrawDisplayList(int var0, int var1, int var2, int var3, Rect var4);

    void outputDisplayList(DisplayList displayList) {
        GLES20Canvas.nOutputDisplayList(this.mRenderer, ((GLES20DisplayList)displayList).getNativeDisplayList());
    }

    private static native void nOutputDisplayList(int var0, int var1);

    void drawHardwareLayer(HardwareLayer layer, float x, float y, Paint paint) {
        GLES20Layer glLayer = (GLES20Layer)layer;
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawLayer(this.mRenderer, glLayer.getLayer(), x, y, nativePaint);
        if (modifier != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
        }
    }

    private static native void nDrawLayer(int var0, int var1, float var2, float var3, int var4);

    void interrupt() {
        GLES20Canvas.nInterrupt(this.mRenderer);
    }

    void resume() {
        GLES20Canvas.nResume(this.mRenderer);
    }

    private static native void nInterrupt(int var0);

    private static native void nResume(int var0);

    public boolean clipPath(Path path) {
        throw new UnsupportedOperationException();
    }

    public boolean clipPath(Path path, Region.Op op) {
        throw new UnsupportedOperationException();
    }

    public boolean clipRect(float left, float top, float right, float bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static native boolean nClipRect(int var0, float var1, float var2, float var3, float var4, int var5);

    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, op.nativeInt);
    }

    public boolean clipRect(int left, int top, int right, int bottom) {
        return GLES20Canvas.nClipRect(this.mRenderer, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private static native boolean nClipRect(int var0, int var1, int var2, int var3, int var4, int var5);

    public boolean clipRect(Rect rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(RectF rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(RectF rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRegion(Region region) {
        throw new UnsupportedOperationException();
    }

    public boolean clipRegion(Region region, Region.Op op) {
        throw new UnsupportedOperationException();
    }

    public boolean getClipBounds(Rect bounds) {
        return GLES20Canvas.nGetClipBounds(this.mRenderer, bounds);
    }

    private static native boolean nGetClipBounds(int var0, Rect var1);

    public boolean quickReject(float left, float top, float right, float bottom, Canvas.EdgeType type) {
        return GLES20Canvas.nQuickReject(this.mRenderer, left, top, right, bottom, type.nativeInt);
    }

    private static native boolean nQuickReject(int var0, float var1, float var2, float var3, float var4, int var5);

    public boolean quickReject(Path path, Canvas.EdgeType type) {
        throw new UnsupportedOperationException();
    }

    public boolean quickReject(RectF rect, Canvas.EdgeType type) {
        return this.quickReject(rect.left, rect.top, rect.right, rect.bottom, type);
    }

    public void translate(float dx, float dy) {
        if (dx != 0.0f || dy != 0.0f) {
            GLES20Canvas.nTranslate(this.mRenderer, dx, dy);
        }
    }

    private static native void nTranslate(int var0, float var1, float var2);

    public void skew(float sx, float sy) {
        GLES20Canvas.nSkew(this.mRenderer, sx, sy);
    }

    private static native void nSkew(int var0, float var1, float var2);

    public void rotate(float degrees) {
        GLES20Canvas.nRotate(this.mRenderer, degrees);
    }

    private static native void nRotate(int var0, float var1);

    public void scale(float sx, float sy) {
        GLES20Canvas.nScale(this.mRenderer, sx, sy);
    }

    private static native void nScale(int var0, float var1, float var2);

    public void setMatrix(Matrix matrix) {
        GLES20Canvas.nSetMatrix(this.mRenderer, matrix.native_instance);
    }

    private static native void nSetMatrix(int var0, int var1);

    public void getMatrix(Matrix matrix) {
        GLES20Canvas.nGetMatrix(this.mRenderer, matrix.native_instance);
    }

    private static native void nGetMatrix(int var0, int var1);

    public void concat(Matrix matrix) {
        GLES20Canvas.nConcatMatrix(this.mRenderer, matrix.native_instance);
    }

    private static native void nConcatMatrix(int var0, int var1);

    public int save() {
        return GLES20Canvas.nSave(this.mRenderer, 3);
    }

    public int save(int saveFlags) {
        return GLES20Canvas.nSave(this.mRenderer, saveFlags);
    }

    private static native int nSave(int var0, int var1);

    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        if (bounds != null) {
            return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, saveFlags);
        }
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        int count = GLES20Canvas.nSaveLayer(this.mRenderer, nativePaint, saveFlags);
        if (modifier != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
        }
        return count;
    }

    private static native int nSaveLayer(int var0, int var1, int var2);

    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        if (left < right && top < bottom) {
            int modifier = paint != null ? this.setupColorFilter(paint) : 0;
            int nativePaint = paint == null ? 0 : paint.mNativePaint;
            int count = GLES20Canvas.nSaveLayer(this.mRenderer, left, top, right, bottom, nativePaint, saveFlags);
            if (modifier != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
            }
            return count;
        }
        return this.save(saveFlags);
    }

    private static native int nSaveLayer(int var0, float var1, float var2, float var3, float var4, int var5, int var6);

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        if (bounds != null) {
            return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, saveFlags);
        }
        return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, alpha, saveFlags);
    }

    private static native int nSaveLayerAlpha(int var0, int var1, int var2);

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        if (left < right && top < bottom) {
            return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, left, top, right, bottom, alpha, saveFlags);
        }
        return this.save(saveFlags);
    }

    private static native int nSaveLayerAlpha(int var0, float var1, float var2, float var3, float var4, int var5, int var6);

    public void restore() {
        GLES20Canvas.nRestore(this.mRenderer);
    }

    private static native void nRestore(int var0);

    public void restoreToCount(int saveCount) {
        GLES20Canvas.nRestoreToCount(this.mRenderer, saveCount);
    }

    private static native void nRestoreToCount(int var0, int var1);

    public int getSaveCount() {
        return GLES20Canvas.nGetSaveCount(this.mRenderer);
    }

    private static native int nGetSaveCount(int var0);

    public void setDrawFilter(DrawFilter filter) {
        this.mFilter = filter;
    }

    public DrawFilter getDrawFilter() {
        return this.mFilter;
    }

    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        GLES20Canvas.nDrawArc(this.mRenderer, oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, useCenter, paint.mNativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawArc(int var0, float var1, float var2, float var3, float var4, float var5, float var6, boolean var7, int var8);

    public void drawARGB(int a, int r, int g, int b) {
        this.drawColor((a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    public void drawPatch(Bitmap bitmap, byte[] chunks, RectF dst, Paint paint) {
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, chunks, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        if (modifier != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
        }
    }

    private static native void nDrawPatch(int var0, int var1, byte[] var2, byte[] var3, float var4, float var5, float var6, float var7, int var8);

    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, nativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawBitmap(int var0, int var1, byte[] var2, float var3, float var4, int var5);

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, matrix.native_instance, nativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawBitmap(int var0, int var1, byte[] var2, int var3, int var4);

    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        int bottom;
        int right;
        int left;
        int top;
        int nativePaint;
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        int n = nativePaint = paint == null ? 0 : paint.mNativePaint;
        if (src == null) {
            top = 0;
            left = 0;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        float bottom;
        float right;
        float left;
        float top;
        int nativePaint;
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        int n = nativePaint = paint == null ? 0 : paint.mNativePaint;
        if (src == null) {
            top = 0.0f;
            left = 0.0f;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawBitmap(int var0, int var1, byte[] var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, int var11);

    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        int modifier = paint != null ? this.setupColorFilter(paint) : 0;
        Bitmap.Config config = hasAlpha ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap b = Bitmap.createBitmap(colors, offset, stride, width, height, config);
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, b.mNativeBitmap, b.mBuffer, x, y, nativePaint);
        b.recycle();
        if (modifier != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifier);
        }
    }

    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if (meshWidth < 0 || meshHeight < 0 || vertOffset < 0 || colorOffset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        GLES20Canvas.checkRange(verts.length, vertOffset, count * 2);
        colors = null;
        colorOffset = 0;
        int modifiers = paint != null ? this.setupModifiers(bitmap, paint) : 0;
        int nativePaint = paint == null ? 0 : paint.mNativePaint;
        GLES20Canvas.nDrawBitmapMesh(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, nativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawBitmapMesh(int var0, int var1, byte[] var2, int var3, int var4, float[] var5, int var6, int[] var7, int var8, int var9);

    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        GLES20Canvas.nDrawCircle(this.mRenderer, cx, cy, radius, paint.mNativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawCircle(int var0, float var1, float var2, float var3, int var4);

    public void drawColor(int color2) {
        this.drawColor(color2, PorterDuff.Mode.SRC_OVER);
    }

    public void drawColor(int color2, PorterDuff.Mode mode) {
        GLES20Canvas.nDrawColor(this.mRenderer, color2, mode.nativeInt);
    }

    private static native void nDrawColor(int var0, int var1, int var2);

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        this.mLine[0] = startX;
        this.mLine[1] = startY;
        this.mLine[2] = stopX;
        this.mLine[3] = stopY;
        this.drawLines(this.mLine, 0, 4, paint);
    }

    public void drawLines(float[] pts, int offset, int count, Paint paint) {
        if ((offset | count) < 0 || offset + count > pts.length) {
            throw new IllegalArgumentException("The lines array must contain 4 elements per line.");
        }
        int modifiers = this.setupModifiers(paint);
        GLES20Canvas.nDrawLines(this.mRenderer, pts, offset, count, paint.mNativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawLines(int var0, float[] var1, int var2, int var3, int var4);

    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    public void drawOval(RectF oval, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        GLES20Canvas.nDrawOval(this.mRenderer, oval.left, oval.top, oval.right, oval.bottom, paint.mNativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawOval(int var0, float var1, float var2, float var3, float var4, int var5);

    public void drawPaint(Paint paint) {
        Rect r = this.mClipBounds;
        GLES20Canvas.nGetClipBounds(this.mRenderer, r);
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawPath(Path path, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        if (path.isSimplePath) {
            if (path.rects != null) {
                GLES20Canvas.nDrawRects(this.mRenderer, path.rects.mNativeRegion, paint.mNativePaint);
            }
        } else {
            GLES20Canvas.nDrawPath(this.mRenderer, path.mNativePath, paint.mNativePaint);
        }
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawPath(int var0, int var1, int var2);

    private static native void nDrawRects(int var0, int var1, int var2);

    public void drawPicture(Picture picture) {
        throw new UnsupportedOperationException();
    }

    public void drawPicture(Picture picture, Rect dst) {
        throw new UnsupportedOperationException();
    }

    public void drawPicture(Picture picture, RectF dst) {
        throw new UnsupportedOperationException();
    }

    public void drawPoint(float x, float y, Paint paint) {
        this.mPoint[0] = x;
        this.mPoint[1] = y;
        this.drawPoints(this.mPoint, 0, 2, paint);
    }

    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    public void drawPoints(float[] pts, int offset, int count, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        GLES20Canvas.nDrawPoints(this.mRenderer, pts, offset, count, paint.mNativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawPoints(int var0, float[] var1, int var2, int var3, int var4);

    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
    }

    public void drawPosText(String text, float[] pos, Paint paint) {
    }

    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        GLES20Canvas.nDrawRect(this.mRenderer, left, top, right, bottom, paint.mNativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawRect(int var0, float var1, float var2, float var3, float var4, int var5);

    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRect(RectF r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRGB(int r, int g, int b) {
        this.drawColor(0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        GLES20Canvas.nDrawRoundRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint.mNativePaint);
        if (modifiers != 0) {
            GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
        }
    }

    private static native void nDrawRoundRect(int var0, float var1, float var2, float var3, float var4, float var5, float var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, index, count, x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawText(int var0, char[] var1, int var2, int var3, float var4, float var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        try {
            if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
                GLES20Canvas.nDrawText(this.mRenderer, ((Object)text).toString(), start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
            } else if (text instanceof GraphicsOperations) {
                ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
            } else {
                char[] buf = TemporaryBuffer.obtain(end - start);
                TextUtils.getChars(text, start, end, buf, 0);
                GLES20Canvas.nDrawText(this.mRenderer, buf, 0, end - start, x, y, paint.mBidiFlags, paint.mNativePaint);
                TemporaryBuffer.recycle(buf);
            }
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawText(int var0, String var1, int var2, int var3, float var4, float var5, int var6, int var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String text, float x, float y, Paint paint) {
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawText(this.mRenderer, text, 0, text.length(), x, y, paint.mBidiFlags, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
    }

    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, int dir, Paint paint) {
        if ((index | count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (dir != 0 && dir != 1) {
            throw new IllegalArgumentException("Unknown direction: " + dir);
        }
        int modifiers = this.setupModifiers(paint);
        try {
            GLES20Canvas.nDrawTextRun(this.mRenderer, text, index, count, contextIndex, contextCount, x, y, dir, paint.mNativePaint);
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawTextRun(int var0, char[] var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, int dir, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int modifiers = this.setupModifiers(paint);
        try {
            int flags;
            int n = flags = dir == 0 ? 0 : 1;
            if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
                GLES20Canvas.nDrawTextRun(this.mRenderer, ((Object)text).toString(), start, end, contextStart, contextEnd, x, y, flags, paint.mNativePaint);
            } else if (text instanceof GraphicsOperations) {
                ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, flags, paint);
            } else {
                int contextLen = contextEnd - contextStart;
                int len = end - start;
                char[] buf = TemporaryBuffer.obtain(contextLen);
                TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
                GLES20Canvas.nDrawTextRun(this.mRenderer, buf, start - contextStart, len, 0, contextLen, x, y, flags, paint.mNativePaint);
                TemporaryBuffer.recycle(buf);
            }
        }
        finally {
            if (modifiers != 0) {
                GLES20Canvas.nResetModifiers(this.mRenderer, modifiers);
            }
        }
    }

    private static native void nDrawTextRun(int var0, String var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9);

    public void drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
    }

    private int setupModifiers(Bitmap b, Paint paint) {
        if (b.getConfig() == Bitmap.Config.ALPHA_8) {
            return this.setupModifiers(paint);
        }
        ColorFilter filter = paint.getColorFilter();
        if (filter != null) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            return 4;
        }
        return 0;
    }

    private int setupModifiers(Paint paint) {
        ColorFilter filter;
        Shader shader;
        int modifiers = 0;
        if (paint.hasShadow) {
            GLES20Canvas.nSetupShadow(this.mRenderer, paint.shadowRadius, paint.shadowDx, paint.shadowDy, paint.shadowColor);
            modifiers |= 1;
        }
        if ((shader = paint.getShader()) != null) {
            GLES20Canvas.nSetupShader(this.mRenderer, shader.native_shader);
            modifiers |= 2;
        }
        if ((filter = paint.getColorFilter()) != null) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            modifiers |= 4;
        }
        return modifiers;
    }

    private int setupColorFilter(Paint paint) {
        ColorFilter filter = paint.getColorFilter();
        if (filter != null) {
            GLES20Canvas.nSetupColorFilter(this.mRenderer, filter.nativeColorFilter);
            return 4;
        }
        return 0;
    }

    private static native void nSetupShader(int var0, int var1);

    private static native void nSetupColorFilter(int var0, int var1);

    private static native void nSetupShadow(int var0, float var1, float var2, float var3, int var4);

    private static native void nResetModifiers(int var0, int var1);

    private static final class CanvasFinalizer {
        private final int mRenderer;

        public CanvasFinalizer(int renderer) {
            this.mRenderer = renderer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                GLES20Canvas.nDestroyRenderer(this.mRenderer);
            }
            finally {
                super.finalize();
            }
        }
    }
}

