/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.SurfaceTexture;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.SurfaceSession;

public class Surface
implements Parcelable {
    private static final String LOG_TAG = "Surface";
    private static final boolean DEBUG_RELEASE = false;
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    public static final int HIDDEN = 4;
    public static final int SECURE = 128;
    public static final int NON_PREMULTIPLIED = 256;
    public static final int OPAQUE = 1024;
    public static final int PROTECTED_APP = 2048;
    public static final int FX_SURFACE_NORMAL = 0;
    @Deprecated
    public static final int FX_SURFACE_BLUR = 65536;
    public static final int FX_SURFACE_DIM = 131072;
    public static final int FX_SURFACE_SCREENSHOT = 196608;
    public static final int FX_SURFACE_MASK = 983040;
    public static final int SURFACE_HIDDEN = 1;
    public static final int SURFACE_FROZEN = 2;
    public static final int SURFACE_DITHER = 4;
    private int mSurfaceControl;
    private int mSaveCount;
    private Canvas mCanvas;
    private int mNativeSurface;
    private int mSurfaceGenerationId;
    private String mName;
    private CompatibilityInfo.Translator mCompatibilityTranslator;
    private Matrix mCompatibleMatrix;
    private Exception mCreationStack;
    public static final Parcelable.Creator<Surface> CREATOR;

    public Surface(SurfaceTexture surfaceTexture) {
        this.mCanvas = new CompatibleCanvas();
        this.initFromSurfaceTexture(surfaceTexture);
    }

    public native boolean isValid();

    public native void release();

    public Canvas lockCanvas(Rect dirty) throws OutOfResourcesException, IllegalArgumentException {
        return this.lockCanvasNative(dirty);
    }

    public native void unlockCanvasAndPost(Canvas var1);

    public native void unlockCanvas(Canvas var1);

    public String toString() {
        return "Surface(name=" + this.mName + ", identity=" + this.getIdentity() + ")";
    }

    public int describeContents() {
        return 0;
    }

    public native void readFromParcel(Parcel var1);

    public native void writeToParcel(Parcel var1, int var2);

    private static native void nativeClassInit();

    public Surface(SurfaceSession s, int pid, int display, int w, int h, int format, int flags) throws OutOfResourcesException {
        this.mCanvas = new CompatibleCanvas();
        this.init(s, pid, null, display, w, h, format, flags);
    }

    public Surface(SurfaceSession s, int pid, String name, int display, int w, int h, int format, int flags) throws OutOfResourcesException {
        this.mCanvas = new CompatibleCanvas();
        this.init(s, pid, name, display, w, h, format, flags);
        this.mName = name;
    }

    public Surface() {
        this.mCanvas = new CompatibleCanvas();
    }

    private Surface(Parcel source) throws OutOfResourcesException {
        this.init(source);
    }

    public native void copyFrom(Surface var1);

    public native void transferFrom(Surface var1);

    public int getGenerationId() {
        return this.mSurfaceGenerationId;
    }

    void setCompatibilityTranslator(CompatibilityInfo.Translator translator) {
        if (translator != null) {
            float appScale = translator.applicationScale;
            this.mCompatibleMatrix = new Matrix();
            this.mCompatibleMatrix.setScale(appScale, appScale);
        }
    }

    public native void destroy();

    private native Canvas lockCanvasNative(Rect var1);

    public static native void freezeDisplay(int var0);

    public static native void unfreezeDisplay(int var0);

    public static native void setOrientation(int var0, int var1, int var2);

    public static void setOrientation(int display, int orientation) {
        Surface.setOrientation(display, orientation, 0);
    }

    public static native Bitmap screenshot(int var0, int var1);

    public static native Bitmap screenshot(int var0, int var1, int var2, int var3);

    public static native void openTransaction();

    public static native void closeTransaction();

    public native void setLayer(int var1);

    public void setPosition(int x, int y) {
        this.setPosition((float)x, (float)y);
    }

    public native void setPosition(float var1, float var2);

    public native void setSize(int var1, int var2);

    public native void hide();

    public native void show();

    public native void setTransparentRegionHint(Region var1);

    public native void setAlpha(float var1);

    public native void setMatrix(float var1, float var2, float var3, float var4);

    public native void freeze();

    public native void unfreeze();

    public native void setFreezeTint(int var1);

    public native void setFlags(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (this.mNativeSurface != 0 || this.mSurfaceControl != 0) {
                Log.w(LOG_TAG, "Surface.finalize() has work. You should have called release() (" + this.mNativeSurface + ", " + this.mSurfaceControl + ")");
            }
            this.release();
        }
    }

    private native void init(SurfaceSession var1, int var2, String var3, int var4, int var5, int var6, int var7, int var8) throws OutOfResourcesException;

    private native void init(Parcel var1);

    private native void initFromSurfaceTexture(SurfaceTexture var1);

    private native int getIdentity();

    static {
        Surface.nativeClassInit();
        CREATOR = new Parcelable.Creator<Surface>(){

            @Override
            public Surface createFromParcel(Parcel source) {
                try {
                    return new Surface(source);
                }
                catch (Exception e) {
                    Log.e(Surface.LOG_TAG, "Exception creating surface from parcel", e);
                    return null;
                }
            }

            public Surface[] newArray(int size) {
                return new Surface[size];
            }
        };
    }

    private class CompatibleCanvas
    extends Canvas {
        private Matrix mOrigMatrix = null;

        private CompatibleCanvas() {
        }

        public int getWidth() {
            int w = super.getWidth();
            if (Surface.this.mCompatibilityTranslator != null) {
                w = (int)((float)w * ((Surface)Surface.this).mCompatibilityTranslator.applicationInvertedScale + 0.5f);
            }
            return w;
        }

        public int getHeight() {
            int h = super.getHeight();
            if (Surface.this.mCompatibilityTranslator != null) {
                h = (int)((float)h * ((Surface)Surface.this).mCompatibilityTranslator.applicationInvertedScale + 0.5f);
            }
            return h;
        }

        public void setMatrix(Matrix matrix) {
            if (Surface.this.mCompatibleMatrix == null || this.mOrigMatrix == null || this.mOrigMatrix.equals(matrix)) {
                super.setMatrix(matrix);
            } else {
                Matrix m = new Matrix(Surface.this.mCompatibleMatrix);
                m.preConcat(matrix);
                super.setMatrix(m);
            }
        }

        public void getMatrix(Matrix m) {
            super.getMatrix(m);
            if (this.mOrigMatrix == null) {
                this.mOrigMatrix = new Matrix();
            }
            this.mOrigMatrix.set(m);
        }
    }

    public static class OutOfResourcesException
    extends Exception {
        public OutOfResourcesException() {
        }

        public OutOfResourcesException(String name) {
            super(name);
        }
    }
}

