/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.LayoutTransition;
import android.app.ActivityManagerNative;
import android.content.ClipDescription;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.media.AudioManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.LatencyTimer;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.AndroidRuntimeException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.CompatibilityInfoHolder;
import android.view.ContextMenu;
import android.view.Display;
import android.view.DisplayList;
import android.view.DragEvent;
import android.view.FallbackEventHandler;
import android.view.FocusFinder;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.HardwareRenderer;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventConsistencyVerifier;
import android.view.InputHandler;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.Scroller;
import com.android.internal.policy.PolicyManager;
import com.android.internal.view.BaseSurfaceHolder;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.RootViewSurfaceTaker;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public final class ViewRootImpl
extends Handler
implements ViewParent,
View.AttachInfo.Callbacks,
HardwareRenderer.HardwareDrawCallbacks {
    private static final String TAG = "ViewRootImpl";
    private static final boolean DBG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final boolean DEBUG_DRAW = false;
    private static final boolean DEBUG_LAYOUT = false;
    private static final boolean DEBUG_DIALOG = false;
    private static final boolean DEBUG_INPUT_RESIZE = false;
    private static final boolean DEBUG_ORIENTATION = false;
    private static final boolean DEBUG_TRACKBALL = false;
    private static final boolean DEBUG_IMF = false;
    private static final boolean DEBUG_CONFIGURATION = false;
    private static final boolean DEBUG_FPS = false;
    private static final boolean WATCH_POINTER = false;
    private static final String PROPERTY_PROFILE_RENDERING = "viewancestor.profile_rendering";
    private static final boolean MEASURE_LATENCY = false;
    private static LatencyTimer lt;
    static final int MAX_TRACKBALL_DELAY = 250;
    static IWindowSession sWindowSession;
    static final Object mStaticInit;
    static boolean mInitialized;
    static final ThreadLocal<RunQueue> sRunQueues;
    static final ArrayList<Runnable> sFirstDrawHandlers;
    static boolean sFirstDrawComplete;
    static final ArrayList<ComponentCallbacks> sConfigCallbacks;
    long mLastTrackballTime = 0L;
    final TrackballAxis mTrackballAxisX = new TrackballAxis();
    final TrackballAxis mTrackballAxisY = new TrackballAxis();
    int mLastJoystickXDirection;
    int mLastJoystickYDirection;
    int mLastJoystickXKeyCode;
    int mLastJoystickYKeyCode;
    final int[] mTmpLocation = new int[2];
    final TypedValue mTmpValue = new TypedValue();
    final InputMethodCallback mInputMethodCallback;
    final SparseArray<Object> mPendingEvents = new SparseArray();
    int mPendingEventSeq = 0;
    final Thread mThread;
    final WindowLeaked mLocation;
    final WindowManager.LayoutParams mWindowAttributes = new WindowManager.LayoutParams();
    final W mWindow;
    final int mTargetSdkVersion;
    int mSeq;
    View mView;
    View mFocusedView;
    View mRealFocusedView;
    int mViewVisibility;
    boolean mAppVisible = true;
    int mOrigWindowType = -1;
    boolean mStopped = false;
    boolean mLastInCompatMode = false;
    SurfaceHolder.Callback2 mSurfaceHolderCallback;
    BaseSurfaceHolder mSurfaceHolder;
    boolean mIsCreating;
    boolean mDrawingAllowed;
    final Region mTransparentRegion;
    final Region mPreviousTransparentRegion;
    int mWidth;
    int mHeight;
    Rect mDirty;
    final Rect mCurrentDirty = new Rect();
    final Rect mPreviousDirty = new Rect();
    boolean mIsAnimating;
    CompatibilityInfo.Translator mTranslator;
    final View.AttachInfo mAttachInfo;
    InputChannel mInputChannel;
    InputQueue.Callback mInputQueueCallback;
    InputQueue mInputQueue;
    FallbackEventHandler mFallbackEventHandler;
    final Rect mTempRect;
    final Rect mVisRect;
    boolean mTraversalScheduled;
    long mLastTraversalFinishedTimeNanos;
    long mLastDrawDurationNanos;
    boolean mWillDrawSoon;
    boolean mLayoutRequested;
    boolean mFirst;
    boolean mReportNextDraw;
    boolean mFullRedrawNeeded;
    boolean mNewSurfaceNeeded;
    boolean mHasHadWindowFocus;
    boolean mLastWasImTarget;
    InputEventMessage mPendingInputEvents = null;
    boolean mWindowAttributesChanged = false;
    int mWindowAttributesChangesFlag = 0;
    private final Surface mSurface = new Surface();
    boolean mAdded;
    boolean mAddedTouchMode;
    CompatibilityInfoHolder mCompatibilityInfo;
    int mAddNesting;
    final Rect mWinFrame;
    final Rect mPendingVisibleInsets = new Rect();
    final Rect mPendingContentInsets = new Rect();
    final ViewTreeObserver.InternalInsetsInfo mLastGivenInsets = new ViewTreeObserver.InternalInsetsInfo();
    final Configuration mLastConfiguration = new Configuration();
    final Configuration mPendingConfiguration = new Configuration();
    boolean mScrollMayChange;
    int mSoftInputMode;
    View mLastScrolledFocus;
    int mScrollY;
    int mCurScrollY;
    Scroller mScroller;
    HardwareLayer mResizeBuffer;
    long mResizeBufferStartTime;
    int mResizeBufferDuration;
    static final Interpolator mResizeInterpolator;
    private ArrayList<LayoutTransition> mPendingTransitions;
    final ViewConfiguration mViewConfiguration;
    ClipDescription mDragDescription;
    View mCurrentDragView;
    volatile Object mLocalDragState;
    final PointF mDragPoint = new PointF();
    final PointF mLastTouchPoint = new PointF();
    private boolean mProfileRendering;
    private Thread mRenderProfiler;
    private volatile boolean mRenderProfilingEnabled;
    private long mFpsStartTime = -1L;
    private long mFpsPrevTime = -1L;
    private int mFpsNumFrames;
    AudioManager mAudioManager;
    final AccessibilityManager mAccessibilityManager;
    AccessibilityInteractionController mAccessibilityInteractionController;
    AccessibilityInteractionConnectionManager mAccessibilityInteractionConnectionManager;
    SendWindowContentChangedAccessibilityEvent mSendWindowContentChangedAccessibilityEvent;
    private final int mDensity;
    protected final InputEventConsistencyVerifier mInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;
    private boolean mProfile = false;
    int mHardwareYOffset;
    int mResizeAlpha;
    final Paint mResizePaint = new Paint();
    public static final int DO_TRAVERSAL = 1000;
    public static final int DIE = 1001;
    public static final int RESIZED = 1002;
    public static final int RESIZED_REPORT = 1003;
    public static final int WINDOW_FOCUS_CHANGED = 1004;
    public static final int DISPATCH_KEY = 1005;
    public static final int DISPATCH_POINTER = 1006;
    public static final int DISPATCH_TRACKBALL = 1007;
    public static final int DISPATCH_APP_VISIBILITY = 1008;
    public static final int DISPATCH_GET_NEW_SURFACE = 1009;
    public static final int FINISHED_EVENT = 1010;
    public static final int DISPATCH_KEY_FROM_IME = 1011;
    public static final int FINISH_INPUT_CONNECTION = 1012;
    public static final int CHECK_FOCUS = 1013;
    public static final int CLOSE_SYSTEM_DIALOGS = 1014;
    public static final int DISPATCH_DRAG_EVENT = 1015;
    public static final int DISPATCH_DRAG_LOCATION_EVENT = 1016;
    public static final int DISPATCH_SYSTEM_UI_VISIBILITY = 1017;
    public static final int DISPATCH_GENERIC_MOTION = 1018;
    public static final int UPDATE_CONFIGURATION = 1019;
    public static final int DO_PERFORM_ACCESSIBILITY_ACTION = 1020;
    public static final int DO_FIND_ACCESSIBLITY_NODE_INFO_BY_ACCESSIBILITY_ID = 1021;
    public static final int DO_FIND_ACCESSIBLITY_NODE_INFO_BY_VIEW_ID = 1022;
    public static final int DO_FIND_ACCESSIBLITY_NODE_INFO_BY_VIEW_TEXT = 1023;
    public static final int PROCESS_INPUT_EVENTS = 1024;
    private long mInputEventReceiveTimeNanos;
    private long mInputEventDeliverTimeNanos;
    private long mInputEventDeliverPostImeTimeNanos;
    private InputQueue.FinishedCallback mFinishedCallback;
    private final InputHandler mInputHandler = new InputHandler(){

        public void handleKey(KeyEvent event, InputQueue.FinishedCallback finishedCallback) {
            ViewRootImpl.this.startInputEvent(finishedCallback);
            ViewRootImpl.this.dispatchKey(event, true);
        }

        public void handleMotion(MotionEvent event, InputQueue.FinishedCallback finishedCallback) {
            ViewRootImpl.this.startInputEvent(finishedCallback);
            ViewRootImpl.this.dispatchMotion(event, true);
        }
    };
    private SurfaceHolder mHolder = new SurfaceHolder(){

        public Surface getSurface() {
            return ViewRootImpl.this.mSurface;
        }

        public boolean isCreating() {
            return false;
        }

        public void addCallback(SurfaceHolder.Callback callback) {
        }

        public void removeCallback(SurfaceHolder.Callback callback) {
        }

        public void setFixedSize(int width, int height) {
        }

        public void setSizeFromLayout() {
        }

        public void setFormat(int format) {
        }

        public void setType(int type) {
        }

        public void setKeepScreenOn(boolean screenOn) {
        }

        public Canvas lockCanvas() {
            return null;
        }

        public Canvas lockCanvas(Rect dirty) {
            return null;
        }

        public void unlockCanvasAndPost(Canvas canvas) {
        }

        public Rect getSurfaceFrame() {
            return null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IWindowSession getWindowSession(Looper mainLooper) {
        Object object = mStaticInit;
        synchronized (object) {
            if (!mInitialized) {
                try {
                    InputMethodManager imm = InputMethodManager.getInstance(mainLooper);
                    sWindowSession = Display.getWindowManager().openSession(imm.getClient(), imm.getInputContext());
                    mInitialized = true;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return sWindowSession;
        }
    }

    public ViewRootImpl(Context context) {
        ViewRootImpl.getWindowSession(context.getMainLooper());
        this.mThread = Thread.currentThread();
        this.mLocation = new WindowLeaked(null);
        this.mLocation.fillInStackTrace();
        this.mWidth = -1;
        this.mHeight = -1;
        this.mDirty = new Rect();
        this.mTempRect = new Rect();
        this.mVisRect = new Rect();
        this.mWinFrame = new Rect();
        this.mWindow = new W(this);
        this.mTargetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        this.mInputMethodCallback = new InputMethodCallback(this);
        this.mViewVisibility = 8;
        this.mTransparentRegion = new Region();
        this.mPreviousTransparentRegion = new Region();
        this.mFirst = true;
        this.mAdded = false;
        this.mAccessibilityManager = AccessibilityManager.getInstance(context);
        this.mAccessibilityInteractionConnectionManager = new AccessibilityInteractionConnectionManager();
        this.mAccessibilityManager.addAccessibilityStateChangeListener(this.mAccessibilityInteractionConnectionManager);
        this.mAttachInfo = new View.AttachInfo(sWindowSession, this.mWindow, this, this);
        this.mViewConfiguration = ViewConfiguration.get(context);
        this.mDensity = context.getResources().getDisplayMetrics().densityDpi;
        this.mFallbackEventHandler = PolicyManager.makeNewFallbackEventHandler(context);
        this.mProfileRendering = Boolean.parseBoolean(SystemProperties.get(PROPERTY_PROFILE_RENDERING, "false"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFirstDrawHandler(Runnable callback) {
        ArrayList<Runnable> arrayList = sFirstDrawHandlers;
        synchronized (arrayList) {
            if (!sFirstDrawComplete) {
                sFirstDrawHandlers.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfigCallback(ComponentCallbacks callback) {
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        synchronized (arrayList) {
            sConfigCallbacks.add(callback);
        }
    }

    public void profile() {
        this.mProfile = true;
    }

    static boolean isInTouchMode() {
        if (mInitialized) {
            try {
                return sWindowSession.getInTouchMode();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setView(View view, WindowManager.LayoutParams attrs, View panelParentView) {
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            if (this.mView == null) {
                int res;
                this.mView = view;
                this.mFallbackEventHandler.setView(view);
                this.mWindowAttributes.copyFrom(attrs);
                attrs = this.mWindowAttributes;
                if (view instanceof RootViewSurfaceTaker) {
                    this.mSurfaceHolderCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheSurface();
                    if (this.mSurfaceHolderCallback != null) {
                        this.mSurfaceHolder = new TakenSurfaceHolder();
                        this.mSurfaceHolder.setFormat(0);
                    }
                }
                CompatibilityInfo compatibilityInfo = this.mCompatibilityInfo.get();
                this.mTranslator = compatibilityInfo.getTranslator();
                if (this.mSurfaceHolder == null) {
                    this.enableHardwareAcceleration(attrs);
                }
                boolean restore = false;
                if (this.mTranslator != null) {
                    this.mSurface.setCompatibilityTranslator(this.mTranslator);
                    restore = true;
                    attrs.backup();
                    this.mTranslator.translateWindowLayout(attrs);
                }
                if (!compatibilityInfo.supportsScreen()) {
                    attrs.flags |= 0x20000000;
                    this.mLastInCompatMode = true;
                }
                this.mSoftInputMode = attrs.softInputMode;
                this.mWindowAttributesChanged = true;
                this.mWindowAttributesChangesFlag = -1;
                this.mAttachInfo.mRootView = view;
                this.mAttachInfo.mScalingRequired = this.mTranslator != null;
                float f = this.mAttachInfo.mApplicationScale = this.mTranslator == null ? 1.0f : this.mTranslator.applicationScale;
                if (panelParentView != null) {
                    this.mAttachInfo.mPanelParentWindowToken = panelParentView.getApplicationWindowToken();
                }
                this.mAdded = true;
                this.requestLayout();
                if ((this.mWindowAttributes.inputFeatures & 2) == 0) {
                    this.mInputChannel = new InputChannel();
                }
                try {
                    this.mOrigWindowType = this.mWindowAttributes.type;
                    res = sWindowSession.add(this.mWindow, this.mSeq, this.mWindowAttributes, this.getHostVisibility(), this.mAttachInfo.mContentInsets, this.mInputChannel);
                }
                catch (RemoteException e) {
                    this.mAdded = false;
                    this.mView = null;
                    this.mAttachInfo.mRootView = null;
                    this.mInputChannel = null;
                    this.mFallbackEventHandler.setView(null);
                    this.unscheduleTraversals();
                    throw new RuntimeException("Adding window failed", e);
                }
                finally {
                    if (restore) {
                        attrs.restore();
                    }
                }
                if (this.mTranslator != null) {
                    this.mTranslator.translateRectInScreenToAppWindow(this.mAttachInfo.mContentInsets);
                }
                this.mPendingContentInsets.set(this.mAttachInfo.mContentInsets);
                this.mPendingVisibleInsets.set(0, 0, 0, 0);
                if (res < 0) {
                    this.mView = null;
                    this.mAttachInfo.mRootView = null;
                    this.mAdded = false;
                    this.mFallbackEventHandler.setView(null);
                    this.unscheduleTraversals();
                    switch (res) {
                        case -2: 
                        case -1: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + attrs.token + " is not valid; is your activity running?");
                        }
                        case -3: {
                            throw new WindowManager.BadTokenException("Unable to add window -- token " + attrs.token + " is not for an application");
                        }
                        case -4: {
                            throw new WindowManager.BadTokenException("Unable to add window -- app for token " + attrs.token + " is exiting");
                        }
                        case -5: {
                            throw new WindowManager.BadTokenException("Unable to add window -- window " + this.mWindow + " has already been added");
                        }
                        case -6: {
                            return;
                        }
                        case -7: {
                            throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- another window of this type already exists");
                        }
                        case -8: {
                            throw new WindowManager.BadTokenException("Unable to add window " + this.mWindow + " -- permission denied for this window type");
                        }
                    }
                    throw new RuntimeException("Unable to add window -- unknown error code " + res);
                }
                if (view instanceof RootViewSurfaceTaker) {
                    this.mInputQueueCallback = ((RootViewSurfaceTaker)((Object)view)).willYouTakeTheInputQueue();
                }
                if (this.mInputChannel != null) {
                    if (this.mInputQueueCallback != null) {
                        this.mInputQueue = new InputQueue(this.mInputChannel);
                        this.mInputQueueCallback.onInputQueueCreated(this.mInputQueue);
                    } else {
                        InputQueue.registerInputChannel(this.mInputChannel, this.mInputHandler, Looper.myQueue());
                    }
                }
                view.assignParent(this);
                this.mAddedTouchMode = (res & 1) != 0;
                boolean bl = this.mAppVisible = (res & 2) != 0;
                if (this.mAccessibilityManager.isEnabled()) {
                    this.mAccessibilityInteractionConnectionManager.ensureConnection();
                }
            }
        }
    }

    void destroyHardwareResources() {
        if (this.mAttachInfo.mHardwareRenderer != null) {
            if (this.mAttachInfo.mHardwareRenderer.isEnabled()) {
                this.mAttachInfo.mHardwareRenderer.destroyLayers(this.mView);
            }
            this.mAttachInfo.mHardwareRenderer.destroy(false);
        }
    }

    void terminateHardwareResources() {
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.destroyHardwareResources(this.mView);
            this.mAttachInfo.mHardwareRenderer.destroy(false);
        }
    }

    void destroyHardwareLayers() {
        if (this.mThread != Thread.currentThread()) {
            if (this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled()) {
                HardwareRenderer.trimMemory(60);
            }
        } else if (this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled()) {
            this.mAttachInfo.mHardwareRenderer.destroyLayers(this.mView);
        }
    }

    private void enableHardwareAcceleration(WindowManager.LayoutParams attrs) {
        boolean hardwareAccelerated;
        this.mAttachInfo.mHardwareAccelerated = false;
        this.mAttachInfo.mHardwareAccelerationRequested = false;
        if (this.mTranslator != null) {
            return;
        }
        boolean bl = hardwareAccelerated = (attrs.flags & 0x1000000) != 0;
        if (hardwareAccelerated) {
            boolean forceHwAccelerated;
            if (!HardwareRenderer.isAvailable()) {
                return;
            }
            boolean fakeHwAccelerated = (attrs.privateFlags & 1) != 0;
            boolean bl2 = forceHwAccelerated = (attrs.privateFlags & 2) != 0;
            if (!HardwareRenderer.sRendererDisabled || HardwareRenderer.sSystemRendererDisabled && forceHwAccelerated) {
                boolean translucent;
                if (!HardwareRenderer.sSystemRendererDisabled && Looper.getMainLooper() != Looper.myLooper()) {
                    Log.w("HardwareRenderer", "Attempting to initialize hardware acceleration outside of the main thread, aborting");
                    return;
                }
                boolean bl3 = translucent = attrs.format != -1;
                if (this.mAttachInfo.mHardwareRenderer != null) {
                    this.mAttachInfo.mHardwareRenderer.destroy(true);
                }
                this.mAttachInfo.mHardwareRenderer = HardwareRenderer.createGlRenderer(2, translucent);
                this.mAttachInfo.mHardwareAccelerationRequested = this.mAttachInfo.mHardwareRenderer != null;
                this.mAttachInfo.mHardwareAccelerated = this.mAttachInfo.mHardwareAccelerationRequested;
            } else if (fakeHwAccelerated) {
                this.mAttachInfo.mHardwareAccelerationRequested = true;
            }
        }
    }

    public View getView() {
        return this.mView;
    }

    final WindowLeaked getLocation() {
        return this.mLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLayoutParams(WindowManager.LayoutParams attrs, boolean newView) {
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            int oldSoftInputMode = this.mWindowAttributes.softInputMode;
            int compatibleWindowFlag = this.mWindowAttributes.flags & 0x20000000;
            this.mWindowAttributesChangesFlag = this.mWindowAttributes.copyFrom(attrs);
            this.mWindowAttributes.flags |= compatibleWindowFlag;
            if (newView) {
                this.mSoftInputMode = attrs.softInputMode;
                this.requestLayout();
            }
            if ((attrs.softInputMode & 0xF0) == 0) {
                this.mWindowAttributes.softInputMode = this.mWindowAttributes.softInputMode & 0xFFFFFF0F | oldSoftInputMode & 0xF0;
            }
            this.mWindowAttributesChanged = true;
            this.scheduleTraversals();
        }
    }

    void handleAppVisibility(boolean visible) {
        if (this.mAppVisible != visible) {
            this.mAppVisible = visible;
            this.scheduleTraversals();
        }
    }

    void handleGetNewSurface() {
        this.mNewSurfaceNeeded = true;
        this.mFullRedrawNeeded = true;
        this.scheduleTraversals();
    }

    public void requestLayout() {
        this.checkThread();
        this.mLayoutRequested = true;
        this.scheduleTraversals();
    }

    public boolean isLayoutRequested() {
        return this.mLayoutRequested;
    }

    public void invalidateChild(View child, Rect dirty) {
        this.checkThread();
        if (dirty == null) {
            this.invalidate();
            return;
        }
        if (this.mCurScrollY != 0 || this.mTranslator != null) {
            this.mTempRect.set(dirty);
            dirty = this.mTempRect;
            if (this.mCurScrollY != 0) {
                dirty.offset(0, -this.mCurScrollY);
            }
            if (this.mTranslator != null) {
                this.mTranslator.translateRectInAppWindowToScreen(dirty);
            }
            if (this.mAttachInfo.mScalingRequired) {
                dirty.inset(-1, -1);
            }
        }
        if (!this.mDirty.isEmpty() && !this.mDirty.contains(dirty)) {
            this.mAttachInfo.mSetIgnoreDirtyState = true;
            this.mAttachInfo.mIgnoreDirtyState = true;
        }
        this.mDirty.union(dirty);
        if (!this.mWillDrawSoon) {
            this.scheduleTraversals();
        }
    }

    void invalidate() {
        this.mDirty.set(0, 0, this.mWidth, this.mHeight);
        this.scheduleTraversals();
    }

    void setStopped(boolean stopped) {
        if (this.mStopped != stopped) {
            this.mStopped = stopped;
            if (!stopped) {
                this.scheduleTraversals();
            }
        }
    }

    public ViewParent getParent() {
        return null;
    }

    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        this.invalidateChild(null, dirty);
        return null;
    }

    public boolean getChildVisibleRect(View child, Rect r, Point offset) {
        if (child != this.mView) {
            throw new RuntimeException("child is not mine, honest!");
        }
        return r.intersect(0, 0, this.mWidth, this.mHeight);
    }

    public void bringChildToFront(View child) {
    }

    public void scheduleTraversals() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.sendEmptyMessage(1000);
        }
    }

    public void unscheduleTraversals() {
        if (this.mTraversalScheduled) {
            this.mTraversalScheduled = false;
            this.removeMessages(1000);
        }
    }

    int getHostVisibility() {
        return this.mAppVisible ? this.mView.getVisibility() : 8;
    }

    void disposeResizeBuffer() {
        if (this.mResizeBuffer != null) {
            this.mResizeBuffer.destroy();
            this.mResizeBuffer = null;
        }
    }

    public void requestTransitionStart(LayoutTransition transition) {
        if (this.mPendingTransitions == null || !this.mPendingTransitions.contains(transition)) {
            if (this.mPendingTransitions == null) {
                this.mPendingTransitions = new ArrayList();
            }
            this.mPendingTransitions.add(transition);
        }
    }

    private void processInputEvents(boolean outOfOrder) {
        while (this.mPendingInputEvents != null) {
            this.handleMessage(this.mPendingInputEvents.mMessage);
            InputEventMessage tmpMessage = this.mPendingInputEvents;
            this.mPendingInputEvents = this.mPendingInputEvents.mNext;
            tmpMessage.recycle();
            if (!outOfOrder) continue;
            this.removeMessages(1024);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performTraversals() {
        boolean cancelDraw;
        boolean imTarget;
        boolean triggerGlobalLayoutListener;
        int childHeightMeasureSpec;
        int childWidthMeasureSpec;
        int desiredWindowHeight;
        int desiredWindowWidth;
        CompatibilityInfo compatibilityInfo;
        View host = this.mView;
        this.processInputEvents(true);
        if (host == null || !this.mAdded) {
            return;
        }
        this.mTraversalScheduled = false;
        this.mWillDrawSoon = true;
        boolean windowSizeMayChange = false;
        boolean fullRedrawNeeded = this.mFullRedrawNeeded;
        boolean newSurface = false;
        boolean surfaceChanged = false;
        WindowManager.LayoutParams lp = this.mWindowAttributes;
        View.AttachInfo attachInfo = this.mAttachInfo;
        int viewVisibility = this.getHostVisibility();
        boolean viewVisibilityChanged = this.mViewVisibility != viewVisibility || this.mNewSurfaceNeeded;
        WindowManager.LayoutParams params = null;
        if (this.mWindowAttributesChanged) {
            this.mWindowAttributesChanged = false;
            surfaceChanged = true;
            params = lp;
        }
        if ((compatibilityInfo = this.mCompatibilityInfo.get()).supportsScreen() == this.mLastInCompatMode) {
            params = lp;
            fullRedrawNeeded = true;
            this.mLayoutRequested = true;
            if (this.mLastInCompatMode) {
                params.flags &= 0xDFFFFFFF;
                this.mLastInCompatMode = false;
            } else {
                params.flags |= 0x20000000;
                this.mLastInCompatMode = true;
            }
        }
        this.mWindowAttributesChangesFlag = 0;
        Rect frame = this.mWinFrame;
        if (this.mFirst) {
            fullRedrawNeeded = true;
            this.mLayoutRequested = true;
            if (lp.type == 2014) {
                Display disp = WindowManagerImpl.getDefault().getDefaultDisplay();
                Point size = new Point();
                disp.getRealSize(size);
                desiredWindowWidth = size.x;
                desiredWindowHeight = size.y;
            } else {
                DisplayMetrics packageMetrics = this.mView.getContext().getResources().getDisplayMetrics();
                desiredWindowWidth = packageMetrics.widthPixels;
                desiredWindowHeight = packageMetrics.heightPixels;
            }
            attachInfo.mSurface = this.mSurface;
            attachInfo.mUse32BitDrawingCache = true;
            attachInfo.mHasWindowFocus = false;
            attachInfo.mWindowVisibility = viewVisibility;
            attachInfo.mRecomputeGlobalAttributes = false;
            attachInfo.mKeepScreenOn = false;
            attachInfo.mSystemUiVisibility = 0;
            viewVisibilityChanged = false;
            this.mLastConfiguration.setTo(host.getResources().getConfiguration());
            host.dispatchAttachedToWindow(attachInfo, 0);
            host.fitSystemWindows(this.mAttachInfo.mContentInsets);
        } else {
            desiredWindowWidth = frame.width();
            desiredWindowHeight = frame.height();
            if (desiredWindowWidth != this.mWidth || desiredWindowHeight != this.mHeight) {
                fullRedrawNeeded = true;
                this.mLayoutRequested = true;
                windowSizeMayChange = true;
            }
        }
        if (viewVisibilityChanged) {
            attachInfo.mWindowVisibility = viewVisibility;
            host.dispatchWindowVisibilityChanged(viewVisibility);
            if (viewVisibility != 0 || this.mNewSurfaceNeeded) {
                this.destroyHardwareResources();
            }
            if (viewVisibility == 8) {
                this.mHasHadWindowFocus = false;
            }
        }
        boolean insetsChanged = false;
        if (this.mLayoutRequested && !this.mStopped) {
            ViewRootImpl.getRunQueue().executeActions(attachInfo.mHandler);
            Resources res = this.mView.getContext().getResources();
            if (this.mFirst) {
                this.mAttachInfo.mInTouchMode = !this.mAddedTouchMode;
                this.ensureTouchModeLocally(this.mAddedTouchMode);
            } else {
                if (!this.mPendingContentInsets.equals(this.mAttachInfo.mContentInsets)) {
                    insetsChanged = true;
                }
                if (!this.mPendingVisibleInsets.equals(this.mAttachInfo.mVisibleInsets)) {
                    this.mAttachInfo.mVisibleInsets.set(this.mPendingVisibleInsets);
                }
                if (lp.width == -2 || lp.height == -2) {
                    windowSizeMayChange = true;
                    if (lp.type == 2014) {
                        Display disp = WindowManagerImpl.getDefault().getDefaultDisplay();
                        Point size = new Point();
                        disp.getRealSize(size);
                        desiredWindowWidth = size.x;
                        desiredWindowHeight = size.y;
                    } else {
                        DisplayMetrics packageMetrics = res.getDisplayMetrics();
                        desiredWindowWidth = packageMetrics.widthPixels;
                        desiredWindowHeight = packageMetrics.heightPixels;
                    }
                }
            }
            boolean goodMeasure = false;
            if (lp.width == -2) {
                DisplayMetrics packageMetrics = res.getDisplayMetrics();
                res.getValue(17104903, this.mTmpValue, true);
                int baseSize = 0;
                if (this.mTmpValue.type == 5) {
                    baseSize = (int)this.mTmpValue.getDimension(packageMetrics);
                }
                if (baseSize != 0 && desiredWindowWidth > baseSize) {
                    childWidthMeasureSpec = this.getRootMeasureSpec(baseSize, lp.width);
                    childHeightMeasureSpec = this.getRootMeasureSpec(desiredWindowHeight, lp.height);
                    host.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    if ((host.getMeasuredWidthAndState() & 0x1000000) == 0) {
                        goodMeasure = true;
                    } else {
                        baseSize = (baseSize + desiredWindowWidth) / 2;
                        childWidthMeasureSpec = this.getRootMeasureSpec(baseSize, lp.width);
                        host.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                        if ((host.getMeasuredWidthAndState() & 0x1000000) == 0) {
                            goodMeasure = true;
                        }
                    }
                }
            }
            if (!goodMeasure) {
                childWidthMeasureSpec = this.getRootMeasureSpec(desiredWindowWidth, lp.width);
                childHeightMeasureSpec = this.getRootMeasureSpec(desiredWindowHeight, lp.height);
                host.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                if (this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight()) {
                    windowSizeMayChange = true;
                }
            }
        }
        if (attachInfo.mRecomputeGlobalAttributes && host.mAttachInfo != null) {
            attachInfo.mRecomputeGlobalAttributes = false;
            boolean oldScreenOn = attachInfo.mKeepScreenOn;
            int oldVis = attachInfo.mSystemUiVisibility;
            boolean oldHasSystemUiListeners = attachInfo.mHasSystemUiListeners;
            attachInfo.mKeepScreenOn = false;
            attachInfo.mSystemUiVisibility = 0;
            attachInfo.mHasSystemUiListeners = false;
            host.dispatchCollectViewAttributes(0);
            if (attachInfo.mKeepScreenOn != oldScreenOn || attachInfo.mSystemUiVisibility != oldVis || attachInfo.mHasSystemUiListeners != oldHasSystemUiListeners) {
                params = lp;
            }
        }
        if (attachInfo.mForceReportNewAttributes) {
            attachInfo.mForceReportNewAttributes = false;
            params = lp;
        }
        if (this.mFirst || attachInfo.mViewVisibilityChanged) {
            attachInfo.mViewVisibilityChanged = false;
            int resizeMode = this.mSoftInputMode & 0xF0;
            if (resizeMode == 0) {
                int N = attachInfo.mScrollContainers.size();
                for (int i = 0; i < N; ++i) {
                    if (!attachInfo.mScrollContainers.get(i).isShown()) continue;
                    resizeMode = 16;
                }
                if (resizeMode == 0) {
                    resizeMode = 32;
                }
                if ((lp.softInputMode & 0xF0) != resizeMode) {
                    lp.softInputMode = lp.softInputMode & 0xFFFFFF0F | resizeMode;
                    params = lp;
                }
            }
        }
        if (params != null && (host.mPrivateFlags & 0x200) != 0 && !PixelFormat.formatHasAlpha(params.format)) {
            params.format = -3;
        }
        boolean windowShouldResize = this.mLayoutRequested && windowSizeMayChange && (this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight() || lp.width == -2 && frame.width() < desiredWindowWidth && frame.width() != this.mWidth || lp.height == -2 && frame.height() < desiredWindowHeight && frame.height() != this.mHeight);
        boolean computesInternalInsets = attachInfo.mTreeObserver.hasComputeInternalInsetsListeners();
        boolean insetsPending = false;
        int relayoutResult = 0;
        if (this.mFirst || windowShouldResize || insetsChanged || viewVisibilityChanged || params != null) {
            boolean focusChangedDueToTouchMode;
            boolean hadSurface;
            boolean contentInsetsChanged;
            boolean hwInitialized;
            block135: {
                if (viewVisibility == 0) {
                    boolean bl = insetsPending = computesInternalInsets && (this.mFirst || viewVisibilityChanged);
                }
                if (this.mSurfaceHolder != null) {
                    this.mSurfaceHolder.mSurfaceLock.lock();
                    this.mDrawingAllowed = true;
                }
                hwInitialized = false;
                contentInsetsChanged = false;
                hadSurface = this.mSurface.isValid();
                try {
                    boolean visibleInsetsChanged;
                    int fl = 0;
                    if (params != null) {
                        fl = params.flags;
                        if (attachInfo.mKeepScreenOn) {
                            params.flags |= 0x80;
                        }
                        params.subtreeSystemUiVisibility = attachInfo.mSystemUiVisibility;
                        params.hasSystemUiListeners = attachInfo.mHasSystemUiListeners;
                    }
                    int surfaceGenerationId = this.mSurface.getGenerationId();
                    relayoutResult = this.relayoutWindow(params, viewVisibility, insetsPending);
                    if (params != null) {
                        params.flags = fl;
                    }
                    if (this.mPendingConfiguration.seq != 0) {
                        this.updateConfiguration(this.mPendingConfiguration, !this.mFirst);
                        this.mPendingConfiguration.seq = 0;
                    }
                    contentInsetsChanged = !this.mPendingContentInsets.equals(this.mAttachInfo.mContentInsets);
                    boolean bl = visibleInsetsChanged = !this.mPendingVisibleInsets.equals(this.mAttachInfo.mVisibleInsets);
                    if (contentInsetsChanged) {
                        if (this.mWidth > 0 && this.mHeight > 0 && this.mSurface != null && this.mSurface.isValid() && !this.mAttachInfo.mTurnOffWindowResizeAnim && this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled() && this.mAttachInfo.mHardwareRenderer.validate() && lp != null && !PixelFormat.formatHasAlpha(lp.format)) {
                            this.disposeResizeBuffer();
                            boolean completed = false;
                            HardwareCanvas hwRendererCanvas = this.mAttachInfo.mHardwareRenderer.getCanvas();
                            HardwareCanvas layerCanvas = null;
                            try {
                                int yoff;
                                boolean scrolling;
                                if (this.mResizeBuffer == null) {
                                    this.mResizeBuffer = this.mAttachInfo.mHardwareRenderer.createHardwareLayer(this.mWidth, this.mHeight, false);
                                } else if (this.mResizeBuffer.getWidth() != this.mWidth || this.mResizeBuffer.getHeight() != this.mHeight) {
                                    this.mResizeBuffer.resize(this.mWidth, this.mHeight);
                                }
                                layerCanvas = this.mResizeBuffer.start(hwRendererCanvas);
                                layerCanvas.setViewport(this.mWidth, this.mHeight);
                                layerCanvas.onPreDraw(null);
                                int restoreCount = layerCanvas.save();
                                layerCanvas.drawColor(-16777216, PorterDuff.Mode.SRC);
                                boolean bl2 = scrolling = this.mScroller != null && this.mScroller.computeScrollOffset();
                                if (scrolling) {
                                    yoff = this.mScroller.getCurrY();
                                    this.mScroller.abortAnimation();
                                } else {
                                    yoff = this.mScrollY;
                                }
                                layerCanvas.translate(0.0f, -yoff);
                                if (this.mTranslator != null) {
                                    this.mTranslator.translateCanvas(layerCanvas);
                                }
                                this.mView.draw(layerCanvas);
                                this.mResizeBufferStartTime = SystemClock.uptimeMillis();
                                this.mResizeBufferDuration = this.mView.getResources().getInteger(0x10E0001);
                                completed = true;
                                layerCanvas.restoreToCount(restoreCount);
                            }
                            catch (OutOfMemoryError e) {
                                Log.w(TAG, "Not enough memory for content change anim buffer", e);
                            }
                            finally {
                                if (layerCanvas != null) {
                                    layerCanvas.onPostDraw();
                                }
                                if (this.mResizeBuffer != null) {
                                    this.mResizeBuffer.end(hwRendererCanvas);
                                    if (!completed) {
                                        this.mResizeBuffer.destroy();
                                        this.mResizeBuffer = null;
                                    }
                                }
                            }
                        }
                        this.mAttachInfo.mContentInsets.set(this.mPendingContentInsets);
                        host.fitSystemWindows(this.mAttachInfo.mContentInsets);
                    }
                    if (visibleInsetsChanged) {
                        this.mAttachInfo.mVisibleInsets.set(this.mPendingVisibleInsets);
                    }
                    if (!hadSurface) {
                        if (!this.mSurface.isValid()) break block135;
                        newSurface = true;
                        fullRedrawNeeded = true;
                        this.mPreviousTransparentRegion.setEmpty();
                        if (this.mAttachInfo.mHardwareRenderer == null) break block135;
                        try {
                            hwInitialized = this.mAttachInfo.mHardwareRenderer.initialize(this.mHolder);
                            break block135;
                        }
                        catch (Surface.OutOfResourcesException e) {
                            Log.e(TAG, "OutOfResourcesException initializing HW surface", e);
                            try {
                                if (!sWindowSession.outOfMemory(this.mWindow)) {
                                    Slog.w(TAG, "No processes killed for memory; killing self");
                                    Process.killProcess(Process.myPid());
                                }
                            }
                            catch (RemoteException ex) {
                                // empty catch block
                            }
                            this.mLayoutRequested = true;
                            return;
                        }
                    }
                    if (!this.mSurface.isValid()) {
                        this.mLastScrolledFocus = null;
                        this.mCurScrollY = 0;
                        this.mScrollY = 0;
                        if (this.mScroller != null) {
                            this.mScroller.abortAnimation();
                        }
                        this.disposeResizeBuffer();
                        if (this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled()) {
                            this.mAttachInfo.mHardwareRenderer.destroy(true);
                        }
                        break block135;
                    }
                    if (surfaceGenerationId == this.mSurface.getGenerationId() || this.mSurfaceHolder != null || this.mAttachInfo.mHardwareRenderer == null) break block135;
                    fullRedrawNeeded = true;
                    try {
                        this.mAttachInfo.mHardwareRenderer.updateSurface(this.mHolder);
                    }
                    catch (Surface.OutOfResourcesException e) {
                        Log.e(TAG, "OutOfResourcesException updating HW surface", e);
                        try {
                            if (!sWindowSession.outOfMemory(this.mWindow)) {
                                Slog.w(TAG, "No processes killed for memory; killing self");
                                Process.killProcess(Process.myPid());
                            }
                        }
                        catch (RemoteException ex) {
                            // empty catch block
                        }
                        this.mLayoutRequested = true;
                        return;
                    }
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            attachInfo.mWindowLeft = frame.left;
            attachInfo.mWindowTop = frame.top;
            this.mWidth = frame.width();
            this.mHeight = frame.height();
            if (this.mSurfaceHolder != null) {
                if (this.mSurface.isValid()) {
                    this.mSurfaceHolder.mSurface = this.mSurface;
                }
                this.mSurfaceHolder.setSurfaceFrameSize(this.mWidth, this.mHeight);
                this.mSurfaceHolder.mSurfaceLock.unlock();
                if (this.mSurface.isValid()) {
                    if (!hadSurface) {
                        this.mSurfaceHolder.ungetCallbacks();
                        this.mIsCreating = true;
                        this.mSurfaceHolderCallback.surfaceCreated(this.mSurfaceHolder);
                        SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                        if (callbacks != null) {
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceCreated(this.mSurfaceHolder);
                            }
                        }
                        surfaceChanged = true;
                    }
                    if (surfaceChanged) {
                        this.mSurfaceHolderCallback.surfaceChanged(this.mSurfaceHolder, lp.format, this.mWidth, this.mHeight);
                        SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                        if (callbacks != null) {
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceChanged(this.mSurfaceHolder, lp.format, this.mWidth, this.mHeight);
                            }
                        }
                    }
                    this.mIsCreating = false;
                } else if (hadSurface) {
                    this.mSurfaceHolder.ungetCallbacks();
                    SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                    this.mSurfaceHolderCallback.surfaceDestroyed(this.mSurfaceHolder);
                    if (callbacks != null) {
                        for (SurfaceHolder.Callback c : callbacks) {
                            c.surfaceDestroyed(this.mSurfaceHolder);
                        }
                    }
                    this.mSurfaceHolder.mSurfaceLock.lock();
                    try {
                        this.mSurfaceHolder.mSurface = new Surface();
                    }
                    finally {
                        this.mSurfaceHolder.mSurfaceLock.unlock();
                    }
                }
            }
            if (this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled() && (hwInitialized || windowShouldResize || this.mWidth != this.mAttachInfo.mHardwareRenderer.getWidth() || this.mHeight != this.mAttachInfo.mHardwareRenderer.getHeight())) {
                this.mAttachInfo.mHardwareRenderer.setup(this.mWidth, this.mHeight);
                if (!hwInitialized) {
                    this.mAttachInfo.mHardwareRenderer.invalidate(this.mHolder);
                }
            }
            if (!this.mStopped && ((focusChangedDueToTouchMode = this.ensureTouchModeLocally((relayoutResult & 1) != 0)) || this.mWidth != host.getMeasuredWidth() || this.mHeight != host.getMeasuredHeight() || contentInsetsChanged)) {
                childWidthMeasureSpec = this.getRootMeasureSpec(this.mWidth, lp.width);
                childHeightMeasureSpec = this.getRootMeasureSpec(this.mHeight, lp.height);
                host.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                int width = host.getMeasuredWidth();
                int height = host.getMeasuredHeight();
                boolean measureAgain = false;
                if (lp.horizontalWeight > 0.0f) {
                    width += (int)((float)(this.mWidth - width) * lp.horizontalWeight);
                    childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
                    measureAgain = true;
                }
                if (lp.verticalWeight > 0.0f) {
                    height += (int)((float)(this.mHeight - height) * lp.verticalWeight);
                    childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height, 0x40000000);
                    measureAgain = true;
                }
                if (measureAgain) {
                    host.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                }
                this.mLayoutRequested = true;
            }
        }
        boolean didLayout = this.mLayoutRequested && !this.mStopped;
        boolean bl = triggerGlobalLayoutListener = didLayout || attachInfo.mRecomputeGlobalAttributes;
        if (didLayout) {
            this.mLayoutRequested = false;
            this.mScrollMayChange = true;
            long startTime = 0L;
            host.layout(0, 0, host.getMeasuredWidth(), host.getMeasuredHeight());
            if ((host.mPrivateFlags & 0x200) != 0) {
                host.getLocationInWindow(this.mTmpLocation);
                this.mTransparentRegion.set(this.mTmpLocation[0], this.mTmpLocation[1], this.mTmpLocation[0] + host.mRight - host.mLeft, this.mTmpLocation[1] + host.mBottom - host.mTop);
                host.gatherTransparentRegion(this.mTransparentRegion);
                if (this.mTranslator != null) {
                    this.mTranslator.translateRegionInWindowToScreen(this.mTransparentRegion);
                }
                if (!this.mTransparentRegion.equals(this.mPreviousTransparentRegion)) {
                    this.mPreviousTransparentRegion.set(this.mTransparentRegion);
                    try {
                        sWindowSession.setTransparentRegion(this.mWindow, this.mTransparentRegion);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (triggerGlobalLayoutListener) {
            attachInfo.mRecomputeGlobalAttributes = false;
            attachInfo.mTreeObserver.dispatchOnGlobalLayout();
            if (AccessibilityManager.getInstance(host.mContext).isEnabled()) {
                this.postSendWindowContentChangedCallback();
            }
        }
        if (computesInternalInsets) {
            ViewTreeObserver.InternalInsetsInfo insets = attachInfo.mGivenInternalInsets;
            insets.reset();
            attachInfo.mTreeObserver.dispatchOnComputeInternalInsets(insets);
            if (insetsPending || !this.mLastGivenInsets.equals(insets)) {
                Region touchableRegion;
                Rect visibleInsets;
                Rect contentInsets;
                this.mLastGivenInsets.set(insets);
                if (this.mTranslator != null) {
                    contentInsets = this.mTranslator.getTranslatedContentInsets(insets.contentInsets);
                    visibleInsets = this.mTranslator.getTranslatedVisibleInsets(insets.visibleInsets);
                    touchableRegion = this.mTranslator.getTranslatedTouchableArea(insets.touchableRegion);
                } else {
                    contentInsets = insets.contentInsets;
                    visibleInsets = insets.visibleInsets;
                    touchableRegion = insets.touchableRegion;
                }
                try {
                    sWindowSession.setInsets(this.mWindow, insets.mTouchableInsets, contentInsets, visibleInsets, touchableRegion);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        if (this.mFirst && this.mView != null) {
            if (!this.mView.hasFocus()) {
                this.mView.requestFocus(2);
                this.mFocusedView = this.mRealFocusedView = this.mView.findFocus();
            } else {
                this.mRealFocusedView = this.mView.findFocus();
            }
        }
        this.mFirst = false;
        this.mWillDrawSoon = false;
        this.mNewSurfaceNeeded = false;
        this.mViewVisibility = viewVisibility;
        if (this.mAttachInfo.mHasWindowFocus && (imTarget = WindowManager.LayoutParams.mayUseInputMethod(this.mWindowAttributes.flags)) != this.mLastWasImTarget) {
            this.mLastWasImTarget = imTarget;
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null && imTarget) {
                imm.startGettingWindowFocus(this.mView);
                imm.onWindowFocus(this.mView, this.mView.findFocus(), this.mWindowAttributes.softInputMode, !this.mHasHadWindowFocus, this.mWindowAttributes.flags);
            }
        }
        boolean bl3 = cancelDraw = attachInfo.mTreeObserver.dispatchOnPreDraw() || viewVisibility != 0;
        if (!cancelDraw && !newSurface) {
            if (this.mPendingTransitions != null && this.mPendingTransitions.size() > 0) {
                for (int i = 0; i < this.mPendingTransitions.size(); ++i) {
                    this.mPendingTransitions.get(i).startChangingAnimations();
                }
                this.mPendingTransitions.clear();
            }
            this.mFullRedrawNeeded = false;
            this.draw(fullRedrawNeeded);
            if ((relayoutResult & 2) != 0 || this.mReportNextDraw) {
                this.mReportNextDraw = false;
                if (this.mSurfaceHolder != null && this.mSurface.isValid()) {
                    this.mSurfaceHolderCallback.surfaceRedrawNeeded(this.mSurfaceHolder);
                    SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                    if (callbacks != null) {
                        for (SurfaceHolder.Callback c : callbacks) {
                            if (!(c instanceof SurfaceHolder.Callback2)) continue;
                            ((SurfaceHolder.Callback2)c).surfaceRedrawNeeded(this.mSurfaceHolder);
                        }
                    }
                }
                try {
                    sWindowSession.finishDrawing(this.mWindow);
                }
                catch (RemoteException e) {}
            }
        } else {
            if (this.mPendingTransitions != null && this.mPendingTransitions.size() > 0) {
                for (int i = 0; i < this.mPendingTransitions.size(); ++i) {
                    this.mPendingTransitions.get(i).endChangingAnimations();
                }
                this.mPendingTransitions.clear();
            }
            if ((relayoutResult & 2) != 0) {
                this.mReportNextDraw = true;
            }
            if (fullRedrawNeeded) {
                this.mFullRedrawNeeded = true;
            }
            if (viewVisibility == 0) {
                this.scheduleTraversals();
            }
        }
    }

    public void requestTransparentRegion(View child) {
        this.checkThread();
        if (this.mView == child) {
            this.mView.mPrivateFlags |= 0x200;
            this.mWindowAttributesChanged = true;
            this.mWindowAttributesChangesFlag = 0;
            this.requestLayout();
        }
    }

    private int getRootMeasureSpec(int windowSize, int rootDimension) {
        int measureSpec;
        switch (rootDimension) {
            case -1: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(windowSize, 0x40000000);
                break;
            }
            case -2: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(windowSize, Integer.MIN_VALUE);
                break;
            }
            default: {
                measureSpec = View.MeasureSpec.makeMeasureSpec(rootDimension, 0x40000000);
            }
        }
        return measureSpec;
    }

    public void onHardwarePreDraw(HardwareCanvas canvas) {
        canvas.translate(0.0f, -this.mHardwareYOffset);
    }

    public void onHardwarePostDraw(HardwareCanvas canvas) {
        if (this.mResizeBuffer != null) {
            this.mResizePaint.setAlpha(this.mResizeAlpha);
            canvas.drawHardwareLayer(this.mResizeBuffer, 0.0f, this.mHardwareYOffset, this.mResizePaint);
        }
    }

    void outputDisplayList(View view) {
        DisplayList displayList;
        if (this.mAttachInfo != null && this.mAttachInfo.mHardwareCanvas != null && (displayList = view.getDisplayList()) != null) {
            this.mAttachInfo.mHardwareCanvas.outputDisplayList(displayList);
        }
    }

    private void profileRendering(boolean enabled) {
        if (this.mProfileRendering) {
            this.mRenderProfilingEnabled = enabled;
            if (this.mRenderProfiler == null) {
                this.mRenderProfiler = new Thread(new Runnable(){

                    public void run() {
                        Log.d(ViewRootImpl.TAG, "Starting profiling thread");
                        while (ViewRootImpl.this.mRenderProfilingEnabled) {
                            ViewRootImpl.this.mAttachInfo.mHandler.post(new Runnable(){

                                public void run() {
                                    ViewRootImpl.this.mDirty.set(0, 0, ViewRootImpl.this.mWidth, ViewRootImpl.this.mHeight);
                                    ViewRootImpl.this.scheduleTraversals();
                                }
                            });
                            try {
                                Thread.sleep(15L);
                            }
                            catch (InterruptedException e) {
                                Log.d(ViewRootImpl.TAG, "Exiting profiling thread");
                            }
                        }
                    }
                }, "Rendering Profiler");
                this.mRenderProfiler.start();
            } else {
                this.mRenderProfiler.interrupt();
                this.mRenderProfiler = null;
            }
        }
    }

    private void trackFPS() {
        long nowTime = System.currentTimeMillis();
        if (this.mFpsStartTime < 0L) {
            this.mFpsStartTime = this.mFpsPrevTime = nowTime;
            this.mFpsNumFrames = 0;
        } else {
            ++this.mFpsNumFrames;
            String thisHash = Integer.toHexString(System.identityHashCode(this));
            long frameTime = nowTime - this.mFpsPrevTime;
            long totalTime = nowTime - this.mFpsStartTime;
            Log.v(TAG, "0x" + thisHash + "\tFrame time:\t" + frameTime);
            this.mFpsPrevTime = nowTime;
            if (totalTime > 1000L) {
                float fps = (float)this.mFpsNumFrames * 1000.0f / (float)totalTime;
                Log.v(TAG, "0x" + thisHash + "\tFPS:\t" + fps);
                this.mFpsStartTime = nowTime;
                this.mFpsNumFrames = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw(boolean fullRedrawNeeded) {
        boolean animating;
        block38: {
            int yoff;
            Surface surface = this.mSurface;
            if (surface == null || !surface.isValid()) {
                return;
            }
            if (!sFirstDrawComplete) {
                ArrayList<Runnable> arrayList = sFirstDrawHandlers;
                synchronized (arrayList) {
                    sFirstDrawComplete = true;
                    int count = sFirstDrawHandlers.size();
                    for (int i = 0; i < count; ++i) {
                        this.post(sFirstDrawHandlers.get(i));
                    }
                }
            }
            this.scrollToRectOrFocus(null, false);
            if (this.mAttachInfo.mViewScrollChanged) {
                this.mAttachInfo.mViewScrollChanged = false;
                this.mAttachInfo.mTreeObserver.dispatchOnScrollChanged();
            }
            if (this.mCurScrollY != (yoff = (animating = this.mScroller != null && this.mScroller.computeScrollOffset()) ? this.mScroller.getCurrY() : this.mScrollY)) {
                this.mCurScrollY = yoff;
                fullRedrawNeeded = true;
            }
            float appScale = this.mAttachInfo.mApplicationScale;
            boolean scalingRequired = this.mAttachInfo.mScalingRequired;
            int resizeAlpha = 0;
            if (this.mResizeBuffer != null) {
                long deltaTime = SystemClock.uptimeMillis() - this.mResizeBufferStartTime;
                if (deltaTime < (long)this.mResizeBufferDuration) {
                    float amt = (float)deltaTime / (float)this.mResizeBufferDuration;
                    amt = mResizeInterpolator.getInterpolation(amt);
                    animating = true;
                    resizeAlpha = 255 - (int)(amt * 255.0f);
                } else {
                    this.disposeResizeBuffer();
                }
            }
            Rect dirty = this.mDirty;
            if (this.mSurfaceHolder != null) {
                dirty.setEmpty();
                if (animating) {
                    if (this.mScroller != null) {
                        this.mScroller.abortAnimation();
                    }
                    this.disposeResizeBuffer();
                }
                return;
            }
            if (fullRedrawNeeded) {
                this.mAttachInfo.mIgnoreDirtyState = true;
                dirty.set(0, 0, (int)((float)this.mWidth * appScale + 0.5f), (int)((float)this.mHeight * appScale + 0.5f));
            }
            if (this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled()) {
                if (!dirty.isEmpty() || this.mIsAnimating) {
                    this.mIsAnimating = false;
                    this.mHardwareYOffset = yoff;
                    this.mResizeAlpha = resizeAlpha;
                    this.mCurrentDirty.set(dirty);
                    this.mCurrentDirty.union(this.mPreviousDirty);
                    this.mPreviousDirty.set(dirty);
                    dirty.setEmpty();
                    Rect currentDirty = this.mCurrentDirty;
                    if (animating) {
                        currentDirty = null;
                    }
                    if (this.mAttachInfo.mHardwareRenderer.draw(this.mView, this.mAttachInfo, this, currentDirty)) {
                        this.mPreviousDirty.set(0, 0, this.mWidth, this.mHeight);
                    }
                }
                if (animating) {
                    this.mFullRedrawNeeded = true;
                    this.scheduleTraversals();
                }
                return;
            }
            if (!dirty.isEmpty() || this.mIsAnimating) {
                Canvas canvas;
                try {
                    int left = dirty.left;
                    int top = dirty.top;
                    int right = dirty.right;
                    int bottom = dirty.bottom;
                    canvas = surface.lockCanvas(dirty);
                    if (left != dirty.left || top != dirty.top || right != dirty.right || bottom != dirty.bottom) {
                        this.mAttachInfo.mIgnoreDirtyState = true;
                    }
                    canvas.setDensity(this.mDensity);
                }
                catch (Surface.OutOfResourcesException e) {
                    Log.e(TAG, "OutOfResourcesException locking surface", e);
                    try {
                        if (!sWindowSession.outOfMemory(this.mWindow)) {
                            Slog.w(TAG, "No processes killed for memory; killing self");
                            Process.killProcess(Process.myPid());
                        }
                    }
                    catch (RemoteException ex) {
                        // empty catch block
                    }
                    this.mLayoutRequested = true;
                    return;
                }
                catch (IllegalArgumentException e) {
                    Log.e(TAG, "IllegalArgumentException locking surface", e);
                    this.mLayoutRequested = true;
                    return;
                }
                try {
                    if (dirty.isEmpty() && !this.mIsAnimating) break block38;
                    long startTime = 0L;
                    if (!canvas.isOpaque() || yoff != 0) {
                        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    }
                    dirty.setEmpty();
                    this.mIsAnimating = false;
                    this.mAttachInfo.mDrawingTime = SystemClock.uptimeMillis();
                    this.mView.mPrivateFlags |= 0x20;
                    try {
                        canvas.translate(0.0f, -yoff);
                        if (this.mTranslator != null) {
                            this.mTranslator.translateCanvas(canvas);
                        }
                        canvas.setScreenDensity(scalingRequired ? DisplayMetrics.DENSITY_DEVICE : 0);
                        this.mAttachInfo.mSetIgnoreDirtyState = false;
                        this.mView.draw(canvas);
                    }
                    finally {
                        if (!this.mAttachInfo.mSetIgnoreDirtyState) {
                            this.mAttachInfo.mIgnoreDirtyState = false;
                        }
                    }
                }
                finally {
                    surface.unlockCanvasAndPost(canvas);
                }
            }
        }
        if (animating) {
            this.mFullRedrawNeeded = true;
            this.scheduleTraversals();
        }
    }

    boolean scrollToRectOrFocus(Rect rectangle, boolean immediate) {
        View.AttachInfo attachInfo = this.mAttachInfo;
        Rect ci = attachInfo.mContentInsets;
        Rect vi = attachInfo.mVisibleInsets;
        int scrollY = 0;
        boolean handled = false;
        if (vi.left > ci.left || vi.top > ci.top || vi.right > ci.right || vi.bottom > ci.bottom) {
            scrollY = this.mScrollY;
            View focus = this.mRealFocusedView;
            if (focus == null || focus.mAttachInfo != this.mAttachInfo) {
                this.mRealFocusedView = null;
                return false;
            }
            if (focus != this.mLastScrolledFocus) {
                rectangle = null;
            }
            if ((focus != this.mLastScrolledFocus || this.mScrollMayChange || rectangle != null) && focus != null) {
                this.mLastScrolledFocus = focus;
                this.mScrollMayChange = false;
                if (focus.getGlobalVisibleRect(this.mVisRect, null)) {
                    if (rectangle == null) {
                        focus.getFocusedRect(this.mTempRect);
                        if (this.mView instanceof ViewGroup) {
                            ((ViewGroup)this.mView).offsetDescendantRectToMyCoords(focus, this.mTempRect);
                        }
                    } else {
                        this.mTempRect.set(rectangle);
                    }
                    if (this.mTempRect.intersect(this.mVisRect)) {
                        if (this.mTempRect.height() <= this.mView.getHeight() - vi.top - vi.bottom) {
                            if (this.mTempRect.top - scrollY < vi.top) {
                                scrollY -= vi.top - (this.mTempRect.top - scrollY);
                            } else if (this.mTempRect.bottom - scrollY > this.mView.getHeight() - vi.bottom) {
                                scrollY += this.mTempRect.bottom - scrollY - (this.mView.getHeight() - vi.bottom);
                            }
                        }
                        handled = true;
                    }
                }
            }
        }
        if (scrollY != this.mScrollY) {
            if (!immediate && this.mResizeBuffer == null) {
                if (this.mScroller == null) {
                    this.mScroller = new Scroller(this.mView.getContext());
                }
                this.mScroller.startScroll(0, this.mScrollY, 0, scrollY - this.mScrollY);
            } else if (this.mScroller != null) {
                this.mScroller.abortAnimation();
            }
            this.mScrollY = scrollY;
        }
        return handled;
    }

    public void requestChildFocus(View child, View focused) {
        this.checkThread();
        if (this.mFocusedView != focused) {
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(this.mFocusedView, focused);
            this.scheduleTraversals();
        }
        this.mFocusedView = this.mRealFocusedView = focused;
    }

    public void clearChildFocus(View child) {
        this.checkThread();
        View oldFocus = this.mFocusedView;
        this.mRealFocusedView = null;
        this.mFocusedView = null;
        if (this.mView != null && !this.mView.hasFocus()) {
            if (!this.mView.requestFocus(2)) {
                this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(oldFocus, null);
            }
        } else if (oldFocus != null) {
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(oldFocus, null);
        }
    }

    public void focusableViewAvailable(View v) {
        this.checkThread();
        if (this.mView != null) {
            if (!this.mView.hasFocus()) {
                v.requestFocus();
            } else {
                boolean descendantsHaveDibsOnFocus;
                this.mFocusedView = this.mView.findFocus();
                boolean bl = descendantsHaveDibsOnFocus = this.mFocusedView instanceof ViewGroup && ((ViewGroup)this.mFocusedView).getDescendantFocusability() == 262144;
                if (descendantsHaveDibsOnFocus && ViewRootImpl.isViewDescendantOf(v, this.mFocusedView)) {
                    v.requestFocus();
                }
            }
        }
    }

    public void recomputeViewAttributes(View child) {
        this.checkThread();
        if (this.mView == child) {
            this.mAttachInfo.mRecomputeGlobalAttributes = true;
            if (!this.mWillDrawSoon) {
                this.scheduleTraversals();
            }
        }
    }

    void dispatchDetachedFromWindow() {
        if (this.mView != null && this.mView.mAttachInfo != null) {
            if (this.mAttachInfo.mHardwareRenderer != null && this.mAttachInfo.mHardwareRenderer.isEnabled()) {
                this.mAttachInfo.mHardwareRenderer.validate();
            }
            this.mView.dispatchDetachedFromWindow();
        }
        this.mAccessibilityInteractionConnectionManager.ensureNoConnection();
        this.mAccessibilityManager.removeAccessibilityStateChangeListener(this.mAccessibilityInteractionConnectionManager);
        this.removeSendWindowContentChangedCallback();
        this.mView = null;
        this.mAttachInfo.mRootView = null;
        this.mAttachInfo.mSurface = null;
        this.destroyHardwareRenderer();
        this.mSurface.release();
        if (this.mInputQueueCallback != null && this.mInputQueue != null) {
            this.mInputQueueCallback.onInputQueueDestroyed(this.mInputQueue);
            this.mInputQueueCallback = null;
            this.mInputQueue = null;
        } else if (this.mInputChannel != null) {
            InputQueue.unregisterInputChannel(this.mInputChannel);
        }
        try {
            sWindowSession.remove(this.mWindow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.mInputChannel != null) {
            this.mInputChannel.dispose();
            this.mInputChannel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfiguration(Configuration config, boolean force) {
        CompatibilityInfo ci = this.mCompatibilityInfo.getIfNeeded();
        if (ci != null) {
            config = new Configuration(config);
            ci.applyToConfiguration(config);
        }
        ArrayList<ComponentCallbacks> arrayList = sConfigCallbacks;
        synchronized (arrayList) {
            for (int i = sConfigCallbacks.size() - 1; i >= 0; --i) {
                sConfigCallbacks.get(i).onConfigurationChanged(config);
            }
        }
        if (this.mView != null) {
            config = this.mView.getResources().getConfiguration();
            if (force || this.mLastConfiguration.diff(config) != 0) {
                this.mLastConfiguration.setTo(config);
                this.mView.dispatchConfigurationChanged(config);
            }
        }
    }

    private static boolean isViewDescendantOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && ViewRootImpl.isViewDescendantOf((View)((Object)theParent), parent);
    }

    private static void forceLayout(View view) {
        view.forceLayout();
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                ViewRootImpl.forceLayout(group.getChildAt(i));
            }
        }
    }

    public String getMessageName(Message message) {
        switch (message.what) {
            case 1000: {
                return "DO_TRAVERSAL";
            }
            case 1001: {
                return "DIE";
            }
            case 1002: {
                return "RESIZED";
            }
            case 1003: {
                return "RESIZED_REPORT";
            }
            case 1004: {
                return "WINDOW_FOCUS_CHANGED";
            }
            case 1005: {
                return "DISPATCH_KEY";
            }
            case 1006: {
                return "DISPATCH_POINTER";
            }
            case 1007: {
                return "DISPATCH_TRACKBALL";
            }
            case 1008: {
                return "DISPATCH_APP_VISIBILITY";
            }
            case 1009: {
                return "DISPATCH_GET_NEW_SURFACE";
            }
            case 1010: {
                return "FINISHED_EVENT";
            }
            case 1011: {
                return "DISPATCH_KEY_FROM_IME";
            }
            case 1012: {
                return "FINISH_INPUT_CONNECTION";
            }
            case 1013: {
                return "CHECK_FOCUS";
            }
            case 1014: {
                return "CLOSE_SYSTEM_DIALOGS";
            }
            case 1015: {
                return "DISPATCH_DRAG_EVENT";
            }
            case 1016: {
                return "DISPATCH_DRAG_LOCATION_EVENT";
            }
            case 1017: {
                return "DISPATCH_SYSTEM_UI_VISIBILITY";
            }
            case 1018: {
                return "DISPATCH_GENERIC_MOTION";
            }
            case 1019: {
                return "UPDATE_CONFIGURATION";
            }
            case 1020: {
                return "DO_PERFORM_ACCESSIBILITY_ACTION";
            }
            case 1021: {
                return "DO_FIND_ACCESSIBLITY_NODE_INFO_BY_ACCESSIBILITY_ID";
            }
            case 1022: {
                return "DO_FIND_ACCESSIBLITY_NODE_INFO_BY_VIEW_ID";
            }
            case 1023: {
                return "DO_FIND_ACCESSIBLITY_NODE_INFO_BY_VIEW_TEXT";
            }
            case 1024: {
                return "PROCESS_INPUT_EVENTS";
            }
        }
        return super.getMessageName(message);
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                ((View)msg.obj).invalidate();
                break;
            }
            case 2: {
                View.AttachInfo.InvalidateInfo info = (View.AttachInfo.InvalidateInfo)msg.obj;
                info.target.invalidate(info.left, info.top, info.right, info.bottom);
                info.release();
                break;
            }
            case 1000: {
                if (this.mProfile) {
                    Debug.startMethodTracing("ViewAncestor");
                }
                this.performTraversals();
                if (!this.mProfile) break;
                Debug.stopMethodTracing();
                this.mProfile = false;
                break;
            }
            case 1010: {
                this.handleFinishedEvent(msg.arg1, msg.arg2 != 0);
                break;
            }
            case 1005: {
                this.deliverKeyEvent((KeyEvent)msg.obj, msg.arg1 != 0);
                break;
            }
            case 1006: {
                this.deliverPointerEvent((MotionEvent)msg.obj, msg.arg1 != 0);
                break;
            }
            case 1007: {
                this.deliverTrackballEvent((MotionEvent)msg.obj, msg.arg1 != 0);
                break;
            }
            case 1018: {
                this.deliverGenericMotionEvent((MotionEvent)msg.obj, msg.arg1 != 0);
                break;
            }
            case 1024: {
                this.processInputEvents(false);
                break;
            }
            case 1008: {
                this.handleAppVisibility(msg.arg1 != 0);
                break;
            }
            case 1009: {
                this.handleGetNewSurface();
                break;
            }
            case 1002: {
                ResizedInfo ri = (ResizedInfo)msg.obj;
                if (this.mWinFrame.width() == msg.arg1 && this.mWinFrame.height() == msg.arg2 && this.mPendingContentInsets.equals(ri.coveredInsets) && this.mPendingVisibleInsets.equals(ri.visibleInsets) && ((ResizedInfo)msg.obj).newConfig == null) break;
            }
            case 1003: {
                if (!this.mAdded) break;
                Configuration config = ((ResizedInfo)msg.obj).newConfig;
                if (config != null) {
                    this.updateConfiguration(config, false);
                }
                this.mWinFrame.left = 0;
                this.mWinFrame.right = msg.arg1;
                this.mWinFrame.top = 0;
                this.mWinFrame.bottom = msg.arg2;
                this.mPendingContentInsets.set(((ResizedInfo)msg.obj).coveredInsets);
                this.mPendingVisibleInsets.set(((ResizedInfo)msg.obj).visibleInsets);
                if (msg.what == 1003) {
                    this.mReportNextDraw = true;
                }
                if (this.mView != null) {
                    ViewRootImpl.forceLayout(this.mView);
                }
                this.requestLayout();
                break;
            }
            case 1004: {
                boolean hasWindowFocus;
                if (!this.mAdded) break;
                this.mAttachInfo.mHasWindowFocus = hasWindowFocus = msg.arg1 != 0;
                this.profileRendering(hasWindowFocus);
                if (hasWindowFocus) {
                    boolean inTouchMode = msg.arg2 != 0;
                    this.ensureTouchModeLocally(inTouchMode);
                    if (this.mAttachInfo.mHardwareRenderer != null && this.mSurface != null && this.mSurface.isValid()) {
                        this.mFullRedrawNeeded = true;
                        try {
                            this.mAttachInfo.mHardwareRenderer.initializeIfNeeded(this.mWidth, this.mHeight, this.mAttachInfo, this.mHolder);
                        }
                        catch (Surface.OutOfResourcesException e) {
                            Log.e(TAG, "OutOfResourcesException locking surface", e);
                            try {
                                if (!sWindowSession.outOfMemory(this.mWindow)) {
                                    Slog.w(TAG, "No processes killed for memory; killing self");
                                    Process.killProcess(Process.myPid());
                                }
                            }
                            catch (RemoteException ex) {
                                // empty catch block
                            }
                            this.sendMessageDelayed(this.obtainMessage(msg.what, msg.arg1, msg.arg2), 500L);
                            return;
                        }
                    }
                }
                this.mLastWasImTarget = WindowManager.LayoutParams.mayUseInputMethod(this.mWindowAttributes.flags);
                InputMethodManager imm = InputMethodManager.peekInstance();
                if (this.mView != null) {
                    if (hasWindowFocus && imm != null && this.mLastWasImTarget) {
                        imm.startGettingWindowFocus(this.mView);
                    }
                    this.mAttachInfo.mKeyDispatchState.reset();
                    this.mView.dispatchWindowFocusChanged(hasWindowFocus);
                }
                if (hasWindowFocus) {
                    if (imm != null && this.mLastWasImTarget) {
                        imm.onWindowFocus(this.mView, this.mView.findFocus(), this.mWindowAttributes.softInputMode, !this.mHasHadWindowFocus, this.mWindowAttributes.flags);
                    }
                    this.mWindowAttributes.softInputMode &= 0xFFFFFEFF;
                    ((WindowManager.LayoutParams)this.mView.getLayoutParams()).softInputMode &= 0xFFFFFEFF;
                    this.mHasHadWindowFocus = true;
                }
                if (!hasWindowFocus || this.mView == null) break;
                this.sendAccessibilityEvents();
                break;
            }
            case 1001: {
                this.doDie();
                break;
            }
            case 1011: {
                KeyEvent event = (KeyEvent)msg.obj;
                if ((event.getFlags() & 8) != 0) {
                    event = KeyEvent.changeFlags(event, event.getFlags() & 0xFFFFFFF7);
                }
                this.deliverKeyEventPostIme((KeyEvent)msg.obj, false);
                break;
            }
            case 1012: {
                InputMethodManager imm = InputMethodManager.peekInstance();
                if (imm == null) break;
                imm.reportFinishInputConnection((InputConnection)msg.obj);
                break;
            }
            case 1013: {
                InputMethodManager imm = InputMethodManager.peekInstance();
                if (imm == null) break;
                imm.checkFocus();
                break;
            }
            case 1014: {
                if (this.mView == null) break;
                this.mView.onCloseSystemDialogs((String)msg.obj);
                break;
            }
            case 1015: 
            case 1016: {
                DragEvent event = (DragEvent)msg.obj;
                event.mLocalState = this.mLocalDragState;
                this.handleDragEvent(event);
                break;
            }
            case 1017: {
                this.handleDispatchSystemUiVisibilityChanged((SystemUiVisibilityInfo)msg.obj);
                break;
            }
            case 1019: {
                Configuration config = (Configuration)msg.obj;
                if (config.isOtherSeqNewer(this.mLastConfiguration)) {
                    config = this.mLastConfiguration;
                }
                this.updateConfiguration(config, false);
                break;
            }
            case 1021: {
                if (this.mView == null) break;
                this.getAccessibilityInteractionController().findAccessibilityNodeInfoByAccessibilityIdUiThread(msg);
                break;
            }
            case 1020: {
                if (this.mView == null) break;
                this.getAccessibilityInteractionController().perfromAccessibilityActionUiThread(msg);
                break;
            }
            case 1022: {
                if (this.mView == null) break;
                this.getAccessibilityInteractionController().findAccessibilityNodeInfoByViewIdUiThread(msg);
                break;
            }
            case 1023: {
                if (this.mView == null) break;
                this.getAccessibilityInteractionController().findAccessibilityNodeInfosByViewTextUiThread(msg);
            }
        }
    }

    private void startInputEvent(InputQueue.FinishedCallback finishedCallback) {
        if (this.mFinishedCallback != null) {
            Slog.w(TAG, "Received a new input event from the input queue but there is already an unfinished input event in progress.");
        }
        this.mFinishedCallback = finishedCallback;
    }

    private void finishInputEvent(InputEvent event, boolean handled) {
        if (this.mFinishedCallback == null) {
            Slog.w(TAG, "Attempted to tell the input queue that the current input event is finished but there is no input event actually in progress.");
            return;
        }
        this.mFinishedCallback.finished(handled);
        this.mFinishedCallback = null;
    }

    boolean ensureTouchMode(boolean inTouchMode) {
        if (this.mAttachInfo.mInTouchMode == inTouchMode) {
            return false;
        }
        try {
            sWindowSession.setInTouchMode(inTouchMode);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return this.ensureTouchModeLocally(inTouchMode);
    }

    private boolean ensureTouchModeLocally(boolean inTouchMode) {
        if (this.mAttachInfo.mInTouchMode == inTouchMode) {
            return false;
        }
        this.mAttachInfo.mInTouchMode = inTouchMode;
        this.mAttachInfo.mTreeObserver.dispatchOnTouchModeChanged(inTouchMode);
        return inTouchMode ? this.enterTouchMode() : this.leaveTouchMode();
    }

    private boolean enterTouchMode() {
        View focused;
        if (this.mView != null && this.mView.hasFocus() && (focused = this.mView.findFocus()) != null && !focused.isFocusableInTouchMode()) {
            ViewGroup ancestorToTakeFocus = this.findAncestorToTakeFocusInTouchMode(focused);
            if (ancestorToTakeFocus != null) {
                return ancestorToTakeFocus.requestFocus();
            }
            this.mView.unFocus();
            this.mAttachInfo.mTreeObserver.dispatchOnGlobalFocusChange(focused, null);
            this.mFocusedView = null;
            return true;
        }
        return false;
    }

    private ViewGroup findAncestorToTakeFocusInTouchMode(View focused) {
        ViewParent parent = focused.getParent();
        while (parent instanceof ViewGroup) {
            ViewGroup vgParent = (ViewGroup)parent;
            if (vgParent.getDescendantFocusability() == 262144 && vgParent.isFocusableInTouchMode()) {
                return vgParent;
            }
            if (vgParent.isRootNamespace()) {
                return null;
            }
            parent = vgParent.getParent();
        }
        return null;
    }

    private boolean leaveTouchMode() {
        if (this.mView != null) {
            View focused;
            if (this.mView.hasFocus()) {
                this.mFocusedView = this.mView.findFocus();
                if (!(this.mFocusedView instanceof ViewGroup)) {
                    return false;
                }
                if (((ViewGroup)this.mFocusedView).getDescendantFocusability() != 262144) {
                    return false;
                }
            }
            if ((focused = this.focusSearch(null, 130)) != null) {
                return focused.requestFocus(130);
            }
        }
        return false;
    }

    private void deliverPointerEvent(MotionEvent event, boolean sendDone) {
        boolean handled;
        int action;
        boolean isTouchEvent = event.isTouchEvent();
        if (this.mInputEventConsistencyVerifier != null) {
            if (isTouchEvent) {
                this.mInputEventConsistencyVerifier.onTouchEvent(event, 0);
            } else {
                this.mInputEventConsistencyVerifier.onGenericMotionEvent(event, 0);
            }
        }
        if (this.mView == null || !this.mAdded) {
            this.finishMotionEvent(event, sendDone, false);
            return;
        }
        if (this.mTranslator != null) {
            this.mTranslator.translateEventInScreenToAppWindow(event);
        }
        if ((action = event.getAction()) == 0 || action == 8) {
            this.ensureTouchMode(true);
        }
        if (this.mCurScrollY != 0) {
            event.offsetLocation(0.0f, this.mCurScrollY);
        }
        if (isTouchEvent) {
            this.mLastTouchPoint.x = event.getRawX();
            this.mLastTouchPoint.y = event.getRawY();
        }
        if (handled = this.mView.dispatchPointerEvent(event)) {
            this.finishMotionEvent(event, sendDone, true);
            return;
        }
        this.finishMotionEvent(event, sendDone, false);
    }

    private void finishMotionEvent(MotionEvent event, boolean sendDone, boolean handled) {
        event.recycle();
        if (sendDone) {
            this.finishInputEvent(event, handled);
        }
    }

    private void deliverTrackballEvent(MotionEvent event, boolean sendDone) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTrackballEvent(event, 0);
        }
        if (this.mView == null || !this.mAdded) {
            this.finishMotionEvent(event, sendDone, false);
            return;
        }
        if (this.mView.dispatchTrackballEvent(event)) {
            this.ensureTouchMode(false);
            this.finishMotionEvent(event, sendDone, true);
            this.mLastTrackballTime = Integer.MIN_VALUE;
            return;
        }
        TrackballAxis x = this.mTrackballAxisX;
        TrackballAxis y = this.mTrackballAxisY;
        long curTime = SystemClock.uptimeMillis();
        if (this.mLastTrackballTime + 250L < curTime) {
            x.reset(0);
            y.reset(0);
            this.mLastTrackballTime = curTime;
        }
        int action = event.getAction();
        int metaState = event.getMetaState();
        switch (action) {
            case 0: {
                x.reset(2);
                y.reset(2);
                this.deliverKeyEvent(new KeyEvent(curTime, curTime, 0, 23, 0, metaState, -1, 0, 1024, 257), false);
                break;
            }
            case 1: {
                x.reset(2);
                y.reset(2);
                this.deliverKeyEvent(new KeyEvent(curTime, curTime, 1, 23, 0, metaState, -1, 0, 1024, 257), false);
            }
        }
        float xOff = x.collect(event.getX(), event.getEventTime(), "X");
        float yOff = y.collect(event.getY(), event.getEventTime(), "Y");
        int keycode = 0;
        int movement = 0;
        float accel = 1.0f;
        if (xOff > yOff) {
            movement = x.generate(2.0f / event.getXPrecision());
            if (movement != 0) {
                keycode = movement > 0 ? 22 : 21;
                accel = x.acceleration;
                y.reset(2);
            }
        } else if (yOff > 0.0f && (movement = y.generate(2.0f / event.getYPrecision())) != 0) {
            keycode = movement > 0 ? 20 : 19;
            accel = y.acceleration;
            x.reset(2);
        }
        if (keycode != 0) {
            int accelMovement;
            if (movement < 0) {
                movement = -movement;
            }
            if ((accelMovement = (int)((float)movement * accel)) > movement) {
                int repeatCount = accelMovement - --movement;
                this.deliverKeyEvent(new KeyEvent(curTime, curTime, 2, keycode, repeatCount, metaState, -1, 0, 1024, 257), false);
            }
            while (movement > 0) {
                --movement;
                curTime = SystemClock.uptimeMillis();
                this.deliverKeyEvent(new KeyEvent(curTime, curTime, 0, keycode, 0, metaState, -1, 0, 1024, 257), false);
                this.deliverKeyEvent(new KeyEvent(curTime, curTime, 1, keycode, 0, metaState, -1, 0, 1024, 257), false);
            }
            this.mLastTrackballTime = curTime;
        }
        this.finishMotionEvent(event, sendDone, true);
    }

    private void deliverGenericMotionEvent(MotionEvent event, boolean sendDone) {
        int source;
        boolean isJoystick;
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onGenericMotionEvent(event, 0);
        }
        boolean bl = isJoystick = ((source = event.getSource()) & 0x10) != 0;
        if (this.mView == null || !this.mAdded) {
            if (isJoystick) {
                this.updateJoystickDirection(event, false);
            }
            this.finishMotionEvent(event, sendDone, false);
            return;
        }
        if (this.mView.dispatchGenericMotionEvent(event)) {
            if (isJoystick) {
                this.updateJoystickDirection(event, false);
            }
            this.finishMotionEvent(event, sendDone, true);
            return;
        }
        if (isJoystick) {
            this.updateJoystickDirection(event, true);
            this.finishMotionEvent(event, sendDone, true);
        } else {
            this.finishMotionEvent(event, sendDone, false);
        }
    }

    private void updateJoystickDirection(MotionEvent event, boolean synthesizeNewKeys) {
        int yDirection;
        long time = event.getEventTime();
        int metaState = event.getMetaState();
        int deviceId = event.getDeviceId();
        int source = event.getSource();
        int xDirection = ViewRootImpl.joystickAxisValueToDirection(event.getAxisValue(15));
        if (xDirection == 0) {
            xDirection = ViewRootImpl.joystickAxisValueToDirection(event.getX());
        }
        if ((yDirection = ViewRootImpl.joystickAxisValueToDirection(event.getAxisValue(16))) == 0) {
            yDirection = ViewRootImpl.joystickAxisValueToDirection(event.getY());
        }
        if (xDirection != this.mLastJoystickXDirection) {
            if (this.mLastJoystickXKeyCode != 0) {
                this.deliverKeyEvent(new KeyEvent(time, time, 1, this.mLastJoystickXKeyCode, 0, metaState, deviceId, 0, 1024, source), false);
                this.mLastJoystickXKeyCode = 0;
            }
            this.mLastJoystickXDirection = xDirection;
            if (xDirection != 0 && synthesizeNewKeys) {
                this.mLastJoystickXKeyCode = xDirection > 0 ? 22 : 21;
                this.deliverKeyEvent(new KeyEvent(time, time, 0, this.mLastJoystickXKeyCode, 0, metaState, deviceId, 0, 1024, source), false);
            }
        }
        if (yDirection != this.mLastJoystickYDirection) {
            if (this.mLastJoystickYKeyCode != 0) {
                this.deliverKeyEvent(new KeyEvent(time, time, 1, this.mLastJoystickYKeyCode, 0, metaState, deviceId, 0, 1024, source), false);
                this.mLastJoystickYKeyCode = 0;
            }
            this.mLastJoystickYDirection = yDirection;
            if (yDirection != 0 && synthesizeNewKeys) {
                this.mLastJoystickYKeyCode = yDirection > 0 ? 20 : 19;
                this.deliverKeyEvent(new KeyEvent(time, time, 0, this.mLastJoystickYKeyCode, 0, metaState, deviceId, 0, 1024, source), false);
            }
        }
    }

    private static int joystickAxisValueToDirection(float value) {
        if (value >= 0.5f) {
            return 1;
        }
        if (value <= -0.5f) {
            return -1;
        }
        return 0;
    }

    private static boolean isNavigationKey(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 61: 
            case 62: 
            case 66: 
            case 92: 
            case 93: 
            case 122: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    private static boolean isTypingKey(KeyEvent keyEvent) {
        return keyEvent.getUnicodeChar() > 0;
    }

    private boolean checkForLeavingTouchModeAndConsume(KeyEvent event) {
        if (!this.mAttachInfo.mInTouchMode) {
            return false;
        }
        int action = event.getAction();
        if (action != 0 && action != 2) {
            return false;
        }
        if ((event.getFlags() & 4) != 0) {
            return false;
        }
        if (ViewRootImpl.isNavigationKey(event)) {
            return this.ensureTouchMode(false);
        }
        if (ViewRootImpl.isTypingKey(event)) {
            this.ensureTouchMode(false);
            return false;
        }
        return false;
    }

    int enqueuePendingEvent(Object event, boolean sendDone) {
        int seq = this.mPendingEventSeq + 1;
        if (seq < 0) {
            seq = 0;
        }
        this.mPendingEventSeq = seq;
        this.mPendingEvents.put(seq, event);
        return sendDone ? seq : -seq;
    }

    Object retrievePendingEvent(int seq) {
        Object event;
        if (seq < 0) {
            seq = -seq;
        }
        if ((event = this.mPendingEvents.get(seq)) != null) {
            this.mPendingEvents.remove(seq);
        }
        return event;
    }

    private void deliverKeyEvent(KeyEvent event, boolean sendDone) {
        InputMethodManager imm;
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onKeyEvent(event, 0);
        }
        if (this.mView == null || !this.mAdded) {
            this.finishKeyEvent(event, sendDone, false);
            return;
        }
        if (this.mView.dispatchKeyEventPreIme(event)) {
            this.finishKeyEvent(event, sendDone, true);
            return;
        }
        if (this.mLastWasImTarget && (imm = InputMethodManager.peekInstance()) != null) {
            int seq = this.enqueuePendingEvent(event, sendDone);
            imm.dispatchKeyEvent(this.mView.getContext(), seq, event, this.mInputMethodCallback);
            return;
        }
        this.deliverKeyEventPostIme(event, sendDone);
    }

    private void handleFinishedEvent(int seq, boolean handled) {
        KeyEvent event = (KeyEvent)this.retrievePendingEvent(seq);
        if (event != null) {
            boolean sendDone;
            boolean bl = sendDone = seq >= 0;
            if (handled) {
                this.finishKeyEvent(event, sendDone, true);
            } else {
                this.deliverKeyEventPostIme(event, sendDone);
            }
        }
    }

    private void deliverKeyEventPostIme(KeyEvent event, boolean sendDone) {
        if (this.mView == null || !this.mAdded) {
            this.finishKeyEvent(event, sendDone, false);
            return;
        }
        if (this.checkForLeavingTouchModeAndConsume(event)) {
            this.finishKeyEvent(event, sendDone, true);
            return;
        }
        this.mFallbackEventHandler.preDispatchKeyEvent(event);
        if (this.mView.dispatchKeyEvent(event)) {
            this.finishKeyEvent(event, sendDone, true);
            return;
        }
        if (event.getAction() == 0 && event.isCtrlPressed() && event.getRepeatCount() == 0 && !KeyEvent.isModifierKey(event.getKeyCode()) && this.mView.dispatchKeyShortcutEvent(event)) {
            this.finishKeyEvent(event, sendDone, true);
            return;
        }
        if (this.mFallbackEventHandler.dispatchKeyEvent(event)) {
            this.finishKeyEvent(event, sendDone, true);
            return;
        }
        if (event.getAction() == 0) {
            int direction = 0;
            switch (event.getKeyCode()) {
                case 21: {
                    if (!event.hasNoModifiers()) break;
                    direction = 17;
                    break;
                }
                case 22: {
                    if (!event.hasNoModifiers()) break;
                    direction = 66;
                    break;
                }
                case 19: {
                    if (!event.hasNoModifiers()) break;
                    direction = 33;
                    break;
                }
                case 20: {
                    if (!event.hasNoModifiers()) break;
                    direction = 130;
                    break;
                }
                case 61: {
                    if (event.hasNoModifiers()) {
                        direction = 2;
                        break;
                    }
                    if (!event.hasModifiers(1)) break;
                    direction = 1;
                }
            }
            if (direction != 0) {
                View focused;
                View view = focused = this.mView != null ? this.mView.findFocus() : null;
                if (focused != null) {
                    View v = focused.focusSearch(direction);
                    if (v != null && v != focused) {
                        focused.getFocusedRect(this.mTempRect);
                        if (this.mView instanceof ViewGroup) {
                            ((ViewGroup)this.mView).offsetDescendantRectToMyCoords(focused, this.mTempRect);
                            ((ViewGroup)this.mView).offsetRectIntoDescendantCoords(v, this.mTempRect);
                        }
                        if (v.requestFocus(direction, this.mTempRect)) {
                            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
                            this.finishKeyEvent(event, sendDone, true);
                            return;
                        }
                    }
                    if (this.mView.dispatchUnhandledMove(focused, direction)) {
                        this.finishKeyEvent(event, sendDone, true);
                        return;
                    }
                }
            }
        }
        this.finishKeyEvent(event, sendDone, false);
    }

    private void finishKeyEvent(KeyEvent event, boolean sendDone, boolean handled) {
        if (sendDone) {
            this.finishInputEvent(event, handled);
        }
    }

    void setLocalDragState(Object obj) {
        this.mLocalDragState = obj;
    }

    private void handleDragEvent(DragEvent event) {
        if (this.mView != null && this.mAdded) {
            int what = event.mAction;
            if (what == 6) {
                this.mView.dispatchDragEvent(event);
            } else {
                if (what == 1) {
                    this.mCurrentDragView = null;
                    this.mDragDescription = event.mClipDescription;
                } else {
                    event.mClipDescription = this.mDragDescription;
                }
                if (what == 2 || what == 3) {
                    this.mDragPoint.set(event.mX, event.mY);
                    if (this.mTranslator != null) {
                        this.mTranslator.translatePointInScreenToAppWindow(this.mDragPoint);
                    }
                    if (this.mCurScrollY != 0) {
                        this.mDragPoint.offset(0.0f, this.mCurScrollY);
                    }
                    event.mX = this.mDragPoint.x;
                    event.mY = this.mDragPoint.y;
                }
                View prevDragView = this.mCurrentDragView;
                boolean result = this.mView.dispatchDragEvent(event);
                if (prevDragView != this.mCurrentDragView) {
                    try {
                        if (prevDragView != null) {
                            sWindowSession.dragRecipientExited(this.mWindow);
                        }
                        if (this.mCurrentDragView != null) {
                            sWindowSession.dragRecipientEntered(this.mWindow);
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e(TAG, "Unable to note drag target change");
                    }
                }
                if (what == 3) {
                    this.mDragDescription = null;
                    try {
                        Log.i(TAG, "Reporting drop result: " + result);
                        sWindowSession.reportDropResult(this.mWindow, result);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Unable to report drop result");
                    }
                }
                if (what == 4) {
                    this.setLocalDragState(null);
                }
            }
        }
        event.recycle();
    }

    public void handleDispatchSystemUiVisibilityChanged(SystemUiVisibilityInfo args) {
        if (this.mSeq != args.seq) {
            this.mSeq = args.seq;
            this.mAttachInfo.mForceReportNewAttributes = true;
            this.scheduleTraversals();
        }
        if (this.mView == null) {
            return;
        }
        if (args.localChanges != 0) {
            if (this.mAttachInfo != null) {
                this.mAttachInfo.mSystemUiVisibility = this.mAttachInfo.mSystemUiVisibility & ~args.localChanges | args.localValue & args.localChanges;
            }
            this.mView.updateLocalSystemUiVisibility(args.localValue, args.localChanges);
            this.mAttachInfo.mRecomputeGlobalAttributes = true;
            this.scheduleTraversals();
        }
        this.mView.dispatchSystemUiVisibilityChanged(args.globalVisibility);
    }

    public void getLastTouchPoint(Point outLocation) {
        outLocation.x = (int)this.mLastTouchPoint.x;
        outLocation.y = (int)this.mLastTouchPoint.y;
    }

    public void setDragFocus(View newDragTarget) {
        if (this.mCurrentDragView != newDragTarget) {
            this.mCurrentDragView = newDragTarget;
        }
    }

    private AudioManager getAudioManager() {
        if (this.mView == null) {
            throw new IllegalStateException("getAudioManager called when there is no mView");
        }
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mView.getContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    public AccessibilityInteractionController getAccessibilityInteractionController() {
        if (this.mView == null) {
            throw new IllegalStateException("getAccessibilityInteractionController called when there is no mView");
        }
        if (this.mAccessibilityInteractionController == null) {
            this.mAccessibilityInteractionController = new AccessibilityInteractionController();
        }
        return this.mAccessibilityInteractionController;
    }

    private int relayoutWindow(WindowManager.LayoutParams params, int viewVisibility, boolean insetsPending) throws RemoteException {
        float appScale = this.mAttachInfo.mApplicationScale;
        boolean restore = false;
        if (params != null && this.mTranslator != null) {
            restore = true;
            params.backup();
            this.mTranslator.translateWindowLayout(params);
        }
        if (params != null) {
            // empty if block
        }
        this.mPendingConfiguration.seq = 0;
        if (params != null && this.mOrigWindowType != params.type && this.mTargetSdkVersion < 14) {
            Slog.w(TAG, "Window type can not be changed after the window is added; ignoring change of " + this.mView);
            params.type = this.mOrigWindowType;
        }
        int relayoutResult = sWindowSession.relayout(this.mWindow, this.mSeq, params, (int)((float)this.mView.getMeasuredWidth() * appScale + 0.5f), (int)((float)this.mView.getMeasuredHeight() * appScale + 0.5f), viewVisibility, insetsPending ? 1 : 0, this.mWinFrame, this.mPendingContentInsets, this.mPendingVisibleInsets, this.mPendingConfiguration, this.mSurface);
        if (restore) {
            params.restore();
        }
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWinFrame(this.mWinFrame);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingContentInsets);
            this.mTranslator.translateRectInScreenToAppWindow(this.mPendingVisibleInsets);
        }
        return relayoutResult;
    }

    public void playSoundEffect(int effectId) {
        this.checkThread();
        try {
            AudioManager audioManager = this.getAudioManager();
            switch (effectId) {
                case 0: {
                    audioManager.playSoundEffect(0);
                    return;
                }
                case 4: {
                    audioManager.playSoundEffect(2);
                    return;
                }
                case 1: {
                    audioManager.playSoundEffect(3);
                    return;
                }
                case 3: {
                    audioManager.playSoundEffect(4);
                    return;
                }
                case 2: {
                    audioManager.playSoundEffect(1);
                    return;
                }
            }
            throw new IllegalArgumentException("unknown effect id " + effectId + " not defined in " + SoundEffectConstants.class.getCanonicalName());
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "FATAL EXCEPTION when attempting to play sound effect: " + e);
            e.printStackTrace();
            return;
        }
    }

    public boolean performHapticFeedback(int effectId, boolean always) {
        try {
            return sWindowSession.performHapticFeedback(this.mWindow, effectId, always);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public View focusSearch(View focused, int direction) {
        this.checkThread();
        if (!(this.mView instanceof ViewGroup)) {
            return null;
        }
        return FocusFinder.getInstance().findNextFocus((ViewGroup)this.mView, focused, direction);
    }

    public void debug() {
        this.mView.debug();
    }

    public void dumpGfxInfo(PrintWriter pw, int[] info) {
        if (this.mView != null) {
            this.getGfxInfo(this.mView, info);
        } else {
            info[1] = 0;
            info[0] = 0;
        }
    }

    private void getGfxInfo(View view, int[] info) {
        DisplayList displayList = view.mDisplayList;
        info[0] = info[0] + 1;
        if (displayList != null) {
            info[1] = info[1] + displayList.getSize();
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            int count = group.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getGfxInfo(group.getChildAt(i), info);
            }
        }
    }

    public void die(boolean immediate) {
        if (immediate) {
            this.doDie();
        } else {
            this.sendEmptyMessage(1001);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDie() {
        this.checkThread();
        ViewRootImpl viewRootImpl = this;
        synchronized (viewRootImpl) {
            if (this.mAdded) {
                this.mAdded = false;
                this.dispatchDetachedFromWindow();
            }
            if (this.mAdded && !this.mFirst) {
                boolean viewVisibilityChanged;
                this.destroyHardwareRenderer();
                int viewVisibility = this.mView.getVisibility();
                boolean bl = viewVisibilityChanged = this.mViewVisibility != viewVisibility;
                if (this.mWindowAttributesChanged || viewVisibilityChanged) {
                    try {
                        if ((this.relayoutWindow(this.mWindowAttributes, viewVisibility, false) & 2) != 0) {
                            sWindowSession.finishDrawing(this.mWindow);
                        }
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                this.mSurface.release();
            }
        }
    }

    public void requestUpdateConfiguration(Configuration config) {
        Message msg = this.obtainMessage(1019, config);
        this.sendMessage(msg);
    }

    private void destroyHardwareRenderer() {
        if (this.mAttachInfo.mHardwareRenderer != null) {
            this.mAttachInfo.mHardwareRenderer.destroy(true);
            this.mAttachInfo.mHardwareRenderer = null;
            this.mAttachInfo.mHardwareAccelerated = false;
        }
    }

    public void dispatchFinishedEvent(int seq, boolean handled) {
        Message msg = this.obtainMessage(1010);
        msg.arg1 = seq;
        msg.arg2 = handled ? 1 : 0;
        this.sendMessage(msg);
    }

    public void dispatchResized(int w, int h, Rect coveredInsets, Rect visibleInsets, boolean reportDraw, Configuration newConfig) {
        Message msg = this.obtainMessage(reportDraw ? 1003 : 1002);
        if (this.mTranslator != null) {
            this.mTranslator.translateRectInScreenToAppWindow(coveredInsets);
            this.mTranslator.translateRectInScreenToAppWindow(visibleInsets);
            w = (int)((float)w * this.mTranslator.applicationInvertedScale);
            h = (int)((float)h * this.mTranslator.applicationInvertedScale);
        }
        msg.arg1 = w;
        msg.arg2 = h;
        ResizedInfo ri = new ResizedInfo();
        ri.coveredInsets = new Rect(coveredInsets);
        ri.visibleInsets = new Rect(visibleInsets);
        ri.newConfig = newConfig;
        msg.obj = ri;
        this.sendMessage(msg);
    }

    private void enqueueInputEvent(Message msg, long when) {
        InputEventMessage inputMessage = InputEventMessage.obtain(msg);
        if (this.mPendingInputEvents == null) {
            this.mPendingInputEvents = inputMessage;
        } else {
            InputEventMessage currMessage = this.mPendingInputEvents;
            while (currMessage.mNext != null) {
                currMessage = currMessage.mNext;
            }
            currMessage.mNext = inputMessage;
        }
        this.sendEmptyMessageAtTime(1024, when);
    }

    public void dispatchKey(KeyEvent event) {
        this.dispatchKey(event, false);
    }

    private void dispatchKey(KeyEvent event, boolean sendDone) {
        Message msg = this.obtainMessage(1005);
        msg.obj = event;
        msg.arg1 = sendDone ? 1 : 0;
        this.enqueueInputEvent(msg, event.getEventTime());
    }

    private void dispatchMotion(MotionEvent event, boolean sendDone) {
        int source = event.getSource();
        if ((source & 2) != 0) {
            this.dispatchPointer(event, sendDone);
        } else if ((source & 4) != 0) {
            this.dispatchTrackball(event, sendDone);
        } else {
            this.dispatchGenericMotion(event, sendDone);
        }
    }

    private void dispatchPointer(MotionEvent event, boolean sendDone) {
        Message msg = this.obtainMessage(1006);
        msg.obj = event;
        msg.arg1 = sendDone ? 1 : 0;
        this.enqueueInputEvent(msg, event.getEventTime());
    }

    private void dispatchTrackball(MotionEvent event, boolean sendDone) {
        Message msg = this.obtainMessage(1007);
        msg.obj = event;
        msg.arg1 = sendDone ? 1 : 0;
        this.enqueueInputEvent(msg, event.getEventTime());
    }

    private void dispatchGenericMotion(MotionEvent event, boolean sendDone) {
        Message msg = this.obtainMessage(1018);
        msg.obj = event;
        msg.arg1 = sendDone ? 1 : 0;
        this.enqueueInputEvent(msg, event.getEventTime());
    }

    public void dispatchAppVisibility(boolean visible) {
        Message msg = this.obtainMessage(1008);
        msg.arg1 = visible ? 1 : 0;
        this.sendMessage(msg);
    }

    public void dispatchGetNewSurface() {
        Message msg = this.obtainMessage(1009);
        this.sendMessage(msg);
    }

    public void windowFocusChanged(boolean hasFocus, boolean inTouchMode) {
        Message msg = Message.obtain();
        msg.what = 1004;
        msg.arg1 = hasFocus ? 1 : 0;
        msg.arg2 = inTouchMode ? 1 : 0;
        this.sendMessage(msg);
    }

    public void dispatchCloseSystemDialogs(String reason) {
        Message msg = Message.obtain();
        msg.what = 1014;
        msg.obj = reason;
        this.sendMessage(msg);
    }

    public void dispatchDragEvent(DragEvent event) {
        int what;
        if (event.getAction() == 2) {
            what = 1016;
            this.removeMessages(what);
        } else {
            what = 1015;
        }
        Message msg = this.obtainMessage(what, event);
        this.sendMessage(msg);
    }

    public void dispatchSystemUiVisibilityChanged(int seq, int globalVisibility, int localValue, int localChanges) {
        SystemUiVisibilityInfo args = new SystemUiVisibilityInfo();
        args.seq = seq;
        args.globalVisibility = globalVisibility;
        args.localValue = localValue;
        args.localChanges = localChanges;
        this.sendMessage(this.obtainMessage(1017, args));
    }

    private void sendAccessibilityEvents() {
        if (!this.mAccessibilityManager.isEnabled()) {
            return;
        }
        this.mView.sendAccessibilityEvent(32);
        View focusedView = this.mView.findFocus();
        if (focusedView != null && focusedView != this.mView) {
            focusedView.sendAccessibilityEvent(8);
        }
    }

    private void postSendWindowContentChangedCallback() {
        if (this.mSendWindowContentChangedAccessibilityEvent == null) {
            this.mSendWindowContentChangedAccessibilityEvent = new SendWindowContentChangedAccessibilityEvent();
        }
        if (!this.mSendWindowContentChangedAccessibilityEvent.mIsPending) {
            this.mSendWindowContentChangedAccessibilityEvent.mIsPending = true;
            this.postDelayed(this.mSendWindowContentChangedAccessibilityEvent, ViewConfiguration.getSendRecurringAccessibilityEventsInterval());
        }
    }

    private void removeSendWindowContentChangedCallback() {
        if (this.mSendWindowContentChangedAccessibilityEvent != null) {
            this.removeCallbacks(this.mSendWindowContentChangedAccessibilityEvent);
        }
    }

    public boolean showContextMenuForChild(View originalView) {
        return false;
    }

    public ActionMode startActionModeForChild(View originalView, ActionMode.Callback callback) {
        return null;
    }

    public void createContextMenu(ContextMenu menu2) {
    }

    public void childDrawableStateChanged(View child) {
    }

    public boolean requestSendAccessibilityEvent(View child, AccessibilityEvent event) {
        if (this.mView == null) {
            return false;
        }
        this.mAccessibilityManager.sendAccessibilityEvent(event);
        return true;
    }

    void checkThread() {
        if (this.mThread != Thread.currentThread()) {
            throw new CalledFromWrongThreadException("Only the original thread that created a view hierarchy can touch its views.");
        }
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        return this.scrollToRectOrFocus(rectangle, immediate);
    }

    static RunQueue getRunQueue() {
        RunQueue rq = sRunQueues.get();
        if (rq != null) {
            return rq;
        }
        rq = new RunQueue();
        sRunQueues.set(rq);
        return rq;
    }

    static {
        mStaticInit = new Object();
        mInitialized = false;
        sRunQueues = new ThreadLocal();
        sFirstDrawHandlers = new ArrayList();
        sFirstDrawComplete = false;
        sConfigCallbacks = new ArrayList();
        mResizeInterpolator = new AccelerateDecelerateInterpolator();
    }

    private class SendWindowContentChangedAccessibilityEvent
    implements Runnable {
        public volatile boolean mIsPending;

        private SendWindowContentChangedAccessibilityEvent() {
        }

        public void run() {
            if (ViewRootImpl.this.mView != null) {
                ViewRootImpl.this.mView.sendAccessibilityEvent(2048);
                this.mIsPending = false;
            }
        }
    }

    final class AccessibilityInteractionController {
        private static final int POOL_SIZE = 5;
        private ArrayList<AccessibilityNodeInfo> mTempAccessibilityNodeInfoList = new ArrayList();
        private final Pool<SomeArgs> mPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<SomeArgs>(){

            @Override
            public SomeArgs newInstance() {
                return new SomeArgs();
            }

            @Override
            public void onAcquired(SomeArgs info) {
            }

            @Override
            public void onReleased(SomeArgs info) {
                info.clear();
            }
        }, 5));

        AccessibilityInteractionController() {
        }

        public void findAccessibilityNodeInfoByAccessibilityIdClientThread(int accessibilityId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int interrogatingPid, long interrogatingTid) {
            Message message = Message.obtain();
            message.what = 1021;
            message.arg1 = accessibilityId;
            message.arg2 = interactionId;
            message.obj = callback;
            if (interrogatingPid == Process.myPid() && interrogatingTid == Looper.getMainLooper().getThread().getId()) {
                message.setTarget(ViewRootImpl.this);
                AccessibilityInteractionClient.getInstance().setSameThreadMessage(message);
            } else {
                ViewRootImpl.this.sendMessage(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void findAccessibilityNodeInfoByAccessibilityIdUiThread(Message message) {
            AccessibilityNodeInfo info;
            IAccessibilityInteractionConnectionCallback callback;
            int interactionId;
            block6: {
                int accessibilityId = message.arg1;
                interactionId = message.arg2;
                callback = (IAccessibilityInteractionConnectionCallback)message.obj;
                info = null;
                try {
                    View target = this.findViewByAccessibilityId(accessibilityId);
                    if (target == null) break block6;
                    info = target.createAccessibilityNodeInfo();
                }
                catch (Throwable throwable) {
                    try {
                        callback.setFindAccessibilityNodeInfoResult(info, interactionId);
                    }
                    catch (RemoteException re) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                callback.setFindAccessibilityNodeInfoResult(info, interactionId);
            }
            catch (RemoteException re) {}
        }

        public void findAccessibilityNodeInfoByViewIdClientThread(int viewId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int interrogatingPid, long interrogatingTid) {
            Message message = Message.obtain();
            message.what = 1022;
            message.arg1 = viewId;
            message.arg2 = interactionId;
            message.obj = callback;
            if (interrogatingPid == Process.myPid() && interrogatingTid == Looper.getMainLooper().getThread().getId()) {
                message.setTarget(ViewRootImpl.this);
                AccessibilityInteractionClient.getInstance().setSameThreadMessage(message);
            } else {
                ViewRootImpl.this.sendMessage(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void findAccessibilityNodeInfoByViewIdUiThread(Message message) {
            int viewId = message.arg1;
            int interactionId = message.arg2;
            IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)message.obj;
            AccessibilityNodeInfo info = null;
            try {
                View root = ViewRootImpl.this.mView;
                View target = root.findViewById(viewId);
                if (target != null && target.getVisibility() == 0) {
                    info = target.createAccessibilityNodeInfo();
                }
            }
            finally {
                try {
                    callback.setFindAccessibilityNodeInfoResult(info, interactionId);
                }
                catch (RemoteException re) {}
            }
        }

        public void findAccessibilityNodeInfosByViewTextClientThread(String text, int accessibilityViewId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int interrogatingPid, long interrogatingTid) {
            Message message = Message.obtain();
            message.what = 1023;
            SomeArgs args = this.mPool.acquire();
            args.arg1 = text;
            args.argi1 = accessibilityViewId;
            args.argi2 = interactionId;
            args.arg2 = callback;
            message.obj = args;
            if (interrogatingPid == Process.myPid() && interrogatingTid == Looper.getMainLooper().getThread().getId()) {
                message.setTarget(ViewRootImpl.this);
                AccessibilityInteractionClient.getInstance().setSameThreadMessage(message);
            } else {
                ViewRootImpl.this.sendMessage(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void findAccessibilityNodeInfosByViewTextUiThread(Message message) {
            SomeArgs args = (SomeArgs)message.obj;
            String text = (String)args.arg1;
            int accessibilityViewId = args.argi1;
            int interactionId = args.argi2;
            IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg2;
            this.mPool.release(args);
            ArrayList<AccessibilityNodeInfo> infos = null;
            try {
                ArrayList<View> foundViews = ViewRootImpl.this.mAttachInfo.mFocusablesTempList;
                foundViews.clear();
                View root = null;
                root = accessibilityViewId != -1 ? this.findViewByAccessibilityId(accessibilityViewId) : ViewRootImpl.this.mView;
                if (root == null || root.getVisibility() != 0) {
                    return;
                }
                root.findViewsWithText(foundViews, text, 3);
                if (foundViews.isEmpty()) {
                    return;
                }
                infos = this.mTempAccessibilityNodeInfoList;
                infos.clear();
                int viewCount = foundViews.size();
                for (int i = 0; i < viewCount; ++i) {
                    View foundView = foundViews.get(i);
                    if (foundView.getVisibility() != 0) continue;
                    infos.add(foundView.createAccessibilityNodeInfo());
                }
            }
            finally {
                try {
                    callback.setFindAccessibilityNodeInfosResult(infos, interactionId);
                }
                catch (RemoteException re) {}
            }
        }

        public void performAccessibilityActionClientThread(int accessibilityId, int action, int interactionId, IAccessibilityInteractionConnectionCallback callback, int interogatingPid, long interrogatingTid) {
            Message message = Message.obtain();
            message.what = 1020;
            SomeArgs args = this.mPool.acquire();
            args.argi1 = accessibilityId;
            args.argi2 = action;
            args.argi3 = interactionId;
            args.arg1 = callback;
            message.obj = args;
            if (interogatingPid == Process.myPid() && interrogatingTid == Looper.getMainLooper().getThread().getId()) {
                message.setTarget(ViewRootImpl.this);
                AccessibilityInteractionClient.getInstance().setSameThreadMessage(message);
            } else {
                ViewRootImpl.this.sendMessage(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perfromAccessibilityActionUiThread(Message message) {
            SomeArgs args = (SomeArgs)message.obj;
            int accessibilityId = args.argi1;
            int action = args.argi2;
            int interactionId = args.argi3;
            IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
            this.mPool.release(args);
            boolean succeeded = false;
            try {
                switch (action) {
                    case 1: {
                        succeeded = this.performActionFocus(accessibilityId);
                        return;
                    }
                    case 2: {
                        succeeded = this.performActionClearFocus(accessibilityId);
                        return;
                    }
                    case 4: {
                        succeeded = this.performActionSelect(accessibilityId);
                        return;
                    }
                    case 8: {
                        succeeded = this.performActionClearSelection(accessibilityId);
                        return;
                    }
                }
                return;
            }
            finally {
                try {
                    callback.setPerformAccessibilityActionResult(succeeded, interactionId);
                }
                catch (RemoteException re) {}
            }
        }

        private boolean performActionFocus(int accessibilityId) {
            View target = this.findViewByAccessibilityId(accessibilityId);
            if (target == null || target.getVisibility() != 0) {
                return false;
            }
            ViewRootImpl.this.ensureTouchMode(false);
            return target.requestFocus();
        }

        private boolean performActionClearFocus(int accessibilityId) {
            View target = this.findViewByAccessibilityId(accessibilityId);
            if (target == null || target.getVisibility() != 0) {
                return false;
            }
            if (!target.isFocused()) {
                return false;
            }
            target.clearFocus();
            return !target.isFocused();
        }

        private boolean performActionSelect(int accessibilityId) {
            View target = this.findViewByAccessibilityId(accessibilityId);
            if (target == null || target.getVisibility() != 0) {
                return false;
            }
            if (target.isSelected()) {
                return false;
            }
            target.setSelected(true);
            return target.isSelected();
        }

        private boolean performActionClearSelection(int accessibilityId) {
            View target = this.findViewByAccessibilityId(accessibilityId);
            if (target == null || target.getVisibility() != 0) {
                return false;
            }
            if (!target.isSelected()) {
                return false;
            }
            target.setSelected(false);
            return !target.isSelected();
        }

        private View findViewByAccessibilityId(int accessibilityId) {
            View root = ViewRootImpl.this.mView;
            if (root == null) {
                return null;
            }
            View foundView = root.findViewByAccessibilityId(accessibilityId);
            if (foundView != null && foundView.getVisibility() != 0) {
                return null;
            }
            return foundView;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SomeArgs
        implements Poolable<SomeArgs> {
            private SomeArgs mNext;
            private boolean mIsPooled;
            public Object arg1;
            public Object arg2;
            public int argi1;
            public int argi2;
            public int argi3;

            @Override
            public SomeArgs getNextPoolable() {
                return this.mNext;
            }

            @Override
            public boolean isPooled() {
                return this.mIsPooled;
            }

            @Override
            public void setNextPoolable(SomeArgs args) {
                this.mNext = args;
            }

            @Override
            public void setPooled(boolean isPooled) {
                this.mIsPooled = isPooled;
            }

            private void clear() {
                this.arg1 = null;
                this.arg2 = null;
                this.argi1 = 0;
                this.argi2 = 0;
                this.argi3 = 0;
            }
        }
    }

    static final class AccessibilityInteractionConnection
    extends IAccessibilityInteractionConnection.Stub {
        private final WeakReference<ViewRootImpl> mRootImpl;

        AccessibilityInteractionConnection(ViewRootImpl viewAncestor) {
            this.mRootImpl = new WeakReference<ViewRootImpl>(viewAncestor);
        }

        public void findAccessibilityNodeInfoByAccessibilityId(int accessibilityId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int interrogatingPid, long interrogatingTid) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mRootImpl.get();
            if (viewRootImpl != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfoByAccessibilityIdClientThread(accessibilityId, interactionId, callback, interrogatingPid, interrogatingTid);
            }
        }

        public void performAccessibilityAction(int accessibilityId, int action, int interactionId, IAccessibilityInteractionConnectionCallback callback, int interogatingPid, long interrogatingTid) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mRootImpl.get();
            if (viewRootImpl != null) {
                viewRootImpl.getAccessibilityInteractionController().performAccessibilityActionClientThread(accessibilityId, action, interactionId, callback, interogatingPid, interrogatingTid);
            }
        }

        public void findAccessibilityNodeInfoByViewId(int viewId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int interrogatingPid, long interrogatingTid) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mRootImpl.get();
            if (viewRootImpl != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfoByViewIdClientThread(viewId, interactionId, callback, interrogatingPid, interrogatingTid);
            }
        }

        public void findAccessibilityNodeInfosByViewText(String text, int accessibilityId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int interrogatingPid, long interrogatingTid) {
            ViewRootImpl viewRootImpl = (ViewRootImpl)this.mRootImpl.get();
            if (viewRootImpl != null) {
                viewRootImpl.getAccessibilityInteractionController().findAccessibilityNodeInfosByViewTextClientThread(text, accessibilityId, interactionId, callback, interrogatingPid, interrogatingTid);
            }
        }
    }

    final class AccessibilityInteractionConnectionManager
    implements AccessibilityManager.AccessibilityStateChangeListener {
        AccessibilityInteractionConnectionManager() {
        }

        public void onAccessibilityStateChanged(boolean enabled) {
            if (enabled) {
                this.ensureConnection();
            } else {
                this.ensureNoConnection();
            }
        }

        public void ensureConnection() {
            boolean registered;
            boolean bl = registered = ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId != -1;
            if (!registered) {
                ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId = ViewRootImpl.this.mAccessibilityManager.addAccessibilityInteractionConnection(ViewRootImpl.this.mWindow, new AccessibilityInteractionConnection(ViewRootImpl.this));
            }
        }

        public void ensureNoConnection() {
            boolean registered;
            boolean bl = registered = ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId != -1;
            if (registered) {
                ViewRootImpl.this.mAttachInfo.mAccessibilityWindowId = -1;
                ViewRootImpl.this.mAccessibilityManager.removeAccessibilityInteractionConnection(ViewRootImpl.this.mWindow);
            }
        }
    }

    static final class RunQueue {
        private final ArrayList<HandlerAction> mActions = new ArrayList();

        RunQueue() {
        }

        void post(Runnable action) {
            this.postDelayed(action, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void postDelayed(Runnable action, long delayMillis) {
            HandlerAction handlerAction = new HandlerAction();
            handlerAction.action = action;
            handlerAction.delay = delayMillis;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                this.mActions.add(handlerAction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeCallbacks(Runnable action) {
            HandlerAction handlerAction = new HandlerAction();
            handlerAction.action = action;
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> actions = this.mActions;
                while (actions.remove(handlerAction)) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void executeActions(Handler handler) {
            ArrayList<HandlerAction> arrayList = this.mActions;
            synchronized (arrayList) {
                ArrayList<HandlerAction> actions = this.mActions;
                int count = actions.size();
                for (int i = 0; i < count; ++i) {
                    HandlerAction handlerAction = actions.get(i);
                    handler.postDelayed(handlerAction.action, handlerAction.delay);
                }
                actions.clear();
            }
        }

        private static class HandlerAction {
            Runnable action;
            long delay;

            private HandlerAction() {
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                HandlerAction that = (HandlerAction)o;
                return !(this.action == null ? that.action != null : !this.action.equals(that.action));
            }

            public int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
                return result;
            }
        }
    }

    public static final class CalledFromWrongThreadException
    extends AndroidRuntimeException {
        public CalledFromWrongThreadException(String msg) {
            super(msg);
        }
    }

    static final class TrackballAxis {
        static final float MAX_ACCELERATION = 20.0f;
        static final long FAST_MOVE_TIME = 150L;
        static final float ACCEL_MOVE_SCALING_FACTOR = 0.025f;
        float position;
        float absPosition;
        float acceleration = 1.0f;
        long lastMoveTime = 0L;
        int step;
        int dir;
        int nonAccelMovement;

        TrackballAxis() {
        }

        void reset(int _step) {
            this.position = 0.0f;
            this.acceleration = 1.0f;
            this.lastMoveTime = 0L;
            this.step = _step;
            this.dir = 0;
        }

        float collect(float off, long time, String axis) {
            long normTime;
            if (off > 0.0f) {
                normTime = (long)(off * 150.0f);
                if (this.dir < 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = 1;
            } else if (off < 0.0f) {
                normTime = (long)(-off * 150.0f);
                if (this.dir > 0) {
                    this.position = 0.0f;
                    this.step = 0;
                    this.acceleration = 1.0f;
                    this.lastMoveTime = 0L;
                }
                this.dir = -1;
            } else {
                normTime = 0L;
            }
            if (normTime > 0L) {
                long delta = time - this.lastMoveTime;
                this.lastMoveTime = time;
                float acc = this.acceleration;
                if (delta < normTime) {
                    float scale = (float)(normTime - delta) * 0.025f;
                    if (scale > 1.0f) {
                        acc *= scale;
                    }
                    this.acceleration = acc < 20.0f ? acc : 20.0f;
                } else {
                    float scale = (float)(delta - normTime) * 0.025f;
                    if (scale > 1.0f) {
                        acc /= scale;
                    }
                    this.acceleration = acc > 1.0f ? acc : 1.0f;
                }
            }
            this.position += off;
            this.absPosition = Math.abs(this.position);
            return this.absPosition;
        }

        int generate(float precision) {
            int movement = 0;
            this.nonAccelMovement = 0;
            block4: while (true) {
                int dir = this.position >= 0.0f ? 1 : -1;
                switch (this.step) {
                    case 0: {
                        if (this.absPosition < precision) {
                            return movement;
                        }
                        movement += dir;
                        this.nonAccelMovement += dir;
                        this.step = 1;
                        continue block4;
                    }
                    case 1: {
                        if (this.absPosition < 2.0f) {
                            return movement;
                        }
                        movement += dir;
                        this.nonAccelMovement += dir;
                        this.position += dir > 0 ? -2.0f : 2.0f;
                        this.absPosition = Math.abs(this.position);
                        this.step = 2;
                        continue block4;
                    }
                }
                if (this.absPosition < 1.0f) {
                    return movement;
                }
                movement += dir;
                this.position += dir >= 0 ? -1.0f : 1.0f;
                this.absPosition = Math.abs(this.position);
                float acc = this.acceleration;
                this.acceleration = acc < 20.0f ? (acc *= 1.1f) : this.acceleration;
            }
        }
    }

    static class W
    extends IWindow.Stub {
        private final WeakReference<ViewRootImpl> mViewAncestor;

        W(ViewRootImpl viewAncestor) {
            this.mViewAncestor = new WeakReference<ViewRootImpl>(viewAncestor);
        }

        public void resized(int w, int h, Rect coveredInsets, Rect visibleInsets, boolean reportDraw, Configuration newConfig) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchResized(w, h, coveredInsets, visibleInsets, reportDraw, newConfig);
            }
        }

        public void dispatchAppVisibility(boolean visible) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchAppVisibility(visible);
            }
        }

        public void dispatchGetNewSurface() {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchGetNewSurface();
            }
        }

        public void windowFocusChanged(boolean hasFocus, boolean inTouchMode) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.windowFocusChanged(hasFocus, inTouchMode);
            }
        }

        private static int checkCallingPermission(String permission2) {
            try {
                return ActivityManagerNative.getDefault().checkPermission(permission2, Binder.getCallingPid(), Binder.getCallingUid());
            }
            catch (RemoteException e) {
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeCommand(String command, String parameters, ParcelFileDescriptor out) {
            View view;
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null && (view = viewAncestor.mView) != null) {
                if (W.checkCallingPermission("android.permission.DUMP") != 0) {
                    throw new SecurityException("Insufficient permissions to invoke executeCommand() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                }
                ParcelFileDescriptor.AutoCloseOutputStream clientStream = null;
                try {
                    clientStream = new ParcelFileDescriptor.AutoCloseOutputStream(out);
                    ViewDebug.dispatchCommand(view, command, parameters, clientStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (clientStream != null) {
                        try {
                            ((OutputStream)clientStream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        public void closeSystemDialogs(String reason) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchCloseSystemDialogs(reason);
            }
        }

        public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, boolean sync) {
            if (sync) {
                try {
                    sWindowSession.wallpaperOffsetsComplete(this.asBinder());
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }

        public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) {
            if (sync) {
                try {
                    sWindowSession.wallpaperCommandComplete(this.asBinder(), null);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }

        public void dispatchDragEvent(DragEvent event) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchDragEvent(event);
            }
        }

        public void dispatchSystemUiVisibilityChanged(int seq, int globalVisibility, int localValue, int localChanges) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchSystemUiVisibilityChanged(seq, globalVisibility, localValue, localChanges);
            }
        }
    }

    static class InputMethodCallback
    extends IInputMethodCallback.Stub {
        private WeakReference<ViewRootImpl> mViewAncestor;

        public InputMethodCallback(ViewRootImpl viewAncestor) {
            this.mViewAncestor = new WeakReference<ViewRootImpl>(viewAncestor);
        }

        public void finishedEvent(int seq, boolean handled) {
            ViewRootImpl viewAncestor = (ViewRootImpl)this.mViewAncestor.get();
            if (viewAncestor != null) {
                viewAncestor.dispatchFinishedEvent(seq, handled);
            }
        }

        public void sessionCreated(IInputMethodSession session) {
        }
    }

    class TakenSurfaceHolder
    extends BaseSurfaceHolder {
        TakenSurfaceHolder() {
        }

        public boolean onAllowLockCanvas() {
            return ViewRootImpl.this.mDrawingAllowed;
        }

        public void onRelayoutContainer() {
        }

        public void setFormat(int format) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceFormat(format);
        }

        public void setType(int type) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceType(type);
        }

        public void onUpdateSurface() {
            throw new IllegalStateException("Shouldn't be here");
        }

        public boolean isCreating() {
            return ViewRootImpl.this.mIsCreating;
        }

        public void setFixedSize(int width, int height) {
            throw new UnsupportedOperationException("Currently only support sizing from layout");
        }

        public void setKeepScreenOn(boolean screenOn) {
            ((RootViewSurfaceTaker)((Object)ViewRootImpl.this.mView)).setSurfaceKeepScreenOn(screenOn);
        }
    }

    static class InputEventMessage {
        Message mMessage;
        InputEventMessage mNext;
        private static final Object sPoolSync = new Object();
        private static InputEventMessage sPool;
        private static int sPoolSize;
        private static final int MAX_POOL_SIZE = 10;

        private InputEventMessage(Message m) {
            this.mMessage = m;
            this.mNext = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InputEventMessage obtain(Message msg) {
            Object object = sPoolSync;
            synchronized (object) {
                if (sPool != null) {
                    InputEventMessage m = sPool;
                    sPool = m.mNext;
                    m.mNext = null;
                    --sPoolSize;
                    m.mMessage = msg;
                    return m;
                }
            }
            return new InputEventMessage(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            this.mMessage.recycle();
            Object object = sPoolSync;
            synchronized (object) {
                if (sPoolSize < 10) {
                    this.mNext = sPool;
                    sPool = this;
                    ++sPoolSize;
                }
            }
        }

        static {
            sPoolSize = 0;
        }
    }

    static final class SystemUiVisibilityInfo {
        int seq;
        int globalVisibility;
        int localValue;
        int localChanges;

        SystemUiVisibilityInfo() {
        }
    }

    class ResizedInfo {
        Rect coveredInsets;
        Rect visibleInsets;
        Configuration newConfig;

        ResizedInfo() {
        }
    }
}

