/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.webkit.DeviceMotionAndOrientationManager;
import java.util.List;

final class DeviceMotionService
implements SensorEventListener {
    private DeviceMotionAndOrientationManager mManager;
    private boolean mIsRunning;
    private Handler mHandler;
    private SensorManager mSensorManager;
    private Context mContext;
    private boolean mHaveSentErrorEvent;
    private Runnable mUpdateRunnable;
    private float[] mLastAcceleration;
    private static final int INTERVAL_MILLIS = 100;

    public DeviceMotionService(DeviceMotionAndOrientationManager manager, Context context) {
        this.mManager = manager;
        assert (this.mManager != null);
        this.mContext = context;
        assert (this.mContext != null);
    }

    public void start() {
        this.mIsRunning = true;
        this.registerForSensor();
    }

    public void stop() {
        this.mIsRunning = false;
        this.stopSendingUpdates();
        this.unregisterFromSensor();
    }

    public void suspend() {
        if (this.mIsRunning) {
            this.stopSendingUpdates();
            this.unregisterFromSensor();
        }
    }

    public void resume() {
        if (this.mIsRunning) {
            this.registerForSensor();
        }
    }

    private void sendErrorEvent() {
        assert ("WebViewCoreThread".equals(Thread.currentThread().getName()));
        if (this.mHaveSentErrorEvent) {
            return;
        }
        this.mHaveSentErrorEvent = true;
        this.createHandler();
        this.mHandler.post(new Runnable(){

            public void run() {
                assert ("WebViewCoreThread".equals(Thread.currentThread().getName()));
                if (DeviceMotionService.this.mIsRunning) {
                    DeviceMotionService.this.mManager.onMotionChange(null, null, null, 0.0);
                }
            }
        });
    }

    private void createHandler() {
        if (this.mHandler != null) {
            return;
        }
        this.mHandler = new Handler();
        this.mUpdateRunnable = new Runnable(){

            public void run() {
                assert (DeviceMotionService.this.mIsRunning);
                DeviceMotionService.this.mManager.onMotionChange(new Double(DeviceMotionService.this.mLastAcceleration[0]), new Double(DeviceMotionService.this.mLastAcceleration[1]), new Double(DeviceMotionService.this.mLastAcceleration[2]), 100.0);
                DeviceMotionService.this.mHandler.postDelayed(DeviceMotionService.this.mUpdateRunnable, 100L);
                DeviceMotionService.this.mHaveSentErrorEvent = false;
            }
        };
    }

    private void startSendingUpdates() {
        this.createHandler();
        this.mUpdateRunnable.run();
    }

    private void stopSendingUpdates() {
        this.mHandler.removeCallbacks(this.mUpdateRunnable);
        this.mLastAcceleration = null;
    }

    private void registerForSensor() {
        if (!this.registerForAccelerometerSensor()) {
            this.sendErrorEvent();
        }
    }

    private SensorManager getSensorManager() {
        assert ("WebViewCoreThread".equals(Thread.currentThread().getName()));
        if (this.mSensorManager == null) {
            this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        }
        return this.mSensorManager;
    }

    private boolean registerForAccelerometerSensor() {
        List<Sensor> sensors = this.getSensorManager().getSensorList(1);
        if (sensors.isEmpty()) {
            return false;
        }
        this.createHandler();
        return this.getSensorManager().registerListener(this, sensors.get(0), 2, this.mHandler);
    }

    private void unregisterFromSensor() {
        this.getSensorManager().unregisterListener(this);
    }

    public void onSensorChanged(SensorEvent event) {
        assert (event.values.length == 3);
        assert ("WebViewCoreThread".equals(Thread.currentThread().getName()));
        assert (event.sensor.getType() == 1);
        if (!this.mIsRunning) {
            return;
        }
        boolean firstData = this.mLastAcceleration == null;
        this.mLastAcceleration = event.values;
        if (firstData) {
            this.startSendingUpdates();
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        assert ("WebViewCoreThread".equals(Thread.currentThread().getName()));
    }
}

