/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.ProxyProperties;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.webkit.CertTool;
import android.webkit.CookieManager;
import android.webkit.PluginManager;
import android.webkit.WebView;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JWebCoreJavaBridge
extends Handler {
    private static final int TIMER_MESSAGE = 1;
    private static final int FUNCPTR_MESSAGE = 2;
    private static final String LOGTAG = "webkit-timers";
    private int mNativeBridge;
    private boolean mHasInstantTimer;
    private boolean mTimerPaused;
    private boolean mHasDeferredTimers;
    private static WeakReference<WebView> sCurrentMainWebView = new WeakReference<Object>(null);
    static final int REFRESH_PLUGINS = 100;
    private HashMap<String, String> mContentUriToFilePathMap;

    public JWebCoreJavaBridge() {
        this.nativeConstructor();
    }

    protected void finalize() {
        this.nativeFinalize();
    }

    static synchronized void setActiveWebView(WebView webview) {
        if (sCurrentMainWebView.get() != null) {
            return;
        }
        sCurrentMainWebView = new WeakReference<WebView>(webview);
    }

    static synchronized void removeActiveWebView(WebView webview) {
        if (sCurrentMainWebView.get() != webview) {
            return;
        }
        sCurrentMainWebView.clear();
    }

    private void fireSharedTimer() {
        this.mHasInstantTimer = false;
        this.sharedTimerFired();
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                if (this.mTimerPaused) {
                    this.mHasDeferredTimers = true;
                    break;
                }
                this.fireSharedTimer();
                break;
            }
            case 2: {
                this.nativeServiceFuncPtrQueue();
                break;
            }
            case 100: {
                this.nativeUpdatePluginDirectories(PluginManager.getInstance(null).getPluginDirectories(), (Boolean)msg.obj);
            }
        }
    }

    private void signalServiceFuncPtrQueue() {
        Message msg = this.obtainMessage(2);
        this.sendMessage(msg);
    }

    private native void nativeServiceFuncPtrQueue();

    public void pause() {
        if (!this.mTimerPaused) {
            this.mTimerPaused = true;
            this.mHasDeferredTimers = false;
        }
    }

    public void resume() {
        if (this.mTimerPaused) {
            this.mTimerPaused = false;
            if (this.mHasDeferredTimers) {
                this.mHasDeferredTimers = false;
                this.fireSharedTimer();
            }
        }
    }

    public native void setCacheSize(int var1);

    private void setCookies(String url, String value) {
        if (value.contains("\r") || value.contains("\n")) {
            int size = value.length();
            StringBuilder buffer = new StringBuilder(size);
            int i = 0;
            while (i != -1 && i < size) {
                int newi;
                int ir = value.indexOf(13, i);
                int in = value.indexOf(10, i);
                int n = ir == -1 ? in : (in == -1 ? ir : (newi = ir < in ? ir : in));
                if (newi > i) {
                    buffer.append(value.subSequence(i, newi));
                } else if (newi == -1) {
                    buffer.append(value.subSequence(i, size));
                    break;
                }
                i = newi + 1;
            }
            value = buffer.toString();
        }
        CookieManager.getInstance().setCookie(url, value);
    }

    private String cookies(String url) {
        return CookieManager.getInstance().getCookie(url);
    }

    private boolean cookiesEnabled() {
        return CookieManager.getInstance().acceptCookie();
    }

    private String[] getPluginDirectories() {
        return PluginManager.getInstance(null).getPluginDirectories();
    }

    private String getPluginSharedDataDirectory() {
        return PluginManager.getInstance(null).getPluginSharedDataDirectory();
    }

    private void setSharedTimer(long timemillis) {
        if (timemillis <= 0L) {
            if (this.mHasInstantTimer) {
                return;
            }
            this.mHasInstantTimer = true;
            Message msg = this.obtainMessage(1);
            this.sendMessageDelayed(msg, timemillis);
        } else {
            Message msg = this.obtainMessage(1);
            this.sendMessageDelayed(msg, timemillis);
        }
    }

    private void stopSharedTimer() {
        this.removeMessages(1);
        this.mHasInstantTimer = false;
        this.mHasDeferredTimers = false;
    }

    private String[] getKeyStrengthList() {
        return CertTool.getKeyStrengthList();
    }

    private synchronized String getSignedPublicKey(int index, String challenge, String url) {
        WebView current = (WebView)sCurrentMainWebView.get();
        if (current != null) {
            return CertTool.getSignedPublicKey(current.getContext(), index, challenge);
        }
        Log.e(LOGTAG, "There is no active WebView for getSignedPublicKey");
        return "";
    }

    private String resolveFilePathForContentUri(String uri) {
        String fileName;
        if (this.mContentUriToFilePathMap != null && (fileName = this.mContentUriToFilePathMap.get(uri)) != null) {
            return fileName;
        }
        Uri jUri = Uri.parse(uri);
        return jUri.getLastPathSegment();
    }

    public void storeFilePathForContentUri(String path, String contentUri) {
        if (this.mContentUriToFilePathMap == null) {
            this.mContentUriToFilePathMap = new HashMap();
        }
        this.mContentUriToFilePathMap.put(contentUri, path);
    }

    public void updateProxy(ProxyProperties proxyProperties) {
        if (proxyProperties == null) {
            this.nativeUpdateProxy("", "");
            return;
        }
        String host = proxyProperties.getHost();
        int port = proxyProperties.getPort();
        if (port != 0) {
            host = host + ":" + port;
        }
        this.nativeUpdateProxy(host, proxyProperties.getExclusionList());
    }

    private native void nativeConstructor();

    private native void nativeFinalize();

    private native void sharedTimerFired();

    private native void nativeUpdatePluginDirectories(String[] var1, boolean var2);

    public native void setNetworkOnLine(boolean var1);

    public native void setNetworkType(String var1, String var2);

    public native void addPackageNames(Set<String> var1);

    public native void addPackageName(String var1);

    public native void removePackageName(String var1);

    public native void nativeUpdateProxy(String var1, String var2);
}

