/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManager;
import android.content.Context;
import android.net.Uri;
import android.provider.Settings;
import android.util.Log;
import java.io.File;
import java.io.InputStream;

class JniUtil {
    private static final String LOGTAG = "webkit";
    private static String sDatabaseDirectory;
    private static String sCacheDirectory;
    private static Boolean sUseChromiumHttpStack;
    private static Context sContext;
    private static final String ANDROID_CONTENT = "content:";

    private JniUtil() {
    }

    private static void checkInitialized() {
        if (sContext == null) {
            throw new IllegalStateException("Call CookieSyncManager::createInstance() or create a webview before using this class");
        }
    }

    protected static synchronized void setContext(Context context) {
        if (sContext != null) {
            return;
        }
        sContext = context.getApplicationContext();
    }

    protected static synchronized Context getContext() {
        return sContext;
    }

    private static synchronized String getDatabaseDirectory() {
        JniUtil.checkInitialized();
        if (sDatabaseDirectory == null) {
            sDatabaseDirectory = sContext.getDatabasePath("dummy").getParent();
        }
        return sDatabaseDirectory;
    }

    private static synchronized String getCacheDirectory() {
        JniUtil.checkInitialized();
        if (sCacheDirectory == null) {
            File cacheDir = sContext.getCacheDir();
            sCacheDirectory = cacheDir == null ? "" : cacheDir.getAbsolutePath();
        }
        return sCacheDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized long contentUrlSize(String url) {
        if (url.startsWith(ANDROID_CONTENT)) {
            try {
                int mimeIndex = url.lastIndexOf(63);
                if (mimeIndex != -1) {
                    url = url.substring(0, mimeIndex);
                }
                Uri uri = Uri.parse(url);
                InputStream is = sContext.getContentResolver().openInputStream(uri);
                byte[] buffer = new byte[1024];
                long size = 0L;
                try {
                    int n;
                    while ((n = is.read(buffer)) != -1) {
                        size += (long)n;
                    }
                }
                finally {
                    is.close();
                }
                return size;
            }
            catch (Exception e) {
                Log.e(LOGTAG, "Exception: " + url);
                return 0L;
            }
        }
        return 0L;
    }

    private static synchronized InputStream contentUrlStream(String url) {
        if (url.startsWith(ANDROID_CONTENT)) {
            try {
                int mimeIndex = url.lastIndexOf(63);
                if (mimeIndex != -1) {
                    url = url.substring(0, mimeIndex);
                }
                Uri uri = Uri.parse(url);
                return sContext.getContentResolver().openInputStream(uri);
            }
            catch (Exception e) {
                Log.e(LOGTAG, "Exception: " + url);
                return null;
            }
        }
        return null;
    }

    static boolean useChromiumHttpStack() {
        if (sUseChromiumHttpStack == null) {
            sUseChromiumHttpStack = JniUtil.nativeUseChromiumHttpStack();
        }
        return sUseChromiumHttpStack;
    }

    private static synchronized String getAutofillQueryUrl() {
        JniUtil.checkInitialized();
        return Settings.Secure.getString(sContext.getContentResolver(), "web_autofill_query_url");
    }

    private static boolean canSatisfyMemoryAllocation(long bytesRequested) {
        JniUtil.checkInitialized();
        ActivityManager manager = (ActivityManager)sContext.getSystemService("activity");
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        manager.getMemoryInfo(memInfo);
        long leftToAllocate = memInfo.availMem - memInfo.threshold;
        return !memInfo.lowMemory && bytesRequested < leftToAllocate;
    }

    private static native boolean nativeUseChromiumHttpStack();

    static {
        System.loadLibrary("webcore");
        System.loadLibrary("chromium_net");
    }
}

